# Generated by Django 3.2.14 on 2022-09-06 10:05

from django.db import migrations, models
import django.db.models.deletion

# Color constants for better readable output
WARN = "\x1b[1;33m"
RESET = "\x1b[0;39m"


# pylint: disable=unused-argument
def delete_organizations(apps, schema_editor):
    """
    Delete all existing organizations because they have to be region-specific now

    :param apps: The configuration of installed applications
    :type apps: ~django.apps.registry.Apps

    :param schema_editor: The database abstraction layer that creates actual SQL code
    :type schema_editor: ~django.db.backends.base.schema.BaseDatabaseSchemaEditor
    """
    Organization = apps.get_model("cms", "Organization")
    organizations = Organization.objects.all()
    if organizations:
        print(
            f"\n    ↳ {WARN}Warning:{RESET} Deleting organizations {organizations!r}",
            end="",
        )
        organizations.delete()


class Migration(migrations.Migration):
    """
    Add region field to organization model
    """

    dependencies = [
        ("cms", "0033_alter_languagetreenode_visible"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="organization",
            options={
                "default_permissions": ("change", "delete", "view"),
                "default_related_name": "organizations",
                "ordering": ["name"],
                "verbose_name": "organization",
                "verbose_name_plural": "organizations",
            },
        ),
        # Force the deletion function to run immediately so the region field can be added as non-nullable without default
        migrations.RunSQL("SET CONSTRAINTS ALL IMMEDIATE;"),
        migrations.RunPython(delete_organizations, migrations.RunPython.noop),
        migrations.RunSQL("SET CONSTRAINTS ALL DEFERRED;"),
        migrations.AddField(
            model_name="organization",
            name="region",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="organizations",
                to="cms.region",
                verbose_name="region",
            ),
        ),
    ]
