"""Platform config client."""
from pkg_resources import get_distribution

from .client import ConfigClient, ConfigClientBase
from .entities import (
    ACMEEnvironment,
    ARecord,
    AWSCloudProvider,
    AWSCredentials,
    AWSStorage,
    AWSStorageOptions,
    AzureCloudProvider,
    AzureCredentials,
    AzureReplicationType,
    AzureStorage,
    AzureStorageOptions,
    AzureStorageTier,
    BucketsConfig,
    CloudProvider,
    CloudProviderOptions,
    CloudProviderType,
    Cluster,
    ClusterLocationType,
    ClusterStatus,
    CredentialsConfig,
    DisksConfig,
    DNSConfig,
    DockerRegistryConfig,
    EFSPerformanceMode,
    EFSThroughputMode,
    EMCECSCredentials,
    GoogleCloudProvider,
    GoogleFilestoreTier,
    GoogleStorage,
    GoogleStorageOptions,
    GrafanaCredentials,
    HelmRegistryConfig,
    IdleJobConfig,
    IngressConfig,
    MetricsConfig,
    MinioCredentials,
    MonitoringConfig,
    NeuroAuthConfig,
    NodePool,
    NodePoolOptions,
    NodeRole,
    NotificationType,
    OnPremCloudProvider,
    OpenStackCredentials,
    OrchestratorConfig,
    RegistryConfig,
    ResourcePoolType,
    ResourcePreset,
    Resources,
    SecretsConfig,
    SentryCredentials,
    Storage,
    StorageConfig,
    StorageInstance,
    StorageOptions,
    TPUPreset,
    TPUResource,
    VCDCloudProvider,
    VCDCloudProviderOptions,
    VCDCredentials,
    VCDStorage,
    VolumeConfig,
)

__all__ = [
    "ConfigClient",
    "ConfigClientBase",
    "ACMEEnvironment",
    "ARecord",
    "AWSCloudProvider",
    "AWSCredentials",
    "AWSStorage",
    "AWSStorageOptions",
    "AzureCloudProvider",
    "AzureCredentials",
    "AzureReplicationType",
    "AzureStorage",
    "AzureStorageOptions",
    "AzureStorageTier",
    "BucketsConfig",
    "CloudProvider",
    "CloudProviderOptions",
    "CloudProviderType",
    "Cluster",
    "ClusterLocationType",
    "ClusterStatus",
    "CredentialsConfig",
    "DisksConfig",
    "DNSConfig",
    "DockerRegistryConfig",
    "EFSPerformanceMode",
    "EFSThroughputMode",
    "EMCECSCredentials",
    "GoogleCloudProvider",
    "GoogleFilestoreTier",
    "GoogleStorage",
    "GoogleStorageOptions",
    "GrafanaCredentials",
    "HelmRegistryConfig",
    "IdleJobConfig",
    "IngressConfig",
    "MetricsConfig",
    "MinioCredentials",
    "MonitoringConfig",
    "NeuroAuthConfig",
    "NodePool",
    "NodePoolOptions",
    "NodeRole",
    "NotificationType",
    "OnPremCloudProvider",
    "OpenStackCredentials",
    "OrchestratorConfig",
    "RegistryConfig",
    "ResourcePoolType",
    "ResourcePreset",
    "Resources",
    "SecretsConfig",
    "SentryCredentials",
    "Storage",
    "StorageConfig",
    "StorageInstance",
    "StorageOptions",
    "TPUPreset",
    "TPUResource",
    "VCDCloudProvider",
    "VCDCloudProviderOptions",
    "VCDCredentials",
    "VCDStorage",
    "VolumeConfig",
]
__version__ = get_distribution(__name__).version
