"""
This file contains all the useful data related to elements in the periodic table 
in the form of dictionaries. Any new type of information about elements should be added here
preferably in form of a new dictionary entry. The contents of this file is primarily extracted
through getEleInfo.py. User can add any Atomtype:Atomname {key:value} combination to 
AtomTypetoAtomName dictionary if the desired Atomtype is missing.

# Data description:
#
# KNOWN_ELEMENTS:     Number of known elements excluding extra points (LP,DUM,X,D).
# Element:            List of elements wherein array indices correspond to atomic number of the element. 
                      LP entry compensates for index 0.
# AtomOrder:          List of elements and extra points in the same order as in following dictionaries. 
# AtomicNumber:       Dictionary matching atomic symbol to atomic number.
# AtomicMass:         Dictionary matching atomic symbol to atomic mass.
# CovalentRadius:     Dictionary matching atomic symbol to covalent radius.
# AtomColor:          Dictionary matching atomic symbol to R G B color values.
# BondOrder:          Dictionary matching atomic symbol to bond order of element.
# BioNametoAtomName:  Dictionary matching atomic symbol used in biomolecular systems to the atomic symbol.
                      Key in this dictionary must be in capital letters.
# AtomTypetoAtomName: Dictionary matching all atom types in CHARMM FF to atomic symbol.

"""

KNOWN_ELEMENTS = 118

Element = [ 'LP','H' ,'He','Li','Be','B' ,'C' ,'N' ,'O' ,'F' ,'Ne','Na','Mg',
            'Al','Si','P' ,'S' ,'Cl','Ar','K' ,'Ca','Sc','Ti','V' ,'Cr',
            'Mn','Fe','Co','Ni','Cu','Zn','Ga','Ge','As','Se','Br','Kr',
            'Rb','Sr','Y' ,'Zr','Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd',
            'In','Sn','Sb','Te','I' ,'Xe','Cs','Ba','La','Ce','Pr','Nd',
            'Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb','Lu','Hf',
            'Ta','W' ,'Re','Os','Ir','Pt','Au','Hg','Tl','Pb','Bi','Po',
            'At','Rn','Fr','Ra','Ac','Th','Pa','U' ,'Np','Pu','Am','Cm',
            'Bk','Cf','Es','Fm','Md','No','Lr','Rf','Db','Sg','Bh','Hs',
            'Mt','Ds','Rg','Uub','Uut','Uuq','Uup','Uuh','Uus','Uuo'] 

AtomOrder = [ 'H' ,'He','Li','Be','B' ,'C' ,'N' ,'O' ,'F' ,'Ne','Na','Mg',
            'Al','Si','P' ,'S' ,'Cl','Ar','K' ,'Ca','Sc','Ti','V' ,'Cr',
            'Mn','Fe','Co','Ni','Cu','Zn','Ga','Ge','As','Se','Br','Kr',
            'Rb','Sr','Y' ,'Zr','Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd',
            'In','Sn','Sb','Te','I' ,'Xe','Cs','Ba','La','Ce','Pr','Nd',
            'Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb','Lu','Hf',
            'Ta','W' ,'Re','Os','Ir','Pt','Au','Hg','Tl','Pb','Bi','Po',
            'At','Rn','Fr','Ra','Ac','Th','Pa','U' ,'Np','Pu','Am','Cm',
            'Bk','Cf','Es','Fm','Md','No','Lr','Rf','Db','Sg','Bh','Hs',
            'Mt','Ds','Rg','Uub','Uut','Uuq','Uup','Uuh','Uus','Uuo','LP',
            'DUM','X','D'] 

AtomicNumber={'H'  :  1, 'He' :  2, 'Li' :  3, 'Be' :  4, 'B'  :  5, 'C'  :  6,
              'N'  :  7, 'O'  :  8, 'F'  :  9, 'Ne' : 10, 'Na' : 11, 'Mg' : 12,
              'Al' : 13, 'Si' : 14, 'P'  : 15, 'S'  : 16, 'Cl' : 17, 'Ar' : 18,
              'K'  : 19, 'Ca' : 20, 'Sc' : 21, 'Ti' : 22, 'V'  : 23, 'Cr' : 24,
              'Mn' : 25, 'Fe' : 26, 'Co' : 27, 'Ni' : 28, 'Cu' : 29, 'Zn' : 30,
              'Ga' : 31, 'Ge' : 32, 'As' : 33, 'Se' : 34, 'Br' : 35, 'Kr' : 36,
              'Rb' : 37, 'Sr' : 38, 'Y'  : 39, 'Zr' : 40, 'Nb' : 41, 'Mo' : 42,
              'Tc' : 43, 'Ru' : 44, 'Rh' : 45, 'Pd' : 46, 'Ag' : 47, 'Cd' : 48,
              'In' : 49, 'Sn' : 50, 'Sb' : 51, 'Te' : 52, 'I'  : 53, 'Xe' : 54,
              'Cs' : 55, 'Ba' : 56, 'La' : 57, 'Ce' : 58, 'Pr' : 59, 'Nd' : 60,
              'Pm' : 61, 'Sm' : 62, 'Eu' : 63, 'Gd' : 64, 'Tb' : 65, 'Dy' : 66,
              'Ho' : 67, 'Er' : 68, 'Tm' : 69, 'Yb' : 70, 'Lu' : 71, 'Hf' : 72,
              'Ta' : 73, 'W'  : 74, 'Re' : 75, 'Os' : 76, 'Ir' : 77, 'Pt' : 78,
              'Au' : 79, 'Hg' : 80, 'Tl' : 81, 'Pb' : 82, 'Bi' : 83, 'Po' : 84,
              'At' : 85, 'Rn' : 86, 'Fr' : 87, 'Ra' : 88, 'Ac' : 89, 'Th' : 90,
              'Pa' : 91, 'U'  : 92, 'Np' : 93, 'Pu' : 94, 'Am' : 95, 'Cm' : 96,
              'Bk' : 97, 'Cf' : 98, 'Es' : 99, 'Fm' :100, 'Md' :101, 'No' :102,
              'Lr' :103, 'Rf' :104, 'Db' :105, 'Sg' :106, 'Bh' :107, 'Hs' :108,
              'Mt' :109, 'Ds' :110, 'Rg' :111, 'Uub':112, 'Uut':113, 'Uuq':114,
              'Uup':115, 'Uuh':116, 'Uus':117, 'Uuo':118, 'LP' : 0 , 'DUM':  0,
              'X'  :  0, 'D'  :  0 }

AtomicMass = { 'H'  :   1.0079 , 'He' :   4.0026 , 'Li' :   6.941  , 'Be' :   9.0122 , 'B'  :  10.811  , 'C'  :  12.0107 ,
               'N'  :  14.0067 , 'O'  :  15.9994 , 'F'  :  18.9984 , 'Ne' :  20.1797 , 'Na' :  22.9898 , 'Mg' :  24.3050 ,
               'Al' :  26.9815 , 'Si' :  28.0855 , 'P'  :  30.9738 , 'S'  :  32.065  , 'Cl' :  35.453  , 'Ar' :  39.948  ,
               'K'  :  39.0983 , 'Ca' :  40.078  , 'Sc' :  44.9559 , 'Ti' :  47.867  , 'V'  :  50.9415 , 'Cr' :  51.9961 ,
               'Mn' :  54.9380 , 'Fe' :  55.845  , 'Co' :  58.9331 , 'Ni' :  58.6934 , 'Cu' :  63.546  , 'Zn' :  65.409  ,
               'Ga' :  69.723  , 'Ge' :  72.64   , 'As' :  74.9216 , 'Se' :  78.96   , 'Br' :  79.904  , 'Kr' :  83.798  ,
               'Rb' :  85.4678 , 'Sr' :  87.62   , 'Y'  :  88.9059 , 'Zr' :  91.224  , 'Nb' :  92.9064 , 'Mo' :  95.94   ,
               'Tc' :  98.     , 'Ru' : 101.07   , 'Rh' : 102.9055 , 'Pd' : 106.42   , 'Ag' : 107.8682 , 'Cd' : 112.411  ,
               'In' : 114.818  , 'Sn' : 118.710  , 'Sb' : 121.760  , 'Te' : 127.60   , 'I'  : 126.9045 , 'Xe' : 131.293  ,
               'Cs' : 132.9055 , 'Ba' : 137.327  , 'La' : 138.9055 , 'Ce' : 140.116  , 'Pr' : 140.9077 , 'Nd' : 144.242  ,
               'Pm' : 145.     , 'Sm' : 150.36   , 'Eu' : 151.964  , 'Gd' : 157.25   , 'Tb' : 158.9254 , 'Dy' : 162.500  ,
               'Ho' : 164.9303 , 'Er' : 167.259  , 'Tm' : 168.9342 , 'Yb' : 173.04   , 'Lu' : 174.967  , 'Hf' : 178.49   ,
               'Ta' : 180.9479 , 'W'  : 183.84   , 'Re' : 186.207  , 'Os' : 190.23   , 'Ir' : 192.217  , 'Pt' : 195.084  ,
               'Au' : 196.9666 , 'Hg' : 200.59   , 'Tl' : 204.3833 , 'Pb' : 207.2    , 'Bi' : 208.9804 , 'Po' : 209.     ,
               'At' : 210.     , 'Rn' : 222.     , 'Fr' : 223.     , 'Ra' : 226.     , 'Ac' : 227.     , 'Th' : 232.0381 ,
               'Pa' : 231.0359 , 'U'  : 238.0289 , 'Np' : 237.     , 'Pu' : 244.     , 'Am' : 243.     , 'Cm' : 247.     ,
               'Bk' : 247.     , 'Cf' : 251.     , 'Es' : 252.     , 'Fm' : 257.     , 'Md' : 258.     , 'No' : 259.     ,
               'Lr' : 262.     , 'Rf' : 261.     , 'Db' : 262.     , 'Sg' : 266.     , 'Bh' : 264.     , 'Hs' : 277.     ,
               'Mt' : 268.     , 'Ds' : 281.     , 'Rg' : 272.     , 'Uub': 285.     , 'Uut': 284.     , 'Uuq': 289.     ,
               'Uup': 288.     , 'Uuh': 292.     , 'Uus': 291.     , 'Uuo': 294.     , 'LP' : 0.000000 , 'DUM': 0.000000 ,
               'X'  : 0.000000 , 'D'  : 0.000000 }

AtomColor = { 'H'  :[1.000000, 1.000000, 1.000000], 'He' :[0.850000, 1.000000, 1.000000], 'Li' :[0.800000, 0.500000, 1.000000], 
              'Be' :[0.760000, 1.000000, 0.000000], 'B'  :[1.000000, 0.710000, 0.710000], 'C'  :[0.500000, 0.500000, 0.500000],
              'N'  :[0.050000, 0.050000, 1.000000], 'O'  :[1.000000, 0.050000, 0.050000], 'F'  :[0.700000, 1.000000, 1.000000],    
              'Ne' :[0.700000, 0.890000, 0.960000], 'Na' :[0.670000, 0.360000, 0.950000], 'Mg' :[0.540000, 1.000000, 0.000000],
              'Al' :[0.750000, 0.650000, 0.650000], 'Si' :[0.500000, 0.600000, 0.600000], 'P'  :[1.000000, 0.500000, 0.000000],
              'S'  :[1.000000, 1.000000, 0.190000], 'Cl' :[0.120000, 0.940000, 0.120000], 'Ar' :[0.500000, 0.820000, 0.890000],
              'K'  :[0.560000, 0.250000, 0.830000], 'Ca' :[0.240000, 1.000000, 0.000000], 'Sc' :[0.900000, 0.900000, 0.900000], 
              'Ti' :[0.750000, 0.760000, 0.780000], 'V'  :[0.650000, 0.650000, 0.670000], 'Cr' :[0.540000, 0.600000, 0.780000], 
              'Mn' :[0.610000, 0.480000, 0.780000], 'Fe' :[0.880000, 0.400000, 0.200000], 'Co' :[0.940000, 0.560000, 0.630000], 
              'Ni' :[0.310000, 0.820000, 0.310000], 'Cu' :[0.780000, 0.500000, 0.200000], 'Zn' :[0.490000, 0.500000, 0.690000], 
              'Ga' :[0.760000, 0.560000, 0.560000], 'Ge' :[0.400000, 0.560000, 0.560000], 'As' :[0.740000, 0.500000, 0.890000], 
              'Se' :[1.000000, 0.630000, 0.000000], 'Br' :[0.650000, 0.160000, 0.160000], 'Kr' :[0.360000, 0.720000, 0.820000], 
              'Rb' :[0.440000, 0.180000, 0.690000], 'Sr' :[0.000000, 1.000000, 0.000000], 'Y'  :[0.580000, 1.000000, 1.000000], 
              'Zr' :[0.580000, 0.880000, 0.880000], 'Nb' :[0.450000, 0.760000, 0.790000], 'Mo' :[0.330000, 0.710000, 0.710000], 
              'Tc' :[0.230000, 0.620000, 0.620000], 'Ru' :[0.140000, 0.560000, 0.560000], 'Rh' :[0.040000, 0.490000, 0.550000], 
              'Pd' :[0.000000, 0.410000, 0.520000], 'Ag' :[0.880000, 0.880000, 1.000000], 'Cd' :[1.000000, 0.850000, 0.560000], 
              'In' :[0.650000, 0.460000, 0.450000], 'Sn' :[0.400000, 0.500000, 0.500000], 'Sb' :[0.620000, 0.390000, 0.710000], 
              'Te' :[0.830000, 0.480000, 0.000000], 'I'  :[0.580000, 0.000000, 0.580000], 'Xe' :[0.260000, 0.620000, 0.690000], 
              'Cs' :[0.340000, 0.090000, 0.560000], 'Ba' :[0.000000, 0.790000, 0.000000], 'La' :[0.440000, 0.830000, 1.000000], 
              'Ce' :[1.000000, 1.000000, 0.780000], 'Pr' :[0.850000, 1.000000, 0.780000], 'Nd' :[0.780000, 1.000000, 0.780000],
              'Pm' :[0.640000, 1.000000, 0.780000], 'Sm' :[0.560000, 1.000000, 0.780000], 'Eu' :[0.380000, 1.000000, 0.780000], 
              'Gd' :[0.270000, 1.000000, 0.780000], 'Tb' :[0.190000, 1.000000, 0.780000], 'Dy' :[0.120000, 1.000000, 0.780000], 
              'Ho' :[0.000000, 1.000000, 0.610000], 'Er' :[0.000000, 0.900000, 0.460000], 'Tm' :[0.000000, 0.830000, 0.320000], 
              'Yb' :[0.000000, 0.750000, 0.220000], 'Lu' :[0.000000, 0.670000, 0.140000], 'Hf' :[0.300000, 0.760000, 1.000000], 
              'Ta' :[0.300000, 0.650000, 1.000000], 'W'  :[0.130000, 0.580000, 0.840000], 'Re' :[0.150000, 0.490000, 0.670000], 
              'Os' :[0.150000, 0.400000, 0.590000], 'Ir' :[0.090000, 0.330000, 0.530000], 'Pt' :[0.960000, 0.930000, 0.820000], 
              'Au' :[0.800000, 0.820000, 0.120000], 'Hg' :[0.710000, 0.710000, 0.760000], 'Tl' :[0.650000, 0.330000, 0.300000], 
              'Pb' :[0.340000, 0.350000, 0.380000], 'Bi' :[0.620000, 0.310000, 0.710000], 'Po' :[0.670000, 0.360000, 0.000000], 
              'At' :[0.460000, 0.310000, 0.270000], 'Rn' :[0.260000, 0.510000, 0.590000], 'Fr' :[0.260000, 0.000000, 0.400000], 
              'Ra' :[0.000000, 0.490000, 0.000000], 'Ac' :[0.440000, 0.670000, 0.980000], 'Th' :[0.000000, 0.730000, 1.000000], 
              'Pa' :[0.000000, 0.630000, 1.000000], 'U'  :[0.000000, 0.560000, 1.000000], 'Np' :[0.000000, 0.500000, 1.000000], 
              'Pu' :[0.000000, 0.420000, 1.000000], 'Am' :[0.330000, 0.360000, 0.950000], 'Cm' :[0.470000, 0.360000, 0.890000], 
              'Bk' :[0.540000, 0.310000, 0.890000], 'Cf' :[0.630000, 0.210000, 0.830000], 'Es' :[0.700000, 0.120000, 0.830000], 
              'Fm' :[0.700000, 0.120000, 0.730000], 'Md' :[0.700000, 0.050000, 0.650000], 'No' :[0.740000, 0.050000, 0.530000], 
              'Lr' :[0.780000, 0.000000, 0.400000], 'Rf' :[0.800000, 0.000000, 0.350000], 'Db' :[0.820000, 0.000000, 0.310000], 
              'Sg' :[0.850000, 0.000000, 0.270000], 'Bh' :[0.880000, 0.000000, 0.220000], 'Hs' :[0.900000, 0.000000, 0.180000], 
              'Mt' :[0.920000, 0.000000, 0.150000], 'Ds' :[0.930000, 0.000000, 0.140000], 'Rg' :[0.940000, 0.000000, 0.130000], 
              'Uub':[0.950000, 0.000000, 0.120000], 'Uut':[0.960000, 0.000000, 0.110000], 'Uuq':[0.970000, 0.000000, 0.100000], 
              'Uup':[0.980000, 0.000000, 0.090000], 'Uuh':[0.990000, 0.000000, 0.080000], 'Uus':[0.970000, 0.090000, 0.100000], 
              'Uuo':[0.980000, 0.090000, 0.090000], 'LP' :[1.000000, 0.800000, 1.000000], 'DUM':[0.070000, 0.300000, 0.300000], 
              'X'  :[0.070000, 0.500000, 0.700000], 'D'  :[0.070000, 0.400000, 0.700000]}


CovalentRadius = { 'H'  : 0.310000 , 'He' : 0.280000 , 'Li' : 1.280000 , 'Be' : 0.960000 , 'B'  : 0.840000 , 'C'  : 0.760000 ,   
                   'N'  : 0.710000 , 'O'  : 0.660000 , 'F'  : 0.570000 , 'Ne' : 0.580000 , 'Na' : 1.660000 , 'Mg' : 1.410000 ,  
                   'Al' : 1.210000 , 'Si' : 1.110000 , 'P'  : 1.070000 , 'S'  : 1.050000 , 'Cl' : 1.020000 , 'Ar' : 1.060000 ,  
                   'K'  : 2.030000 , 'Ca' : 1.760000 , 'Sc' : 1.700000 , 'Ti' : 1.600000 , 'V'  : 1.530000 , 'Cr' : 1.390000 ,  
                   'Mn' : 1.390000 , 'Fe' : 1.320000 , 'Co' : 1.260000 , 'Ni' : 1.240000 , 'Cu' : 1.320000 , 'Zn' : 1.220000 ,  
                   'Ga' : 1.220000 , 'Ge' : 1.200000 , 'As' : 1.190000 , 'Se' : 1.200000 , 'Br' : 1.200000 , 'Kr' : 1.160000 ,  
                   'Rb' : 2.200000 , 'Sr' : 1.950000 , 'Y'  : 1.900000 , 'Zr' : 1.750000 , 'Nb' : 1.640000 , 'Mo' : 1.540000 ,  
                   'Tc' : 1.470000 , 'Ru' : 1.460000 , 'Rh' : 1.420000 , 'Pd' : 1.390000 , 'Ag' : 1.450000 , 'Cd' : 1.440000 ,  
                   'In' : 1.420000 , 'Sn' : 1.390000 , 'Sb' : 1.390000 , 'Te' : 1.380000 , 'I'  : 1.390000 , 'Xe' : 1.400000 ,  
                   'Cs' : 2.440000 , 'Ba' : 2.150000 , 'La' : 2.070000 , 'Ce' : 2.040000 , 'Pr' : 2.030000 , 'Nd' : 2.010000 ,  
                   'Pm' : 1.990000 , 'Sm' : 1.980000 , 'Eu' : 1.980000 , 'Gd' : 1.960000 , 'Tb' : 1.940000 , 'Dy' : 1.920000 ,  
                   'Ho' : 1.920000 , 'Er' : 1.890000 , 'Tm' : 1.900000 , 'Yb' : 1.870000 , 'Lu' : 1.870000 , 'Hf' : 1.750000 ,  
                   'Ta' : 1.700000 , 'W'  : 1.620000 , 'Re' : 1.510000 , 'Os' : 1.440000 , 'Ir' : 1.410000 , 'Pt' : 1.360000 ,  
                   'Au' : 1.360000 , 'Hg' : 1.320000 , 'Tl' : 1.450000 , 'Pb' : 1.460000 , 'Bi' : 1.480000 , 'Po' : 1.400000 ,  
                   'At' : 1.500000 , 'Rn' : 1.500000 , 'Fr' : 2.600000 , 'Ra' : 2.210000 , 'Ac' : 2.150000 , 'Th' : 2.060000 ,  
                   'Pa' : 2.000000 , 'U'  : 1.960000 , 'Np' : 1.900000 , 'Pu' : 1.870000 , 'Am' : 1.800000 , 'Cm' : 1.690000 ,  
                   'Bk' : 1.600000 , 'Cf' : 1.600000 , 'Es' : 1.600000 , 'Fm' : 1.600000 , 'Md' : 1.600000 , 'No' : 1.600000 , 
                   'Lr' : 1.600000 , 'Rf' : 1.600000 , 'Db' : 1.600000 , 'Sg' : 1.600000 , 'Bh' : 1.600000 , 'Hs' : 1.600000 , 
                   'Mt' : 1.600000 , 'Ds' : 1.600000 , 'Rg' : 1.600000 , 'Uub': 1.600000 , 'Uut': 1.600000 , 'Uuq': 1.600000 , 
                   'Uup': 1.600000 , 'Uuh': 1.600000 , 'Uus': 1.600000 , 'Uuo': 1.600000 , 'LP' : 0.310000 , 'DUM': 0.100000 ,
                   'X'  : 0.100000 , 'D'  : 0.200000 }


BondOrder = { 'H'  :  1, 'He' :  0, 'Li' :  1, 'Be' :  2, 'B'  :  4, 'C'  :  4,  
              'N'  :  4, 'O'  :  3, 'F'  :  1, 'Ne' :  0, 'Na' :  1, 'Mg' :  2,
              'Al' :  6, 'Si' :  6, 'P'  :  6, 'S'  :  6, 'Cl' :  1, 'Ar' :  0,
              'K'  :  1, 'Ca' :  2, 'Sc' :  6, 'Ti' :  6, 'V'  :  6, 'Cr' :  6, 
              'Mn' :  8, 'Fe' :  6, 'Co' :  6, 'Ni' :  6, 'Cu' :  6, 'Zn' :  6, 
              'Ga' :  3, 'Ge' :  4, 'As' :  3, 'Se' :  2, 'Br' :  1, 'Kr' :  0, 
              'Rb' :  1, 'Sr' :  2, 'Y'  :  6, 'Zr' :  6, 'Nb' :  6, 'Mo' :  6, 
              'Tc' :  6, 'Ru' :  6, 'Rh' :  6, 'Pd' :  6, 'Ag' :  6, 'Cd' :  6, 
              'In' :  3, 'Sn' :  4, 'Sb' :  3, 'Te' :  2, 'I'  :  1, 'Xe' :  0, 
              'Cs' :  1, 'Ba' :  2, 'La' : 12, 'Ce' :  6, 'Pr' :  6, 'Nd' :  6, 
              'Pm' :  6, 'Sm' :  6, 'Eu' :  6, 'Gd' :  6, 'Tb' :  6, 'Dy' :  6, 
              'Ho' :  6, 'Er' :  6, 'Tm' :  6, 'Yb' :  6, 'Lu' :  6, 'Hf' :  6, 
              'Ta' :  6, 'W'  :  6, 'Re' :  6, 'Os' :  6, 'Ir' :  6, 'Pt' :  6, 
              'Au' :  6, 'Hg' :  6, 'Tl' :  3, 'Pb' :  4, 'Bi' :  3, 'Po' :  2, 
              'At' :  1, 'Rn' :  0, 'Fr' :  1, 'Ra' :  2, 'Ac' :  6, 'Th' :  6, 
              'Pa' :  6, 'U'  :  6, 'Np' :  6, 'Pu' :  6, 'Am' :  6, 'Cm' :  6, 
              'Bk' :  6, 'Cf' :  6, 'Es' :  6, 'Fm' :  6, 'Md' :  6, 'No' :  6, 
              'Lr' :  6, 'Rf' :  6, 'Db' :  6, 'Sg' :  6, 'Bh' :  6, 'Hs' :  6, 
              'Mt' :  6, 'Ds' :  6, 'Rg' :  6, 'Uub':  6, 'Uut':  6, 'Uuq':  6, 
              'Uup':  6, 'Uuh':  6, 'Uus':  6, 'Uuo':  6, 'LP' :  0, 'DUM':  0,
              'X'  :  0, 'D'  :  0 }

BioNametoAtomName={'HA'  :'H', 'HB'  :'H', 'HD'  :'H', 'HE'  :'H', 'HN'  :'H', 'HY'  :'H', 'HTC' :'H', 'HG' : 'H', 
                   'CA'  :'C', 'CB'  :'C', 'CD'  :'C', 'CE'  :'C', 'CG'  :'C', 'CY'  :'C', 'CZ'  :'C',
                   'ND'  :'N', 'NE'  :'N', 'NH'  :'N', 'NT'  :'N', 'OD'  :'O', 'OE'  :'O', 'OY'  :'O',
                   'OS'  :'O', 'SG'  :'S',  'SOD' :'Na','MAG' :'Mg','CLA' :'Cl','POT' :'K', 'CAL' :'Ca'}

AtomTypetoAtomName={'ALG1':    'Al',  'BAD':     'Ba',  'BAR':     'Ba',  'BRAD':    'Br',  'BRGA1':   'Br',     
                    'BRGA2':   'Br',  'BRGA3':   'Br',  'BRGR1':   'Br',  'BRQA1':   'Br',  'BRQR1':   'Br',
                    'C800':    'C',   'CA':      'C',   'CAD':     'Cd',  'CAI':     'C',   'C':       'C',
                    'CC1A':    'C',   'CC1B':    'C',   'CC2':     'C',   'CC2O1':   'C',   'CC2O2':   'C',
                    'CC2O3':   'C',   'CC2O4':   'C',   'CC2O5':   'C',   'CC301':   'C',   'CC3051':  'C',
                    'CC3062':  'C',   'CC311':   'C',   'CC311C':  'C',   'CC311D':  'C',   'CC312':   'C',
                    'CC312C':  'C',   'CC312D':  'C',   'CC3151':  'C',   'CC3152':  'C',   'CC3153':  'C',
                    'CC3161':  'C',   'CC3162':  'C',   'CC3163':  'C',   'CC321':   'C',   'CC321C':  'C',
                    'CC321D':  'C',   'CC322':   'C',   'CC322C':  'C',   'CC3251':  'C',   'CC3261':  'C',
                    'CC3263':  'C',   'CC331':   'C',   'CC':      'C',   'CCL':     'C',   'CD1N1':   'C',
                    'CD2C1A':  'C',   'CD2N1A':  'C',   'CD2O1A':  'C',   'CD2O1C':  'C',   'CD2O1D':  'C',
                    'CD2O2A':  'C',   'CD2O3A':  'C',   'CD2O3B':  'C',   'CD2O4A':  'C',   'CD2R5A':  'C',
                    'CD2R5B':  'C',   'CD2R5C':  'C',   'CD2R5D':  'C',   'CD2R5E':  'C',   'CD2R5F':  'C',
                    'CD2R6A':  'C',   'CD2R6B':  'C',   'CD2R6C':  'C',   'CD2R6D':  'C',   'CD2R6F':  'C',
                    'CD2R6H':  'C',   'CD2R6I':  'C',   'CD2R6J':  'C',   'CD30A':   'C',   'CD30FA':  'C',
                    'CD315A':  'C',   'CD315B':  'C',   'CD316A':  'C',   'CD31A':   'C',   'CD31C':   'C',
                    'CD31FA':  'C',   'CD31FB':  'C',   'CD31FC':  'C',   'CD31G':   'C',   'CD31HA':  'C',
                    'CD31HB':  'C',   'CD31HC':  'C',   'CD325A':  'C',   'CD325B':  'C',   'CD326A':  'C',
                    'CD326B':  'C',   'CD32A':   'C',   'CD32B':   'C',   'CD32C':   'C',   'CD32E':   'C',
                    'CD32F':   'C',   'CD33A':   'C',   'CD33B':   'C',   'CD33C':   'C',   'CD33D':   'C',
                    'CD33E':   'C',   'CD':      'C',
                    'CE1':     'C',   'CE2':     'C',   'CEL1':    'C',   'CEL2':    'C',   'CEL3':    'C',
                    'CF1':     'C',   'CF2':     'C',   'CF3':     'C',
                    'CG1N1':   'C',   'CG1T1':   'C',   'CG1T2':   'C',   'CG251O':  'C',
                    'CG252O':  'C',   'CG25C1':  'C',   'CG25C2':  'C',   'CG2D1':   'C',   'CG2D1O':  'C',    'CG2D2':   'C',   'CG2D2O':  'C',
                    'CG2DC1':  'C',   'CG2DC2':  'C',   'CG2DC3':  'C',
                    'CG2N1':   'C',   'CG2N2':   'C',   'CG2O1':   'C',   'CG2O2':   'C',   'CG2O3':   'C',    'CG2O4':   'C',   'CG2O5':   'C',
                    'CG2O6':   'C',   'CG2O7':   'C',   'CG2R51':  'C',   'CG2R52':  'C',
                    'CG2R53':  'C',   'CG2R57':  'C',   'CG2R61':  'C',   'CG2R62':  'C',   'CG2R63':  'C',    'CG2R64':  'C',   'CG2R66':  'C',
                    'CG2R67':  'C',   'CG2R71':  'C',   'CG2RC0':  'C',
                    'CG2RC7':  'C',   'CG301':   'C',   'CG302':   'C',   'CG311':   'C',   'CG312':   'C',    'CG314':   'C',   'CG321':   'C',
                    'CG322':   'C',   'CG323':   'C',   'CG324':   'C',   'CG331':   'C',
                    'CG334':   'C',   'CG3AM0':  'C',   'CG3AM1':  'C',   'CG3AM2':  'C',   'CG3C31':  'C',    'CG3C41':  'C',   'CG3C50':  'C',
                    'CG3C51':  'C',   'CG3C52':  'C',   'CG3C53':  'C',
                    'CG3C54':  'C',   'CG3RC1':  'C',   'CM':      'C',   'CN1A':    'C',   'CN1':     'C',    'CN1T':    'C',   'CN2':     'C',  'CN3A':   'C',
                    'CN3B':    'C',   'CN3':     'C',   'CN3C':    'C',   'CN3T':    'C',
                    'CN4':     'C',   'CN5':     'C',   'CN5G':    'C',   'CN7B':    'C',   'CN7':     'C',    'CN8B':    'C',   'CN8':     'C',  'CN9':    'C',
                    'CP1':     'C',   'CP2':     'C',   'CP3':     'C',   'CPA':     'C',   'CPB':     'C',
                    'CPD1':    'C',   'CPH1':    'C',   'CPH2':    'C',   'CPM':     'C',   'CPT':     'C',    'CQ1C1A':  'C',   'CQ1C1B':  'C',  'CQ1N1':  'C',
                    'CQ251O':  'C',   'CQ25C1':  'C',   'CQ25C2':  'C',
                    'CQ2C1A':  'C',   'CQ2C1B':  'C',   'CQ2D1O':  'C',   'CQ2D2O':  'C',   'CQ2DC1':  'C',    'CQ2DC2':  'C',   'CQ2DC3':  'C',
                    'CQ2N1A':  'C',   'CQ2N1B':  'C',   'CQ2O1A':  'C',
                    'CQ2O1C':  'C',   'CQ2O1D':  'C',   'CQ2O1E':  'C',   'CQ2O2A':  'C',   'CQ2O3A':  'C',    'CQ2O4A':  'C',   'CQ2R5A':  'C',
                    'CQ2R5B':  'C',   'CQ2R5D':  'C',   'CQ2R5E':  'C',
                    'CQ2R5G':  'C',   'CQ2R6A':  'C',   'CQ2R6B':  'C',   'CQ2R6C':  'C',   'CQ2R6E':  'C',    'CQ2R6F':  'C',   'CQ2R6H':  'C',
                    'CQ2R6I':  'C',   'CQ2R7A':  'C',   'CQ2R7B':  'C',
                    'CQ30A':   'C',   'CQ30FA':  'C',   'CQ316A':  'C',   'CQ31A':   'C',   'CQ31FA':  'C',    'CQ325A':  'C',   'CQ326A':  'C',
                    'CQ326B':  'C',   'CQ32A':   'C',   'CQ33A':   'C',   'CQ3R3A':  'C',
                    'CQ3R4A':  'C',   'CQ3RC1':  'C',   'CRL1':    'C',   'CRL2':    'C',   'CS':      'C',
                    'CST':     'C',   'CT1':     'C',   'CT2A':    'C',   'CT2':     'C',   'CT3':     'C',    'CT':      'C',   'CTD1':    'C',
                    'CTL1':    'C',   'CTL2':    'C',   'CTL3':    'C',   'CTL5':    'C',   'CTO1':    'C',    'CTO2':    'C',   'CY':      'C',
                    'CL801':   'Cl',  'CL802':   'Cl',  'CL803':   'Cl',  'CLA':     'Cl',
                    'CLAD':    'Cl',  'CL':      'C',   'CLGA1':   'Cl',  'CLGA3':   'Cl',  'CLGR1':   'Cl',
                    'CLQA1':   'Cl',  'CLQA3':   'Cl',  'CLQR1':   'Cl',
                    'CAL':     'Ca',  'CALD':    'Ca',
                    'CES':     'Cs',  'CSD':     'Cs',  'DOH2':    'D',   'DRUD':    'D',   'DUM':     'DUM',
                    'F1':      'F',   'F2':      'F',   'F3':      'F',   'FAD':     'F',   'FE':      'Fe',
                    'FGA1':    'F',   'FGA2':    'F',   'FGA3':    'F',
                    'FGP1':    'F',   'FGR1':    'F',   'FQA1':    'F',   'FQA3':    'F',   'FQP1':    'F',    'FQR1':    'F',
                    'H804':    'H',   'HA1':     'H',   'HA2':     'H',   'HA3':     'H',   'HA':      'H',    'HAL1':    'H',   'HAL2':    'H',
                    'HAL3':    'H',   'HB1':     'H',   'HB2':     'H',   'HBL':     'H',   'HCA1C2':  'H',    'HCA1':    'H',
                    'HCA2C2':  'H',   'HCA2':    'H',   'HCA3':    'H',   'HCA3M':   'H',   'HC':      'H',    'HCL':     'H',
                    'HCP1':    'H',   'HCP1M':   'H',   'HCR1':    'H',   'HD2C1A':  'H',   'HDA1A':   'H',    'HDA1C':   'H',
                    'HDA1R5':  'H',   'HDA2A':   'H',   'HDA2C':   'H',   'HDA2E':   'H',   'HDA2R5':  'H',
                    'HDA3A':   'H',   'HDA3B':   'H',   'HDA3C':   'H',   'HDP1A':   'H',   'HDP1B':   'H',    'HDP1C':   'H',
                    'HDR5A':   'H',   'HDR5B':   'H',   'HDR5C':   'H',   'HDR5D':   'H',   'HDR5E':   'H',
                    'HDR6A':   'H',   'HDR6B':   'H',   'HDR6C':   'H',   'HDW':     'H',   'HF1':     'H',    'HF2':     'H',   'HGA1':    'H',
                    'HGA2':    'H',   'HGA3':    'H',   'HGA4':    'H',   'HGA5':    'H',   'HGA6':    'H',    'HGA7':    'H',   'HGAAM0':  'H',
                    'HGAAM1':  'H',   'HGAAM2':  'H',   'HGP1':    'H',   'HGP2':    'H',   'HGP3':    'H',
                    'HGP4':    'H',   'HGP5':    'H',   'HGPAM1':  'H',   'HGPAM2':  'H',   'HGPAM3':  'H',    'HGR51':   'H',
                    'HGR52':   'H',   'HGR53':   'H',   'HGR61':   'H',   'HGR62':   'H',   'HGR63':   'H',
                    'HGR71':   'H',   'H':       'H',   'HL':      'H',   'HN1':     'H',   'HN2':     'H',
                    'HN3B':    'H',   'HN3':     'H',   'HN4':     'H',   'HN5':     'H',   'HN6':     'H',
                    'HN7':     'H',   'HN8':     'H',   'HN9':     'H',
                    'HOL':     'H',   'HP':      'H',   'HQ2C1A':  'H',   'HQ2C1B':  'H',   'HQA1A':   'H',    'HQA2A':   'H',
                    'HQA3A':   'H',   'HQP1A':   'H',   'HQP1C':   'H',   'HQR5A':   'H',   'HQR5D':   'H',    'HQR6A':   'H',
                    'HQR6B':   'H',   'HQR7A':   'H',   'HR1':     'H',   'HR2':     'H',   'HR3':     'H',
                    'HS':      'H',   'HT':      'H',   'HX':      'H',
                    'HE1':     'H',   'HE2':     'H',   'HE':      'He',  'HEL1':    'H',   'HEL2':    'H',
                    'IAD':     'I',   'IGR1':    'I',   'IQA1':    'I',   'IQR1':    'I',
                    'LID':     'Li',  'LIT':     'Li',  'LPD':     'LP',  'LPDN1':   'LP',  'LPDNA1':  'LP',
                    'LPDO1':   'LP',  'LPDW':    'LP',  'LPH':     'LP',  'LPQN1':   'LP',  'LPQN2':   'LP',   'LPQN3':   'LP',
                    'LPQO1':   'LP',  'LPQO2':   'LP',  'LPR':     'LP',  'MAGD':    'Mg',  'MG':      'Mg',
                    'NC2D1':   'N',   'NC2':     'N',   'NC311':   'N',   'ND1T1':   'N',   'ND2A1':   'N',
                    'ND2A2':   'N',   'ND2A3':   'N',   'ND2B1':   'N',   'ND2P1A':  'N',   'ND2R5A':  'N',    'ND2R5B':  'N',
                    'ND2R5C':  'N',   'ND2R5D':  'N',   'ND2R5E':  'N',   'ND2R5F':  'N',   'ND2R6A':  'N',
                    'ND2R6B':  'N',   'ND2R6C':  'N',   'ND2R6D':  'N',   'ND3A3':   'N',   'ND3P2A':  'N',    'ND3P3A':  'N',
                    'NED':     'Ne',  'NE':      'Ne',  'NG1T1':   'N',   'NG2D1':   'N',   'NG2O1':   'N',    'NG2P1':   'N',   'NG2R43':  'N',
                    'NG2R50':  'N',   'NG2R51':  'N',   'NG2R52':  'N',   'NG2R53':  'N',   'NG2R57':  'N',    'NG2R60':  'N',
                    'NG2R61':  'N',   'NG2R62':  'N',   'NG2R67':  'N',   'NG2RC0':  'N',   'NG2S0':   'N',
                    'NG2S1':   'N',   'NG2S2':   'N',   'NG2S3':   'N',   'NG301':   'N',   'NG311':   'N',    'NG321':   'N',
                    'NG331':   'N',   'NG3C51':  'N',   'NG3N1':   'N',   'NG3P0':   'N',   'NG3P1':   'N',
                    'NG3P2':   'N',   'NG3P3':   'N',   'NH1':     'N',   'NH2':     'N',   'NH3L':    'N',    'NH3':     'N',
                    'NHL':     'N',   'N':       'N',   'NN1':     'N',   'NN2B':    'N',   'NN2G':    'N',    'NN2':     'N',   'NN2U':    'N',
                    'NN3A':    'N',   'NN3G':    'N',   'NN3':     'N',   'NN4':     'N',   'NN6':     'N',    'NPH':     'N',   'NP':      'N',
                    'NQ2A1':   'N',   'NQ2A2':   'N',   'NQ2A3':   'N',   'NQ2B1':   'N',   'NQ2C1':   'N',
                    'NQ2C2':   'N',   'NQ2N2':   'N',   'NQ2O1':   'N',   'NQ2P1A':  'N',   'NQ2R4A':  'N',    'NQ2R5A':  'N',
                    'NQ2R5B':  'N',   'NQ2R5C':  'N',   'NQ2R5G':  'N',   'NQ2R5H':  'N',   'NQ2R6A':  'N',
                    'NQ2R6B':  'N',   'NQ2R6C':  'N',   'NQ2R6D':  'N',   'NQ2R6E':  'N',   'NQ30A':   'N',    'NQ31A':   'N',
                    'NQ32A':   'N',   'NQ33A':   'N',   'NQ3A3':   'N',   'NQ3P2A':  'N',   'NQ3P3A':  'N',
                    'NR1':     'N',   'NR2':     'N',   'NR3':     'N',   'NS1':     'N',   'NS2':     'N',
                    'NTL':     'N',   'NY':      'N',   'O2L':     'O',   'OBL':     'O',   'OB':      'O',    'OC2D1':   'O',
                    'OC2D2':   'O',   'OC2D3':   'O',   'OC2D4':   'O',   'OC2DP':   'O',   'OC301':   'O',    'OC302':   'O',
                    'OC303':   'O',   'OC30P':   'O',   'OC311M':  'O',   'OC311':   'O',   'OC312':   'O',
                    'OC3C51':  'O',   'OC3C5M':  'O',   'OC3C61':  'O',   'OCL':     'O',   'OC':      'O',    'OD2C1A':  'O',   'OD2C1B':  'O',
                    'OD2C1C':  'O',   'OD2C1D':  'O',   'OD2C2A':  'O',   'OD2C2B':  'O',   'OD2C2C':  'O',    'OD2C3A':  'O',
                    'OD2C3B':  'O',   'OD305A':  'O',   'OD306A':  'O',   'OD30A':   'O',   'OD30BN':  'O',    'OD30B':   'O',
                    'OD30BR':  'O',   'OD30CL':  'O',   'OD30C':   'O',   'OD30D':   'O',   'OD31A':   'O',
                    'OD31B':   'O',   'OD31C':   'O',   'OD31D':   'O',   'OD31E':   'O',   'OD31G':   'O',    'ODW6':    'O',
                    'ODW':     'O',   'OG2D1':   'O',   'OG2D2':   'O',   'OG2D3':   'O',   'OG2D4':   'O',    'OG2D5':   'O',
                    'OG2N1':   'O',   'OG2P1':   'O',   'OG2R50':  'O',   'OG2S1':   'O',   'OG301':   'O',    'OG302':   'O',
                    'OG303':   'O',   'OG304':   'O',   'OG311':   'O',   'OG312':   'O',   'OG3C31':  'O',
                    'OG3C51':  'O',   'OG3C61':  'O',   'OG3R60':  'O',   'OH1':     'O',   'OHL':     'O',    'OM':      'O',
                    'ON1C':    'O',   'ON1':     'O',   'ON2B':    'O',   'ON2':     'O',   'ON3':     'O',    'ON4':     'O',
                    'ON5':     'O',   'ON6B':    'O',   'ON6':     'O',   'O':       'O',   'OQ2C1A':  'O',    'OQ2C1B':  'O',
                    'OQ2C1C':  'O',   'OQ2C1D':  'O',   'OQ2C2A':  'O',   'OQ2C2B':  'O',   'OQ2C2D':  'O',
                    'OQ2C3A':  'O',   'OQ2N1':   'O',   'OQ2R5A':  'O',   'OQ2R6A':  'O',   'OQ2S1':   'O',    'OQ305A':  'O',
                    'OQ306A':  'O',   'OQ30A':   'O',   'OQ30B':   'O',   'OQ30C':   'O',   'OQ30E':   'O',
                    'OQ30F':   'O',   'OQ31A':   'O',   'OQ31C':   'O',   'OQ31D':   'O',   'OQ31F':   'O',    'OQ3C3A':  'O',
                    'OSL':     'O',   'OSLP':    'O',   'OS':      'O',   'OST':     'O',   'OT':      'O',    'OX':      'O',
                    'P2':      'P',   'P3':      'P',   'P4':      'P',   'PC':      'P',
                    'PD1AN':   'P',   'PD1A':    'P',   'PG0':     'P',   'PG1':     'P',
                    'PG2':     'P',   'PL':      'P',   'POTD':    'K',   'POT':     'K',
                    'P':       'P',   'PQ1A':    'P',   'PQ1B':    'P',   'RBD':     'Rb',
                    'RUB':     'Rb',  'SC':      'S',   'SD1A':    'S',   'SD2C2A':  'S',
                    'SD2C2B':  'S',   'SD30A':   'S',   'SD30B':   'S',   'SD31A':   'S',   'SD31B':   'S',
                    'SG2D1':   'S',   'SG2P1':   'S',   'SG2P2':   'S',   'SG2R50':  'S',
                    'SG301':   'S',   'SG302':   'S',   'SG311':   'S',   'SG3O1':   'S',   'SG3O2':   'S',    'SG3O3':   'S',
                    'SL':      'S',   'SM':      'S',   'SP':      'S',   'SQ2C2A':  'S',   'SQ2O1':   'S',
                    'SQ2P1':   'S',   'SQ2P2':   'S',   'SQ2R5A':  'S',   'SQ30A':   'S',   'SQ30B':   'S',    'SQ31A':   'S',
                    'SQ3OA':   'S',   'SQ3OB':   'S',   'SQ3OC':   'S',   'S':       'S',   'SS':      'S',
                    'SEGD1':   'Se',  'SODD':    'Na',  'SOD':     'Na',  'SRD':     'Sr',  'XED':     'Xe',
                    'ZND':     'Zn',  'ZN':      'Zn' }
