# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_datacompy_report.ipynb.

# %% auto 0
__all__ = ['DatacompyReport']

# %% ../nbs/00_datacompy_report.ipynb 3
import pandas

# %% ../nbs/00_datacompy_report.ipynb 4
from fastcore.utils import *

# %% ../nbs/00_datacompy_report.ipynb 5
class DatacompyReport():
    """A class to modify the output of a datacompy instance and add reporting functionality"""
    
    def __init__(self, 
                 compare_instance): # a datacompy.core.Compare instance
        self.compare_instance = compare_instance
        self.column_summary = pandas.DataFrame(
            {
                'Quantity': [

                    f"Total Columns {self.compare_instance.df1_name}",
                    f"Total Columns {self.compare_instance.df2_name}",
                    f"Columns in Common",
                    f"Columns in {self.compare_instance.df1_name} but not in {self.compare_instance.df2_name}",
                    f"Columns in {self.compare_instance.df2_name} but not in {self.compare_instance.df1_name}",
                    "Number of columns compared with some values unequal",
                    "Number of columns compared with all values equal",
                    "Total number of values which compare unequal"


                ],
                'Value': [

                    self.compare_instance.df1.shape[1],
                    self.compare_instance.df2.shape[1],
                    len(self.compare_instance.intersect_columns()),
                    len(self.compare_instance.df1_unq_columns()), 
                    len(self.compare_instance.df2_unq_columns()),
                    len([col for col in self.compare_instance.column_stats if col["unequal_cnt"] > 0]),
                    len([col for col in self.compare_instance.column_stats if col["unequal_cnt"] == 0]),
                    sum([col["unequal_cnt"] for col in self.compare_instance.column_stats])
                ]

            }
        ).set_index('Quantity')
        
        self.row_summary = pandas.DataFrame(
            {
                'Quantity': [
                    "Matched On", 
                    "Any duplicates on Match Values", 
                    "Absolute/Relative Tolerance",
                    f"Total Rows {self.compare_instance.df1_name}",
                    f"Total Rows {self.compare_instance.df2_name}",
                    "Rows with Key Matches but Non-Key Differences",
                    f"Rows Only in {self.compare_instance.df1_name}",
                    f"Rows Only in {self.compare_instance.df2_name}",
                    "Number of rows with some compared columns unequal",
                    "Number of rows with all compared columns equal"
                ],
                'Value': [
                    self.compare_instance.join_columns, 
                    self.compare_instance._any_dupes, 
                    f"{self.compare_instance.abs_tol}, {self.compare_instance.rel_tol}",
                    self.compare_instance.df1.shape[0],
                    self.compare_instance.df2.shape[0],
                    self.compare_instance.intersect_rows.shape[0],
                    self.compare_instance.df1_unq_rows.shape[0],
                    self.compare_instance.df2_unq_rows.shape[0],
                    self.compare_instance.intersect_rows.shape[0] - self.compare_instance.count_matching_rows(),
                    self.compare_instance.count_matching_rows()

                ]

            }
        ).set_index('Quantity')
    
    def __str__(self):
        return f" datacompy_report instance:\n Comparing: {self.compare_instance.df1_name} and {self.compare_instance.df2_name}"
        
    __repr__ = __str__
    
    def _autosize_excel_columns_df(self, worksheet, df, offset=0):
        """Helper utility to appropriately widen column of Excel Spreadsheet"""

        for idx, col in enumerate(df):
            series = df[col]
            max_len = max((series.astype(str).map(len).max(),len(str(series.name)))) + 1
            worksheet.set_column(idx+offset, idx+offset, max_len)  
                   
    def _autosize_excel_columns(self, worksheet, df):
        """Helper ulitlity to apply across all columns and the index"""

        self._autosize_excel_columns_df(worksheet, df.index.to_frame())
        self._autosize_excel_columns_df(worksheet, df, offset=df.index.nlevels)

    def _make_worksheet(self, writer, df, sheet_name):
        """Helper utility to add DataFrame as worksheet to excel notebook"""

        if df.shape[0] > 1048576:
            print('Note: Excel workbooks have a limit of 1048576 rows, 16384 columns, and column widths of 255.')
            return None
    
        if df.shape[0] > 0:
            df.to_excel(
                writer, 
                sheet_name=sheet_name, 
                freeze_panes=(df.columns.nlevels, df.index.nlevels)
            )
            self._autosize_excel_columns(writer.sheets[sheet_name], df)
                

# %% ../nbs/00_datacompy_report.ipynb 6
@patch
def prepare_compare_results(self:DatacompyReport) -> 'pandas.DataFrame':
    
    """Reformats the Datacompy output to display all column differences found
    for matches between the two DataFrames based on the keys compare.join_columns

    Parameters
    ----------
    compare : instance of datacompy.Compare class
        An initialized datacompy.Compare() instance

    Returns
    -------
    pandas.DataFrame
        A DataFrame containing all records found in both tables where there
        was at least one difference found in a non-key column. Further, columns
        where the two DataFrames match are blanked out to make visual inspection
        of the differences stand out.
    """

    def _blank_matches(row: 'pd.DataFrame', col: str) -> 'pandas.DataFrame':
        """To reduce visual clutter, blank out entries where dataframes match.
            Meant to be applied across the rows of a difference_intersection DataFrame
            for a specific column at a time. This is just a helper function for .apply
            and I cannot think of a great way to do this. (TODO)

        """
        if row[f'{col}_match']:
            row[f'{col}_df1'] = ''
            row[f'{col}_df2'] = ''
            row[f'{col}_match'] = ''
        return row

    # Get the max number of comparisons made
    match_columns = self.compare_instance.intersect_rows.columns.str.contains('_match$', regex=True)
    len_cols_compare = match_columns.sum()

    # Find the number of matches for each row
    remove_rows_all_equal = self.compare_instance.intersect_rows.iloc[:,match_columns].sum(axis=1)

    # Remove rows were all compared columns were equal 
    remove_rows_all_equal = remove_rows_all_equal[(remove_rows_all_equal != len_cols_compare) == True]

    # Display the intersection only where at least one discrepancy is detected
    difference_intersection = self.compare_instance.intersect_rows.loc[remove_rows_all_equal.index]
    compare_cols = [item for item in self.compare_instance.intersect_columns() if item not in self.compare_instance.join_columns]

    # Get only the desired columns and in the desired order
    intersect_columns = []
    for item in sorted(compare_cols):
        for suf in ['_df1', '_df2', '_match']:
            intersect_columns.append(item + suf) 
    difference_intersection = difference_intersection[intersect_columns + self.compare_instance.join_columns]

    # Blank values where DataFrames match
    for col in compare_cols:
        difference_intersection = difference_intersection.apply(lambda row: _blank_matches(row, col), axis = 1)

    cols_to_delete = difference_intersection.columns[difference_intersection.columns.str.contains('_match$', regex=True)]
    difference_intersection.drop(columns = cols_to_delete, inplace=True)
    difference_intersection.set_index(self.compare_instance.join_columns, inplace=True)

    return difference_intersection

# %% ../nbs/00_datacompy_report.ipynb 7
@patch
def create_excel_report(
    self:DatacompyReport, 
    write_file: str # full path + filename where the Excel file is to be created
    ) -> None: 
    
    """Create Excel workbook with nicely formatted output comparing two DataFrames

    Parameters
    ----------
    compare : instance of datacompy.core.Compare class
        An initialized datacompy.core.Compare() instance

    write_file : path to where the Excel Workbook should be created

    Returns
    -------
    None
        Excel workbook written at write_file location
    """

    column_stats_summary = pandas.DataFrame(self.compare_instance.column_stats).set_index('column')
    matched_compare = self.prepare_compare_results()

    try:
        with pandas.ExcelWriter(write_file, engine='xlsxwriter') as writer: 

            self._make_worksheet(writer=writer, df=self.row_summary, sheet_name='Row Summary')
            self._make_worksheet(writer=writer, df=self.column_summary, sheet_name='Column Summary')
            self._make_worksheet(writer=writer, df=column_stats_summary, sheet_name='Column Stats')
            self._make_worksheet(
                writer=writer, 
                df=self.compare_instance.df1_unq_rows.set_index(self.compare_instance.join_columns), 
                sheet_name=f'{self.compare_instance.df1_name} Only Observations'
            )
            self._make_worksheet(
                writer=writer, 
                df=self.compare_instance.df2_unq_rows.set_index(self.compare_instance.join_columns), 
                sheet_name=f'{self.compare_instance.df2_name} Only Observations'
            )
            self._make_worksheet(writer=writer, df=matched_compare, sheet_name='Matched Differences')

        print("Excel Workbook has been created")

    except OSError as err:
        print("OS error:", err)
    except ValueError as err:
        print(f"Value error: {err}")
    except Exception as err:
        print(f"Unexpected {err}, {type(err)}")
        raise

    return None
