# Criteo API SDK for Python

## Introduction

API Client Libraries can facilitate your use of the Criteo API allowing you to build unique and customized solutions to serve your businesses and clients.
These libraries can reduce the amount of code you need to write in order to start accessing Criteo programmatically. They also can help expedite troubleshooting, should you encounter any issues.

More information: [https://developers.criteo.com/marketing-solutions/docs/python-api-client-library](https://developers.criteo.com/marketing-solutions/docs/python-api-client-library)

[![](https://img.shields.io/pypi/pyversions/criteo-marketing.svg)](https://pypi.org/project/criteo-marketing-transition/)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- Package version: 0.0.221003

## Requirements

Python 2.7 and 3.5+

## Installation & Usage
### pip install

```sh
pip install criteo-api-retailmedia-sdk==0.0.221003
```
(you may need to run `pip` with root permission: `sudo pip install criteo-api-retailmedia-sdk==0.0.221003`)

Then import the package:
```python
import criteo_api_retailmedia_preview
```

### Manual Installation using [Setuptools](http://pypi.python.org/pypi/setuptools)

Download the code or clone the repository locally, then execute the following command:

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import criteo_api_retailmedia_preview
```

## Example
Please see [examples/](examples/) for full examples to get a valid token and make a call to the API.

```sh
python ./examples/portfolio.py [client_id] [client_secret]
```

## Documentation for API Endpoints

The developers documentation is available at: *https://developers.criteo.com*.

All URIs are relative to *https://api.criteo.com*.

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------


## Documentation For Models

 - [AccessTokenModel](docs/AccessTokenModel.md)
 - [ApplicationSummaryModel](docs/ApplicationSummaryModel.md)
 - [ApplicationSummaryModelResource](docs/ApplicationSummaryModelResource.md)
 - [ApplicationSummaryModelResponse](docs/ApplicationSummaryModelResponse.md)
 - [BadRequest](docs/BadRequest.md)
 - [BrandPreview](docs/BrandPreview.md)
 - [BrandPreviewListResponse](docs/BrandPreviewListResponse.md)
 - [CommonError](docs/CommonError.md)
 - [CommonProblem](docs/CommonProblem.md)
 - [CommonWarning](docs/CommonWarning.md)
 - [CreateRetailMediaAudience](docs/CreateRetailMediaAudience.md)
 - [CreateRetailMediaAudienceAttributes](docs/CreateRetailMediaAudienceAttributes.md)
 - [CreateRetailMediaAudienceBody](docs/CreateRetailMediaAudienceBody.md)
 - [CreateRetailMediaAudienceRequest](docs/CreateRetailMediaAudienceRequest.md)
 - [CreateRetailMediaAudienceResponse](docs/CreateRetailMediaAudienceResponse.md)
 - [CustomerListDetails](docs/CustomerListDetails.md)
 - [EnvelopeReportRequest](docs/EnvelopeReportRequest.md)
 - [EnvelopeReportStatus](docs/EnvelopeReportStatus.md)
 - [Error](docs/Error.md)
 - [ExternalAccount](docs/ExternalAccount.md)
 - [ExternalBalance](docs/ExternalBalance.md)
 - [ExternalBalanceCampaign](docs/ExternalBalanceCampaign.md)
 - [ExternalBrand](docs/ExternalBrand.md)
 - [ExternalCampaign](docs/ExternalCampaign.md)
 - [ExternalCampaignAttributes](docs/ExternalCampaignAttributes.md)
 - [ExternalCatalogRequestPreview](docs/ExternalCatalogRequestPreview.md)
 - [ExternalCatalogStatus](docs/ExternalCatalogStatus.md)
 - [ExternalDeleteBalanceCampaign](docs/ExternalDeleteBalanceCampaign.md)
 - [ExternalEditableCampaignAttributes](docs/ExternalEditableCampaignAttributes.md)
 - [ExternalEditableLineItemAttributes](docs/ExternalEditableLineItemAttributes.md)
 - [ExternalLineItem](docs/ExternalLineItem.md)
 - [ExternalLineItemAttributes](docs/ExternalLineItemAttributes.md)
 - [ExternalPostCampaign](docs/ExternalPostCampaign.md)
 - [ExternalPostLineItem](docs/ExternalPostLineItem.md)
 - [ExternalPromotedProduct](docs/ExternalPromotedProduct.md)
 - [ExternalPutBalanceCampaign](docs/ExternalPutBalanceCampaign.md)
 - [ExternalPutCampaign](docs/ExternalPutCampaign.md)
 - [ExternalPutLineItem](docs/ExternalPutLineItem.md)
 - [ExternalRetailer](docs/ExternalRetailer.md)
 - [GetPageOfAudiencesByAccountIdResponse](docs/GetPageOfAudiencesByAccountIdResponse.md)
 - [JsonApiBodyWithExternalIdOfEditableCampaignAttributesAndCampaign](docs/JsonApiBodyWithExternalIdOfEditableCampaignAttributesAndCampaign.md)
 - [JsonApiBodyWithExternalIdOfEditableLineItemAttributesAndLineItem](docs/JsonApiBodyWithExternalIdOfEditableLineItemAttributesAndLineItem.md)
 - [JsonApiBodyWithIdOfInt64AndAccountAndAccount](docs/JsonApiBodyWithIdOfInt64AndAccountAndAccount.md)
 - [JsonApiBodyWithIdOfInt64AndBalanceAndBalance](docs/JsonApiBodyWithIdOfInt64AndBalanceAndBalance.md)
 - [JsonApiBodyWithIdOfInt64AndBrandAndBrand](docs/JsonApiBodyWithIdOfInt64AndBrandAndBrand.md)
 - [JsonApiBodyWithIdOfInt64AndCampaignAndCampaign](docs/JsonApiBodyWithIdOfInt64AndCampaignAndCampaign.md)
 - [JsonApiBodyWithIdOfInt64AndCatalogStatusAndCatalogStatus](docs/JsonApiBodyWithIdOfInt64AndCatalogStatusAndCatalogStatus.md)
 - [JsonApiBodyWithIdOfInt64AndLineItemAndLineItem](docs/JsonApiBodyWithIdOfInt64AndLineItemAndLineItem.md)
 - [JsonApiBodyWithIdOfInt64AndRetailerAndRetailer](docs/JsonApiBodyWithIdOfInt64AndRetailerAndRetailer.md)
 - [JsonApiBodyWithIdOfStringAndPromotedProductAndPromotedProduct](docs/JsonApiBodyWithIdOfStringAndPromotedProductAndPromotedProduct.md)
 - [JsonApiBodyWithoutIdOfCampaignAttributesAndCampaign](docs/JsonApiBodyWithoutIdOfCampaignAttributesAndCampaign.md)
 - [JsonApiBodyWithoutIdOfCatalogRequestAndCatalogRequestPreview](docs/JsonApiBodyWithoutIdOfCatalogRequestAndCatalogRequestPreview.md)
 - [JsonApiBodyWithoutIdOfLineItemAttributesAndLineItem](docs/JsonApiBodyWithoutIdOfLineItemAttributesAndLineItem.md)
 - [JsonApiDataRequestOfDeleteBalanceCampaign](docs/JsonApiDataRequestOfDeleteBalanceCampaign.md)
 - [JsonApiDataRequestOfPutBalanceCampaign](docs/JsonApiDataRequestOfPutBalanceCampaign.md)
 - [JsonApiDataRequestWithIdOfStringAndPromotedProduct](docs/JsonApiDataRequestWithIdOfStringAndPromotedProduct.md)
 - [JsonApiPageResponseOfAccount](docs/JsonApiPageResponseOfAccount.md)
 - [JsonApiPageResponseOfBalance](docs/JsonApiPageResponseOfBalance.md)
 - [JsonApiPageResponseOfBrand](docs/JsonApiPageResponseOfBrand.md)
 - [JsonApiPageResponseOfCampaign](docs/JsonApiPageResponseOfCampaign.md)
 - [JsonApiPageResponseOfLineItem](docs/JsonApiPageResponseOfLineItem.md)
 - [JsonApiPageResponseOfRetailer](docs/JsonApiPageResponseOfRetailer.md)
 - [JsonApiPageResponseOfStringAndPromotedProduct](docs/JsonApiPageResponseOfStringAndPromotedProduct.md)
 - [JsonApiRequestOfCatalogRequestPreview](docs/JsonApiRequestOfCatalogRequestPreview.md)
 - [JsonApiSingleResponseOfCampaign](docs/JsonApiSingleResponseOfCampaign.md)
 - [JsonApiSingleResponseOfCatalogStatus](docs/JsonApiSingleResponseOfCatalogStatus.md)
 - [JsonApiSingleResponseOfLineItem](docs/JsonApiSingleResponseOfLineItem.md)
 - [MapString](docs/MapString.md)
 - [OAuthErrorModel](docs/OAuthErrorModel.md)
 - [PageMetadata](docs/PageMetadata.md)
 - [PageOfBalanceCampaign](docs/PageOfBalanceCampaign.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [ReportRequest](docs/ReportRequest.md)
 - [ReportRequestAttributes](docs/ReportRequestAttributes.md)
 - [ReportStatus](docs/ReportStatus.md)
 - [ReportStatusAttributes](docs/ReportStatusAttributes.md)
 - [ResourceOfBrandPreview](docs/ResourceOfBrandPreview.md)
 - [ResourceOfSellerPreview](docs/ResourceOfSellerPreview.md)
 - [ResourceOfSkuDataPreview](docs/ResourceOfSkuDataPreview.md)
 - [ResourceOfSkuSearchRequestPreview](docs/ResourceOfSkuSearchRequestPreview.md)
 - [RetailMediaAudience](docs/RetailMediaAudience.md)
 - [RetailMediaAudienceAttributes](docs/RetailMediaAudienceAttributes.md)
 - [SellerPreview](docs/SellerPreview.md)
 - [SellerPreviewResponse](docs/SellerPreviewResponse.md)
 - [SkuDataPreview](docs/SkuDataPreview.md)
 - [SkuDataPreviewListResponse](docs/SkuDataPreviewListResponse.md)
 - [SkuSearchRequestPreview](docs/SkuSearchRequestPreview.md)
 - [SkuSearchRequestPreviewRequest](docs/SkuSearchRequestPreviewRequest.md)
 - [UserBehaviorDetails](docs/UserBehaviorDetails.md)


## Disclaimer

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.