"""
    Criteo API

    Criteo publicly exposed API  # noqa: E501

    The version of the OpenAPI document: Preview
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from criteo_api_retailmedia_preview.api_client import ApiClient, Endpoint as _Endpoint
from criteo_api_retailmedia_preview.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from criteo_api_retailmedia_preview.model.brand_preview_list_response import BrandPreviewListResponse
from criteo_api_retailmedia_preview.model.external_post_campaign import ExternalPostCampaign
from criteo_api_retailmedia_preview.model.external_post_line_item import ExternalPostLineItem
from criteo_api_retailmedia_preview.model.external_put_campaign import ExternalPutCampaign
from criteo_api_retailmedia_preview.model.external_put_line_item import ExternalPutLineItem
from criteo_api_retailmedia_preview.model.json_api_data_request_of_delete_balance_campaign import JsonApiDataRequestOfDeleteBalanceCampaign
from criteo_api_retailmedia_preview.model.json_api_data_request_of_put_balance_campaign import JsonApiDataRequestOfPutBalanceCampaign
from criteo_api_retailmedia_preview.model.json_api_data_request_with_id_of_string_and_promoted_product import JsonApiDataRequestWithIdOfStringAndPromotedProduct
from criteo_api_retailmedia_preview.model.json_api_page_response_of_account import JsonApiPageResponseOfAccount
from criteo_api_retailmedia_preview.model.json_api_page_response_of_balance import JsonApiPageResponseOfBalance
from criteo_api_retailmedia_preview.model.json_api_page_response_of_brand import JsonApiPageResponseOfBrand
from criteo_api_retailmedia_preview.model.json_api_page_response_of_campaign import JsonApiPageResponseOfCampaign
from criteo_api_retailmedia_preview.model.json_api_page_response_of_line_item import JsonApiPageResponseOfLineItem
from criteo_api_retailmedia_preview.model.json_api_page_response_of_retailer import JsonApiPageResponseOfRetailer
from criteo_api_retailmedia_preview.model.json_api_page_response_of_string_and_promoted_product import JsonApiPageResponseOfStringAndPromotedProduct
from criteo_api_retailmedia_preview.model.json_api_request_of_catalog_request_preview import JsonApiRequestOfCatalogRequestPreview
from criteo_api_retailmedia_preview.model.json_api_single_response_of_campaign import JsonApiSingleResponseOfCampaign
from criteo_api_retailmedia_preview.model.json_api_single_response_of_catalog_status import JsonApiSingleResponseOfCatalogStatus
from criteo_api_retailmedia_preview.model.json_api_single_response_of_line_item import JsonApiSingleResponseOfLineItem
from criteo_api_retailmedia_preview.model.page_of_balance_campaign import PageOfBalanceCampaign
from criteo_api_retailmedia_preview.model.seller_preview_response import SellerPreviewResponse
from criteo_api_retailmedia_preview.model.sku_data_preview_list_response import SkuDataPreviewListResponse
from criteo_api_retailmedia_preview.model.sku_search_request_preview_request import SkuSearchRequestPreviewRequest


class CampaignApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __delete_api_v1_external_balance_campaigns_by_balance_id(
            self,
            balance_id,
            **kwargs
        ):
            """delete_api_v1_external_balance_campaigns_by_balance_id  # noqa: E501

            Removes one or more campaigns on the specified balance  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_api_v1_external_balance_campaigns_by_balance_id(balance_id, async_req=True)
            >>> result = thread.get()

            Args:
                balance_id (str): The balance to remove campaigns from

            Keyword Args:
                json_api_data_request_of_delete_balance_campaign (JsonApiDataRequestOfDeleteBalanceCampaign): The campaigns to append. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PageOfBalanceCampaign
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['balance_id'] = \
                balance_id
            return self.call_with_http_info(**kwargs)

        self.delete_api_v1_external_balance_campaigns_by_balance_id = _Endpoint(
            settings={
                'response_type': (PageOfBalanceCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/balances/{balanceId}/campaigns',
                'operation_id': 'delete_api_v1_external_balance_campaigns_by_balance_id',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'balance_id',
                    'json_api_data_request_of_delete_balance_campaign',
                ],
                'required': [
                    'balance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'balance_id':
                        (str,),
                    'json_api_data_request_of_delete_balance_campaign':
                        (JsonApiDataRequestOfDeleteBalanceCampaign,),
                },
                'attribute_map': {
                    'balance_id': 'balanceId',
                },
                'location_map': {
                    'balance_id': 'path',
                    'json_api_data_request_of_delete_balance_campaign': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_api_v1_external_balance_campaigns_by_balance_id
        )

        def __delete_api_v1_external_line_item_products_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """delete_api_v1_external_line_item_products_by_line_item_id  # noqa: E501

            This endpoint removes one or more products from promotion on the specified line item.  The resulting state of the line item is returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_api_v1_external_line_item_products_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                json_api_data_request_with_id_of_string_and_promoted_product (JsonApiDataRequestWithIdOfStringAndPromotedProduct): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiPageResponseOfStringAndPromotedProduct
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.delete_api_v1_external_line_item_products_by_line_item_id = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfStringAndPromotedProduct,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{lineItemId}/products',
                'operation_id': 'delete_api_v1_external_line_item_products_by_line_item_id',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'json_api_data_request_with_id_of_string_and_promoted_product',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'json_api_data_request_with_id_of_string_and_promoted_product':
                        (JsonApiDataRequestWithIdOfStringAndPromotedProduct,),
                },
                'attribute_map': {
                    'line_item_id': 'lineItemId',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'json_api_data_request_with_id_of_string_and_promoted_product': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_api_v1_external_line_item_products_by_line_item_id
        )

        def __get_api_v0_external_catalog_output_by_catalog_id(
            self,
            catalog_id,
            **kwargs
        ):
            """get_api_v0_external_catalog_output_by_catalog_id  # noqa: E501

            Output the indicated catalog. Catalogs are only available for retrieval when their associated status request  is at a Success status.  Produces application/x-json-stream of CatalogProduct json objects.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v0_external_catalog_output_by_catalog_id(catalog_id, async_req=True)
            >>> result = thread.get()

            Args:
                catalog_id (str): A catalog ID returned from an account catalog request.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['catalog_id'] = \
                catalog_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v0_external_catalog_output_by_catalog_id = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/catalogs/{catalogId}/output',
                'operation_id': 'get_api_v0_external_catalog_output_by_catalog_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'catalog_id',
                ],
                'required': [
                    'catalog_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'catalog_id':
                        (str,),
                },
                'attribute_map': {
                    'catalog_id': 'catalogId',
                },
                'location_map': {
                    'catalog_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/x-json-stream',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v0_external_catalog_output_by_catalog_id
        )

        def __get_api_v0_external_catalog_status_by_catalog_id(
            self,
            catalog_id,
            **kwargs
        ):
            """get_api_v0_external_catalog_status_by_catalog_id  # noqa: E501

            Check the status of a catalog request.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v0_external_catalog_status_by_catalog_id(catalog_id, async_req=True)
            >>> result = thread.get()

            Args:
                catalog_id (str): A catalog ID returned from an account catalog request.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiSingleResponseOfCatalogStatus
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['catalog_id'] = \
                catalog_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v0_external_catalog_status_by_catalog_id = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCatalogStatus,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/catalogs/{catalogId}/status',
                'operation_id': 'get_api_v0_external_catalog_status_by_catalog_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'catalog_id',
                ],
                'required': [
                    'catalog_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'catalog_id':
                        (str,),
                },
                'attribute_map': {
                    'catalog_id': 'catalogId',
                },
                'location_map': {
                    'catalog_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v0_external_catalog_status_by_catalog_id
        )

        def __get_api_v1_external_account_balances_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """get_api_v1_external_account_balances_by_account_id  # noqa: E501

            Gets page of balance objects for the given account id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_account_balances_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): The account to get balances for

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiPageResponseOfBalance
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_account_balances_by_account_id = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfBalance,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{accountId}/balances',
                'operation_id': 'get_api_v1_external_account_balances_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_account_balances_by_account_id
        )

        def __get_api_v1_external_account_brands_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """get_api_v1_external_account_brands_by_account_id  # noqa: E501

            Gets page of retailer objects that are associated with the given account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_account_brands_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): The given account id

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiPageResponseOfBrand
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_account_brands_by_account_id = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfBrand,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{accountId}/brands',
                'operation_id': 'get_api_v1_external_account_brands_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_account_brands_by_account_id
        )

        def __get_api_v1_external_account_campaigns_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """get_api_v1_external_account_campaigns_by_account_id  # noqa: E501

            Gets page of campaign objects for the given account id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_account_campaigns_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): The given account id

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiPageResponseOfCampaign
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_account_campaigns_by_account_id = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{accountId}/campaigns',
                'operation_id': 'get_api_v1_external_account_campaigns_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_account_campaigns_by_account_id
        )

        def __get_api_v1_external_account_retailers_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """get_api_v1_external_account_retailers_by_account_id  # noqa: E501

            Gets page of retailer objects that are associated with the given account  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_account_retailers_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): The given account id

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiPageResponseOfRetailer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_account_retailers_by_account_id = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfRetailer,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{accountId}/retailers',
                'operation_id': 'get_api_v1_external_account_retailers_by_account_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'account_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_account_retailers_by_account_id
        )

        def __get_api_v1_external_accounts(
            self,
            **kwargs
        ):
            """get_api_v1_external_accounts  # noqa: E501

            Gets page of account objects that the current user can access  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_accounts(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiPageResponseOfAccount
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_accounts = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfAccount,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts',
                'operation_id': 'get_api_v1_external_accounts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_accounts
        )

        def __get_api_v1_external_balance_campaigns_by_balance_id(
            self,
            balance_id,
            **kwargs
        ):
            """get_api_v1_external_balance_campaigns_by_balance_id  # noqa: E501

            Gets page of campaigns for the given balanceId  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_balance_campaigns_by_balance_id(balance_id, async_req=True)
            >>> result = thread.get()

            Args:
                balance_id (str): The balance to get campaigns from

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PageOfBalanceCampaign
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['balance_id'] = \
                balance_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_balance_campaigns_by_balance_id = _Endpoint(
            settings={
                'response_type': (PageOfBalanceCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/balances/{balanceId}/campaigns',
                'operation_id': 'get_api_v1_external_balance_campaigns_by_balance_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'balance_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'balance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'balance_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'balance_id': 'balanceId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'balance_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_balance_campaigns_by_balance_id
        )

        def __get_api_v1_external_campaign_by_campaign_id(
            self,
            campaign_id,
            **kwargs
        ):
            """get_api_v1_external_campaign_by_campaign_id  # noqa: E501

            Gets the campaign for the given campaign id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_campaign_by_campaign_id(campaign_id, async_req=True)
            >>> result = thread.get()

            Args:
                campaign_id (str): The given campaign id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiSingleResponseOfCampaign
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['campaign_id'] = \
                campaign_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_campaign_by_campaign_id = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/campaigns/{campaignId}',
                'operation_id': 'get_api_v1_external_campaign_by_campaign_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignId',
                },
                'location_map': {
                    'campaign_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_campaign_by_campaign_id
        )

        def __get_api_v1_external_campaign_line_items_by_campaign_id(
            self,
            campaign_id,
            **kwargs
        ):
            """get_api_v1_external_campaign_line_items_by_campaign_id  # noqa: E501

            Gets page of line item objects for the given campaign id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_campaign_line_items_by_campaign_id(campaign_id, async_req=True)
            >>> result = thread.get()

            Args:
                campaign_id (str): The given campaign id

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiPageResponseOfLineItem
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['campaign_id'] = \
                campaign_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_campaign_line_items_by_campaign_id = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfLineItem,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/campaigns/{campaignId}/line-items',
                'operation_id': 'get_api_v1_external_campaign_line_items_by_campaign_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_campaign_line_items_by_campaign_id
        )

        def __get_api_v1_external_line_item_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """get_api_v1_external_line_item_by_line_item_id  # noqa: E501

            Gets the line item for the given line item id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_line_item_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The given line item id

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiSingleResponseOfLineItem
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_line_item_by_line_item_id = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfLineItem,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{lineItemId}',
                'operation_id': 'get_api_v1_external_line_item_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                },
                'attribute_map': {
                    'line_item_id': 'lineItemId',
                },
                'location_map': {
                    'line_item_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_line_item_by_line_item_id
        )

        def __get_api_v1_external_line_item_products_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """get_api_v1_external_line_item_products_by_line_item_id  # noqa: E501

            This endpoint gets the promoted products on the specified line item.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_line_item_products_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                limit_to_id ([str]): The ids that you would like to limit your result set to. [optional]
                page_index (int): The 0 indexed page index you would like to receive given the page size. [optional]
                page_size (int): The maximum number of items you would like to receive in this request. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiPageResponseOfStringAndPromotedProduct
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_line_item_products_by_line_item_id = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfStringAndPromotedProduct,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{lineItemId}/products',
                'operation_id': 'get_api_v1_external_line_item_products_by_line_item_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'limit_to_id',
                    'page_index',
                    'page_size',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'limit_to_id':
                        ([str],),
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'line_item_id': 'lineItemId',
                    'limit_to_id': 'limitToId',
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'limit_to_id': 'query',
                    'page_index': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                    'limit_to_id': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_line_item_products_by_line_item_id
        )

        def __get_api_v1_external_retailer_brands_by_retailer_id(
            self,
            retailer_id,
            **kwargs
        ):
            """get_api_v1_external_retailer_brands_by_retailer_id  # noqa: E501

            Gets the brands for the given retailer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_retailer_brands_by_retailer_id(retailer_id, async_req=True)
            >>> result = thread.get()

            Args:
                retailer_id (int): The retailer id for which brands should be fetched.

            Keyword Args:
                sku_stock_type_filter (str): Filter to narrow down brands [first-party|third-party|first-and-third-party]. Defaults to first-and-third-party. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BrandPreviewListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['retailer_id'] = \
                retailer_id
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_retailer_brands_by_retailer_id = _Endpoint(
            settings={
                'response_type': (BrandPreviewListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/retailers/{retailerId}/brands',
                'operation_id': 'get_api_v1_external_retailer_brands_by_retailer_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'retailer_id',
                    'sku_stock_type_filter',
                ],
                'required': [
                    'retailer_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'sku_stock_type_filter',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('sku_stock_type_filter',): {

                        "FIRST-PARTY": "first-party",
                        "THIRD-PARTY": "third-party",
                        "FIRST-AND-THIRD-PARTY": "first-and-third-party"
                    },
                },
                'openapi_types': {
                    'retailer_id':
                        (int,),
                    'sku_stock_type_filter':
                        (str,),
                },
                'attribute_map': {
                    'retailer_id': 'retailerId',
                    'sku_stock_type_filter': 'sku-stock-type-filter',
                },
                'location_map': {
                    'retailer_id': 'path',
                    'sku_stock_type_filter': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_retailer_brands_by_retailer_id
        )

        def __get_api_v1_external_retailer_by_retailer_id_seller_by_seller(
            self,
            retailer_id,
            seller,
            **kwargs
        ):
            """get_api_v1_external_retailer_by_retailer_id_seller_by_seller  # noqa: E501

            Endpoint to get market place seller id and name  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_v1_external_retailer_by_retailer_id_seller_by_seller(retailer_id, seller, async_req=True)
            >>> result = thread.get()

            Args:
                retailer_id (int): The retailer id for which seller should be fetched.
                seller (str): The seller id or seller name which should be validated.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SellerPreviewResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['retailer_id'] = \
                retailer_id
            kwargs['seller'] = \
                seller
            return self.call_with_http_info(**kwargs)

        self.get_api_v1_external_retailer_by_retailer_id_seller_by_seller = _Endpoint(
            settings={
                'response_type': (SellerPreviewResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/retailers/{retailerId}/sellers/{seller}',
                'operation_id': 'get_api_v1_external_retailer_by_retailer_id_seller_by_seller',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'retailer_id',
                    'seller',
                ],
                'required': [
                    'retailer_id',
                    'seller',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'retailer_id':
                        (int,),
                    'seller':
                        (str,),
                },
                'attribute_map': {
                    'retailer_id': 'retailerId',
                    'seller': 'seller',
                },
                'location_map': {
                    'retailer_id': 'path',
                    'seller': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_api_v1_external_retailer_by_retailer_id_seller_by_seller
        )

        def __post_api_v0_external_account_catalogs_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """post_api_v0_external_account_catalogs_by_account_id  # noqa: E501

            Create a request for a Catalog available to the indicated account.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api_v0_external_account_catalogs_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): The account to request the catalog for.

            Keyword Args:
                json_api_request_of_catalog_request_preview (JsonApiRequestOfCatalogRequestPreview): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiSingleResponseOfCatalogStatus
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.post_api_v0_external_account_catalogs_by_account_id = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCatalogStatus,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{accountId}/catalogs',
                'operation_id': 'post_api_v0_external_account_catalogs_by_account_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'json_api_request_of_catalog_request_preview',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'json_api_request_of_catalog_request_preview':
                        (JsonApiRequestOfCatalogRequestPreview,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'json_api_request_of_catalog_request_preview': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api_v0_external_account_catalogs_by_account_id
        )

        def __post_api_v1_external_account_campaigns_by_account_id(
            self,
            account_id,
            **kwargs
        ):
            """post_api_v1_external_account_campaigns_by_account_id  # noqa: E501

            Creates a new campaign with the specified settings  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api_v1_external_account_campaigns_by_account_id(account_id, async_req=True)
            >>> result = thread.get()

            Args:
                account_id (str): The given account id

            Keyword Args:
                external_post_campaign (ExternalPostCampaign): The campaign settings to create a campaign with. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiSingleResponseOfCampaign
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['account_id'] = \
                account_id
            return self.call_with_http_info(**kwargs)

        self.post_api_v1_external_account_campaigns_by_account_id = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/accounts/{accountId}/campaigns',
                'operation_id': 'post_api_v1_external_account_campaigns_by_account_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'external_post_campaign',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'external_post_campaign':
                        (ExternalPostCampaign,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'external_post_campaign': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api_v1_external_account_campaigns_by_account_id
        )

        def __post_api_v1_external_campaign_line_items_by_campaign_id(
            self,
            campaign_id,
            **kwargs
        ):
            """post_api_v1_external_campaign_line_items_by_campaign_id  # noqa: E501

            Creates a new line item with the specified settings  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api_v1_external_campaign_line_items_by_campaign_id(campaign_id, async_req=True)
            >>> result = thread.get()

            Args:
                campaign_id (str): The given campaign id

            Keyword Args:
                external_post_line_item (ExternalPostLineItem): The line item settings to create a line item with. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiSingleResponseOfLineItem
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['campaign_id'] = \
                campaign_id
            return self.call_with_http_info(**kwargs)

        self.post_api_v1_external_campaign_line_items_by_campaign_id = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfLineItem,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/campaigns/{campaignId}/line-items',
                'operation_id': 'post_api_v1_external_campaign_line_items_by_campaign_id',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'external_post_line_item',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                    'external_post_line_item':
                        (ExternalPostLineItem,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignId',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'external_post_line_item': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api_v1_external_campaign_line_items_by_campaign_id
        )

        def __post_api_v1_external_catalogs_sku_retrieval(
            self,
            **kwargs
        ):
            """post_api_v1_external_catalogs_sku_retrieval  # noqa: E501

            Endpoint to search skus by text, retailer and sellers/brands.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api_v1_external_catalogs_sku_retrieval(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                page_index (int): The start position in the overall list of matches. Must be zero or greater.. [optional] if omitted the server will use the default value of 0
                page_size (int): The maximum number of results to return with each call. Must be greater than zero.. [optional] if omitted the server will use the default value of 100
                request_body ([str]): The list of SKU keys to retrieve sku information. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SkuDataPreviewListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.post_api_v1_external_catalogs_sku_retrieval = _Endpoint(
            settings={
                'response_type': (SkuDataPreviewListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/catalogs/sku-retrieval',
                'operation_id': 'post_api_v1_external_catalogs_sku_retrieval',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_index',
                    'page_size',
                    'request_body',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_index',
                    'page_size',
                    'request_body',
                ]
            },
            root_map={
                'validations': {
                    ('page_index',): {

                        'inclusive_maximum': 500,
                        'inclusive_minimum': 0,
                    },
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                    ('request_body',): {

                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                    'request_body':
                        ([str],),
                },
                'attribute_map': {
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'page_index': 'query',
                    'page_size': 'query',
                    'request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api_v1_external_catalogs_sku_retrieval
        )

        def __post_api_v1_external_catalogs_sku_search(
            self,
            **kwargs
        ):
            """post_api_v1_external_catalogs_sku_search  # noqa: E501

            Endpoint to search skus by text, retailer and sellers/brands.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.post_api_v1_external_catalogs_sku_search(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                page_index (int): The start position in the overall list of matches. Must be zero or greater.. [optional] if omitted the server will use the default value of 0
                page_size (int): The maximum number of results to return with each call. Must be greater than zero.. [optional] if omitted the server will use the default value of 100
                sku_search_request_preview_request (SkuSearchRequestPreviewRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SkuDataPreviewListResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.post_api_v1_external_catalogs_sku_search = _Endpoint(
            settings={
                'response_type': (SkuDataPreviewListResponse,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/catalogs/sku-search',
                'operation_id': 'post_api_v1_external_catalogs_sku_search',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'page_index',
                    'page_size',
                    'sku_search_request_preview_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_index',
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('page_index',): {

                        'inclusive_maximum': 500,
                        'inclusive_minimum': 0,
                    },
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page_index':
                        (int,),
                    'page_size':
                        (int,),
                    'sku_search_request_preview_request':
                        (SkuSearchRequestPreviewRequest,),
                },
                'attribute_map': {
                    'page_index': 'pageIndex',
                    'page_size': 'pageSize',
                },
                'location_map': {
                    'page_index': 'query',
                    'page_size': 'query',
                    'sku_search_request_preview_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__post_api_v1_external_catalogs_sku_search
        )

        def __put_api_v1_external_balance_campaigns_by_balance_id(
            self,
            balance_id,
            **kwargs
        ):
            """put_api_v1_external_balance_campaigns_by_balance_id  # noqa: E501

            appends one or more campaigns to the specified balance  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.put_api_v1_external_balance_campaigns_by_balance_id(balance_id, async_req=True)
            >>> result = thread.get()

            Args:
                balance_id (str): The balance to add campaigns from

            Keyword Args:
                json_api_data_request_of_put_balance_campaign (JsonApiDataRequestOfPutBalanceCampaign): The campaigns to append. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PageOfBalanceCampaign
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['balance_id'] = \
                balance_id
            return self.call_with_http_info(**kwargs)

        self.put_api_v1_external_balance_campaigns_by_balance_id = _Endpoint(
            settings={
                'response_type': (PageOfBalanceCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/balances/{balanceId}/campaigns',
                'operation_id': 'put_api_v1_external_balance_campaigns_by_balance_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'balance_id',
                    'json_api_data_request_of_put_balance_campaign',
                ],
                'required': [
                    'balance_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'balance_id':
                        (str,),
                    'json_api_data_request_of_put_balance_campaign':
                        (JsonApiDataRequestOfPutBalanceCampaign,),
                },
                'attribute_map': {
                    'balance_id': 'balanceId',
                },
                'location_map': {
                    'balance_id': 'path',
                    'json_api_data_request_of_put_balance_campaign': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__put_api_v1_external_balance_campaigns_by_balance_id
        )

        def __put_api_v1_external_campaign_by_campaign_id(
            self,
            campaign_id,
            **kwargs
        ):
            """put_api_v1_external_campaign_by_campaign_id  # noqa: E501

            Updates the campaign for the given campaign id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.put_api_v1_external_campaign_by_campaign_id(campaign_id, async_req=True)
            >>> result = thread.get()

            Args:
                campaign_id (str): The given campaign id

            Keyword Args:
                external_put_campaign (ExternalPutCampaign): The campaign settings to update that campaign with. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiSingleResponseOfCampaign
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['campaign_id'] = \
                campaign_id
            return self.call_with_http_info(**kwargs)

        self.put_api_v1_external_campaign_by_campaign_id = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfCampaign,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/campaigns/{campaignId}',
                'operation_id': 'put_api_v1_external_campaign_by_campaign_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_id',
                    'external_put_campaign',
                ],
                'required': [
                    'campaign_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_id':
                        (str,),
                    'external_put_campaign':
                        (ExternalPutCampaign,),
                },
                'attribute_map': {
                    'campaign_id': 'campaignId',
                },
                'location_map': {
                    'campaign_id': 'path',
                    'external_put_campaign': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__put_api_v1_external_campaign_by_campaign_id
        )

        def __put_api_v1_external_line_item_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """put_api_v1_external_line_item_by_line_item_id  # noqa: E501

            Updates the line item for the given line item id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.put_api_v1_external_line_item_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The given line item id

            Keyword Args:
                external_put_line_item (ExternalPutLineItem): The line item settings to create a line item with. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiSingleResponseOfLineItem
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.put_api_v1_external_line_item_by_line_item_id = _Endpoint(
            settings={
                'response_type': (JsonApiSingleResponseOfLineItem,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{lineItemId}',
                'operation_id': 'put_api_v1_external_line_item_by_line_item_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'external_put_line_item',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'external_put_line_item':
                        (ExternalPutLineItem,),
                },
                'attribute_map': {
                    'line_item_id': 'lineItemId',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'external_put_line_item': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__put_api_v1_external_line_item_by_line_item_id
        )

        def __put_api_v1_external_line_item_products_by_line_item_id(
            self,
            line_item_id,
            **kwargs
        ):
            """put_api_v1_external_line_item_products_by_line_item_id  # noqa: E501

            This endpoint appends one or more products to promote on the specified line item.  The resulting state of the line item is returned.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.put_api_v1_external_line_item_products_by_line_item_id(line_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                line_item_id (str): The line item to interact with

            Keyword Args:
                json_api_data_request_with_id_of_string_and_promoted_product (JsonApiDataRequestWithIdOfStringAndPromotedProduct): the products to append to this line item. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                JsonApiPageResponseOfStringAndPromotedProduct
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['line_item_id'] = \
                line_item_id
            return self.call_with_http_info(**kwargs)

        self.put_api_v1_external_line_item_products_by_line_item_id = _Endpoint(
            settings={
                'response_type': (JsonApiPageResponseOfStringAndPromotedProduct,),
                'auth': [
                    'oauth'
                ],
                'endpoint_path': '/preview/retail-media/line-items/{lineItemId}/products',
                'operation_id': 'put_api_v1_external_line_item_products_by_line_item_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'line_item_id',
                    'json_api_data_request_with_id_of_string_and_promoted_product',
                ],
                'required': [
                    'line_item_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'line_item_id':
                        (str,),
                    'json_api_data_request_with_id_of_string_and_promoted_product':
                        (JsonApiDataRequestWithIdOfStringAndPromotedProduct,),
                },
                'attribute_map': {
                    'line_item_id': 'lineItemId',
                },
                'location_map': {
                    'line_item_id': 'path',
                    'json_api_data_request_with_id_of_string_and_promoted_product': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__put_api_v1_external_line_item_products_by_line_item_id
        )
