import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultIdentityOidcClientCredsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_oidc_client_creds#id DataVaultIdentityOidcClientCreds#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_oidc_client_creds#name DataVaultIdentityOidcClientCreds#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/identity_oidc_client_creds#namespace DataVaultIdentityOidcClientCreds#namespace}
    */
    readonly namespace?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/identity_oidc_client_creds vault_identity_oidc_client_creds}
*/
export declare class DataVaultIdentityOidcClientCreds extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_identity_oidc_client_creds";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/identity_oidc_client_creds vault_identity_oidc_client_creds} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultIdentityOidcClientCredsConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultIdentityOidcClientCredsConfig);
    get clientId(): string;
    get clientSecret(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
