import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultKubernetesServiceAccountTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Kubernetes secret backend to generate service account tokens from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_service_account_token#backend DataVaultKubernetesServiceAccountToken#backend}
    */
    readonly backend: string;
    /**
    * If true, generate a ClusterRoleBinding to grant permissions across the whole cluster instead of within a namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_service_account_token#cluster_role_binding DataVaultKubernetesServiceAccountToken#cluster_role_binding}
    */
    readonly clusterRoleBinding?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_service_account_token#id DataVaultKubernetesServiceAccountToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Kubernetes namespace in which to generate the credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_service_account_token#kubernetes_namespace DataVaultKubernetesServiceAccountToken#kubernetes_namespace}
    */
    readonly kubernetesNamespace: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_service_account_token#namespace DataVaultKubernetesServiceAccountToken#namespace}
    */
    readonly namespace?: string;
    /**
    * The name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_service_account_token#role DataVaultKubernetesServiceAccountToken#role}
    */
    readonly role: string;
    /**
    * The TTL of the generated Kubernetes service account token, specified in seconds or as a Go duration format string
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_service_account_token#ttl DataVaultKubernetesServiceAccountToken#ttl}
    */
    readonly ttl?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_service_account_token vault_kubernetes_service_account_token}
*/
export declare class DataVaultKubernetesServiceAccountToken extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_kubernetes_service_account_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_service_account_token vault_kubernetes_service_account_token} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultKubernetesServiceAccountTokenConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultKubernetesServiceAccountTokenConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _clusterRoleBinding?;
    get clusterRoleBinding(): boolean | cdktf.IResolvable;
    set clusterRoleBinding(value: boolean | cdktf.IResolvable);
    resetClusterRoleBinding(): void;
    get clusterRoleBindingInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kubernetesNamespace?;
    get kubernetesNamespace(): string;
    set kubernetesNamespace(value: string);
    get kubernetesNamespaceInput(): string | undefined;
    get leaseDuration(): number;
    get leaseId(): string;
    get leaseRenewable(): cdktf.IResolvable;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    get serviceAccountName(): string;
    get serviceAccountNamespace(): string;
    get serviceAccountToken(): string;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
