"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NomadSecretBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/nomad_secret_backend vault_nomad_secret_backend}
*/
class NomadSecretBackend extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/nomad_secret_backend vault_nomad_secret_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NomadSecretBackendConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vault_nomad_secret_backend',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.8.1',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._address = config.address;
        this._backend = config.backend;
        this._caCert = config.caCert;
        this._clientCert = config.clientCert;
        this._clientKey = config.clientKey;
        this._defaultLeaseTtlSeconds = config.defaultLeaseTtlSeconds;
        this._description = config.description;
        this._id = config.id;
        this._local = config.local;
        this._maxLeaseTtlSeconds = config.maxLeaseTtlSeconds;
        this._maxTokenNameLength = config.maxTokenNameLength;
        this._maxTtl = config.maxTtl;
        this._namespace = config.namespace;
        this._token = config.token;
        this._ttl = config.ttl;
    }
    get address() {
        return this.getStringAttribute('address');
    }
    set address(value) {
        this._address = value;
    }
    resetAddress() {
        this._address = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get addressInput() {
        return this._address;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    resetBackend() {
        this._backend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get caCert() {
        return this.getStringAttribute('ca_cert');
    }
    set caCert(value) {
        this._caCert = value;
    }
    resetCaCert() {
        this._caCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get caCertInput() {
        return this._caCert;
    }
    get clientCert() {
        return this.getStringAttribute('client_cert');
    }
    set clientCert(value) {
        this._clientCert = value;
    }
    resetClientCert() {
        this._clientCert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientCertInput() {
        return this._clientCert;
    }
    get clientKey() {
        return this.getStringAttribute('client_key');
    }
    set clientKey(value) {
        this._clientKey = value;
    }
    resetClientKey() {
        this._clientKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientKeyInput() {
        return this._clientKey;
    }
    get defaultLeaseTtlSeconds() {
        return this.getNumberAttribute('default_lease_ttl_seconds');
    }
    set defaultLeaseTtlSeconds(value) {
        this._defaultLeaseTtlSeconds = value;
    }
    resetDefaultLeaseTtlSeconds() {
        this._defaultLeaseTtlSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultLeaseTtlSecondsInput() {
        return this._defaultLeaseTtlSeconds;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get local() {
        return this.getBooleanAttribute('local');
    }
    set local(value) {
        this._local = value;
    }
    resetLocal() {
        this._local = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localInput() {
        return this._local;
    }
    get maxLeaseTtlSeconds() {
        return this.getNumberAttribute('max_lease_ttl_seconds');
    }
    set maxLeaseTtlSeconds(value) {
        this._maxLeaseTtlSeconds = value;
    }
    resetMaxLeaseTtlSeconds() {
        this._maxLeaseTtlSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxLeaseTtlSecondsInput() {
        return this._maxLeaseTtlSeconds;
    }
    get maxTokenNameLength() {
        return this.getNumberAttribute('max_token_name_length');
    }
    set maxTokenNameLength(value) {
        this._maxTokenNameLength = value;
    }
    resetMaxTokenNameLength() {
        this._maxTokenNameLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxTokenNameLengthInput() {
        return this._maxTokenNameLength;
    }
    get maxTtl() {
        return this.getNumberAttribute('max_ttl');
    }
    set maxTtl(value) {
        this._maxTtl = value;
    }
    resetMaxTtl() {
        this._maxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxTtlInput() {
        return this._maxTtl;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get token() {
        return this.getStringAttribute('token');
    }
    set token(value) {
        this._token = value;
    }
    resetToken() {
        this._token = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token;
    }
    get ttl() {
        return this.getNumberAttribute('ttl');
    }
    set ttl(value) {
        this._ttl = value;
    }
    resetTtl() {
        this._ttl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ttlInput() {
        return this._ttl;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            address: cdktf.stringToTerraform(this._address),
            backend: cdktf.stringToTerraform(this._backend),
            ca_cert: cdktf.stringToTerraform(this._caCert),
            client_cert: cdktf.stringToTerraform(this._clientCert),
            client_key: cdktf.stringToTerraform(this._clientKey),
            default_lease_ttl_seconds: cdktf.numberToTerraform(this._defaultLeaseTtlSeconds),
            description: cdktf.stringToTerraform(this._description),
            id: cdktf.stringToTerraform(this._id),
            local: cdktf.booleanToTerraform(this._local),
            max_lease_ttl_seconds: cdktf.numberToTerraform(this._maxLeaseTtlSeconds),
            max_token_name_length: cdktf.numberToTerraform(this._maxTokenNameLength),
            max_ttl: cdktf.numberToTerraform(this._maxTtl),
            namespace: cdktf.stringToTerraform(this._namespace),
            token: cdktf.stringToTerraform(this._token),
            ttl: cdktf.numberToTerraform(this._ttl),
        };
    }
}
exports.NomadSecretBackend = NomadSecretBackend;
_a = JSII_RTTI_SYMBOL_1;
NomadSecretBackend[_a] = { fqn: "@cdktf/provider-vault.NomadSecretBackend", version: "2.0.19" };
// =================
// STATIC PROPERTIES
// =================
NomadSecretBackend.tfResourceType = "vault_nomad_secret_backend";
//# sourceMappingURL=data:application/json;base64,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