from setuptools import setup, find_packages

DESCRIPTION = "Kentico Kontent Delivery API SDK"
LONGDESCRIPTION = """
The Delivery Python SDK can be used in Python projects to retrieve content from the Kentico Kontent headless CMS. This is a community project and not an official Kentico SDK. 
If you find a bug in the SDK or have a feature request, please submit a GitHub issue at https://github.com/kentico-michaelb/kontent-delivery-python-sdk.
"""


setup(
        name="kontent_delivery",
        version="0.1.3",
        author="Michael Berry",
        description=DESCRIPTION,
        long_description=LONGDESCRIPTION,
        license="MIT",
        packages=find_packages(exclude=["tests", "samples"]),
        url="https://github.com/kentico-michaelb/kontent-delivery-python-sdk",
        install_requires=[
            "astroid>=2.5.1",
            "atomicwrites>=1.4.0",
            "attrs>=20.3.0",
            "beautifulsoup4>=4.9.3",
            "bleach>=3.3.0",
            "build>=0.3.1.post1",
            "certifi>=2020.12.5",
            "chardet>=4.0.0",
            "colorama>=0.4.4",
            "docutils>=0.17.1",
            "flake8>=3.9.1",
            "idna>=2.10",
            "importlib-metadata>=4.0.1",
            "iniconfig>=1.1.1",
            "isort>=5.7.0",
            "keyring>=23.0.1",
            "lazy-object-proxy>=1.5.2",
            "mccabe>=0.6.1",
            "packaging>=20.9",
            "pep517>=0.10.0",
            "pep8>=1.7.1",
            "pkginfo>=1.7.0",
            "pluggy>=0.13.1",
            "py>=1.10.0",
            "pycodestyle>=2.7.0",
            "pyflakes>=2.3.1",
            "Pygments>=2.8.1",
            "pylint>=2.7.2",
            "pyparsing>=2.4.7",
            "pytest>=6.2.2",
            "pywin32-ctypes>=0.2.0",
            "readme-renderer>=29.0",
            "requests>=2.25.1",
            "requests-toolbelt>=0.9.1",
            "rfc3986>=1.4.0",
            "six>=1.15.0",
            "soupsieve>=2.2",
            "toml>=0.10.2",
            "tqdm>=4.60.0",
            "twine>=3.4.1",
            "urllib3>=1.26.4",
            "webencodings>=0.5.1",
            "wrapt>=1.12.1",
            "zipp>=3.4.1",
        ],
        keywords=[
            "Kontent",
            "Kontent SDK",
            "Kontent API",
            "Kentico",
            "Kentico API",
            "Kentico Python",
            "Kentico SDK",
            "Kentico Kontent",
            "Kentico Kontent SDK",
            "Kentico Kontent Delivery",
            "Kentico Kontent Delivery SDK",
            "Kentico Delivery",
            "Kentico Delivery SDK",
            ],
        classifiers=[
            "Development Status :: 3 - Alpha",
            "Intended Audience :: Developers",
            "Programming Language :: Python :: 3",
            "License :: OSI Approved :: MIT License",
            "Operating System :: MacOS :: MacOS X",
            "Operating System :: Microsoft :: Windows",
        ]
)