"""
    lakeFS API

    lakeFS HTTP API  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Contact: services@treeverse.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from lakefs_client.api_client import ApiClient, Endpoint as _Endpoint
from lakefs_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from lakefs_client.model.error import Error
from lakefs_client.model.object_copy_creation import ObjectCopyCreation
from lakefs_client.model.object_error_list import ObjectErrorList
from lakefs_client.model.object_stage_creation import ObjectStageCreation
from lakefs_client.model.object_stats import ObjectStats
from lakefs_client.model.object_stats_list import ObjectStatsList
from lakefs_client.model.path_list import PathList
from lakefs_client.model.underlying_object_properties import UnderlyingObjectProperties


class ObjectsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.copy_object_endpoint = _Endpoint(
            settings={
                'response_type': (ObjectStats,),
                'auth': [
                    'basic_auth',
                    'cookie_auth',
                    'jwt_token',
                    'oidc_auth',
                    'saml_auth'
                ],
                'endpoint_path': '/repositories/{repository}/branches/{branch}/objects/copy',
                'operation_id': 'copy_object',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'repository',
                    'branch',
                    'dest_path',
                    'object_copy_creation',
                ],
                'required': [
                    'repository',
                    'branch',
                    'dest_path',
                    'object_copy_creation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repository':
                        (str,),
                    'branch':
                        (str,),
                    'dest_path':
                        (str,),
                    'object_copy_creation':
                        (ObjectCopyCreation,),
                },
                'attribute_map': {
                    'repository': 'repository',
                    'branch': 'branch',
                    'dest_path': 'dest_path',
                },
                'location_map': {
                    'repository': 'path',
                    'branch': 'path',
                    'dest_path': 'query',
                    'object_copy_creation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_object_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basic_auth',
                    'cookie_auth',
                    'jwt_token',
                    'oidc_auth',
                    'saml_auth'
                ],
                'endpoint_path': '/repositories/{repository}/branches/{branch}/objects',
                'operation_id': 'delete_object',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'repository',
                    'branch',
                    'path',
                ],
                'required': [
                    'repository',
                    'branch',
                    'path',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repository':
                        (str,),
                    'branch':
                        (str,),
                    'path':
                        (str,),
                },
                'attribute_map': {
                    'repository': 'repository',
                    'branch': 'branch',
                    'path': 'path',
                },
                'location_map': {
                    'repository': 'path',
                    'branch': 'path',
                    'path': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_objects_endpoint = _Endpoint(
            settings={
                'response_type': (ObjectErrorList,),
                'auth': [
                    'basic_auth',
                    'cookie_auth',
                    'jwt_token',
                    'oidc_auth',
                    'saml_auth'
                ],
                'endpoint_path': '/repositories/{repository}/branches/{branch}/objects/delete',
                'operation_id': 'delete_objects',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'repository',
                    'branch',
                    'path_list',
                ],
                'required': [
                    'repository',
                    'branch',
                    'path_list',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repository':
                        (str,),
                    'branch':
                        (str,),
                    'path_list':
                        (PathList,),
                },
                'attribute_map': {
                    'repository': 'repository',
                    'branch': 'branch',
                },
                'location_map': {
                    'repository': 'path',
                    'branch': 'path',
                    'path_list': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_object_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'basic_auth',
                    'cookie_auth',
                    'jwt_token',
                    'oidc_auth',
                    'saml_auth'
                ],
                'endpoint_path': '/repositories/{repository}/refs/{ref}/objects',
                'operation_id': 'get_object',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'repository',
                    'ref',
                    'path',
                    'range',
                    'presign',
                ],
                'required': [
                    'repository',
                    'ref',
                    'path',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'range',
                ]
            },
            root_map={
                'validations': {
                    ('range',): {

                        'regex': {
                            'pattern': r'^bytes=((\d*-\d*,? ?)+)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repository':
                        (str,),
                    'ref':
                        (str,),
                    'path':
                        (str,),
                    'range':
                        (str,),
                    'presign':
                        (bool,),
                },
                'attribute_map': {
                    'repository': 'repository',
                    'ref': 'ref',
                    'path': 'path',
                    'range': 'Range',
                    'presign': 'presign',
                },
                'location_map': {
                    'repository': 'path',
                    'ref': 'path',
                    'path': 'query',
                    'range': 'header',
                    'presign': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/octet-stream',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_underlying_properties_endpoint = _Endpoint(
            settings={
                'response_type': (UnderlyingObjectProperties,),
                'auth': [
                    'basic_auth',
                    'cookie_auth',
                    'jwt_token',
                    'oidc_auth',
                    'saml_auth'
                ],
                'endpoint_path': '/repositories/{repository}/refs/{ref}/objects/underlyingProperties',
                'operation_id': 'get_underlying_properties',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'repository',
                    'ref',
                    'path',
                ],
                'required': [
                    'repository',
                    'ref',
                    'path',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repository':
                        (str,),
                    'ref':
                        (str,),
                    'path':
                        (str,),
                },
                'attribute_map': {
                    'repository': 'repository',
                    'ref': 'ref',
                    'path': 'path',
                },
                'location_map': {
                    'repository': 'path',
                    'ref': 'path',
                    'path': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.head_object_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basic_auth',
                    'cookie_auth',
                    'jwt_token',
                    'oidc_auth',
                    'saml_auth'
                ],
                'endpoint_path': '/repositories/{repository}/refs/{ref}/objects',
                'operation_id': 'head_object',
                'http_method': 'HEAD',
                'servers': None,
            },
            params_map={
                'all': [
                    'repository',
                    'ref',
                    'path',
                    'range',
                ],
                'required': [
                    'repository',
                    'ref',
                    'path',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'range',
                ]
            },
            root_map={
                'validations': {
                    ('range',): {

                        'regex': {
                            'pattern': r'^bytes=((\d*-\d*,? ?)+)$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repository':
                        (str,),
                    'ref':
                        (str,),
                    'path':
                        (str,),
                    'range':
                        (str,),
                },
                'attribute_map': {
                    'repository': 'repository',
                    'ref': 'ref',
                    'path': 'path',
                    'range': 'Range',
                },
                'location_map': {
                    'repository': 'path',
                    'ref': 'path',
                    'path': 'query',
                    'range': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_objects_endpoint = _Endpoint(
            settings={
                'response_type': (ObjectStatsList,),
                'auth': [
                    'basic_auth',
                    'cookie_auth',
                    'jwt_token',
                    'oidc_auth',
                    'saml_auth'
                ],
                'endpoint_path': '/repositories/{repository}/refs/{ref}/objects/ls',
                'operation_id': 'list_objects',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'repository',
                    'ref',
                    'user_metadata',
                    'presign',
                    'after',
                    'amount',
                    'delimiter',
                    'prefix',
                ],
                'required': [
                    'repository',
                    'ref',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'amount',
                ]
            },
            root_map={
                'validations': {
                    ('amount',): {

                        'inclusive_maximum': 1000,
                        'inclusive_minimum': -1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repository':
                        (str,),
                    'ref':
                        (str,),
                    'user_metadata':
                        (bool,),
                    'presign':
                        (bool,),
                    'after':
                        (str,),
                    'amount':
                        (int,),
                    'delimiter':
                        (str,),
                    'prefix':
                        (str,),
                },
                'attribute_map': {
                    'repository': 'repository',
                    'ref': 'ref',
                    'user_metadata': 'user_metadata',
                    'presign': 'presign',
                    'after': 'after',
                    'amount': 'amount',
                    'delimiter': 'delimiter',
                    'prefix': 'prefix',
                },
                'location_map': {
                    'repository': 'path',
                    'ref': 'path',
                    'user_metadata': 'query',
                    'presign': 'query',
                    'after': 'query',
                    'amount': 'query',
                    'delimiter': 'query',
                    'prefix': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.stage_object_endpoint = _Endpoint(
            settings={
                'response_type': (ObjectStats,),
                'auth': [
                    'basic_auth',
                    'cookie_auth',
                    'jwt_token',
                    'oidc_auth',
                    'saml_auth'
                ],
                'endpoint_path': '/repositories/{repository}/branches/{branch}/objects',
                'operation_id': 'stage_object',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'repository',
                    'branch',
                    'path',
                    'object_stage_creation',
                ],
                'required': [
                    'repository',
                    'branch',
                    'path',
                    'object_stage_creation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repository':
                        (str,),
                    'branch':
                        (str,),
                    'path':
                        (str,),
                    'object_stage_creation':
                        (ObjectStageCreation,),
                },
                'attribute_map': {
                    'repository': 'repository',
                    'branch': 'branch',
                    'path': 'path',
                },
                'location_map': {
                    'repository': 'path',
                    'branch': 'path',
                    'path': 'query',
                    'object_stage_creation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.stat_object_endpoint = _Endpoint(
            settings={
                'response_type': (ObjectStats,),
                'auth': [
                    'basic_auth',
                    'cookie_auth',
                    'jwt_token',
                    'oidc_auth',
                    'saml_auth'
                ],
                'endpoint_path': '/repositories/{repository}/refs/{ref}/objects/stat',
                'operation_id': 'stat_object',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'repository',
                    'ref',
                    'path',
                    'user_metadata',
                    'presign',
                ],
                'required': [
                    'repository',
                    'ref',
                    'path',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repository':
                        (str,),
                    'ref':
                        (str,),
                    'path':
                        (str,),
                    'user_metadata':
                        (bool,),
                    'presign':
                        (bool,),
                },
                'attribute_map': {
                    'repository': 'repository',
                    'ref': 'ref',
                    'path': 'path',
                    'user_metadata': 'user_metadata',
                    'presign': 'presign',
                },
                'location_map': {
                    'repository': 'path',
                    'ref': 'path',
                    'path': 'query',
                    'user_metadata': 'query',
                    'presign': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.upload_object_endpoint = _Endpoint(
            settings={
                'response_type': (ObjectStats,),
                'auth': [
                    'basic_auth',
                    'cookie_auth',
                    'jwt_token',
                    'oidc_auth',
                    'saml_auth'
                ],
                'endpoint_path': '/repositories/{repository}/branches/{branch}/objects',
                'operation_id': 'upload_object',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'repository',
                    'branch',
                    'path',
                    'storage_class',
                    'if_none_match',
                    'content',
                ],
                'required': [
                    'repository',
                    'branch',
                    'path',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'if_none_match',
                ]
            },
            root_map={
                'validations': {
                    ('if_none_match',): {

                        'regex': {
                            'pattern': r'^\*$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'repository':
                        (str,),
                    'branch':
                        (str,),
                    'path':
                        (str,),
                    'storage_class':
                        (str,),
                    'if_none_match':
                        (str,),
                    'content':
                        (file_type,),
                },
                'attribute_map': {
                    'repository': 'repository',
                    'branch': 'branch',
                    'path': 'path',
                    'storage_class': 'storageClass',
                    'if_none_match': 'If-None-Match',
                    'content': 'content',
                },
                'location_map': {
                    'repository': 'path',
                    'branch': 'path',
                    'path': 'query',
                    'storage_class': 'query',
                    'if_none_match': 'header',
                    'content': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )

    def copy_object(
        self,
        repository,
        branch,
        dest_path,
        object_copy_creation,
        **kwargs
    ):
        """create a copy of an object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.copy_object(repository, branch, dest_path, object_copy_creation, async_req=True)
        >>> result = thread.get()

        Args:
            repository (str):
            branch (str): destination branch for the copy
            dest_path (str): destination path relative to the branch
            object_copy_creation (ObjectCopyCreation):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ObjectStats
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['repository'] = \
            repository
        kwargs['branch'] = \
            branch
        kwargs['dest_path'] = \
            dest_path
        kwargs['object_copy_creation'] = \
            object_copy_creation
        return self.copy_object_endpoint.call_with_http_info(**kwargs)

    def delete_object(
        self,
        repository,
        branch,
        path,
        **kwargs
    ):
        """delete object. Missing objects will not return a NotFound error.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_object(repository, branch, path, async_req=True)
        >>> result = thread.get()

        Args:
            repository (str):
            branch (str):
            path (str): relative to the branch

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['repository'] = \
            repository
        kwargs['branch'] = \
            branch
        kwargs['path'] = \
            path
        return self.delete_object_endpoint.call_with_http_info(**kwargs)

    def delete_objects(
        self,
        repository,
        branch,
        path_list,
        **kwargs
    ):
        """delete objects. Missing objects will not return a NotFound error.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_objects(repository, branch, path_list, async_req=True)
        >>> result = thread.get()

        Args:
            repository (str):
            branch (str):
            path_list (PathList):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ObjectErrorList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['repository'] = \
            repository
        kwargs['branch'] = \
            branch
        kwargs['path_list'] = \
            path_list
        return self.delete_objects_endpoint.call_with_http_info(**kwargs)

    def get_object(
        self,
        repository,
        ref,
        path,
        **kwargs
    ):
        """get object content  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_object(repository, ref, path, async_req=True)
        >>> result = thread.get()

        Args:
            repository (str):
            ref (str): a reference (could be either a branch or a commit ID)
            path (str): relative to the ref

        Keyword Args:
            range (str): Byte range to retrieve. [optional]
            presign (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['repository'] = \
            repository
        kwargs['ref'] = \
            ref
        kwargs['path'] = \
            path
        return self.get_object_endpoint.call_with_http_info(**kwargs)

    def get_underlying_properties(
        self,
        repository,
        ref,
        path,
        **kwargs
    ):
        """get object properties on underlying storage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_underlying_properties(repository, ref, path, async_req=True)
        >>> result = thread.get()

        Args:
            repository (str):
            ref (str): a reference (could be either a branch or a commit ID)
            path (str): relative to the branch

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UnderlyingObjectProperties
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['repository'] = \
            repository
        kwargs['ref'] = \
            ref
        kwargs['path'] = \
            path
        return self.get_underlying_properties_endpoint.call_with_http_info(**kwargs)

    def head_object(
        self,
        repository,
        ref,
        path,
        **kwargs
    ):
        """check if object exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.head_object(repository, ref, path, async_req=True)
        >>> result = thread.get()

        Args:
            repository (str):
            ref (str): a reference (could be either a branch or a commit ID)
            path (str): relative to the ref

        Keyword Args:
            range (str): Byte range to retrieve. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['repository'] = \
            repository
        kwargs['ref'] = \
            ref
        kwargs['path'] = \
            path
        return self.head_object_endpoint.call_with_http_info(**kwargs)

    def list_objects(
        self,
        repository,
        ref,
        **kwargs
    ):
        """list objects under a given prefix  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_objects(repository, ref, async_req=True)
        >>> result = thread.get()

        Args:
            repository (str):
            ref (str): a reference (could be either a branch or a commit ID)

        Keyword Args:
            user_metadata (bool): [optional] if omitted the server will use the default value of True
            presign (bool): [optional]
            after (str): return items after this value. [optional]
            amount (int): how many items to return. [optional] if omitted the server will use the default value of 100
            delimiter (str): delimiter used to group common prefixes by. [optional]
            prefix (str): return items prefixed with this value. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ObjectStatsList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['repository'] = \
            repository
        kwargs['ref'] = \
            ref
        return self.list_objects_endpoint.call_with_http_info(**kwargs)

    def stage_object(
        self,
        repository,
        branch,
        path,
        object_stage_creation,
        **kwargs
    ):
        """stage an object's metadata for the given branch  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stage_object(repository, branch, path, object_stage_creation, async_req=True)
        >>> result = thread.get()

        Args:
            repository (str):
            branch (str):
            path (str): relative to the branch
            object_stage_creation (ObjectStageCreation):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ObjectStats
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['repository'] = \
            repository
        kwargs['branch'] = \
            branch
        kwargs['path'] = \
            path
        kwargs['object_stage_creation'] = \
            object_stage_creation
        return self.stage_object_endpoint.call_with_http_info(**kwargs)

    def stat_object(
        self,
        repository,
        ref,
        path,
        **kwargs
    ):
        """get object metadata  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stat_object(repository, ref, path, async_req=True)
        >>> result = thread.get()

        Args:
            repository (str):
            ref (str): a reference (could be either a branch or a commit ID)
            path (str): relative to the branch

        Keyword Args:
            user_metadata (bool): [optional] if omitted the server will use the default value of True
            presign (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ObjectStats
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['repository'] = \
            repository
        kwargs['ref'] = \
            ref
        kwargs['path'] = \
            path
        return self.stat_object_endpoint.call_with_http_info(**kwargs)

    def upload_object(
        self,
        repository,
        branch,
        path,
        **kwargs
    ):
        """upload_object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_object(repository, branch, path, async_req=True)
        >>> result = thread.get()

        Args:
            repository (str):
            branch (str):
            path (str): relative to the branch

        Keyword Args:
            storage_class (str): [optional]
            if_none_match (str): Currently supports only \"*\" to allow uploading an object only if one doesn't exist yet. [optional]
            content (file_type): Only a single file per upload which must be named \\\"content\\\".. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ObjectStats
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['repository'] = \
            repository
        kwargs['branch'] = \
            branch
        kwargs['path'] = \
            path
        return self.upload_object_endpoint.call_with_http_info(**kwargs)

