# Generated by Django 2.1.10 on 2019-12-22 23:14
from bulk_update.helper import bulk_update
from django.db import migrations

from outputs.models import Export


def set_metadata(*args, **kwargs):
    print('Init emails in Exports ...')
    exports = Export.objects.all()

    for export in exports:
        emails = list(export.recipients.values_list('email', flat=True))
        export.emails = emails

    print('>>> bulk update started ...')
    bulk_update(exports, update_fields=['emails'])
    print('>>> bulk update finished')


class Migration(migrations.Migration):

    dependencies = [
        ('outputs', '0002_auto_20200821_1321'),
    ]

    operations = [
        migrations.RunPython(set_metadata, lambda *args, **kwargs: None)
    ]
