"""Test fixtures."""
from _pytest.fixtures import fixture

DBGAP_FIXTURES = 'tests/fixtures/dbgap'


@fixture
def config_path():
    """Fixture our config."""
    return './tests/fixtures/dbgap/config.yaml'


@fixture
def output_path():
    """Fixture where to write data."""
    return f'{DBGAP_FIXTURES}/output'


@fixture
def pfb_path():
    """Fixture where to write data."""
    return f'{DBGAP_FIXTURES}/output/dbgap.pfb.avro'


@fixture
def expected_results():
    """Expect keys."""
    return {'Observation': {'code.coding.0.code',
                            'code.coding.0.display',
                            'code.coding.0.extension.0.url',
                            'code.coding.0.extension.0.valueReference.reference',
                            'code.coding.0.extension.1.url',
                            'code.coding.0.extension.1.valueCoding.code',
                            'code.coding.0.extension.1.valueCoding.display',
                            'code.coding.0.extension.1.valueCoding.system',
                            'code.coding.0.system',
                            'code.coding.1.code',
                            'code.coding.1.display',
                            'code.coding.1.extension.0.url',
                            'code.coding.1.extension.0.valueReference.reference',
                            'code.coding.1.extension.1.url',
                            'code.coding.1.extension.1.valueCoding.code',
                            'code.coding.1.extension.1.valueCoding.display',
                            'code.coding.1.extension.1.valueCoding.system',
                            'code.coding.1.system',
                            'code.coding.10.code',
                            'code.coding.10.display',
                            'code.coding.10.extension.0.url',
                            'code.coding.10.extension.0.valueReference.reference',
                            'code.coding.10.extension.1.url',
                            'code.coding.10.extension.1.valueCoding.code',
                            'code.coding.10.extension.1.valueCoding.display',
                            'code.coding.10.extension.1.valueCoding.system',
                            'code.coding.10.system',
                            'code.coding.11.code',
                            'code.coding.11.display',
                            'code.coding.11.extension.0.url',
                            'code.coding.11.extension.0.valueReference.reference',
                            'code.coding.11.extension.1.url',
                            'code.coding.11.extension.1.valueCoding.code',
                            'code.coding.11.extension.1.valueCoding.display',
                            'code.coding.11.extension.1.valueCoding.system',
                            'code.coding.11.system',
                            'code.coding.12.code',
                            'code.coding.12.display',
                            'code.coding.12.extension.0.url',
                            'code.coding.12.extension.0.valueReference.reference',
                            'code.coding.12.extension.1.url',
                            'code.coding.12.extension.1.valueCoding.code',
                            'code.coding.12.extension.1.valueCoding.display',
                            'code.coding.12.extension.1.valueCoding.system',
                            'code.coding.12.system',
                            'code.coding.13.code',
                            'code.coding.13.display',
                            'code.coding.13.extension.0.url',
                            'code.coding.13.extension.0.valueReference.reference',
                            'code.coding.13.extension.1.url',
                            'code.coding.13.extension.1.valueCoding.code',
                            'code.coding.13.extension.1.valueCoding.display',
                            'code.coding.13.extension.1.valueCoding.system',
                            'code.coding.13.system',
                            'code.coding.14.code',
                            'code.coding.14.display',
                            'code.coding.14.extension.0.url',
                            'code.coding.14.extension.0.valueReference.reference',
                            'code.coding.14.extension.1.url',
                            'code.coding.14.extension.1.valueCoding.code',
                            'code.coding.14.extension.1.valueCoding.display',
                            'code.coding.14.extension.1.valueCoding.system',
                            'code.coding.14.system',
                            'code.coding.15.code',
                            'code.coding.15.display',
                            'code.coding.15.extension.0.url',
                            'code.coding.15.extension.0.valueReference.reference',
                            'code.coding.15.extension.1.url',
                            'code.coding.15.extension.1.valueCoding.code',
                            'code.coding.15.extension.1.valueCoding.display',
                            'code.coding.15.extension.1.valueCoding.system',
                            'code.coding.15.system',
                            'code.coding.16.code',
                            'code.coding.16.display',
                            'code.coding.16.extension.0.url',
                            'code.coding.16.extension.0.valueReference.reference',
                            'code.coding.16.extension.1.url',
                            'code.coding.16.extension.1.valueCoding.code',
                            'code.coding.16.extension.1.valueCoding.display',
                            'code.coding.16.extension.1.valueCoding.system',
                            'code.coding.16.system',
                            'code.coding.17.code',
                            'code.coding.17.display',
                            'code.coding.17.extension.0.url',
                            'code.coding.17.extension.0.valueReference.reference',
                            'code.coding.17.extension.1.url',
                            'code.coding.17.extension.1.valueCoding.code',
                            'code.coding.17.extension.1.valueCoding.display',
                            'code.coding.17.extension.1.valueCoding.system',
                            'code.coding.17.system',
                            'code.coding.18.code',
                            'code.coding.18.display',
                            'code.coding.18.extension.0.url',
                            'code.coding.18.extension.0.valueReference.reference',
                            'code.coding.18.extension.1.url',
                            'code.coding.18.extension.1.valueCoding.code',
                            'code.coding.18.extension.1.valueCoding.display',
                            'code.coding.18.extension.1.valueCoding.system',
                            'code.coding.18.system',
                            'code.coding.19.code',
                            'code.coding.19.display',
                            'code.coding.19.extension.0.url',
                            'code.coding.19.extension.0.valueReference.reference',
                            'code.coding.19.extension.1.url',
                            'code.coding.19.extension.1.valueCoding.code',
                            'code.coding.19.extension.1.valueCoding.display',
                            'code.coding.19.extension.1.valueCoding.system',
                            'code.coding.19.system',
                            'code.coding.2.code',
                            'code.coding.2.display',
                            'code.coding.2.extension.0.url',
                            'code.coding.2.extension.0.valueReference.reference',
                            'code.coding.2.extension.1.url',
                            'code.coding.2.extension.1.valueCoding.code',
                            'code.coding.2.extension.1.valueCoding.display',
                            'code.coding.2.extension.1.valueCoding.system',
                            'code.coding.2.system',
                            'code.coding.3.code',
                            'code.coding.3.display',
                            'code.coding.3.extension.0.url',
                            'code.coding.3.extension.0.valueReference.reference',
                            'code.coding.3.extension.1.url',
                            'code.coding.3.extension.1.valueCoding.code',
                            'code.coding.3.extension.1.valueCoding.display',
                            'code.coding.3.extension.1.valueCoding.system',
                            'code.coding.3.system',
                            'code.coding.4.code',
                            'code.coding.4.display',
                            'code.coding.4.extension.0.url',
                            'code.coding.4.extension.0.valueReference.reference',
                            'code.coding.4.extension.1.url',
                            'code.coding.4.extension.1.valueCoding.code',
                            'code.coding.4.extension.1.valueCoding.display',
                            'code.coding.4.extension.1.valueCoding.system',
                            'code.coding.4.system',
                            'code.coding.5.code',
                            'code.coding.5.display',
                            'code.coding.5.extension.0.url',
                            'code.coding.5.extension.0.valueReference.reference',
                            'code.coding.5.extension.1.url',
                            'code.coding.5.extension.1.valueCoding.code',
                            'code.coding.5.extension.1.valueCoding.display',
                            'code.coding.5.extension.1.valueCoding.system',
                            'code.coding.5.system',
                            'code.coding.6.code',
                            'code.coding.6.display',
                            'code.coding.6.extension.0.url',
                            'code.coding.6.extension.0.valueReference.reference',
                            'code.coding.6.extension.1.url',
                            'code.coding.6.extension.1.valueCoding.code',
                            'code.coding.6.extension.1.valueCoding.display',
                            'code.coding.6.extension.1.valueCoding.system',
                            'code.coding.6.system',
                            'code.coding.7.code',
                            'code.coding.7.display',
                            'code.coding.7.extension.0.url',
                            'code.coding.7.extension.0.valueReference.reference',
                            'code.coding.7.extension.1.url',
                            'code.coding.7.extension.1.valueCoding.code',
                            'code.coding.7.extension.1.valueCoding.display',
                            'code.coding.7.extension.1.valueCoding.system',
                            'code.coding.7.system',
                            'code.coding.8.code',
                            'code.coding.8.display',
                            'code.coding.8.extension.0.url',
                            'code.coding.8.extension.0.valueReference.reference',
                            'code.coding.8.extension.1.url',
                            'code.coding.8.extension.1.valueCoding.code',
                            'code.coding.8.extension.1.valueCoding.display',
                            'code.coding.8.extension.1.valueCoding.system',
                            'code.coding.8.system',
                            'code.coding.9.code',
                            'code.coding.9.display',
                            'code.coding.9.extension.0.url',
                            'code.coding.9.extension.0.valueReference.reference',
                            'code.coding.9.extension.1.url',
                            'code.coding.9.extension.1.valueCoding.code',
                            'code.coding.9.extension.1.valueCoding.display',
                            'code.coding.9.extension.1.valueCoding.system',
                            'code.coding.9.system',
                            'extension.0.url',
                            'extension.0.valueUri',
                            'id',
                            'meta.lastUpdated',
                            'meta.security.0.code',
                            'meta.security.0.display',
                            'meta.security.0.system',
                            'meta.source',
                            'meta.versionId',
                            'resourceType',
                            'subject.reference',
                            'valueCodeableConcept.coding.0.code',
                            'valueCodeableConcept.coding.0.display',
                            'valueCodeableConcept.coding.0.system',
                            'valueQuantity.code',
                            'valueQuantity.system',
                            'valueQuantity.unit',
                            'valueQuantity.value'},
            'Organization': {'alias.0',
                             'id',
                             'identifier.0.system',
                             'identifier.0.value',
                             'identifier.1.system',
                             'identifier.1.value',
                             'identifier.2.system',
                             'identifier.2.value',
                             'meta.lastUpdated',
                             'meta.source',
                             'meta.versionId',
                             'name',
                             'resourceType'},
            'Patient': {'gender',
                        'id',
                        'identifier.0.id',
                        'identifier.0.system',
                        'meta.lastUpdated',
                        'meta.source',
                        'meta.versionId',
                        'resourceType',
                        'text.div',
                        'text.status'},
            'ResearchStudy': {'category.0.coding.0.code',
                              'category.0.coding.0.display',
                              'category.0.coding.0.system',
                              'category.0.text',
                              'condition.0.coding.0.code',
                              'condition.0.coding.0.display',
                              'condition.0.coding.0.system',
                              'condition.0.text',
                              'condition.1.coding.0.code',
                              'condition.1.coding.0.display',
                              'condition.1.coding.0.system',
                              'condition.1.text',
                              'condition.2.coding.0.code',
                              'condition.2.coding.0.display',
                              'condition.2.coding.0.system',
                              'condition.2.text',
                              'condition.3.coding.0.code',
                              'condition.3.coding.0.display',
                              'condition.3.coding.0.system',
                              'condition.3.text',
                              'condition.4.coding.0.code',
                              'condition.4.coding.0.display',
                              'condition.4.coding.0.system',
                              'condition.4.text',
                              'description',
                              'enrollment.0.reference',
                              'extension.0.url',
                              'extension.0.valueUrl',
                              'extension.1.url',
                              'extension.1.valueDate',
                              'extension.2.extension.0.url',
                              'extension.2.extension.0.valueCoding.code',
                              'extension.2.extension.0.valueCoding.display',
                              'extension.2.extension.0.valueCoding.system',
                              'extension.2.url',
                              'extension.3.extension.0.url',
                              'extension.3.extension.0.valueCount.code',
                              'extension.3.extension.0.valueCount.system',
                              'extension.3.extension.0.valueCount.value',
                              'extension.3.extension.1.url',
                              'extension.3.extension.1.valueCount.code',
                              'extension.3.extension.1.valueCount.system',
                              'extension.3.extension.2.url',
                              'extension.3.extension.2.valueCount.code',
                              'extension.3.extension.2.valueCount.system',
                              'extension.3.extension.2.valueCount.value',
                              'extension.3.extension.3.url',
                              'extension.3.extension.3.valueCount.code',
                              'extension.3.extension.3.valueCount.system',
                              'extension.3.extension.3.valueCount.value',
                              'extension.3.extension.4.url',
                              'extension.3.extension.4.valueCount.code',
                              'extension.3.extension.4.valueCount.system',
                              'extension.3.url',
                              'focus.0.coding.0.code',
                              'focus.0.coding.0.display',
                              'focus.0.coding.0.system',
                              'focus.0.text',
                              'id',
                              'identifier.0.type.coding.0.code',
                              'identifier.0.type.coding.0.display',
                              'identifier.0.type.coding.0.system',
                              'identifier.0.value',
                              'keyword.0.coding.0.code',
                              'keyword.0.coding.0.display',
                              'keyword.0.coding.0.system',
                              'keyword.0.text',
                              'keyword.1.coding.0.code',
                              'keyword.1.coding.0.display',
                              'keyword.1.coding.0.system',
                              'keyword.1.text',
                              'keyword.2.coding.0.code',
                              'keyword.2.coding.0.display',
                              'keyword.2.coding.0.system',
                              'keyword.2.text',
                              'keyword.3.coding.0.code',
                              'keyword.3.coding.0.display',
                              'keyword.3.coding.0.system',
                              'keyword.3.text',
                              'keyword.4.coding.0.code',
                              'keyword.4.coding.0.display',
                              'keyword.4.coding.0.system',
                              'keyword.4.text',
                              'meta.lastUpdated',
                              'meta.security.0.code',
                              'meta.security.0.display',
                              'meta.security.0.system',
                              'meta.source',
                              'meta.versionId',
                              'resourceType',
                              'sponsor.display',
                              'sponsor.reference',
                              'sponsor.type',
                              'status',
                              'title'},
            'ResearchSubject': {'id',
                                'individual.reference',
                                'meta.lastUpdated',
                                'meta.security.0.code',
                                'meta.security.0.display',
                                'meta.security.0.system',
                                'meta.source',
                                'meta.versionId',
                                'resourceType',
                                'status',
                                'study.reference'}}


@fixture
def input_paths():
    """Raw files."""
    return [
        f'{DBGAP_FIXTURES}/examples/observation.json',
        f'{DBGAP_FIXTURES}/examples/research_study.json',
        f'{DBGAP_FIXTURES}/examples/research_subject_patient.json'
    ]
