# AUTOGENERATED! DO NOT EDIT! File to edit: src/cli.ipynb (unless otherwise specified).

__all__ = ['parser', 'main']

# Cell
import argparse

from .slideslive import SlidesLive

# Cell
#export
parser = argparse.ArgumentParser(description='Take care of your SlidesLive slides...')

parser.add_argument('url', type=str, help='SlidesLive URL', nargs=1)
parser.add_argument('--size', default='big', type=str, help='Slide size: medium or big')
parser.add_argument('--waittime', default=0.2, type=float, help='Seconds to wait after downloading each slide')
parser.add_argument('--lastduration', default=None, type=int, help='The duration of last slide in seconds')

parser.add_argument('--time', default=None,
                    nargs=2, type=tuple, metavar=('MIN_TIME', 'MAX_TIME'),
                    help='A time range used to extract slides (use None for one of '
                         'the values to get min or max range)')
parser.add_argument('--slide', default=None,
                    nargs=2, type=tuple, metavar=('MIN_SLIDE_ID', 'MAX_SLIDE_ID'),
                    help='A range of slide IDs to extract (use None for one of '
                         'the values to get min or max range)')

# Cell
#export
def main():
    """Defines command line interface."""
    args = parser.parse_args()
    if args.size not in ('big', 'medium'):
        raise RuntimeError('The slide size can only be *big* or *medium*.')

    if args.slide is not None:
        assert len(args.slide) == 2
        s1 = ''.join(args.slide[0])
        if s1.isdecimal():
            s1 = int(s1)
        elif s1.lower() == 'none':
            s1 = None
        else:
            raise RuntimeError('--slide MIN_SLIDE_ID must either be an integer '
                               f'or None.\n{s1} was given.')
        s2 = ''.join(args.slide[1])
        if s2.isdecimal():
            s2 = int(s2)
        elif s2.lower() == 'none':
            s2 = None
        else:
            raise RuntimeError('--slide MAX_SLIDE_ID must either be an integer '
                               f'or None.\n{s2} was given.')
        slide = (s1, s2)
    else:
        slide = None

    if args.time is not None:
        assert len(args.time) == 2
        t1 = ''.join(args.time[0])
        if t1.isdecimal():
            t1 = int(t1)
        elif t1.lower() == 'none':
            t1 = None
        else:
            raise RuntimeError('--time MIN_TIME must either be an integer '
                               f'or None.\n{t1} was given.')
        t2 = ''.join(args.time[1])
        if t2.isdecimal():
            t2 = int(t2)
        elif t2.lower() == 'none':
            t2 = None
        else:
            raise RuntimeError('--slide MAX_TIME must either be an integer '
                               f'or None.\n{t2} was given.')
        time = (t1, t2)
    else:
        time = None

    assert isinstance(args.url ,list) and len(args.url) == 1
    url = args.url[0]

    msl = SlidesLive(url)
    msl.download_slides(slide_type=args.size,
                        slide=slide,
                        time=time,
                        sleep_time=args.waittime)
    msl.compose_video(last_duration=args.lastduration)

# Cell
#export
if __name__ == '__main__':
    main()