"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import attestation_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ComputeNodeFormat:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ComputeNodeFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ComputeNodeFormat.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RAW: _ComputeNodeFormat.ValueType  # 0
    ZIP: _ComputeNodeFormat.ValueType  # 1

class ComputeNodeFormat(_ComputeNodeFormat, metaclass=_ComputeNodeFormatEnumTypeWrapper): ...

RAW: ComputeNodeFormat.ValueType  # 0
ZIP: ComputeNodeFormat.ValueType  # 1
global___ComputeNodeFormat = ComputeNodeFormat

class DataRoom(google.protobuf.message.Message):
    """/ To create a dataroom the user need to specify the `GovernanceProtocol`
    / and the list of `ConfigurationModification`.
    / The `GovernanceProtocol` defines how new modifications can be applied to an
    / existing data room. The list of `ConfigurationModification`s (abbreviated by
    / "Modification" in the diagram below) defined the structure of the data room
    / itself (the compute nodes, the permissions, etc...), this list makes up the
    / first `ConfigurationCommit` for the dataroom.
    /
    / ```diagram
    /  ┌──────────────────────┐
    /  │CreateDataRoomRequest │           ┌──────────────────┐
    /  │ ┌──────────────────┐ │           │ DataRoomContext  │
    /  │ │GovernanceProtocol│ │           │ ┌──────────────┐ │
    /  │ └──────────────────┘ │           │ │  Leaf nodes  │ │
    /  │ ┌─────────────┐      ├──────────▶│ │ manifest map │ │
    /  │ │ ┌───────────┴─┐    │           │ └──────────────┘ │
    /  │ └─┤┌────────────┴──┐ │           │ ┌──────────────┐ │
    /  │   └┤ Modification  │ │           │ │CommitsHistory│ │
    /  │    └───────────────┘ │           │ └──────────────┘ │
    /  └──────────────────────┘           └──────────────────┘
    / ```
    /
    / A dataroom has a corresponding `DataRoomContext` which includes a map of the
    / currently published datasets (and corresponding encryption key) and the
    / commits history which is a list of the `ConfigurationCommit` that make up
    / the data room
    /
    / ```diagram
    /  ┌──────────────────────────────┐
    /  │        CommitsHistory        │
    /  │┌────────────────────┐        │        ┌────┬─────────────────────────┐
    /  ││ ┌──────────────────┴─┐      │     ┌──│ Id │ConfigurationCommit #1   │
    /  ││ │  ┌─────────────────┴──┐   │     │  └────┴─────────────────────────┘
    /  ││ │  │ ┌──────────────────┴─┐ │     │  ┌────┬─────────────────────────┐
    /  ││ │  │ │ConfigurationCommit │ │     ├──│ Id │ConfigurationCommit #2   │
    /  ││ │  │ │┌──────────────────┐│ │     │  └────┴─────────────────────────┘
    /  ││ │  │ ││    DataRoomId    ││ │     │  ┌────┬─────────────────────────┐
    /  ││ │  │ │└──────────────────┘│ │     ├──│ Id │ConfigurationCommit #3   │
    /  ││ │  │ │┌──────────────────┐│ │     │  └────┴─────────────────────────┘
    /  ││ │  │ ││   DataRoomPin    ││ │     │  ┌────┬─────────────────────────┐
    /  ││ │  │ │└──────────────────┘│ │     ├──│ Id │ConfigurationCommit #4   │
    /  ││ │  │ │┌─────────────┐     │ │     │  └────┴─────────────────────────┘
    /  ││ │  │ ││ ┌───────────┴─┐   │ │     │
    /  │└─┤  │ │└─┤┌────────────┴──┐│ │     │
    /  │  └──┤ │  └┤ Modification  ││ │     │    ┌──────────────────────────┐
    /  │     └─┤   └───────────────┘│ │     └───▶│       DataRoomPin        │
    /  │       └────────────────────┘ │          └──────────────────────────┘
    /  └──────────────────────────────┘
    / ```
    /
    / Each `ConfigurationCommit` is identified by the data room which it refers to
    / and the pin of the data room itself. A commit can only be merged if the
    / `pin` corresponds to the current configuration history state of the data
    / room
    /
    / ```diagram
    /  ┌───────────────────────────────┐           ┌────────────────┐
    /  │MergeConfigurationCommitRequest│           │ CommitsHistory │
    /  │ ┌───────────────────────────┐ │           └────────────────┘
    /  │ │  ConfigurationCommit #5   │ │              ┌────┐
    /  │ └───────────────────────────┘ │              │ ┌──┴─┐
    /  │ ┌─────────────────────┐       ├──────────▶   └─┤ ┌──┴─┐
    /  │ │  ┌──────────────────┴──┐    │                └─┤ ┌──┴─┐
    /  │ └──┤  ┌──────────────────┴──┐ │                  └─┤ ┌──┴─┐
    /  │    └──┤   MergeSignature    │ │                    └─┤ 5  │
    /  │       └─────────────────────┘ │                      └────┘
    /  └───────────────────────────────┘
    / ```
    /
    / When a user collects the approval signatures required to merge a commit,
    / this can be added to the commits history. The list of approvers depends both
    / on the commit and the `GovernanceProtocol` that the data room is configured
    / with:
    / - StaticDataRoomPolicy: the data room is static, there isn't an approver
    / that
    /    can authorize the merge
    / - AffectedDataOwnersApprovePolicy: the approvers for a commit are the user
    / which have
    /     a CrudPermisison on the leaf node that the new nodes may use
    /
    / ```diagram
    /                                           ┌────────────────────┐
    /                                           │   UserPermission   │
    /  ┌ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ┐      │ ┌───────────────┐  │
    /            New Commit Node                │ │user1@email.com│──┼──┐
    /  │          ┌───┬───────┐          │      │ └───────────────┘  │  │
    /           ┌▶│0x4│Python │◀─┐              │ ┌──────────────┐   │  │
    /  │        │ └───┴───────┘  │       │      │ │ ┌────────────┴─┐ │  │
    /   ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─│─ ─ ─ ─       │ └─┤CrudPermission│ │  │
    /   ┌───────────────┐
    /  ┌ ─ ─ ─ ─│─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ┐      │   │   id: 0x1    │ │  └────▶│
    /  Required    │
    /     ┌───┬─┴─────┐          │              │   └──────────────┘ │        │
    /     Approvers   │
    /  │  │0x3│  Sql  │          │       │      └────────────────────┘
    /  ├───────────────┤
    /     └───┴───────┘          │              ┌────────────────────┐
    /     ┌────▶│user1@email.com│
    /  │        ▲                │       │      │   UserPermission   │  │     │ │
    /     ┌───┬─┴─────┐   ┌───┬──┴────┐         │ ┌───────────────┐  │  │
    /     │user2@email.com│
    /  │  │0x1│Leaf 1 │   │0x2│Leaf 2 │  │      │ │user2@email.com│──┼──┘
    /  └───────────────┘
    /     └───┴───────┘   └───┴───────┘         │ └───────────────┘  │
    /  │                                 │      │ ┌──────────────┐   │
    /      Old data room configuration          │ │ ┌────────────┴─┐ │
    /  └ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ─ ┘      │ └─┤CrudPermission│ │
    /                                           │   │   id: 0x2    │ │
    /                                           │   └──────────────┘ │
    /                                           └────────────────────┘
    / ```
    /
    / In the example above `user3@email.com` has created a new commit which adds
    / node `0x4` to the data room. By walking the computation graph the node
    / depends on node `0x2` directly and node `0x1` indirectly. To authorize the
    / merge both owners of these leaf nodes must provide an approval signature.
    / The ownership of the nodes is determined by checking who has
    / `CrudPermission` on the leaf nodes.
    /
    / Configuration commits don't have to be merged into a data room configuration
    / history, but can also be used to execute computations on top of data the
    / user already has access to. This is determined by checking if a user has
    / ExecuteComputePermission on the node which the new nodes depend on
    /
    / ```diagram
    /  ┌ ─ ─ ─ ─ ─ ─ ─ ─ ┐
    /    New Commit Node
    /  │  ┌───┬───────┐  │
    /     │0x3│Python │       ┌────────────────────┐
    /  │  └───┴───────┘  │    │   UserPermission   │
    /   ─ ─ ─ ─ ▲ ─ ─ ─ ─     │ ┌───────────────┐  │
    /  ┌ ─ ─ ─ ─│─ ─ ─ ─ ┐    │ │user2@email.com│  │
    /     ┌───┬─┴─────┐       │ └───────────────┘  │
    /  │  │0x2│  Sql  │  │    │ ┌──────────────┐   │
    /     └───┴───────┘       │ │ ┌────────────┴─┐ │
    /  │        ▲        │    │ └─┤ExecuteCompute│ │
    /     ┌───┬─┴─────┐       │   │   id: 0x2    │ │
    /  │  │0x1│Leaf 1 │  │    │   └──────────────┘ │
    /     └───┴───────┘       └────────────────────┘
    /  │  Old data room  │
    /     configuration
    /  └ ─ ─ ─ ─ ─ ─ ─ ─ ┘
    / ```
    /
    / In the example above `user2@email.com` has created a new commit which adds
    / node `0x3` to the data room. The node has a dependency on `0x2`, for which
    / the user has `ExecuteComputePermission` which means that the user can
    / execute the node `0x3`
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    GOVERNANCEPROTOCOL_FIELD_NUMBER: builtins.int
    INITIALCONFIGURATION_FIELD_NUMBER: builtins.int
    id: builtins.str
    name: builtins.str
    description: builtins.str
    @property
    def governanceProtocol(self) -> global___GovernanceProtocol: ...
    @property
    def initialConfiguration(self) -> global___DataRoomConfiguration: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        governanceProtocol: global___GovernanceProtocol | None = ...,
        initialConfiguration: global___DataRoomConfiguration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["governanceProtocol", b"governanceProtocol", "initialConfiguration", b"initialConfiguration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "governanceProtocol", b"governanceProtocol", "id", b"id", "initialConfiguration", b"initialConfiguration", "name", b"name"]) -> None: ...

global___DataRoom = DataRoom

class GovernanceProtocol(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATICDATAROOMPOLICY_FIELD_NUMBER: builtins.int
    AFFECTEDDATAOWNERSAPPROVEPOLICY_FIELD_NUMBER: builtins.int
    @property
    def staticDataRoomPolicy(self) -> global___StaticDataRoomPolicy: ...
    @property
    def affectedDataOwnersApprovePolicy(self) -> global___AffectedDataOwnersApprovePolicy: ...
    def __init__(
        self,
        *,
        staticDataRoomPolicy: global___StaticDataRoomPolicy | None = ...,
        affectedDataOwnersApprovePolicy: global___AffectedDataOwnersApprovePolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["affectedDataOwnersApprovePolicy", b"affectedDataOwnersApprovePolicy", "policy", b"policy", "staticDataRoomPolicy", b"staticDataRoomPolicy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["affectedDataOwnersApprovePolicy", b"affectedDataOwnersApprovePolicy", "policy", b"policy", "staticDataRoomPolicy", b"staticDataRoomPolicy"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["policy", b"policy"]) -> typing_extensions.Literal["staticDataRoomPolicy", "affectedDataOwnersApprovePolicy"] | None: ...

global___GovernanceProtocol = GovernanceProtocol

class StaticDataRoomPolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___StaticDataRoomPolicy = StaticDataRoomPolicy

class AffectedDataOwnersApprovePolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___AffectedDataOwnersApprovePolicy = AffectedDataOwnersApprovePolicy

class DataRoomConfiguration(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENTS_FIELD_NUMBER: builtins.int
    @property
    def elements(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConfigurationElement]: ...
    def __init__(
        self,
        *,
        elements: collections.abc.Iterable[global___ConfigurationElement] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["elements", b"elements"]) -> None: ...

global___DataRoomConfiguration = DataRoomConfiguration

class ConfigurationElement(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    COMPUTENODE_FIELD_NUMBER: builtins.int
    ATTESTATIONSPECIFICATION_FIELD_NUMBER: builtins.int
    USERPERMISSION_FIELD_NUMBER: builtins.int
    AUTHENTICATIONMETHOD_FIELD_NUMBER: builtins.int
    id: builtins.str
    @property
    def computeNode(self) -> global___ComputeNode: ...
    @property
    def attestationSpecification(self) -> attestation_pb2.AttestationSpecification: ...
    @property
    def userPermission(self) -> global___UserPermission: ...
    @property
    def authenticationMethod(self) -> global___AuthenticationMethod: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        computeNode: global___ComputeNode | None = ...,
        attestationSpecification: attestation_pb2.AttestationSpecification | None = ...,
        userPermission: global___UserPermission | None = ...,
        authenticationMethod: global___AuthenticationMethod | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["attestationSpecification", b"attestationSpecification", "authenticationMethod", b"authenticationMethod", "computeNode", b"computeNode", "element", b"element", "userPermission", b"userPermission"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attestationSpecification", b"attestationSpecification", "authenticationMethod", b"authenticationMethod", "computeNode", b"computeNode", "element", b"element", "id", b"id", "userPermission", b"userPermission"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["element", b"element"]) -> typing_extensions.Literal["computeNode", "attestationSpecification", "userPermission", "authenticationMethod"] | None: ...

global___ConfigurationElement = ConfigurationElement

class ConfigurationModification(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADD_FIELD_NUMBER: builtins.int
    CHANGE_FIELD_NUMBER: builtins.int
    DELETE_FIELD_NUMBER: builtins.int
    @property
    def add(self) -> global___AddModification: ...
    @property
    def change(self) -> global___ChangeModification: ...
    @property
    def delete(self) -> global___DeleteModification: ...
    def __init__(
        self,
        *,
        add: global___AddModification | None = ...,
        change: global___ChangeModification | None = ...,
        delete: global___DeleteModification | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["add", b"add", "change", b"change", "delete", b"delete", "modification", b"modification"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["add", b"add", "change", b"change", "delete", b"delete", "modification", b"modification"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["modification", b"modification"]) -> typing_extensions.Literal["add", "change", "delete"] | None: ...

global___ConfigurationModification = ConfigurationModification

class AddModification(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_FIELD_NUMBER: builtins.int
    @property
    def element(self) -> global___ConfigurationElement: ...
    def __init__(
        self,
        *,
        element: global___ConfigurationElement | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["element", b"element"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["element", b"element"]) -> None: ...

global___AddModification = AddModification

class ChangeModification(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENT_FIELD_NUMBER: builtins.int
    @property
    def element(self) -> global___ConfigurationElement: ...
    def __init__(
        self,
        *,
        element: global___ConfigurationElement | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["element", b"element"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["element", b"element"]) -> None: ...

global___ChangeModification = ChangeModification

class DeleteModification(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    def __init__(
        self,
        *,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id"]) -> None: ...

global___DeleteModification = DeleteModification

class ConfigurationCommit(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DATAROOMID_FIELD_NUMBER: builtins.int
    DATAROOMHISTORYPIN_FIELD_NUMBER: builtins.int
    MODIFICATIONS_FIELD_NUMBER: builtins.int
    id: builtins.str
    name: builtins.str
    dataRoomId: builtins.bytes
    dataRoomHistoryPin: builtins.bytes
    @property
    def modifications(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ConfigurationModification]: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        dataRoomId: builtins.bytes = ...,
        dataRoomHistoryPin: builtins.bytes = ...,
        modifications: collections.abc.Iterable[global___ConfigurationModification] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["dataRoomHistoryPin", b"dataRoomHistoryPin", "dataRoomId", b"dataRoomId", "id", b"id", "modifications", b"modifications", "name", b"name"]) -> None: ...

global___ConfigurationCommit = ConfigurationCommit

class ComputeNode(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NODENAME_FIELD_NUMBER: builtins.int
    LEAF_FIELD_NUMBER: builtins.int
    PARAMETER_FIELD_NUMBER: builtins.int
    BRANCH_FIELD_NUMBER: builtins.int
    nodeName: builtins.str
    @property
    def leaf(self) -> global___ComputeNodeLeaf: ...
    @property
    def parameter(self) -> global___ComputeNodeParameter: ...
    @property
    def branch(self) -> global___ComputeNodeBranch: ...
    def __init__(
        self,
        *,
        nodeName: builtins.str = ...,
        leaf: global___ComputeNodeLeaf | None = ...,
        parameter: global___ComputeNodeParameter | None = ...,
        branch: global___ComputeNodeBranch | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["branch", b"branch", "leaf", b"leaf", "node", b"node", "parameter", b"parameter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["branch", b"branch", "leaf", b"leaf", "node", b"node", "nodeName", b"nodeName", "parameter", b"parameter"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["node", b"node"]) -> typing_extensions.Literal["leaf", "parameter", "branch"] | None: ...

global___ComputeNode = ComputeNode

class ComputeNodeLeaf(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ISREQUIRED_FIELD_NUMBER: builtins.int
    isRequired: builtins.bool
    def __init__(
        self,
        *,
        isRequired: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["isRequired", b"isRequired"]) -> None: ...

global___ComputeNodeLeaf = ComputeNodeLeaf

class ComputeNodeParameter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ISREQUIRED_FIELD_NUMBER: builtins.int
    isRequired: builtins.bool
    def __init__(
        self,
        *,
        isRequired: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["isRequired", b"isRequired"]) -> None: ...

global___ComputeNodeParameter = ComputeNodeParameter

class ComputeNodeProtocol(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    version: builtins.int
    def __init__(
        self,
        *,
        version: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["version", b"version"]) -> None: ...

global___ComputeNodeProtocol = ComputeNodeProtocol

class ComputeNodeBranch(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIG_FIELD_NUMBER: builtins.int
    DEPENDENCIES_FIELD_NUMBER: builtins.int
    OUTPUTFORMAT_FIELD_NUMBER: builtins.int
    PROTOCOL_FIELD_NUMBER: builtins.int
    ATTESTATIONSPECIFICATIONID_FIELD_NUMBER: builtins.int
    config: builtins.bytes
    @property
    def dependencies(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    outputFormat: global___ComputeNodeFormat.ValueType
    @property
    def protocol(self) -> global___ComputeNodeProtocol: ...
    attestationSpecificationId: builtins.str
    def __init__(
        self,
        *,
        config: builtins.bytes = ...,
        dependencies: collections.abc.Iterable[builtins.str] | None = ...,
        outputFormat: global___ComputeNodeFormat.ValueType = ...,
        protocol: global___ComputeNodeProtocol | None = ...,
        attestationSpecificationId: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["protocol", b"protocol"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attestationSpecificationId", b"attestationSpecificationId", "config", b"config", "dependencies", b"dependencies", "outputFormat", b"outputFormat", "protocol", b"protocol"]) -> None: ...

global___ComputeNodeBranch = ComputeNodeBranch

class UserPermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EMAIL_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    AUTHENTICATIONMETHODID_FIELD_NUMBER: builtins.int
    email: builtins.str
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Permission]: ...
    authenticationMethodId: builtins.str
    def __init__(
        self,
        *,
        email: builtins.str = ...,
        permissions: collections.abc.Iterable[global___Permission] | None = ...,
        authenticationMethodId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["authenticationMethodId", b"authenticationMethodId", "email", b"email", "permissions", b"permissions"]) -> None: ...

global___UserPermission = UserPermission

class AuthenticationMethod(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERSONALPKI_FIELD_NUMBER: builtins.int
    DQPKI_FIELD_NUMBER: builtins.int
    DCRSECRET_FIELD_NUMBER: builtins.int
    @property
    def personalPki(self) -> global___PkiPolicy: ...
    @property
    def dqPki(self) -> global___PkiPolicy: ...
    @property
    def dcrSecret(self) -> global___DcrSecretPolicy:
        """the policies below could be implemented later on
        EmailVerificationPolicy emailVerificationPolicy = 3;
        OpenIdConnectPolicy openIdConnectPolicy = 4;
        DcrSecretPolicy
        """
    def __init__(
        self,
        *,
        personalPki: global___PkiPolicy | None = ...,
        dqPki: global___PkiPolicy | None = ...,
        dcrSecret: global___DcrSecretPolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["dcrSecret", b"dcrSecret", "dqPki", b"dqPki", "personalPki", b"personalPki"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["dcrSecret", b"dcrSecret", "dqPki", b"dqPki", "personalPki", b"personalPki"]) -> None: ...

global___AuthenticationMethod = AuthenticationMethod

class PkiPolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROOTCERTIFICATEPEM_FIELD_NUMBER: builtins.int
    rootCertificatePem: builtins.bytes
    def __init__(
        self,
        *,
        rootCertificatePem: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["rootCertificatePem", b"rootCertificatePem"]) -> None: ...

global___PkiPolicy = PkiPolicy

class DcrSecretPolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DCRSECRETID_FIELD_NUMBER: builtins.int
    dcrSecretId: builtins.bytes
    def __init__(
        self,
        *,
        dcrSecretId: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["dcrSecretId", b"dcrSecretId"]) -> None: ...

global___DcrSecretPolicy = DcrSecretPolicy

class Permission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXECUTECOMPUTEPERMISSION_FIELD_NUMBER: builtins.int
    LEAFCRUDPERMISSION_FIELD_NUMBER: builtins.int
    RETRIEVEDATAROOMPERMISSION_FIELD_NUMBER: builtins.int
    RETRIEVEAUDITLOGPERMISSION_FIELD_NUMBER: builtins.int
    RETRIEVEDATAROOMSTATUSPERMISSION_FIELD_NUMBER: builtins.int
    UPDATEDATAROOMSTATUSPERMISSION_FIELD_NUMBER: builtins.int
    RETRIEVEPUBLISHEDDATASETSPERMISSION_FIELD_NUMBER: builtins.int
    DRYRUNPERMISSION_FIELD_NUMBER: builtins.int
    GENERATEMERGESIGNATUREPERMISSION_FIELD_NUMBER: builtins.int
    EXECUTEDEVELOPMENTCOMPUTEPERMISSION_FIELD_NUMBER: builtins.int
    MERGECONFIGURATIONCOMMITPERMISSION_FIELD_NUMBER: builtins.int
    RETRIEVECOMPUTERESULTPERMISSION_FIELD_NUMBER: builtins.int
    CASAUXILIARYSTATEPERMISSION_FIELD_NUMBER: builtins.int
    READAUXILIARYSTATEPERMISSION_FIELD_NUMBER: builtins.int
    @property
    def executeComputePermission(self) -> global___ExecuteComputePermission: ...
    @property
    def leafCrudPermission(self) -> global___LeafCrudPermission: ...
    @property
    def retrieveDataRoomPermission(self) -> global___RetrieveDataRoomPermission: ...
    @property
    def retrieveAuditLogPermission(self) -> global___RetrieveAuditLogPermission: ...
    @property
    def retrieveDataRoomStatusPermission(self) -> global___RetrieveDataRoomStatusPermission: ...
    @property
    def updateDataRoomStatusPermission(self) -> global___UpdateDataRoomStatusPermission: ...
    @property
    def retrievePublishedDatasetsPermission(self) -> global___RetrievePublishedDatasetsPermission: ...
    @property
    def dryRunPermission(self) -> global___DryRunPermission: ...
    @property
    def generateMergeSignaturePermission(self) -> global___GenerateMergeSignaturePermission: ...
    @property
    def executeDevelopmentComputePermission(self) -> global___ExecuteDevelopmentComputePermission: ...
    @property
    def mergeConfigurationCommitPermission(self) -> global___MergeConfigurationCommitPermission: ...
    @property
    def retrieveComputeResultPermission(self) -> global___RetrieveComputeResultPermission: ...
    @property
    def casAuxiliaryStatePermission(self) -> global___CasAuxiliaryStatePermission: ...
    @property
    def readAuxiliaryStatePermission(self) -> global___ReadAuxiliaryStatePermission: ...
    def __init__(
        self,
        *,
        executeComputePermission: global___ExecuteComputePermission | None = ...,
        leafCrudPermission: global___LeafCrudPermission | None = ...,
        retrieveDataRoomPermission: global___RetrieveDataRoomPermission | None = ...,
        retrieveAuditLogPermission: global___RetrieveAuditLogPermission | None = ...,
        retrieveDataRoomStatusPermission: global___RetrieveDataRoomStatusPermission | None = ...,
        updateDataRoomStatusPermission: global___UpdateDataRoomStatusPermission | None = ...,
        retrievePublishedDatasetsPermission: global___RetrievePublishedDatasetsPermission | None = ...,
        dryRunPermission: global___DryRunPermission | None = ...,
        generateMergeSignaturePermission: global___GenerateMergeSignaturePermission | None = ...,
        executeDevelopmentComputePermission: global___ExecuteDevelopmentComputePermission | None = ...,
        mergeConfigurationCommitPermission: global___MergeConfigurationCommitPermission | None = ...,
        retrieveComputeResultPermission: global___RetrieveComputeResultPermission | None = ...,
        casAuxiliaryStatePermission: global___CasAuxiliaryStatePermission | None = ...,
        readAuxiliaryStatePermission: global___ReadAuxiliaryStatePermission | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["casAuxiliaryStatePermission", b"casAuxiliaryStatePermission", "dryRunPermission", b"dryRunPermission", "executeComputePermission", b"executeComputePermission", "executeDevelopmentComputePermission", b"executeDevelopmentComputePermission", "generateMergeSignaturePermission", b"generateMergeSignaturePermission", "leafCrudPermission", b"leafCrudPermission", "mergeConfigurationCommitPermission", b"mergeConfigurationCommitPermission", "permission", b"permission", "readAuxiliaryStatePermission", b"readAuxiliaryStatePermission", "retrieveAuditLogPermission", b"retrieveAuditLogPermission", "retrieveComputeResultPermission", b"retrieveComputeResultPermission", "retrieveDataRoomPermission", b"retrieveDataRoomPermission", "retrieveDataRoomStatusPermission", b"retrieveDataRoomStatusPermission", "retrievePublishedDatasetsPermission", b"retrievePublishedDatasetsPermission", "updateDataRoomStatusPermission", b"updateDataRoomStatusPermission"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["casAuxiliaryStatePermission", b"casAuxiliaryStatePermission", "dryRunPermission", b"dryRunPermission", "executeComputePermission", b"executeComputePermission", "executeDevelopmentComputePermission", b"executeDevelopmentComputePermission", "generateMergeSignaturePermission", b"generateMergeSignaturePermission", "leafCrudPermission", b"leafCrudPermission", "mergeConfigurationCommitPermission", b"mergeConfigurationCommitPermission", "permission", b"permission", "readAuxiliaryStatePermission", b"readAuxiliaryStatePermission", "retrieveAuditLogPermission", b"retrieveAuditLogPermission", "retrieveComputeResultPermission", b"retrieveComputeResultPermission", "retrieveDataRoomPermission", b"retrieveDataRoomPermission", "retrieveDataRoomStatusPermission", b"retrieveDataRoomStatusPermission", "retrievePublishedDatasetsPermission", b"retrievePublishedDatasetsPermission", "updateDataRoomStatusPermission", b"updateDataRoomStatusPermission"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["permission", b"permission"]) -> typing_extensions.Literal["executeComputePermission", "leafCrudPermission", "retrieveDataRoomPermission", "retrieveAuditLogPermission", "retrieveDataRoomStatusPermission", "updateDataRoomStatusPermission", "retrievePublishedDatasetsPermission", "dryRunPermission", "generateMergeSignaturePermission", "executeDevelopmentComputePermission", "mergeConfigurationCommitPermission", "retrieveComputeResultPermission", "casAuxiliaryStatePermission", "readAuxiliaryStatePermission"] | None: ...

global___Permission = Permission

class ExecuteComputePermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPUTENODEID_FIELD_NUMBER: builtins.int
    computeNodeId: builtins.str
    def __init__(
        self,
        *,
        computeNodeId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["computeNodeId", b"computeNodeId"]) -> None: ...

global___ExecuteComputePermission = ExecuteComputePermission

class LeafCrudPermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LEAFNODEID_FIELD_NUMBER: builtins.int
    leafNodeId: builtins.str
    def __init__(
        self,
        *,
        leafNodeId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["leafNodeId", b"leafNodeId"]) -> None: ...

global___LeafCrudPermission = LeafCrudPermission

class RetrieveDataRoomPermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RetrieveDataRoomPermission = RetrieveDataRoomPermission

class RetrieveAuditLogPermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RetrieveAuditLogPermission = RetrieveAuditLogPermission

class RetrieveDataRoomStatusPermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RetrieveDataRoomStatusPermission = RetrieveDataRoomStatusPermission

class UpdateDataRoomStatusPermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UpdateDataRoomStatusPermission = UpdateDataRoomStatusPermission

class RetrievePublishedDatasetsPermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RetrievePublishedDatasetsPermission = RetrievePublishedDatasetsPermission

class DryRunPermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DryRunPermission = DryRunPermission

class GenerateMergeSignaturePermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GenerateMergeSignaturePermission = GenerateMergeSignaturePermission

class ExecuteDevelopmentComputePermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ExecuteDevelopmentComputePermission = ExecuteDevelopmentComputePermission

class MergeConfigurationCommitPermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___MergeConfigurationCommitPermission = MergeConfigurationCommitPermission

class RetrieveComputeResultPermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPUTENODEID_FIELD_NUMBER: builtins.int
    computeNodeId: builtins.str
    def __init__(
        self,
        *,
        computeNodeId: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["computeNodeId", b"computeNodeId"]) -> None: ...

global___RetrieveComputeResultPermission = RetrieveComputeResultPermission

class CasAuxiliaryStatePermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___CasAuxiliaryStatePermission = CasAuxiliaryStatePermission

class ReadAuxiliaryStatePermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ReadAuxiliaryStatePermission = ReadAuxiliaryStatePermission
