[![Build Status](https://travis-ci.org/SpikeInterface/spikeextractors.svg?branch=master)](https://travis-ci.org/SpikeInterface/spikeextractors) [![PyPI version](https://badge.fury.io/py/spikeextractors.svg)](https://badge.fury.io/py/spikeextractors)

# SpikeExtractors

SpikeExtractors is a package of the SpikeInterface project designed to address issues of file format compatibility within spike sorting pipelines without creating yet another file format. 

SpikeExtractors provides functionality to extract data from, convert between, and interface with many common file formats in extracellular recording. File types that can be utilized with SpikeExtractors include recorded dataset files, sorted dataset files, and probe files (.csv and .prb).

## Getting Started

To get started with SpikeExtractors, you can install it with pip:

```shell
pip install spikeextractors
```

You can also get SpikeExtractors through the [spikeinterface](https://github.com/SpikeInterface/spikeinterface) package:

```shell
pip install spikeinterface
```

You can also install SpikeExtractors locally by cloning the repo into your code base. If you install SpikeExtractors locally, you need to run the setup.py file.

```shell
git clone https://github.com/SpikeInterface/spikeextractors.git
cd spikeextractors
python setup.py install
```

## Examples

For more information about how to use SpikeExtractors, please checkout these [examples](https://github.com/SpikeInterface/spikeinterface/tree/master/examples/modules/extractors).

## Documentation

All documentation for SpikeInterface can be found here: https://spikeinterface.readthedocs.io/en/latest/.

### Authors

[Cole Hurwitz](https://www.inf.ed.ac.uk/people/students/Cole_Hurwitz.html) - The Institute for Adaptive and Neural Computation (ANC), University of Edinburgh, Edinburgh, Scotland

[Alessio Paolo Buccino](https://www.mn.uio.no/ifi/english/people/aca/alessiob/) - Center for Inegrative Neurolasticity (CINPLA), Department of Biosciences, Physics, and Informatics, University of Oslo, Oslo, Norway

[Jeremy Magland](https://www.simonsfoundation.org/team/jeremy-magland/) - Center for Computational Biology (CCB), Flatiron Institute, New York, United States

[Matthias Hennig](http://homepages.inf.ed.ac.uk/mhennig/) - The Institute for Adaptive and Neural Computation (ANC), University of Edinburgh, Edinburgh, Scotland

[Samuel Garcia](https://github.com/samuelgarcia) - Centre de Recherche en Neuroscience de Lyon (CRNL), Lyon, France

<br/>
<br/>
For any correspondence, contact Cole Hurwitz at colehurwitz@gmail.com
