"""empty message

Revision ID: 51e638dafa33
Revises: 
Create Date: 2020-09-25 23:37:50.830365

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '51e638dafa33'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('appointments',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('date', sa.String(length=20), nullable=True),
    sa.Column('time', sa.String(length=20), nullable=True),
    sa.Column('active', sa.String(length=20), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('category',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_table('people',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('phone', sa.Integer(), nullable=True),
    sa.Column('mobile', sa.Integer(), nullable=True),
    sa.Column('email', sa.String(length=100), nullable=True),
    sa.Column('facebook', sa.String(length=128), nullable=True),
    sa.Column('twitter', sa.String(length=128), nullable=True),
    sa.Column('linkedin', sa.String(length=128), nullable=True),
    sa.Column('age', sa.Integer(), nullable=True),
    sa.Column('birthday', sa.String(length=100), nullable=True),
    sa.Column('notes', sa.String(length=100), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('roles',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('settings',
    sa.Column('setting', sa.String(length=100), nullable=False),
    sa.Column('value', sa.String(length=100), nullable=True),
    sa.PrimaryKeyConstraint('setting')
    )
    op.create_table('users',
    sa.Column('id', sa.String(length=10), nullable=False),
    sa.Column('username', sa.String(length=100), nullable=True),
    sa.Column('password', sa.String(length=128), nullable=True),
    sa.Column('admin_user', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('username')
    )
    op.create_table('product',
    sa.Column('barcode', sa.String(length=100), nullable=False),
    sa.Column('price', sa.Float(), nullable=True),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('description', sa.String(length=300), nullable=True),
    sa.Column('date', sa.String(length=100), nullable=True),
    sa.Column('in_stock', sa.Integer(), nullable=True),
    sa.Column('discontinued', sa.Boolean(), nullable=True),
    sa.Column('selling_price', sa.Float(), nullable=True),
    sa.Column('category_name', sa.String(length=100), nullable=False),
    sa.ForeignKeyConstraint(['category_name'], ['category.name'], ),
    sa.PrimaryKeyConstraint('barcode')
    )
    op.create_table('role_helpers',
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('role_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['role_id'], ['roles.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], )
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('role_helpers')
    op.drop_table('product')
    op.drop_table('users')
    op.drop_table('settings')
    op.drop_table('roles')
    op.drop_table('people')
    op.drop_table('category')
    op.drop_table('appointments')
    # ### end Alembic commands ###
