import { DockerImage, ILocalBundling } from 'aws-cdk-lib';
import { BuildOptions } from './esbuild-types';
import { IBuildProvider } from './provider';
/**
 * A path or list or map of paths to the entry points of your code.
 *
 * Relative paths are by default resolved from the current working directory.
 * To change the working directory, see `buildOptions.absWorkingDir`.
 *
 * Absolute paths can be used if files are part of the working directory.
 *
 * Examples:
 *  - `'src/index.ts'`
 *  - `require.resolve('./lambda')`
 *  - `['src/index.ts', 'src/util.ts']`
 *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
 *
 * @stability stable
 */
export declare type EntryPoints = string | string[] | Record<string, string>;
/**
 * @stability stable
 */
export interface BundlerProps {
    /**
     * Build options passed on to esbuild. Please refer to the esbuild Build API docs for details.
     *
     * * `buildOptions.outdir: string`
     * The actual path for the output directory is defined by CDK. However setting this option allows to write files into a subdirectory. \
     * For example `{ outdir: 'js' }` will create an asset with a single directory called `js`, which contains all built files. This approach can be useful for static website deployments, where JavaScript code should be placed into a subdirectory. \
     * *Cannot be used together with `outfile`*.
     * * `buildOptions.outfile: string`
     * Relative path to a file inside the CDK asset output directory.
     * For example `{ outfile: 'js/index.js' }` will create an asset with a single directory called `js`, which contains a single file `index.js`. This can be useful to rename the entry point. \
     * *Cannot be used with multiple entryPoints or together with `outdir`.*
     * * `buildOptions.absWorkingDir: string`
     * Absolute path to the [esbuild working directory](https://esbuild.github.io/api/#working-directory) and defaults to the [current working directory](https://en.wikipedia.org/wiki/Working_directory). \
     * If paths cannot be found, a good starting point is to look at the concatenation of `absWorkingDir + entryPoint`. It must always be a valid absolute path pointing to the entry point. When needed, the probably easiest way to set absWorkingDir is to use a combination of `resolve` and `__dirname` (see "Library authors" section in the documentation).
     *
     * @see https://esbuild.github.io/api/#build-api
     * @stability stable
     */
    readonly buildOptions?: BuildOptions;
    /**
     * The esbuild Build API implementation to be used.
     *
     * Configure the default `EsbuildProvider` for more options or
     * provide a custom `IBuildProvider` as an escape hatch.
     *
     * @stability stable
     *
     * @default new EsbuildProvider()
     */
    readonly buildProvider?: IBuildProvider;
    /**
     * Copy additional files to the code [asset staging directory](https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.AssetStaging.html#absolutestagedpath), before the build runs.
     * Files copied like this will be overwritten by esbuild if they share the same name as any of the outputs.
     *
     * * When provided with a `string` or `array`, all files are copied to the root of asset staging directory.
     * * When given a `map`, the key indicates the destination relative to the asset staging directory and the value is a list of all sources to be copied.
     *
     * Therefore the following values for `copyDir` are all equivalent:
     * ```
     * { copyDir: "path/to/source" }
     * { copyDir: ["path/to/source"] }
     * { copyDir: { ".": "path/to/source" } }
     * { copyDir: { ".": ["path/to/source"] } }
     * ```
     * The destination cannot be outside of the asset staging directory.
     * If you are receiving the error "Cannot copy files to outside of the asset staging directory."
     * you are likely using `..` or an absolute path as key on the `copyDir` map.
     * Instead use only relative paths and avoid `..`.
     *
     * @stability stable
     */
    readonly copyDir?: string | string[] | Record<string, string | string[]>;
}
/**
 * Low-level construct that can be used where `BundlingOptions` are required.
 * This class directly interfaces with esbuild and provides almost no configuration safeguards.
 *
 * @stability experimental
 */
export declare class EsbuildBundler {
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability experimental
     */
    readonly entryPoints: EntryPoints;
    /**
     * Props to change the behavior of the bundler.
     *
     * @stability experimental
     */
    readonly props: BundlerProps;
    /**
     * Implementation of `ILocalBundling` interface, responsible for calling esbuild functions.
     *
     * @stability experimental
     */
    readonly local: ILocalBundling;
    /**
     * @deprecated This value is ignored since the bundler is always using a locally installed version of esbuild. However the property is required to comply with the `BundlingOptions` interface.
     *
     * @stability deprecated
     */
    readonly image: DockerImage;
    /**
     * @stability experimental
     */
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability experimental
     */
    entryPoints: EntryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * @stability experimental
     */
    props: BundlerProps);
    private getCopyDirList;
    private getOutputOptions;
}
