import { CfnResource } from 'aws-cdk-lib';
import { ResourceBindOptions, Code, CodeConfig } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { EsbuildAsset, AssetBaseProps, AssetProps } from './asset';
import { EntryPoints } from './bundler';
export { CodeConfig } from 'aws-cdk-lib/aws-lambda';
export interface JavaScriptCodeProps extends AssetBaseProps {
}
export interface TypeScriptCodeProps extends AssetBaseProps {
}
/**
 * Represents a generic esbuild code bundle.
 *
 * You should always use `TypeScriptCode` or `JavaScriptCode`.
 *
 * @stability experimental
 */
export declare class EsbuildCode<Props extends JavaScriptCodeProps | TypeScriptCodeProps> extends Code {
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    readonly entryPoints: EntryPoints;
    protected getAsset(scope: Construct): EsbuildAsset<AssetProps>;
    protected props: AssetProps;
    protected asset: EsbuildAsset<AssetProps>;
    /**
     * Determines whether this Code is inline code or not.
     *
     * @deprecated this value is ignored since inline is now determined based on the the inlineCode field of CodeConfig returned from bind().
     */
    isInline: boolean;
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints: EntryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * Default values for `props.buildOptions`:
     * - `bundle=true`
     * - `platform=node`
     * - `target=nodeX` with X being the major node version running locally
     *
     * @stability stable
     */
    props: Props);
    bind(scope: Construct): CodeConfig;
    /**
     * Called after the CFN function resource has been created to allow the code class to bind to it.
     *
     * Specifically it's required to allow assets to add
     * metadata for tooling like SAM CLI to be able to find their origins.
     *
     * @stability stable
     */
    bindToResource(resource: CfnResource, options?: ResourceBindOptions): void;
}
/**
 * Represents the deployed JavaScript Code.
 *
 * @stability stable
 */
export declare class JavaScriptCode extends EsbuildCode<JavaScriptCodeProps> {
    protected getAsset(scope: Construct): EsbuildAsset<AssetProps>;
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints: EntryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * Default values for `props.buildOptions`:
     * - `bundle=true`
     * - `platform=node`
     * - `target=nodeX` with X being the major node version running locally
     *
     * @stability stable
     */
    props?: JavaScriptCodeProps);
}
/**
 * Represents the deployed TypeScript Code.
 *
 * @stability stable
 */
export declare class TypeScriptCode extends EsbuildCode<TypeScriptCodeProps> {
    protected getAsset(scope: Construct): EsbuildAsset<AssetProps>;
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints: EntryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * Default values for `props.buildOptions`:
     * - `bundle=true`
     * - `platform=node`
     * - `target=nodeX` with X being the major node version running locally
     *
     * @stability stable
     */
    props?: TypeScriptCodeProps);
}
