"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeScriptCode = exports.JavaScriptCode = exports.EsbuildCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const asset_1 = require("./asset");
const utils_1 = require("./private/utils");
;
;
/**
 * Represents a generic esbuild code bundle.
 *
 * You should always use `TypeScriptCode` or `JavaScriptCode`.
 *
 * @stability experimental
 */
class EsbuildCode extends aws_lambda_1.Code {
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * Default values for `props.buildOptions`:
     * - `bundle=true`
     * - `platform=node`
     * - `target=nodeX` with X being the major node version running locally
     *
     * @stability stable
     */
    props) {
        super();
        this.entryPoints = entryPoints;
        /**
         * Determines whether this Code is inline code or not.
         *
         * @deprecated this value is ignored since inline is now determined based on the the inlineCode field of CodeConfig returned from bind().
         */
        this.isInline = false;
        const defaultOptions = utils_1.defaultPlatformProps(props.buildOptions);
        this.props = {
            ...props,
            entryPoints,
            buildOptions: {
                ...defaultOptions,
                ...props.buildOptions,
            },
        };
    }
    getAsset(scope) {
        return new asset_1.EsbuildAsset(scope, this.constructor.name, this.props);
    }
    bind(scope) {
        // If the same AssetCode is used multiple times, retain only the first instantiation.
        if (!this.asset) {
            this.asset = this.getAsset(scope);
        }
        else if (aws_cdk_lib_1.Stack.of(this.asset) !== aws_cdk_lib_1.Stack.of(scope)) {
            throw new Error(`Asset is already associated with another stack '${aws_cdk_lib_1.Stack.of(this.asset).stackName}'. ` + 'Create a new Asset instance for every stack.');
        }
        return {
            s3Location: {
                bucketName: this.asset.s3BucketName,
                objectKey: this.asset.s3ObjectKey,
            },
        };
    }
    /**
     * Called after the CFN function resource has been created to allow the code class to bind to it.
     *
     * Specifically it's required to allow assets to add
     * metadata for tooling like SAM CLI to be able to find their origins.
     *
     * @stability stable
     */
    bindToResource(resource, options) {
        if (!this.asset) {
            throw new Error('bindToResource() must be called after bind()');
        }
        const resourceProperty = options?.resourceProperty || this.constructor.name;
        // https://github.com/aws/aws-cdk/issues/1432
        this.asset.addResourceMetadata(resource, resourceProperty);
    }
}
exports.EsbuildCode = EsbuildCode;
_a = JSII_RTTI_SYMBOL_1;
EsbuildCode[_a] = { fqn: "@mrgrain/cdk-esbuild.EsbuildCode", version: "4.1.0" };
/**
 * Represents the deployed JavaScript Code.
 *
 * @stability stable
 */
class JavaScriptCode extends EsbuildCode {
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * Default values for `props.buildOptions`:
     * - `bundle=true`
     * - `platform=node`
     * - `target=nodeX` with X being the major node version running locally
     *
     * @stability stable
     */
    props = {}) {
        super(entryPoints, props);
    }
    getAsset(scope) {
        return new asset_1.JavaScriptAsset(scope, this.constructor.name, this.props);
    }
}
exports.JavaScriptCode = JavaScriptCode;
_b = JSII_RTTI_SYMBOL_1;
JavaScriptCode[_b] = { fqn: "@mrgrain/cdk-esbuild.JavaScriptCode", version: "4.1.0" };
/**
 * Represents the deployed TypeScript Code.
 *
 * @stability stable
 */
class TypeScriptCode extends EsbuildCode {
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * Default values for `props.buildOptions`:
     * - `bundle=true`
     * - `platform=node`
     * - `target=nodeX` with X being the major node version running locally
     *
     * @stability stable
     */
    props = {}) {
        super(entryPoints, props);
    }
    getAsset(scope) {
        return new asset_1.TypeScriptAsset(scope, this.constructor.name, this.props);
    }
}
exports.TypeScriptCode = TypeScriptCode;
_c = JSII_RTTI_SYMBOL_1;
TypeScriptCode[_c] = { fqn: "@mrgrain/cdk-esbuild.TypeScriptCode", version: "4.1.0" };
//# sourceMappingURL=data:application/json;base64,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