import { CodeConfig, InlineCode } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { TransformOptions } from './esbuild-types';
import { ITransformProvider } from './provider';
/**
 * @stability stable
 */
export interface TransformerProps {
    /**
     * Transform options passed on to esbuild. Please refer to the esbuild Transform API docs for details.
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability stable
     */
    readonly transformOptions?: TransformOptions;
    /**
     * The esbuild Transform API implementation to be used.
     *
     * Configure the default `EsbuildProvider` for more options or
     * provide a custom `ITransformProvider` as an escape hatch.
     *
     * @stability stable
     *
     * @default new DefaultEsbuildProvider()
     */
    readonly transformProvider?: ITransformProvider;
}
declare abstract class BaseInlineCode extends InlineCode {
    readonly isInline = true;
    private readonly inlineCode;
    constructor(code: string, props: TransformerProps);
    bind(scope: Construct): CodeConfig;
}
/**
 * An implementation of `lambda.InlineCode` using the esbuild Transform API. Inline function code is limited to 4 KiB after transformation.
 *
 * @stability stable
 */
export declare class InlineJavaScriptCode extends BaseInlineCode {
    constructor(
    /**
     * The inline code to be transformed.
     *
     * @stability stable
     */
    code: string, 
    /**
     * Props to change the behavior of the transformer.
     *
     * Default values for `props.transformOptions`:
     * - `loader='js'`
     * - `platform=node`
     * - `target=nodeX` with X being the major node version running locally
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability stable
     */
    props?: TransformerProps);
}
/**
 * An implementation of `lambda.InlineCode` using the esbuild Transform API. Inline function code is limited to 4 KiB after transformation.
 *
 * @stability stable
 */
export declare class InlineTypeScriptCode extends BaseInlineCode {
    constructor(
    /**
     * The inline code to be transformed.
     *
     * @stability stable
     */
    code: string, 
    /**
     * Props to change the behavior of the transformer.
     *
     * Default values for `transformOptions`:
     * - `loader='ts'`
     * - `platform=node`
     * - `target=nodeX` with X being the major node version running locally
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability stable
     */
    props?: TransformerProps);
}
export {};
