"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InlineTypeScriptCode = exports.InlineJavaScriptCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const utils_1 = require("./private/utils");
const provider_1 = require("./provider");
class BaseInlineCode extends aws_lambda_1.InlineCode {
    constructor(code, props) {
        super(code);
        this.isInline = true;
        this.inlineCode = aws_cdk_lib_1.Lazy.string({
            produce: () => {
                try {
                    const provider = props.transformProvider ?? provider_1.EsbuildProvider.defaultTransformationProvider();
                    const transformedCode = provider.transformSync(code, {
                        color: process.env.NO_COLOR ? Boolean(process.env.NO_COLOR) : undefined,
                        logLevel: 'warning',
                        ...(props.transformOptions || {}),
                    });
                    return transformedCode;
                }
                catch (error) {
                    if (utils_1.isEsbuildError(error)) {
                        throw new Error(`Esbuild failed to transform ${this.constructor.name}`);
                    }
                    throw error;
                }
            },
        });
    }
    bind(scope) {
        const name = scope.node.path + constructs_1.Node.PATH_SEP + this.constructor.name;
        process.stderr.write(`Transforming inline code ${name}...\n`);
        return {
            inlineCode: aws_cdk_lib_1.Stack.of(scope).resolve(this.inlineCode),
        };
    }
}
function transformerProps(loader, props = {}) {
    return {
        ...props,
        transformOptions: {
            loader,
            format: 'cjs',
            ...utils_1.defaultPlatformProps(props.transformOptions),
            ...props.transformOptions,
        },
    };
}
/**
 * An implementation of `lambda.InlineCode` using the esbuild Transform API. Inline function code is limited to 4 KiB after transformation.
 *
 * @stability stable
 */
class InlineJavaScriptCode extends BaseInlineCode {
    constructor(
    /**
     * The inline code to be transformed.
     *
     * @stability stable
     */
    code, 
    /**
     * Props to change the behavior of the transformer.
     *
     * Default values for `props.transformOptions`:
     * - `loader='js'`
     * - `platform=node`
     * - `target=nodeX` with X being the major node version running locally
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability stable
     */
    props) {
        super(code, transformerProps('js', props));
    }
}
exports.InlineJavaScriptCode = InlineJavaScriptCode;
_a = JSII_RTTI_SYMBOL_1;
InlineJavaScriptCode[_a] = { fqn: "@mrgrain/cdk-esbuild.InlineJavaScriptCode", version: "4.1.0" };
/**
 * An implementation of `lambda.InlineCode` using the esbuild Transform API. Inline function code is limited to 4 KiB after transformation.
 *
 * @stability stable
 */
class InlineTypeScriptCode extends BaseInlineCode {
    constructor(
    /**
     * The inline code to be transformed.
     *
     * @stability stable
     */
    code, 
    /**
     * Props to change the behavior of the transformer.
     *
     * Default values for `transformOptions`:
     * - `loader='ts'`
     * - `platform=node`
     * - `target=nodeX` with X being the major node version running locally
     *
     * @see https://esbuild.github.io/api/#transform-api
     * @stability stable
     */
    props) {
        super(code, transformerProps('ts', props));
    }
}
exports.InlineTypeScriptCode = InlineTypeScriptCode;
_b = JSII_RTTI_SYMBOL_1;
InlineTypeScriptCode[_b] = { fqn: "@mrgrain/cdk-esbuild.InlineTypeScriptCode", version: "4.1.0" };
//# sourceMappingURL=data:application/json;base64,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