export declare const Esbuild: {
    name: string;
    version: string | undefined;
    spec: string;
};
export declare class EsbuildSource {
    private static dynamicPackage;
    private constructor();
    /**
     * `EsbuildSource.nodeJs()` for NodeJs, `EsbuildSource.auto()` for all other languages
     */
    static platformDefault(): string;
    /**
     * Try to find the module in most common paths.
     */
    static anywhere(): string | undefined;
    /**
     * Try to find the module in common global installation paths.
     */
    static globalPaths(): string | undefined;
    /**
     * Require module by name, do not attempt to find it anywhere else.
     */
    static nodeJs(): string;
    /**
     * Install the module to a temporary location.
     */
    static install(): string;
    /**
     * First try to find to module, then install it to a temporary location.
     */
    static auto(): string;
}
