"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EsbuildSource = exports.Esbuild = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const dynamic_package_1 = require("./dynamic-package");
const dynamicEsbuild = new dynamic_package_1.DynamicPackage('esbuild@^0.17.0');
exports.Esbuild = {
    name: dynamicEsbuild.name,
    version: dynamicEsbuild.version,
    spec: dynamicEsbuild.spec,
};
class EsbuildSource {
    constructor() { }
    /**
     * `EsbuildSource.nodeJs()` for NodeJs, `EsbuildSource.auto()` for all other languages
     */
    static platformDefault() {
        if (Boolean(process.env.JSII_AGENT)) {
            return this.auto();
        }
        return this.nodeJs();
    }
    /**
     * Try to find the module in most common paths.
     */
    static anywhere() {
        return this.dynamicPackage.findInPaths();
    }
    /**
     * Try to find the module in common global installation paths.
     */
    static globalPaths() {
        return this.dynamicPackage.findInGlobalPaths();
    }
    /**
     * Require module by name, do not attempt to find it anywhere else.
     */
    static nodeJs() {
        return this.dynamicPackage.nodeJs();
    }
    /**
     * Install the module to a temporary location.
     */
    static install() {
        return this.dynamicPackage.install();
    }
    /**
     * First try to find to module, then install it to a temporary location.
     */
    static auto() {
        return this.dynamicPackage.auto();
    }
}
exports.EsbuildSource = EsbuildSource;
_a = JSII_RTTI_SYMBOL_1;
EsbuildSource[_a] = { fqn: "@mrgrain/cdk-esbuild.EsbuildSource", version: "4.1.0" };
EsbuildSource.dynamicPackage = dynamicEsbuild;
//# sourceMappingURL=data:application/json;base64,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