"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultPlatformProps = exports.nodeMajorVersion = exports.isEsbuildError = void 0;
function isEsbuildError(error) {
    return !!error
        && typeof error == 'object'
        && error != null
        && 'errors' in error
        && 'warnings' in error;
}
exports.isEsbuildError = isEsbuildError;
function nodeMajorVersion() {
    return parseInt(process.versions.node.split('.')[0], 10);
}
exports.nodeMajorVersion = nodeMajorVersion;
function defaultPlatformProps(options) {
    if (!options?.platform || options?.platform === 'node') {
        return { platform: 'node', target: 'node' + nodeMajorVersion() };
    }
    return {};
}
exports.defaultPlatformProps = defaultPlatformProps;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvcHJpdmF0ZS91dGlscy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFFQSxTQUFnQixjQUFjLENBQUMsS0FBYztJQUMzQyxPQUFPLENBQUMsQ0FBQyxLQUFLO1dBQ1gsT0FBTyxLQUFLLElBQUksUUFBUTtXQUN4QixLQUFLLElBQUksSUFBSTtXQUNiLFFBQVEsSUFBSSxLQUFLO1dBQ2pCLFVBQVUsSUFBSSxLQUFLLENBQUM7QUFDekIsQ0FBQztBQU5ELHdDQU1DO0FBRUQsU0FBZ0IsZ0JBQWdCO0lBQzlCLE9BQU8sUUFBUSxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztBQUMzRCxDQUFDO0FBRkQsNENBRUM7QUFFRCxTQUFnQixvQkFBb0IsQ0FBQyxPQUF5QztJQUk1RSxJQUFJLENBQUMsT0FBTyxFQUFFLFFBQVEsSUFBSSxPQUFPLEVBQUUsUUFBUSxLQUFLLE1BQU0sRUFBRTtRQUN0RCxPQUFPLEVBQUUsUUFBUSxFQUFFLE1BQU0sRUFBRSxNQUFNLEVBQUUsTUFBTSxHQUFHLGdCQUFnQixFQUFFLEVBQUUsQ0FBQztLQUNsRTtJQUVELE9BQU8sRUFBRSxDQUFDO0FBQ1osQ0FBQztBQVRELG9EQVNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQnVpbGRPcHRpb25zLCBQbGF0Zm9ybSwgVHJhbnNmb3JtT3B0aW9ucyB9IGZyb20gJy4uL2VzYnVpbGQtdHlwZXMnO1xuXG5leHBvcnQgZnVuY3Rpb24gaXNFc2J1aWxkRXJyb3IoZXJyb3I6IHVua25vd24pOiBib29sZWFuIHtcbiAgcmV0dXJuICEhZXJyb3JcbiAgJiYgdHlwZW9mIGVycm9yID09ICdvYmplY3QnXG4gICYmIGVycm9yICE9IG51bGxcbiAgJiYgJ2Vycm9ycycgaW4gZXJyb3JcbiAgJiYgJ3dhcm5pbmdzJyBpbiBlcnJvcjtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIG5vZGVNYWpvclZlcnNpb24oKTogbnVtYmVyIHtcbiAgcmV0dXJuIHBhcnNlSW50KHByb2Nlc3MudmVyc2lvbnMubm9kZS5zcGxpdCgnLicpWzBdLCAxMCk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBkZWZhdWx0UGxhdGZvcm1Qcm9wcyhvcHRpb25zPzogQnVpbGRPcHRpb25zIHwgVHJhbnNmb3JtT3B0aW9ucyk6IHtcbiAgcGxhdGZvcm0/OiBQbGF0Zm9ybTtcbiAgdGFyZ2V0Pzogc3RyaW5nIHwgc3RyaW5nW107XG59IHtcbiAgaWYgKCFvcHRpb25zPy5wbGF0Zm9ybSB8fCBvcHRpb25zPy5wbGF0Zm9ybSA9PT0gJ25vZGUnKSB7XG4gICAgcmV0dXJuIHsgcGxhdGZvcm06ICdub2RlJywgdGFyZ2V0OiAnbm9kZScgKyBub2RlTWFqb3JWZXJzaW9uKCkgfTtcbiAgfVxuXG4gIHJldHVybiB7fTtcbn1cbiJdfQ==