"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EsbuildProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const esbuild_source_1 = require("./private/esbuild-source");
var esbuild_source_2 = require("./private/esbuild-source");
Object.defineProperty(exports, "EsbuildSource", { enumerable: true, get: function () { return esbuild_source_2.EsbuildSource; } });
/**
 * Default esbuild implementation calling esbuild's JavaScript API.
 */
class EsbuildProvider {
    constructor(props = {}) {
        this.esbuildBinaryPath = props.esbuildBinaryPath;
        this.esbuildModulePath = props.esbuildModulePath;
    }
    /**
     * Set the default implementation for both Build and Transformation API
     */
    static overrideDefaultProvider(provider) {
        this.overrideDefaultBuildProvider(provider);
        this.overrideDefaultTransformationProvider(provider);
    }
    /**
     * Set the default implementation for the Build API
     */
    static overrideDefaultBuildProvider(provider) {
        this._buildProvider = provider;
    }
    /**
     * Get the default implementation for the Build API
     */
    static defaultBuildProvider() {
        return this._buildProvider ?? this._fallbackProvider;
    }
    /**
     * Set the default implementation for the Transformation API
     */
    static overrideDefaultTransformationProvider(provider) {
        this._transformationProvider = provider;
    }
    /**
     * Get the default implementation for the Transformation API
     */
    static defaultTransformationProvider() {
        return this._transformationProvider ?? this._fallbackProvider;
    }
    buildSync(options) {
        const esbuild = this.require(this.esbuildModulePath);
        const buildFn = this.withEsbuildBinaryPath(esbuild.buildSync, this.esbuildBinaryPath);
        buildFn(options);
    }
    transformSync(input, options) {
        const esbuild = this.require(this.esbuildModulePath);
        const transformFn = this.withEsbuildBinaryPath(esbuild.transformSync, this.esbuildBinaryPath);
        return transformFn(input, options).code;
    }
    /**
     * Invoke a function with a specific `process.env.ESBUILD_BINARY_PATH`
     * and restore the env var afterwards.
     */
    withEsbuildBinaryPath(fn, esbuildBinaryPath) {
        if (!esbuildBinaryPath) {
            return fn;
        }
        return (...args) => {
            const originalEsbuildBinaryPath = process.env.ESBUILD_BINARY_PATH;
            if (esbuildBinaryPath) {
                process.env.ESBUILD_BINARY_PATH = esbuildBinaryPath;
            }
            const result = fn(...args);
            /**
             * only reset `ESBUILD_BINARY_PATH` if it was explicitly set via the construct props
             * since `esbuild` itself sometimes sets it (eg. when running in yarn 2 plug&play)
             */
            if (esbuildBinaryPath) {
                process.env.ESBUILD_BINARY_PATH = originalEsbuildBinaryPath;
            }
            return result;
        };
    }
    /**
     * Load the esbuild module according to defined rules.
     */
    require(path) {
        const module = path || process.env.CDK_ESBUILD_MODULE_PATH || esbuild_source_1.EsbuildSource.platformDefault() || esbuild_source_1.Esbuild.name;
        return this._require(this.resolve(module));
    }
    /**
     * Wrapper for require
     */
    _require(path) {
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        return require(path);
    }
    /**
     * Resolve a token without context
     */
    resolve(token) {
        if (!aws_cdk_lib_1.Token.isUnresolved(token)) {
            return token;
        }
        return aws_cdk_lib_1.Tokenization.resolve(token, {
            scope: new constructs_1.Construct(undefined, ''),
            resolver: new aws_cdk_lib_1.DefaultTokenResolver(new aws_cdk_lib_1.StringConcat()),
        });
    }
}
exports.EsbuildProvider = EsbuildProvider;
_a = JSII_RTTI_SYMBOL_1;
EsbuildProvider[_a] = { fqn: "@mrgrain/cdk-esbuild.EsbuildProvider", version: "4.1.0" };
EsbuildProvider._fallbackProvider = new EsbuildProvider();
//# sourceMappingURL=data:application/json;base64,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