# Netbox Network Importer

Tool to analyze and synchronize an existing network with a Netbox (SOT).

The main use cases for the network importer: 
 - Import an existing network into a Netbox
 - ~~Check the differences between the running network and the Netbox~~

---
## Install
1. Clone repository
   - `git clone git@gitlab.cesnet.cz:701/done/netbox_network_importer.git`
2. Go into the repository
   - `cd netbox_network_importer `
3. Create `virtualenv`
   - `python3 -m venv venv`
3. Activate it
   - `source venv/bin/activate`
3. Install the tool
   - `pip install .`
---
## Pre-requisite
To operate, the Netbox Network Importer is dependent on the following items:
- Access to Netbox API
- Access to Network Devices via SSH
- Created Custom Field on Netbox
```json
   {
    "display": "Ignore Importer",
    "content_types": [
        "dcim.interface",
    ],
    "type": {
        "value": "boolean",
        "label": "Boolean (true/false)"
    },
    "object_type": null,
    "data_type": "boolean",
    "name": "ignore_importer",
    "label": "Ignore Importer",
    "description": "Will be ignored when processed by Network Importer",
    "required": true,
    "filter_logic": {
        "value": "exact",
        "label": "Exact"
    },
    "default": false,
    "weight": 100,
   }
```
---
## Inventory
A device inventory must be available in NetBox. 

To be able to connect to the device the following information needs to be defined :
- Primary ip address
- Platform (must be a one of the following ['iosxr', 'ios', 'iosxe'])
---
## Configuration file
The information to connect to NetBox must be provided via the configuration file. The configuration file below present standard options that can be provided to control the behavior of the Netbox Network Importer.

Netbox Network Importer try to find the configuration file at:
- `/home/<user>/.config/netbox_network_importer/config.yml` 
- `/etc/netbox_network_importer/config.yml`
- Or you can set path to configuratin file like:
   - `netbox_network_importer --config path_to_dir_with_config/ synchronize`
```
---
netbox:
  NETBOX_API_TOKEN: "API_TOKEN"
  NETBOX_INSTANCE_URL: "https://netbox.done-test.cesnet.cz/"
  NETBOX_GRAPHQL_URL: "https://netbox.done-test.cesnet.cz/graphql/"
tacacs:
  TACACS_USERNAME: "username"
  TACACS_PASSWORD: "password"

config:
  LOG_DIR: "path_where_output.log_will_be_stored"
  LOG_LEVEL: "DEBUG"
  OUTPUT_DIR: "output_folder_where_results_will_be_stored"
```
---
## Execute
The Netbox Network Importer runs only in apply mode.
- ~~In check mode, no modification will be made to the SOT, the differences will be printed on the screen~~
- In apply mode, the NETBOX will be updated with:
   - interfaces
   - IPs
   - vlans 
   - LAGs

### Apply Mode
The Netbox Network Importer will attempt to create/update or delete all elements in the Netbox that do not match what has been observed in the network.
It will ignore devices or interfaces on certain circumstances:
- Device `status` must be `Active`, otherwise the device is skipped
- Device `primary_ip` must be properly set, otherwise the device is skipped
- Device `platform` must include one of the following values `[ios, iosxr, iosxe]`, otherwise the device is skipped
- If interface has attribute `Ignore Importer` set to `True`, then the processing on the Interface will be skipped and ignored

**Execution**:
- `netbox_network_importer synchronize` # runs the importer
- `netbox_network_importer synchronize -d Rxx` # runs importer on device Rxx from Netbox
- `netbox_network_importer synchronize -p iosxe` # runs importer on all devices with platform iosxe
- `netbox_network_importer synchronize -d Rxx -d Ryy` # runs importer on devices Rxx and Ryy
---

### Help
```
~/netbox_network_importer$ netbox_network_importer --help
Usage: netbox_network_importer [OPTIONS] COMMAND [ARGS]...

Options:
  -c, --configs PATH  path to folder with configurations
  --help              Show this message and exit.

Commands:
  pyats        Connect to device using pyats and pynetbox and print...
  synchronize  Run set of Nornir task to update data in Netbox from...

~/NETBOX/netbox_network_importer$ netbox_network_importer synchronize --help
Usage: netbox_network_importer synchronize [OPTIONS]

  Run set of Nornir task to update data in Netbox from network devices

  Args:     devices (str): device name filter, can be used multiple times
  platforms (str): platform name filter, can be used multiple times
  no_progress_bar (bool): use to hide progress bar Returns:     dict:
  Dictionary of hosts, it's actions and results

Options:
  -d, --devices TEXT    Run on specificied devices
  -p, --platforms TEXT  Run on specificied platforms
  --no-progress-bar
  --help                Show this message and exit.```
---
