from data_profiler.expectations.expectation import MulticolumnMapExpectation
from data_profiler.expectations.util import render_evaluation_parameter_string
from data_profiler.render.renderer.renderer import renderer
from data_profiler.render.types import (
    RenderedStringTemplateContent,
    RenderedTableContent,
)
from data_profiler.render.util import num_to_str, substitute_none_for_missing


class ExpectMulticolumnSumToEqual(MulticolumnMapExpectation):
    """
    Expects that the sum of row values is the same for each row, summing only values in columns specified in
    column_list, and equal to the specific value, sum_total.

    Args:
        column_list (tuple or list): Set of columns to be checked
        sum_total (int): \
            expected sum of columns

    Keyword Args:
        ignore_row_if (str): "all_values_are_missing", "any_value_is_missing", "never"

    Other Parameters:
        result_format (str or None): \
            Which output mode to use: `BOOLEAN_ONLY`, `BASIC`, `COMPLETE`, or `SUMMARY`.
        include_config (boolean): \
            If True, then include the expectation config as part of the result object. \
        catch_exceptions (boolean or None): \
            If True, then catch exceptions and include them as part of the result object. \
        meta (dict or None): \
            A JSON-serializable dictionary (nesting allowed) that will be included in the output without modification.

    Returns:
        An ExpectationSuiteValidationResult
    """

    # This dictionary contains metadata for display in the public gallery
    library_metadata = {
        "maturity": "production",
        "package": "data_profiler",
        "tags": [
            "core expectation",
            "column aggregate expectation",
            "needs migration to modular expectations api",
        ],
        "contributors": ["@data_profiler"],
        "requirements": [],
    }

    map_metric = "multicolumn_sum.equal"
    success_keys = ("sum_total",)
    default_kwarg_values = {
        "row_condition": None,
        "condition_parser": None,  # we expect this to be explicitly set whenever a row_condition is passed
        "ignore_row_if": "all_values_are_missing",
        "result_format": "BASIC",
        "include_config": True,
        "catch_exceptions": False,
    }

    @classmethod
    @renderer(renderer_type="renderer.prescriptive")
    @render_evaluation_parameter_string
    def _prescriptive_renderer(
        cls,
        configuration=None,
        result=None,
        language=None,
        runtime_configuration=None,
        **kwargs,
    ):
        pass

    @classmethod
    @renderer(renderer_type="renderer.diagnostic.observed_value")
    def _diagnostic_observed_value_renderer(
        cls,
        configuration=None,
        result=None,
        language=None,
        runtime_configuration=None,
        **kwargs,
    ):
        pass
