# mypy-boto3-ce

[![PyPI - mypy-boto3-ce](https://img.shields.io/pypi/v/mypy-boto3-ce.svg?color=blue)](https://pypi.org/project/mypy-boto3-ce)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ce.svg?color=blue)](https://pypi.org/project/mypy-boto3-ce)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CostExplorer 1.16.20](https://boto3.amazonaws.com/v1/documentation/api/1.16.20/reference/services/ce.html#CostExplorer) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-ce](#mypy-boto3-ce)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `CostExplorer` service.

```bash
python -m pip install boto3-stubs[ce]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ce]` in your environment: `python -m pip install 'boto3-stubs[ce]'`

Both type checking and auto-complete should work for `CostExplorer` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[ce]` in your environment: `python -m pip install 'boto3-stubs[ce]'`

Both type checking and auto-complete should work for `CostExplorer` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ce]` in your environment: `python -m pip install 'boto3-stubs[ce]'`
- Run `mypy` as usual

Type checking should work for `CostExplorer` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ce]` in your environment: `python -m pip install 'boto3-stubs[ce]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CostExplorer` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`CostExplorerClient` provides annotations for `boto3.client("ce")`.

```python
import boto3

from mypy_boto3_ce import CostExplorerClient

client: CostExplorerClient = boto3.client("ce")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CostExplorerClient = session.client("ce")
```








### Typed dictionations

`mypy_boto3_ce.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_ce.type_defs import (
    AnomalyDateIntervalTypeDef,
    AnomalyMonitorTypeDef,
    AnomalyScoreTypeDef,
    AnomalySubscriptionTypeDef,
    AnomalyTypeDef,
    CostCategoryProcessingStatusTypeDef,
    CostCategoryReferenceTypeDef,
    CostCategoryRuleTypeDef,
    CostCategoryTypeDef,
    CostCategoryValuesTypeDef,
    CoverageByTimeTypeDef,
    CoverageCostTypeDef,
    CoverageHoursTypeDef,
    CoverageNormalizedUnitsTypeDef,
    CoverageTypeDef,
    CreateAnomalyMonitorResponseTypeDef,
    CreateAnomalySubscriptionResponseTypeDef,
    CreateCostCategoryDefinitionResponseTypeDef,
    CurrentInstanceTypeDef,
    DateIntervalTypeDef,
    DeleteCostCategoryDefinitionResponseTypeDef,
    DescribeCostCategoryDefinitionResponseTypeDef,
    DimensionValuesTypeDef,
    DimensionValuesWithAttributesTypeDef,
    EBSResourceUtilizationTypeDef,
    EC2InstanceDetailsTypeDef,
    EC2ResourceDetailsTypeDef,
    EC2ResourceUtilizationTypeDef,
    EC2SpecificationTypeDef,
    ElastiCacheInstanceDetailsTypeDef,
    ESInstanceDetailsTypeDef,
    ExpressionTypeDef,
    ForecastResultTypeDef,
    GetAnomaliesResponseTypeDef,
    GetAnomalyMonitorsResponseTypeDef,
    GetAnomalySubscriptionsResponseTypeDef,
    GetCostAndUsageResponseTypeDef,
    GetCostAndUsageWithResourcesResponseTypeDef,
    GetCostForecastResponseTypeDef,
    GetDimensionValuesResponseTypeDef,
    GetReservationCoverageResponseTypeDef,
    GetReservationPurchaseRecommendationResponseTypeDef,
    GetReservationUtilizationResponseTypeDef,
    GetRightsizingRecommendationResponseTypeDef,
    GetSavingsPlansCoverageResponseTypeDef,
    GetSavingsPlansPurchaseRecommendationResponseTypeDef,
    GetSavingsPlansUtilizationDetailsResponseTypeDef,
    GetSavingsPlansUtilizationResponseTypeDef,
    GetTagsResponseTypeDef,
    GetUsageForecastResponseTypeDef,
    GroupDefinitionTypeDef,
    GroupTypeDef,
    ImpactTypeDef,
    InstanceDetailsTypeDef,
    ListCostCategoryDefinitionsResponseTypeDef,
    MetricValueTypeDef,
    ModifyRecommendationDetailTypeDef,
    ProvideAnomalyFeedbackResponseTypeDef,
    RDSInstanceDetailsTypeDef,
    RedshiftInstanceDetailsTypeDef,
    ReservationAggregatesTypeDef,
    ReservationCoverageGroupTypeDef,
    ReservationPurchaseRecommendationDetailTypeDef,
    ReservationPurchaseRecommendationMetadataTypeDef,
    ReservationPurchaseRecommendationSummaryTypeDef,
    ReservationPurchaseRecommendationTypeDef,
    ReservationUtilizationGroupTypeDef,
    ResourceDetailsTypeDef,
    ResourceUtilizationTypeDef,
    ResultByTimeTypeDef,
    RightsizingRecommendationConfigurationTypeDef,
    RightsizingRecommendationMetadataTypeDef,
    RightsizingRecommendationSummaryTypeDef,
    RightsizingRecommendationTypeDef,
    RootCauseTypeDef,
    SavingsPlansAmortizedCommitmentTypeDef,
    SavingsPlansCoverageDataTypeDef,
    SavingsPlansCoverageTypeDef,
    SavingsPlansDetailsTypeDef,
    SavingsPlansPurchaseRecommendationDetailTypeDef,
    SavingsPlansPurchaseRecommendationMetadataTypeDef,
    SavingsPlansPurchaseRecommendationSummaryTypeDef,
    SavingsPlansPurchaseRecommendationTypeDef,
    SavingsPlansSavingsTypeDef,
    SavingsPlansUtilizationAggregatesTypeDef,
    SavingsPlansUtilizationByTimeTypeDef,
    SavingsPlansUtilizationDetailTypeDef,
    SavingsPlansUtilizationTypeDef,
    ServiceSpecificationTypeDef,
    SubscriberTypeDef,
    TagValuesTypeDef,
    TargetInstanceTypeDef,
    TerminateRecommendationDetailTypeDef,
    TotalImpactFilterTypeDef,
    UpdateAnomalyMonitorResponseTypeDef,
    UpdateAnomalySubscriptionResponseTypeDef,
    UpdateCostCategoryDefinitionResponseTypeDef,
    UtilizationByTimeTypeDef,
)

def get_structure() -> AnomalyMonitorTypeDef:
    return {
      ...
    }
```
