import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * audit_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#audit_config DataGoogleIamPolicy#audit_config}
     *
     * @stability stable
     */
    readonly auditConfig?: DataGoogleIamPolicyAuditConfig[];
    /**
     * binding block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#binding DataGoogleIamPolicy#binding}
     *
     * @stability stable
     */
    readonly binding?: DataGoogleIamPolicyBinding[];
}
/**
 * @stability stable
 */
export interface DataGoogleIamPolicyAuditConfigAuditLogConfigs {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#exempted_members DataGoogleIamPolicy#exempted_members}.
     *
     * @stability stable
     */
    readonly exemptedMembers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#log_type DataGoogleIamPolicy#log_type}.
     *
     * @stability stable
     */
    readonly logType: string;
}
export declare function dataGoogleIamPolicyAuditConfigAuditLogConfigsToTerraform(struct?: DataGoogleIamPolicyAuditConfigAuditLogConfigs): any;
/**
 * @stability stable
 */
export interface DataGoogleIamPolicyAuditConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#service DataGoogleIamPolicy#service}.
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * audit_log_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#audit_log_configs DataGoogleIamPolicy#audit_log_configs}
     *
     * @stability stable
     */
    readonly auditLogConfigs: DataGoogleIamPolicyAuditConfigAuditLogConfigs[];
}
export declare function dataGoogleIamPolicyAuditConfigToTerraform(struct?: DataGoogleIamPolicyAuditConfig): any;
/**
 * @stability stable
 */
export interface DataGoogleIamPolicyBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#description DataGoogleIamPolicy#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#expression DataGoogleIamPolicy#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#title DataGoogleIamPolicy#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function dataGoogleIamPolicyBindingConditionToTerraform(struct?: DataGoogleIamPolicyBindingConditionOutputReference | DataGoogleIamPolicyBindingCondition): any;
/**
 * @stability stable
 */
export declare class DataGoogleIamPolicyBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataGoogleIamPolicyBindingCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataGoogleIamPolicyBindingCondition | undefined);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataGoogleIamPolicyBinding {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#members DataGoogleIamPolicy#members}.
     *
     * @stability stable
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#role DataGoogleIamPolicy#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html#condition DataGoogleIamPolicy#condition}
     *
     * @stability stable
     */
    readonly condition?: DataGoogleIamPolicyBindingCondition;
}
export declare function dataGoogleIamPolicyBindingToTerraform(struct?: DataGoogleIamPolicyBinding): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html google_iam_policy}.
 *
 * @stability stable
 */
export declare class DataGoogleIamPolicy extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/iam_policy.html google_iam_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGoogleIamPolicyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get policyData(): string;
    private _auditConfig?;
    /**
     * @stability stable
     */
    get auditConfig(): DataGoogleIamPolicyAuditConfig[];
    /**
     * @stability stable
     */
    set auditConfig(value: DataGoogleIamPolicyAuditConfig[]);
    /**
     * @stability stable
     */
    resetAuditConfig(): void;
    /**
     * @stability stable
     */
    get auditConfigInput(): DataGoogleIamPolicyAuditConfig[] | undefined;
    private _binding?;
    /**
     * @stability stable
     */
    get binding(): DataGoogleIamPolicyBinding[];
    /**
     * @stability stable
     */
    set binding(value: DataGoogleIamPolicyBinding[]);
    /**
     * @stability stable
     */
    resetBinding(): void;
    /**
     * @stability stable
     */
    get bindingInput(): DataGoogleIamPolicyBinding[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
