# `containerCluster` Submodule <a name="`containerCluster` Submodule" id="@cdktf/provider-google.containerCluster"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### ContainerCluster <a name="ContainerCluster" id="@cdktf/provider-google.containerCluster.ContainerCluster"></a>

Represents a {@link https://www.terraform.io/docs/providers/google/r/container_cluster google_container_cluster}.

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerCluster;

ContainerCluster.Builder.create(Construct scope, java.lang.String id)
//  .connection(SSHProvisionerConnection)
//  .connection(WinrmProvisionerConnection)
//  .count(java.lang.Number)
//  .dependsOn(java.util.List<ITerraformDependable>)
//  .forEach(ITerraformIterator)
//  .lifecycle(TerraformResourceLifecycle)
//  .provider(TerraformProvider)
//  .provisioners(java.util.List<FileProvisioner)
//  .provisioners(LocalExecProvisioner)
//  .provisioners(RemoteExecProvisioner>)
    .name(java.lang.String)
//  .addonsConfig(ContainerClusterAddonsConfig)
//  .authenticatorGroupsConfig(ContainerClusterAuthenticatorGroupsConfig)
//  .binaryAuthorization(ContainerClusterBinaryAuthorization)
//  .clusterAutoscaling(ContainerClusterClusterAutoscaling)
//  .clusterIpv4Cidr(java.lang.String)
//  .confidentialNodes(ContainerClusterConfidentialNodes)
//  .costManagementConfig(ContainerClusterCostManagementConfig)
//  .databaseEncryption(ContainerClusterDatabaseEncryption)
//  .datapathProvider(java.lang.String)
//  .defaultMaxPodsPerNode(java.lang.Number)
//  .defaultSnatStatus(ContainerClusterDefaultSnatStatus)
//  .description(java.lang.String)
//  .dnsConfig(ContainerClusterDnsConfig)
//  .enableAutopilot(java.lang.Boolean)
//  .enableAutopilot(IResolvable)
//  .enableBinaryAuthorization(java.lang.Boolean)
//  .enableBinaryAuthorization(IResolvable)
//  .enableIntranodeVisibility(java.lang.Boolean)
//  .enableIntranodeVisibility(IResolvable)
//  .enableKubernetesAlpha(java.lang.Boolean)
//  .enableKubernetesAlpha(IResolvable)
//  .enableL4IlbSubsetting(java.lang.Boolean)
//  .enableL4IlbSubsetting(IResolvable)
//  .enableLegacyAbac(java.lang.Boolean)
//  .enableLegacyAbac(IResolvable)
//  .enableShieldedNodes(java.lang.Boolean)
//  .enableShieldedNodes(IResolvable)
//  .enableTpu(java.lang.Boolean)
//  .enableTpu(IResolvable)
//  .gatewayApiConfig(ContainerClusterGatewayApiConfig)
//  .id(java.lang.String)
//  .initialNodeCount(java.lang.Number)
//  .ipAllocationPolicy(ContainerClusterIpAllocationPolicy)
//  .location(java.lang.String)
//  .loggingConfig(ContainerClusterLoggingConfig)
//  .loggingService(java.lang.String)
//  .maintenancePolicy(ContainerClusterMaintenancePolicy)
//  .masterAuth(ContainerClusterMasterAuth)
//  .masterAuthorizedNetworksConfig(ContainerClusterMasterAuthorizedNetworksConfig)
//  .meshCertificates(ContainerClusterMeshCertificates)
//  .minMasterVersion(java.lang.String)
//  .monitoringConfig(ContainerClusterMonitoringConfig)
//  .monitoringService(java.lang.String)
//  .network(java.lang.String)
//  .networkingMode(java.lang.String)
//  .networkPolicy(ContainerClusterNetworkPolicy)
//  .nodeConfig(ContainerClusterNodeConfig)
//  .nodeLocations(java.util.List<java.lang.String>)
//  .nodePool(IResolvable)
//  .nodePool(java.util.List<ContainerClusterNodePool>)
//  .nodePoolDefaults(ContainerClusterNodePoolDefaults)
//  .nodeVersion(java.lang.String)
//  .notificationConfig(ContainerClusterNotificationConfig)
//  .privateClusterConfig(ContainerClusterPrivateClusterConfig)
//  .privateIpv6GoogleAccess(java.lang.String)
//  .project(java.lang.String)
//  .releaseChannel(ContainerClusterReleaseChannel)
//  .removeDefaultNodePool(java.lang.Boolean)
//  .removeDefaultNodePool(IResolvable)
//  .resourceLabels(java.util.Map<java.lang.String, java.lang.String>)
//  .resourceUsageExportConfig(ContainerClusterResourceUsageExportConfig)
//  .serviceExternalIpsConfig(ContainerClusterServiceExternalIpsConfig)
//  .subnetwork(java.lang.String)
//  .timeouts(ContainerClusterTimeouts)
//  .verticalPodAutoscaling(ContainerClusterVerticalPodAutoscaling)
//  .workloadIdentityConfig(ContainerClusterWorkloadIdentityConfig)
    .build();
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.scope">scope</a></code> | <code>software.constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.id">id</a></code> | <code>java.lang.String</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.connection">connection</a></code> | <code>com.hashicorp.cdktf.SSHProvisionerConnection OR com.hashicorp.cdktf.WinrmProvisionerConnection</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.count">count</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.dependsOn">dependsOn</a></code> | <code>java.util.List<com.hashicorp.cdktf.ITerraformDependable></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.forEach">forEach</a></code> | <code>com.hashicorp.cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.lifecycle">lifecycle</a></code> | <code>com.hashicorp.cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.provider">provider</a></code> | <code>com.hashicorp.cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.provisioners">provisioners</a></code> | <code>java.util.List<com.hashicorp.cdktf.FileProvisioner OR com.hashicorp.cdktf.LocalExecProvisioner OR com.hashicorp.cdktf.RemoteExecProvisioner></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.name">name</a></code> | <code>java.lang.String</code> | The name of the cluster, unique within the project and location. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.addonsConfig">addonsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig">ContainerClusterAddonsConfig</a></code> | addons_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.authenticatorGroupsConfig">authenticatorGroupsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfig">ContainerClusterAuthenticatorGroupsConfig</a></code> | authenticator_groups_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.binaryAuthorization">binaryAuthorization</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization">ContainerClusterBinaryAuthorization</a></code> | binary_authorization block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.clusterAutoscaling">clusterAutoscaling</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling">ContainerClusterClusterAutoscaling</a></code> | cluster_autoscaling block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.clusterIpv4Cidr">clusterIpv4Cidr</a></code> | <code>java.lang.String</code> | The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.confidentialNodes">confidentialNodes</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodes">ContainerClusterConfidentialNodes</a></code> | confidential_nodes block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.costManagementConfig">costManagementConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfig">ContainerClusterCostManagementConfig</a></code> | cost_management_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.databaseEncryption">databaseEncryption</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryption">ContainerClusterDatabaseEncryption</a></code> | database_encryption block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.datapathProvider">datapathProvider</a></code> | <code>java.lang.String</code> | The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.defaultMaxPodsPerNode">defaultMaxPodsPerNode</a></code> | <code>java.lang.Number</code> | The default maximum number of pods per node in this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.defaultSnatStatus">defaultSnatStatus</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDefaultSnatStatus">ContainerClusterDefaultSnatStatus</a></code> | default_snat_status block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.description">description</a></code> | <code>java.lang.String</code> | Description of the cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.dnsConfig">dnsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig">ContainerClusterDnsConfig</a></code> | dns_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableAutopilot">enableAutopilot</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Enable Autopilot for this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableBinaryAuthorization">enableBinaryAuthorization</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binary Authorization. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableIntranodeVisibility">enableIntranodeVisibility</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether Intra-node visibility is enabled for this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableKubernetesAlpha">enableKubernetesAlpha</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether to enable Kubernetes Alpha features for this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableL4IlbSubsetting">enableL4IlbSubsetting</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether L4ILB Subsetting is enabled for this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableLegacyAbac">enableLegacyAbac</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether the ABAC authorizer is enabled for this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableShieldedNodes">enableShieldedNodes</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Enable Shielded Nodes features on all nodes in this cluster. Defaults to true. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableTpu">enableTpu</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether to enable Cloud TPU resources in this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.gatewayApiConfig">gatewayApiConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterGatewayApiConfig">ContainerClusterGatewayApiConfig</a></code> | gateway_api_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.id">id</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#id ContainerCluster#id}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.initialNodeCount">initialNodeCount</a></code> | <code>java.lang.Number</code> | The number of nodes to create in this cluster's default node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.ipAllocationPolicy">ipAllocationPolicy</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy">ContainerClusterIpAllocationPolicy</a></code> | ip_allocation_policy block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.location">location</a></code> | <code>java.lang.String</code> | The location (region or zone) in which the cluster master will be created, as well as the default node location. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.loggingConfig">loggingConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterLoggingConfig">ContainerClusterLoggingConfig</a></code> | logging_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.loggingService">loggingService</a></code> | <code>java.lang.String</code> | The logging service that the cluster should write logs to. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.maintenancePolicy">maintenancePolicy</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy">ContainerClusterMaintenancePolicy</a></code> | maintenance_policy block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.masterAuth">masterAuth</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuth">ContainerClusterMasterAuth</a></code> | master_auth block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.masterAuthorizedNetworksConfig">masterAuthorizedNetworksConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfig">ContainerClusterMasterAuthorizedNetworksConfig</a></code> | master_authorized_networks_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.meshCertificates">meshCertificates</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMeshCertificates">ContainerClusterMeshCertificates</a></code> | mesh_certificates block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.minMasterVersion">minMasterVersion</a></code> | <code>java.lang.String</code> | The minimum version of the master. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.monitoringConfig">monitoringConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfig">ContainerClusterMonitoringConfig</a></code> | monitoring_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.monitoringService">monitoringService</a></code> | <code>java.lang.String</code> | The monitoring service that the cluster should write metrics to. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.network">network</a></code> | <code>java.lang.String</code> | The name or self_link of the Google Compute Engine network to which the cluster is connected. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.networkingMode">networkingMode</a></code> | <code>java.lang.String</code> | Determines whether alias IPs or routes will be used for pod IPs in the cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.networkPolicy">networkPolicy</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicy">ContainerClusterNetworkPolicy</a></code> | network_policy block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.nodeConfig">nodeConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig">ContainerClusterNodeConfig</a></code> | node_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.nodeLocations">nodeLocations</a></code> | <code>java.util.List<java.lang.String></code> | The list of zones in which the cluster's nodes are located. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.nodePool">nodePool</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool">ContainerClusterNodePool</a>></code> | node_pool block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.nodePoolDefaults">nodePoolDefaults</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaults">ContainerClusterNodePoolDefaults</a></code> | node_pool_defaults block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.nodeVersion">nodeVersion</a></code> | <code>java.lang.String</code> | The Kubernetes version on the nodes. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.notificationConfig">notificationConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfig">ContainerClusterNotificationConfig</a></code> | notification_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.privateClusterConfig">privateClusterConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig">ContainerClusterPrivateClusterConfig</a></code> | private_cluster_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.privateIpv6GoogleAccess">privateIpv6GoogleAccess</a></code> | <code>java.lang.String</code> | The desired state of IPv6 connectivity to Google Services. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.project">project</a></code> | <code>java.lang.String</code> | The ID of the project in which the resource belongs. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.releaseChannel">releaseChannel</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterReleaseChannel">ContainerClusterReleaseChannel</a></code> | release_channel block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.removeDefaultNodePool">removeDefaultNodePool</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | If true, deletes the default node pool upon cluster creation. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.resourceLabels">resourceLabels</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | The GCE resource labels (a map of key/value pairs) to be applied to the cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.resourceUsageExportConfig">resourceUsageExportConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig">ContainerClusterResourceUsageExportConfig</a></code> | resource_usage_export_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.serviceExternalIpsConfig">serviceExternalIpsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterServiceExternalIpsConfig">ContainerClusterServiceExternalIpsConfig</a></code> | service_external_ips_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.subnetwork">subnetwork</a></code> | <code>java.lang.String</code> | The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterTimeouts">ContainerClusterTimeouts</a></code> | timeouts block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.verticalPodAutoscaling">verticalPodAutoscaling</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterVerticalPodAutoscaling">ContainerClusterVerticalPodAutoscaling</a></code> | vertical_pod_autoscaling block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.workloadIdentityConfig">workloadIdentityConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterWorkloadIdentityConfig">ContainerClusterWorkloadIdentityConfig</a></code> | workload_identity_config block. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.scope"></a>

- *Type:* software.constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.id"></a>

- *Type:* java.lang.String

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.connection"></a>

- *Type:* com.hashicorp.cdktf.SSHProvisionerConnection OR com.hashicorp.cdktf.WinrmProvisionerConnection

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.count"></a>

- *Type:* java.lang.Number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.dependsOn"></a>

- *Type:* java.util.List<com.hashicorp.cdktf.ITerraformDependable>

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.forEach"></a>

- *Type:* com.hashicorp.cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.lifecycle"></a>

- *Type:* com.hashicorp.cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.provider"></a>

- *Type:* com.hashicorp.cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.provisioners"></a>

- *Type:* java.util.List<com.hashicorp.cdktf.FileProvisioner OR com.hashicorp.cdktf.LocalExecProvisioner OR com.hashicorp.cdktf.RemoteExecProvisioner>

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.name"></a>

- *Type:* java.lang.String

The name of the cluster, unique within the project and location.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#name ContainerCluster#name}

---

##### `addonsConfig`<sup>Optional</sup> <a name="addonsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.addonsConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig">ContainerClusterAddonsConfig</a>

addons_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#addons_config ContainerCluster#addons_config}

---

##### `authenticatorGroupsConfig`<sup>Optional</sup> <a name="authenticatorGroupsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.authenticatorGroupsConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfig">ContainerClusterAuthenticatorGroupsConfig</a>

authenticator_groups_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#authenticator_groups_config ContainerCluster#authenticator_groups_config}

---

##### `binaryAuthorization`<sup>Optional</sup> <a name="binaryAuthorization" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.binaryAuthorization"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization">ContainerClusterBinaryAuthorization</a>

binary_authorization block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#binary_authorization ContainerCluster#binary_authorization}

---

##### `clusterAutoscaling`<sup>Optional</sup> <a name="clusterAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.clusterAutoscaling"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling">ContainerClusterClusterAutoscaling</a>

cluster_autoscaling block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_autoscaling ContainerCluster#cluster_autoscaling}

---

##### `clusterIpv4Cidr`<sup>Optional</sup> <a name="clusterIpv4Cidr" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.clusterIpv4Cidr"></a>

- *Type:* java.lang.String

The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_ipv4_cidr ContainerCluster#cluster_ipv4_cidr}

---

##### `confidentialNodes`<sup>Optional</sup> <a name="confidentialNodes" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.confidentialNodes"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodes">ContainerClusterConfidentialNodes</a>

confidential_nodes block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#confidential_nodes ContainerCluster#confidential_nodes}

---

##### `costManagementConfig`<sup>Optional</sup> <a name="costManagementConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.costManagementConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfig">ContainerClusterCostManagementConfig</a>

cost_management_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cost_management_config ContainerCluster#cost_management_config}

---

##### `databaseEncryption`<sup>Optional</sup> <a name="databaseEncryption" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.databaseEncryption"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryption">ContainerClusterDatabaseEncryption</a>

database_encryption block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#database_encryption ContainerCluster#database_encryption}

---

##### `datapathProvider`<sup>Optional</sup> <a name="datapathProvider" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.datapathProvider"></a>

- *Type:* java.lang.String

The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#datapath_provider ContainerCluster#datapath_provider}

---

##### `defaultMaxPodsPerNode`<sup>Optional</sup> <a name="defaultMaxPodsPerNode" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.defaultMaxPodsPerNode"></a>

- *Type:* java.lang.Number

The default maximum number of pods per node in this cluster.

This doesn't work on "routes-based" clusters, clusters that don't have IP Aliasing enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#default_max_pods_per_node ContainerCluster#default_max_pods_per_node}

---

##### `defaultSnatStatus`<sup>Optional</sup> <a name="defaultSnatStatus" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.defaultSnatStatus"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDefaultSnatStatus">ContainerClusterDefaultSnatStatus</a>

default_snat_status block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#default_snat_status ContainerCluster#default_snat_status}

---

##### `description`<sup>Optional</sup> <a name="description" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.description"></a>

- *Type:* java.lang.String

Description of the cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#description ContainerCluster#description}

---

##### `dnsConfig`<sup>Optional</sup> <a name="dnsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.dnsConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig">ContainerClusterDnsConfig</a>

dns_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#dns_config ContainerCluster#dns_config}

---

##### `enableAutopilot`<sup>Optional</sup> <a name="enableAutopilot" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableAutopilot"></a>

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Enable Autopilot for this cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_autopilot ContainerCluster#enable_autopilot}

---

##### `enableBinaryAuthorization`<sup>Optional</sup> <a name="enableBinaryAuthorization" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableBinaryAuthorization"></a>

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binary Authorization.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_binary_authorization ContainerCluster#enable_binary_authorization}

---

##### `enableIntranodeVisibility`<sup>Optional</sup> <a name="enableIntranodeVisibility" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableIntranodeVisibility"></a>

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether Intra-node visibility is enabled for this cluster.

This makes same node pod to pod traffic visible for VPC network.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_intranode_visibility ContainerCluster#enable_intranode_visibility}

---

##### `enableKubernetesAlpha`<sup>Optional</sup> <a name="enableKubernetesAlpha" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableKubernetesAlpha"></a>

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether to enable Kubernetes Alpha features for this cluster.

Note that when this option is enabled, the cluster cannot be upgraded and will be automatically deleted after 30 days.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_kubernetes_alpha ContainerCluster#enable_kubernetes_alpha}

---

##### `enableL4IlbSubsetting`<sup>Optional</sup> <a name="enableL4IlbSubsetting" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableL4IlbSubsetting"></a>

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether L4ILB Subsetting is enabled for this cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_l4_ilb_subsetting ContainerCluster#enable_l4_ilb_subsetting}

---

##### `enableLegacyAbac`<sup>Optional</sup> <a name="enableLegacyAbac" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableLegacyAbac"></a>

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether the ABAC authorizer is enabled for this cluster.

When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM. Defaults to false.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_legacy_abac ContainerCluster#enable_legacy_abac}

---

##### `enableShieldedNodes`<sup>Optional</sup> <a name="enableShieldedNodes" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableShieldedNodes"></a>

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Enable Shielded Nodes features on all nodes in this cluster. Defaults to true.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_shielded_nodes ContainerCluster#enable_shielded_nodes}

---

##### `enableTpu`<sup>Optional</sup> <a name="enableTpu" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.enableTpu"></a>

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether to enable Cloud TPU resources in this cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_tpu ContainerCluster#enable_tpu}

---

##### `gatewayApiConfig`<sup>Optional</sup> <a name="gatewayApiConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.gatewayApiConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterGatewayApiConfig">ContainerClusterGatewayApiConfig</a>

gateway_api_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gateway_api_config ContainerCluster#gateway_api_config}

---

##### `id`<sup>Optional</sup> <a name="id" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.id"></a>

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#id ContainerCluster#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

##### `initialNodeCount`<sup>Optional</sup> <a name="initialNodeCount" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.initialNodeCount"></a>

- *Type:* java.lang.Number

The number of nodes to create in this cluster's default node pool.

In regional or multi-zonal clusters, this is the number of nodes per zone. Must be set if node_pool is not set. If you're using google_container_node_pool objects with no default node pool, you'll need to set this to a value of at least 1, alongside setting remove_default_node_pool to true.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#initial_node_count ContainerCluster#initial_node_count}

---

##### `ipAllocationPolicy`<sup>Optional</sup> <a name="ipAllocationPolicy" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.ipAllocationPolicy"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy">ContainerClusterIpAllocationPolicy</a>

ip_allocation_policy block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#ip_allocation_policy ContainerCluster#ip_allocation_policy}

---

##### `location`<sup>Optional</sup> <a name="location" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.location"></a>

- *Type:* java.lang.String

The location (region or zone) in which the cluster master will be created, as well as the default node location.

If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#location ContainerCluster#location}

---

##### `loggingConfig`<sup>Optional</sup> <a name="loggingConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.loggingConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterLoggingConfig">ContainerClusterLoggingConfig</a>

logging_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#logging_config ContainerCluster#logging_config}

---

##### `loggingService`<sup>Optional</sup> <a name="loggingService" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.loggingService"></a>

- *Type:* java.lang.String

The logging service that the cluster should write logs to.

Available options include logging.googleapis.com(Legacy Stackdriver), logging.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Logging), and none. Defaults to logging.googleapis.com/kubernetes.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#logging_service ContainerCluster#logging_service}

---

##### `maintenancePolicy`<sup>Optional</sup> <a name="maintenancePolicy" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.maintenancePolicy"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy">ContainerClusterMaintenancePolicy</a>

maintenance_policy block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#maintenance_policy ContainerCluster#maintenance_policy}

---

##### `masterAuth`<sup>Optional</sup> <a name="masterAuth" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.masterAuth"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuth">ContainerClusterMasterAuth</a>

master_auth block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_auth ContainerCluster#master_auth}

---

##### `masterAuthorizedNetworksConfig`<sup>Optional</sup> <a name="masterAuthorizedNetworksConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.masterAuthorizedNetworksConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfig">ContainerClusterMasterAuthorizedNetworksConfig</a>

master_authorized_networks_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_authorized_networks_config ContainerCluster#master_authorized_networks_config}

---

##### `meshCertificates`<sup>Optional</sup> <a name="meshCertificates" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.meshCertificates"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMeshCertificates">ContainerClusterMeshCertificates</a>

mesh_certificates block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#mesh_certificates ContainerCluster#mesh_certificates}

---

##### `minMasterVersion`<sup>Optional</sup> <a name="minMasterVersion" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.minMasterVersion"></a>

- *Type:* java.lang.String

The minimum version of the master.

GKE will auto-update the master to new versions, so this does not guarantee the current master version--use the read-only master_version field to obtain that. If unset, the cluster's version will be set by GKE to the version of the most recent official release (which is not necessarily the latest version).

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_master_version ContainerCluster#min_master_version}

---

##### `monitoringConfig`<sup>Optional</sup> <a name="monitoringConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.monitoringConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfig">ContainerClusterMonitoringConfig</a>

monitoring_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#monitoring_config ContainerCluster#monitoring_config}

---

##### `monitoringService`<sup>Optional</sup> <a name="monitoringService" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.monitoringService"></a>

- *Type:* java.lang.String

The monitoring service that the cluster should write metrics to.

Automatically send metrics from pods in the cluster to the Google Cloud Monitoring API. VM metrics will be collected by Google Compute Engine regardless of this setting Available options include monitoring.googleapis.com(Legacy Stackdriver), monitoring.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Monitoring), and none. Defaults to monitoring.googleapis.com/kubernetes.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#monitoring_service ContainerCluster#monitoring_service}

---

##### `network`<sup>Optional</sup> <a name="network" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.network"></a>

- *Type:* java.lang.String

The name or self_link of the Google Compute Engine network to which the cluster is connected.

For Shared VPC, set this to the self link of the shared network.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#network ContainerCluster#network}

---

##### `networkingMode`<sup>Optional</sup> <a name="networkingMode" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.networkingMode"></a>

- *Type:* java.lang.String

Determines whether alias IPs or routes will be used for pod IPs in the cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#networking_mode ContainerCluster#networking_mode}

---

##### `networkPolicy`<sup>Optional</sup> <a name="networkPolicy" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.networkPolicy"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicy">ContainerClusterNetworkPolicy</a>

network_policy block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#network_policy ContainerCluster#network_policy}

---

##### `nodeConfig`<sup>Optional</sup> <a name="nodeConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.nodeConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig">ContainerClusterNodeConfig</a>

node_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_config ContainerCluster#node_config}

---

##### `nodeLocations`<sup>Optional</sup> <a name="nodeLocations" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.nodeLocations"></a>

- *Type:* java.util.List<java.lang.String>

The list of zones in which the cluster's nodes are located.

Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If this is specified for a zonal cluster, omit the cluster's zone.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_locations ContainerCluster#node_locations}

---

##### `nodePool`<sup>Optional</sup> <a name="nodePool" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.nodePool"></a>

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool">ContainerClusterNodePool</a>>

node_pool block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_pool ContainerCluster#node_pool}

---

##### `nodePoolDefaults`<sup>Optional</sup> <a name="nodePoolDefaults" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.nodePoolDefaults"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaults">ContainerClusterNodePoolDefaults</a>

node_pool_defaults block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_pool_defaults ContainerCluster#node_pool_defaults}

---

##### `nodeVersion`<sup>Optional</sup> <a name="nodeVersion" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.nodeVersion"></a>

- *Type:* java.lang.String

The Kubernetes version on the nodes.

Must either be unset or set to the same value as min_master_version on create. Defaults to the default version set by GKE which is not necessarily the latest version. This only affects nodes in the default node pool. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way. To update nodes in other node pools, use the version attribute on the node pool.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_version ContainerCluster#node_version}

---

##### `notificationConfig`<sup>Optional</sup> <a name="notificationConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.notificationConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfig">ContainerClusterNotificationConfig</a>

notification_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#notification_config ContainerCluster#notification_config}

---

##### `privateClusterConfig`<sup>Optional</sup> <a name="privateClusterConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.privateClusterConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig">ContainerClusterPrivateClusterConfig</a>

private_cluster_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#private_cluster_config ContainerCluster#private_cluster_config}

---

##### `privateIpv6GoogleAccess`<sup>Optional</sup> <a name="privateIpv6GoogleAccess" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.privateIpv6GoogleAccess"></a>

- *Type:* java.lang.String

The desired state of IPv6 connectivity to Google Services.

By default, no private IPv6 access to or from Google Services (all access will be via IPv4).

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#private_ipv6_google_access ContainerCluster#private_ipv6_google_access}

---

##### `project`<sup>Optional</sup> <a name="project" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.project"></a>

- *Type:* java.lang.String

The ID of the project in which the resource belongs.

If it is not provided, the provider project is used.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#project ContainerCluster#project}

---

##### `releaseChannel`<sup>Optional</sup> <a name="releaseChannel" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.releaseChannel"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterReleaseChannel">ContainerClusterReleaseChannel</a>

release_channel block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#release_channel ContainerCluster#release_channel}

---

##### `removeDefaultNodePool`<sup>Optional</sup> <a name="removeDefaultNodePool" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.removeDefaultNodePool"></a>

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

If true, deletes the default node pool upon cluster creation.

If you're using google_container_node_pool resources with no default node pool, this should be set to true, alongside setting initial_node_count to at least 1.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#remove_default_node_pool ContainerCluster#remove_default_node_pool}

---

##### `resourceLabels`<sup>Optional</sup> <a name="resourceLabels" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.resourceLabels"></a>

- *Type:* java.util.Map<java.lang.String, java.lang.String>

The GCE resource labels (a map of key/value pairs) to be applied to the cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_labels ContainerCluster#resource_labels}

---

##### `resourceUsageExportConfig`<sup>Optional</sup> <a name="resourceUsageExportConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.resourceUsageExportConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig">ContainerClusterResourceUsageExportConfig</a>

resource_usage_export_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_usage_export_config ContainerCluster#resource_usage_export_config}

---

##### `serviceExternalIpsConfig`<sup>Optional</sup> <a name="serviceExternalIpsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.serviceExternalIpsConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterServiceExternalIpsConfig">ContainerClusterServiceExternalIpsConfig</a>

service_external_ips_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#service_external_ips_config ContainerCluster#service_external_ips_config}

---

##### `subnetwork`<sup>Optional</sup> <a name="subnetwork" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.subnetwork"></a>

- *Type:* java.lang.String

The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#subnetwork ContainerCluster#subnetwork}

---

##### `timeouts`<sup>Optional</sup> <a name="timeouts" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.timeouts"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterTimeouts">ContainerClusterTimeouts</a>

timeouts block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#timeouts ContainerCluster#timeouts}

---

##### `verticalPodAutoscaling`<sup>Optional</sup> <a name="verticalPodAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.verticalPodAutoscaling"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterVerticalPodAutoscaling">ContainerClusterVerticalPodAutoscaling</a>

vertical_pod_autoscaling block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#vertical_pod_autoscaling ContainerCluster#vertical_pod_autoscaling}

---

##### `workloadIdentityConfig`<sup>Optional</sup> <a name="workloadIdentityConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.Initializer.parameter.workloadIdentityConfig"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterWorkloadIdentityConfig">ContainerClusterWorkloadIdentityConfig</a>

workload_identity_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#workload_identity_config ContainerCluster#workload_identity_config}

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putAddonsConfig">putAddonsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putAuthenticatorGroupsConfig">putAuthenticatorGroupsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putBinaryAuthorization">putBinaryAuthorization</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putClusterAutoscaling">putClusterAutoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putConfidentialNodes">putConfidentialNodes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putCostManagementConfig">putCostManagementConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putDatabaseEncryption">putDatabaseEncryption</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putDefaultSnatStatus">putDefaultSnatStatus</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putDnsConfig">putDnsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putGatewayApiConfig">putGatewayApiConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putIpAllocationPolicy">putIpAllocationPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putLoggingConfig">putLoggingConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putMaintenancePolicy">putMaintenancePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putMasterAuth">putMasterAuth</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putMasterAuthorizedNetworksConfig">putMasterAuthorizedNetworksConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putMeshCertificates">putMeshCertificates</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putMonitoringConfig">putMonitoringConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putNetworkPolicy">putNetworkPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putNodeConfig">putNodeConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putNodePool">putNodePool</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putNodePoolDefaults">putNodePoolDefaults</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putNotificationConfig">putNotificationConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putPrivateClusterConfig">putPrivateClusterConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putReleaseChannel">putReleaseChannel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putResourceUsageExportConfig">putResourceUsageExportConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putServiceExternalIpsConfig">putServiceExternalIpsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putTimeouts">putTimeouts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putVerticalPodAutoscaling">putVerticalPodAutoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.putWorkloadIdentityConfig">putWorkloadIdentityConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetAddonsConfig">resetAddonsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetAuthenticatorGroupsConfig">resetAuthenticatorGroupsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetBinaryAuthorization">resetBinaryAuthorization</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetClusterAutoscaling">resetClusterAutoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetClusterIpv4Cidr">resetClusterIpv4Cidr</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetConfidentialNodes">resetConfidentialNodes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetCostManagementConfig">resetCostManagementConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetDatabaseEncryption">resetDatabaseEncryption</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetDatapathProvider">resetDatapathProvider</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetDefaultMaxPodsPerNode">resetDefaultMaxPodsPerNode</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetDefaultSnatStatus">resetDefaultSnatStatus</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetDescription">resetDescription</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetDnsConfig">resetDnsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableAutopilot">resetEnableAutopilot</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableBinaryAuthorization">resetEnableBinaryAuthorization</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableIntranodeVisibility">resetEnableIntranodeVisibility</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableKubernetesAlpha">resetEnableKubernetesAlpha</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableL4IlbSubsetting">resetEnableL4IlbSubsetting</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableLegacyAbac">resetEnableLegacyAbac</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableShieldedNodes">resetEnableShieldedNodes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableTpu">resetEnableTpu</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetGatewayApiConfig">resetGatewayApiConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetId">resetId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetInitialNodeCount">resetInitialNodeCount</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetIpAllocationPolicy">resetIpAllocationPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetLocation">resetLocation</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetLoggingConfig">resetLoggingConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetLoggingService">resetLoggingService</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetMaintenancePolicy">resetMaintenancePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetMasterAuth">resetMasterAuth</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetMasterAuthorizedNetworksConfig">resetMasterAuthorizedNetworksConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetMeshCertificates">resetMeshCertificates</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetMinMasterVersion">resetMinMasterVersion</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetMonitoringConfig">resetMonitoringConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetMonitoringService">resetMonitoringService</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetNetwork">resetNetwork</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetNetworkingMode">resetNetworkingMode</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetNetworkPolicy">resetNetworkPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetNodeConfig">resetNodeConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetNodeLocations">resetNodeLocations</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetNodePool">resetNodePool</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetNodePoolDefaults">resetNodePoolDefaults</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetNodeVersion">resetNodeVersion</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetNotificationConfig">resetNotificationConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetPrivateClusterConfig">resetPrivateClusterConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetPrivateIpv6GoogleAccess">resetPrivateIpv6GoogleAccess</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetProject">resetProject</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetReleaseChannel">resetReleaseChannel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetRemoveDefaultNodePool">resetRemoveDefaultNodePool</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetResourceLabels">resetResourceLabels</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetResourceUsageExportConfig">resetResourceUsageExportConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetServiceExternalIpsConfig">resetServiceExternalIpsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetSubnetwork">resetSubnetwork</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetTimeouts">resetTimeouts</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetVerticalPodAutoscaling">resetVerticalPodAutoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.resetWorkloadIdentityConfig">resetWorkloadIdentityConfig</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerCluster.toString"></a>

```java
public java.lang.String toString()
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-google.containerCluster.ContainerCluster.addOverride"></a>

```java
public void addOverride(java.lang.String path, java.lang.Object value)
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-google.containerCluster.ContainerCluster.addOverride.parameter.path"></a>

- *Type:* java.lang.String

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.addOverride.parameter.value"></a>

- *Type:* java.lang.Object

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-google.containerCluster.ContainerCluster.overrideLogicalId"></a>

```java
public void overrideLogicalId(java.lang.String newLogicalId)
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-google.containerCluster.ContainerCluster.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* java.lang.String

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetOverrideLogicalId"></a>

```java
public void resetOverrideLogicalId()
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-google.containerCluster.ContainerCluster.toMetadata"></a>

```java
public java.lang.Object toMetadata()
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-google.containerCluster.ContainerCluster.toTerraform"></a>

```java
public java.lang.Object toTerraform()
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerCluster.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `putAddonsConfig` <a name="putAddonsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putAddonsConfig"></a>

```java
public void putAddonsConfig(ContainerClusterAddonsConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putAddonsConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig">ContainerClusterAddonsConfig</a>

---

##### `putAuthenticatorGroupsConfig` <a name="putAuthenticatorGroupsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putAuthenticatorGroupsConfig"></a>

```java
public void putAuthenticatorGroupsConfig(ContainerClusterAuthenticatorGroupsConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putAuthenticatorGroupsConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfig">ContainerClusterAuthenticatorGroupsConfig</a>

---

##### `putBinaryAuthorization` <a name="putBinaryAuthorization" id="@cdktf/provider-google.containerCluster.ContainerCluster.putBinaryAuthorization"></a>

```java
public void putBinaryAuthorization(ContainerClusterBinaryAuthorization value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putBinaryAuthorization.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization">ContainerClusterBinaryAuthorization</a>

---

##### `putClusterAutoscaling` <a name="putClusterAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerCluster.putClusterAutoscaling"></a>

```java
public void putClusterAutoscaling(ContainerClusterClusterAutoscaling value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putClusterAutoscaling.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling">ContainerClusterClusterAutoscaling</a>

---

##### `putConfidentialNodes` <a name="putConfidentialNodes" id="@cdktf/provider-google.containerCluster.ContainerCluster.putConfidentialNodes"></a>

```java
public void putConfidentialNodes(ContainerClusterConfidentialNodes value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putConfidentialNodes.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodes">ContainerClusterConfidentialNodes</a>

---

##### `putCostManagementConfig` <a name="putCostManagementConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putCostManagementConfig"></a>

```java
public void putCostManagementConfig(ContainerClusterCostManagementConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putCostManagementConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfig">ContainerClusterCostManagementConfig</a>

---

##### `putDatabaseEncryption` <a name="putDatabaseEncryption" id="@cdktf/provider-google.containerCluster.ContainerCluster.putDatabaseEncryption"></a>

```java
public void putDatabaseEncryption(ContainerClusterDatabaseEncryption value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putDatabaseEncryption.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryption">ContainerClusterDatabaseEncryption</a>

---

##### `putDefaultSnatStatus` <a name="putDefaultSnatStatus" id="@cdktf/provider-google.containerCluster.ContainerCluster.putDefaultSnatStatus"></a>

```java
public void putDefaultSnatStatus(ContainerClusterDefaultSnatStatus value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putDefaultSnatStatus.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDefaultSnatStatus">ContainerClusterDefaultSnatStatus</a>

---

##### `putDnsConfig` <a name="putDnsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putDnsConfig"></a>

```java
public void putDnsConfig(ContainerClusterDnsConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putDnsConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig">ContainerClusterDnsConfig</a>

---

##### `putGatewayApiConfig` <a name="putGatewayApiConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putGatewayApiConfig"></a>

```java
public void putGatewayApiConfig(ContainerClusterGatewayApiConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putGatewayApiConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterGatewayApiConfig">ContainerClusterGatewayApiConfig</a>

---

##### `putIpAllocationPolicy` <a name="putIpAllocationPolicy" id="@cdktf/provider-google.containerCluster.ContainerCluster.putIpAllocationPolicy"></a>

```java
public void putIpAllocationPolicy(ContainerClusterIpAllocationPolicy value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putIpAllocationPolicy.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy">ContainerClusterIpAllocationPolicy</a>

---

##### `putLoggingConfig` <a name="putLoggingConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putLoggingConfig"></a>

```java
public void putLoggingConfig(ContainerClusterLoggingConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putLoggingConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterLoggingConfig">ContainerClusterLoggingConfig</a>

---

##### `putMaintenancePolicy` <a name="putMaintenancePolicy" id="@cdktf/provider-google.containerCluster.ContainerCluster.putMaintenancePolicy"></a>

```java
public void putMaintenancePolicy(ContainerClusterMaintenancePolicy value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putMaintenancePolicy.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy">ContainerClusterMaintenancePolicy</a>

---

##### `putMasterAuth` <a name="putMasterAuth" id="@cdktf/provider-google.containerCluster.ContainerCluster.putMasterAuth"></a>

```java
public void putMasterAuth(ContainerClusterMasterAuth value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putMasterAuth.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuth">ContainerClusterMasterAuth</a>

---

##### `putMasterAuthorizedNetworksConfig` <a name="putMasterAuthorizedNetworksConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putMasterAuthorizedNetworksConfig"></a>

```java
public void putMasterAuthorizedNetworksConfig(ContainerClusterMasterAuthorizedNetworksConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putMasterAuthorizedNetworksConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfig">ContainerClusterMasterAuthorizedNetworksConfig</a>

---

##### `putMeshCertificates` <a name="putMeshCertificates" id="@cdktf/provider-google.containerCluster.ContainerCluster.putMeshCertificates"></a>

```java
public void putMeshCertificates(ContainerClusterMeshCertificates value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putMeshCertificates.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMeshCertificates">ContainerClusterMeshCertificates</a>

---

##### `putMonitoringConfig` <a name="putMonitoringConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putMonitoringConfig"></a>

```java
public void putMonitoringConfig(ContainerClusterMonitoringConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putMonitoringConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfig">ContainerClusterMonitoringConfig</a>

---

##### `putNetworkPolicy` <a name="putNetworkPolicy" id="@cdktf/provider-google.containerCluster.ContainerCluster.putNetworkPolicy"></a>

```java
public void putNetworkPolicy(ContainerClusterNetworkPolicy value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putNetworkPolicy.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicy">ContainerClusterNetworkPolicy</a>

---

##### `putNodeConfig` <a name="putNodeConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putNodeConfig"></a>

```java
public void putNodeConfig(ContainerClusterNodeConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putNodeConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig">ContainerClusterNodeConfig</a>

---

##### `putNodePool` <a name="putNodePool" id="@cdktf/provider-google.containerCluster.ContainerCluster.putNodePool"></a>

```java
public void putNodePool(IResolvable OR java.util.List<ContainerClusterNodePool> value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putNodePool.parameter.value"></a>

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool">ContainerClusterNodePool</a>>

---

##### `putNodePoolDefaults` <a name="putNodePoolDefaults" id="@cdktf/provider-google.containerCluster.ContainerCluster.putNodePoolDefaults"></a>

```java
public void putNodePoolDefaults(ContainerClusterNodePoolDefaults value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putNodePoolDefaults.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaults">ContainerClusterNodePoolDefaults</a>

---

##### `putNotificationConfig` <a name="putNotificationConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putNotificationConfig"></a>

```java
public void putNotificationConfig(ContainerClusterNotificationConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putNotificationConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfig">ContainerClusterNotificationConfig</a>

---

##### `putPrivateClusterConfig` <a name="putPrivateClusterConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putPrivateClusterConfig"></a>

```java
public void putPrivateClusterConfig(ContainerClusterPrivateClusterConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putPrivateClusterConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig">ContainerClusterPrivateClusterConfig</a>

---

##### `putReleaseChannel` <a name="putReleaseChannel" id="@cdktf/provider-google.containerCluster.ContainerCluster.putReleaseChannel"></a>

```java
public void putReleaseChannel(ContainerClusterReleaseChannel value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putReleaseChannel.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterReleaseChannel">ContainerClusterReleaseChannel</a>

---

##### `putResourceUsageExportConfig` <a name="putResourceUsageExportConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putResourceUsageExportConfig"></a>

```java
public void putResourceUsageExportConfig(ContainerClusterResourceUsageExportConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putResourceUsageExportConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig">ContainerClusterResourceUsageExportConfig</a>

---

##### `putServiceExternalIpsConfig` <a name="putServiceExternalIpsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putServiceExternalIpsConfig"></a>

```java
public void putServiceExternalIpsConfig(ContainerClusterServiceExternalIpsConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putServiceExternalIpsConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterServiceExternalIpsConfig">ContainerClusterServiceExternalIpsConfig</a>

---

##### `putTimeouts` <a name="putTimeouts" id="@cdktf/provider-google.containerCluster.ContainerCluster.putTimeouts"></a>

```java
public void putTimeouts(ContainerClusterTimeouts value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putTimeouts.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterTimeouts">ContainerClusterTimeouts</a>

---

##### `putVerticalPodAutoscaling` <a name="putVerticalPodAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerCluster.putVerticalPodAutoscaling"></a>

```java
public void putVerticalPodAutoscaling(ContainerClusterVerticalPodAutoscaling value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putVerticalPodAutoscaling.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterVerticalPodAutoscaling">ContainerClusterVerticalPodAutoscaling</a>

---

##### `putWorkloadIdentityConfig` <a name="putWorkloadIdentityConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.putWorkloadIdentityConfig"></a>

```java
public void putWorkloadIdentityConfig(ContainerClusterWorkloadIdentityConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerCluster.putWorkloadIdentityConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterWorkloadIdentityConfig">ContainerClusterWorkloadIdentityConfig</a>

---

##### `resetAddonsConfig` <a name="resetAddonsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetAddonsConfig"></a>

```java
public void resetAddonsConfig()
```

##### `resetAuthenticatorGroupsConfig` <a name="resetAuthenticatorGroupsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetAuthenticatorGroupsConfig"></a>

```java
public void resetAuthenticatorGroupsConfig()
```

##### `resetBinaryAuthorization` <a name="resetBinaryAuthorization" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetBinaryAuthorization"></a>

```java
public void resetBinaryAuthorization()
```

##### `resetClusterAutoscaling` <a name="resetClusterAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetClusterAutoscaling"></a>

```java
public void resetClusterAutoscaling()
```

##### `resetClusterIpv4Cidr` <a name="resetClusterIpv4Cidr" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetClusterIpv4Cidr"></a>

```java
public void resetClusterIpv4Cidr()
```

##### `resetConfidentialNodes` <a name="resetConfidentialNodes" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetConfidentialNodes"></a>

```java
public void resetConfidentialNodes()
```

##### `resetCostManagementConfig` <a name="resetCostManagementConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetCostManagementConfig"></a>

```java
public void resetCostManagementConfig()
```

##### `resetDatabaseEncryption` <a name="resetDatabaseEncryption" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetDatabaseEncryption"></a>

```java
public void resetDatabaseEncryption()
```

##### `resetDatapathProvider` <a name="resetDatapathProvider" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetDatapathProvider"></a>

```java
public void resetDatapathProvider()
```

##### `resetDefaultMaxPodsPerNode` <a name="resetDefaultMaxPodsPerNode" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetDefaultMaxPodsPerNode"></a>

```java
public void resetDefaultMaxPodsPerNode()
```

##### `resetDefaultSnatStatus` <a name="resetDefaultSnatStatus" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetDefaultSnatStatus"></a>

```java
public void resetDefaultSnatStatus()
```

##### `resetDescription` <a name="resetDescription" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetDescription"></a>

```java
public void resetDescription()
```

##### `resetDnsConfig` <a name="resetDnsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetDnsConfig"></a>

```java
public void resetDnsConfig()
```

##### `resetEnableAutopilot` <a name="resetEnableAutopilot" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableAutopilot"></a>

```java
public void resetEnableAutopilot()
```

##### `resetEnableBinaryAuthorization` <a name="resetEnableBinaryAuthorization" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableBinaryAuthorization"></a>

```java
public void resetEnableBinaryAuthorization()
```

##### `resetEnableIntranodeVisibility` <a name="resetEnableIntranodeVisibility" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableIntranodeVisibility"></a>

```java
public void resetEnableIntranodeVisibility()
```

##### `resetEnableKubernetesAlpha` <a name="resetEnableKubernetesAlpha" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableKubernetesAlpha"></a>

```java
public void resetEnableKubernetesAlpha()
```

##### `resetEnableL4IlbSubsetting` <a name="resetEnableL4IlbSubsetting" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableL4IlbSubsetting"></a>

```java
public void resetEnableL4IlbSubsetting()
```

##### `resetEnableLegacyAbac` <a name="resetEnableLegacyAbac" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableLegacyAbac"></a>

```java
public void resetEnableLegacyAbac()
```

##### `resetEnableShieldedNodes` <a name="resetEnableShieldedNodes" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableShieldedNodes"></a>

```java
public void resetEnableShieldedNodes()
```

##### `resetEnableTpu` <a name="resetEnableTpu" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetEnableTpu"></a>

```java
public void resetEnableTpu()
```

##### `resetGatewayApiConfig` <a name="resetGatewayApiConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetGatewayApiConfig"></a>

```java
public void resetGatewayApiConfig()
```

##### `resetId` <a name="resetId" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetId"></a>

```java
public void resetId()
```

##### `resetInitialNodeCount` <a name="resetInitialNodeCount" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetInitialNodeCount"></a>

```java
public void resetInitialNodeCount()
```

##### `resetIpAllocationPolicy` <a name="resetIpAllocationPolicy" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetIpAllocationPolicy"></a>

```java
public void resetIpAllocationPolicy()
```

##### `resetLocation` <a name="resetLocation" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetLocation"></a>

```java
public void resetLocation()
```

##### `resetLoggingConfig` <a name="resetLoggingConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetLoggingConfig"></a>

```java
public void resetLoggingConfig()
```

##### `resetLoggingService` <a name="resetLoggingService" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetLoggingService"></a>

```java
public void resetLoggingService()
```

##### `resetMaintenancePolicy` <a name="resetMaintenancePolicy" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetMaintenancePolicy"></a>

```java
public void resetMaintenancePolicy()
```

##### `resetMasterAuth` <a name="resetMasterAuth" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetMasterAuth"></a>

```java
public void resetMasterAuth()
```

##### `resetMasterAuthorizedNetworksConfig` <a name="resetMasterAuthorizedNetworksConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetMasterAuthorizedNetworksConfig"></a>

```java
public void resetMasterAuthorizedNetworksConfig()
```

##### `resetMeshCertificates` <a name="resetMeshCertificates" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetMeshCertificates"></a>

```java
public void resetMeshCertificates()
```

##### `resetMinMasterVersion` <a name="resetMinMasterVersion" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetMinMasterVersion"></a>

```java
public void resetMinMasterVersion()
```

##### `resetMonitoringConfig` <a name="resetMonitoringConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetMonitoringConfig"></a>

```java
public void resetMonitoringConfig()
```

##### `resetMonitoringService` <a name="resetMonitoringService" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetMonitoringService"></a>

```java
public void resetMonitoringService()
```

##### `resetNetwork` <a name="resetNetwork" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetNetwork"></a>

```java
public void resetNetwork()
```

##### `resetNetworkingMode` <a name="resetNetworkingMode" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetNetworkingMode"></a>

```java
public void resetNetworkingMode()
```

##### `resetNetworkPolicy` <a name="resetNetworkPolicy" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetNetworkPolicy"></a>

```java
public void resetNetworkPolicy()
```

##### `resetNodeConfig` <a name="resetNodeConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetNodeConfig"></a>

```java
public void resetNodeConfig()
```

##### `resetNodeLocations` <a name="resetNodeLocations" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetNodeLocations"></a>

```java
public void resetNodeLocations()
```

##### `resetNodePool` <a name="resetNodePool" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetNodePool"></a>

```java
public void resetNodePool()
```

##### `resetNodePoolDefaults` <a name="resetNodePoolDefaults" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetNodePoolDefaults"></a>

```java
public void resetNodePoolDefaults()
```

##### `resetNodeVersion` <a name="resetNodeVersion" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetNodeVersion"></a>

```java
public void resetNodeVersion()
```

##### `resetNotificationConfig` <a name="resetNotificationConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetNotificationConfig"></a>

```java
public void resetNotificationConfig()
```

##### `resetPrivateClusterConfig` <a name="resetPrivateClusterConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetPrivateClusterConfig"></a>

```java
public void resetPrivateClusterConfig()
```

##### `resetPrivateIpv6GoogleAccess` <a name="resetPrivateIpv6GoogleAccess" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetPrivateIpv6GoogleAccess"></a>

```java
public void resetPrivateIpv6GoogleAccess()
```

##### `resetProject` <a name="resetProject" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetProject"></a>

```java
public void resetProject()
```

##### `resetReleaseChannel` <a name="resetReleaseChannel" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetReleaseChannel"></a>

```java
public void resetReleaseChannel()
```

##### `resetRemoveDefaultNodePool` <a name="resetRemoveDefaultNodePool" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetRemoveDefaultNodePool"></a>

```java
public void resetRemoveDefaultNodePool()
```

##### `resetResourceLabels` <a name="resetResourceLabels" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetResourceLabels"></a>

```java
public void resetResourceLabels()
```

##### `resetResourceUsageExportConfig` <a name="resetResourceUsageExportConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetResourceUsageExportConfig"></a>

```java
public void resetResourceUsageExportConfig()
```

##### `resetServiceExternalIpsConfig` <a name="resetServiceExternalIpsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetServiceExternalIpsConfig"></a>

```java
public void resetServiceExternalIpsConfig()
```

##### `resetSubnetwork` <a name="resetSubnetwork" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetSubnetwork"></a>

```java
public void resetSubnetwork()
```

##### `resetTimeouts` <a name="resetTimeouts" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetTimeouts"></a>

```java
public void resetTimeouts()
```

##### `resetVerticalPodAutoscaling` <a name="resetVerticalPodAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetVerticalPodAutoscaling"></a>

```java
public void resetVerticalPodAutoscaling()
```

##### `resetWorkloadIdentityConfig` <a name="resetWorkloadIdentityConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.resetWorkloadIdentityConfig"></a>

```java
public void resetWorkloadIdentityConfig()
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.isTerraformElement">isTerraformElement</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.isTerraformResource">isTerraformResource</a></code> | *No description.* |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-google.containerCluster.ContainerCluster.isConstruct"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerCluster;

ContainerCluster.isConstruct(java.lang.Object x)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-google.containerCluster.ContainerCluster.isConstruct.parameter.x"></a>

- *Type:* java.lang.Object

Any object.

---

##### `isTerraformElement` <a name="isTerraformElement" id="@cdktf/provider-google.containerCluster.ContainerCluster.isTerraformElement"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerCluster;

ContainerCluster.isTerraformElement(java.lang.Object x)
```

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-google.containerCluster.ContainerCluster.isTerraformElement.parameter.x"></a>

- *Type:* java.lang.Object

---

##### `isTerraformResource` <a name="isTerraformResource" id="@cdktf/provider-google.containerCluster.ContainerCluster.isTerraformResource"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerCluster;

ContainerCluster.isTerraformResource(java.lang.Object x)
```

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-google.containerCluster.ContainerCluster.isTerraformResource.parameter.x"></a>

- *Type:* java.lang.Object

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.node">node</a></code> | <code>software.constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.cdktfStack">cdktfStack</a></code> | <code>com.hashicorp.cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>java.util.Map<java.lang.String, java.lang.Object></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.terraformResourceType">terraformResourceType</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>com.hashicorp.cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.connection">connection</a></code> | <code>com.hashicorp.cdktf.SSHProvisionerConnection OR com.hashicorp.cdktf.WinrmProvisionerConnection</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.count">count</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.dependsOn">dependsOn</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.forEach">forEach</a></code> | <code>com.hashicorp.cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.lifecycle">lifecycle</a></code> | <code>com.hashicorp.cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.provider">provider</a></code> | <code>com.hashicorp.cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.provisioners">provisioners</a></code> | <code>java.util.List<com.hashicorp.cdktf.FileProvisioner OR com.hashicorp.cdktf.LocalExecProvisioner OR com.hashicorp.cdktf.RemoteExecProvisioner></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.addonsConfig">addonsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference">ContainerClusterAddonsConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.authenticatorGroupsConfig">authenticatorGroupsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference">ContainerClusterAuthenticatorGroupsConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.binaryAuthorization">binaryAuthorization</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference">ContainerClusterBinaryAuthorizationOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.clusterAutoscaling">clusterAutoscaling</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference">ContainerClusterClusterAutoscalingOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.confidentialNodes">confidentialNodes</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference">ContainerClusterConfidentialNodesOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.costManagementConfig">costManagementConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference">ContainerClusterCostManagementConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.databaseEncryption">databaseEncryption</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference">ContainerClusterDatabaseEncryptionOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.defaultSnatStatus">defaultSnatStatus</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDefaultSnatStatusOutputReference">ContainerClusterDefaultSnatStatusOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.dnsConfig">dnsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDnsConfigOutputReference">ContainerClusterDnsConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.endpoint">endpoint</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.gatewayApiConfig">gatewayApiConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterGatewayApiConfigOutputReference">ContainerClusterGatewayApiConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.ipAllocationPolicy">ipAllocationPolicy</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicyOutputReference">ContainerClusterIpAllocationPolicyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.labelFingerprint">labelFingerprint</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.loggingConfig">loggingConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterLoggingConfigOutputReference">ContainerClusterLoggingConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.maintenancePolicy">maintenancePolicy</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyOutputReference">ContainerClusterMaintenancePolicyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.masterAuth">masterAuth</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthOutputReference">ContainerClusterMasterAuthOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.masterAuthorizedNetworksConfig">masterAuthorizedNetworksConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfigOutputReference">ContainerClusterMasterAuthorizedNetworksConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.masterVersion">masterVersion</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.meshCertificates">meshCertificates</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMeshCertificatesOutputReference">ContainerClusterMeshCertificatesOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.monitoringConfig">monitoringConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfigOutputReference">ContainerClusterMonitoringConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.networkPolicy">networkPolicy</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicyOutputReference">ContainerClusterNetworkPolicyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.nodeConfig">nodeConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigOutputReference">ContainerClusterNodeConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.nodePool">nodePool</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolList">ContainerClusterNodePoolList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.nodePoolDefaults">nodePoolDefaults</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaultsOutputReference">ContainerClusterNodePoolDefaultsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.notificationConfig">notificationConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigOutputReference">ContainerClusterNotificationConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.operation">operation</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.privateClusterConfig">privateClusterConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfigOutputReference">ContainerClusterPrivateClusterConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.releaseChannel">releaseChannel</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterReleaseChannelOutputReference">ContainerClusterReleaseChannelOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.resourceUsageExportConfig">resourceUsageExportConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfigOutputReference">ContainerClusterResourceUsageExportConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.selfLink">selfLink</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.serviceExternalIpsConfig">serviceExternalIpsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterServiceExternalIpsConfigOutputReference">ContainerClusterServiceExternalIpsConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.servicesIpv4Cidr">servicesIpv4Cidr</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterTimeoutsOutputReference">ContainerClusterTimeoutsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.tpuIpv4CidrBlock">tpuIpv4CidrBlock</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.verticalPodAutoscaling">verticalPodAutoscaling</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterVerticalPodAutoscalingOutputReference">ContainerClusterVerticalPodAutoscalingOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.workloadIdentityConfig">workloadIdentityConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterWorkloadIdentityConfigOutputReference">ContainerClusterWorkloadIdentityConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.addonsConfigInput">addonsConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig">ContainerClusterAddonsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.authenticatorGroupsConfigInput">authenticatorGroupsConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfig">ContainerClusterAuthenticatorGroupsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.binaryAuthorizationInput">binaryAuthorizationInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization">ContainerClusterBinaryAuthorization</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.clusterAutoscalingInput">clusterAutoscalingInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling">ContainerClusterClusterAutoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.clusterIpv4CidrInput">clusterIpv4CidrInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.confidentialNodesInput">confidentialNodesInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodes">ContainerClusterConfidentialNodes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.costManagementConfigInput">costManagementConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfig">ContainerClusterCostManagementConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.databaseEncryptionInput">databaseEncryptionInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryption">ContainerClusterDatabaseEncryption</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.datapathProviderInput">datapathProviderInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.defaultMaxPodsPerNodeInput">defaultMaxPodsPerNodeInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.defaultSnatStatusInput">defaultSnatStatusInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDefaultSnatStatus">ContainerClusterDefaultSnatStatus</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.descriptionInput">descriptionInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.dnsConfigInput">dnsConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig">ContainerClusterDnsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableAutopilotInput">enableAutopilotInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableBinaryAuthorizationInput">enableBinaryAuthorizationInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableIntranodeVisibilityInput">enableIntranodeVisibilityInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableKubernetesAlphaInput">enableKubernetesAlphaInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableL4IlbSubsettingInput">enableL4IlbSubsettingInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableLegacyAbacInput">enableLegacyAbacInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableShieldedNodesInput">enableShieldedNodesInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableTpuInput">enableTpuInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.gatewayApiConfigInput">gatewayApiConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterGatewayApiConfig">ContainerClusterGatewayApiConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.idInput">idInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.initialNodeCountInput">initialNodeCountInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.ipAllocationPolicyInput">ipAllocationPolicyInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy">ContainerClusterIpAllocationPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.locationInput">locationInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.loggingConfigInput">loggingConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterLoggingConfig">ContainerClusterLoggingConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.loggingServiceInput">loggingServiceInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.maintenancePolicyInput">maintenancePolicyInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy">ContainerClusterMaintenancePolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.masterAuthInput">masterAuthInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuth">ContainerClusterMasterAuth</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.masterAuthorizedNetworksConfigInput">masterAuthorizedNetworksConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfig">ContainerClusterMasterAuthorizedNetworksConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.meshCertificatesInput">meshCertificatesInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMeshCertificates">ContainerClusterMeshCertificates</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.minMasterVersionInput">minMasterVersionInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.monitoringConfigInput">monitoringConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfig">ContainerClusterMonitoringConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.monitoringServiceInput">monitoringServiceInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.nameInput">nameInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.networkingModeInput">networkingModeInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.networkInput">networkInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.networkPolicyInput">networkPolicyInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicy">ContainerClusterNetworkPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.nodeConfigInput">nodeConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig">ContainerClusterNodeConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.nodeLocationsInput">nodeLocationsInput</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.nodePoolDefaultsInput">nodePoolDefaultsInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaults">ContainerClusterNodePoolDefaults</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.nodePoolInput">nodePoolInput</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool">ContainerClusterNodePool</a>></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.nodeVersionInput">nodeVersionInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.notificationConfigInput">notificationConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfig">ContainerClusterNotificationConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.privateClusterConfigInput">privateClusterConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig">ContainerClusterPrivateClusterConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.privateIpv6GoogleAccessInput">privateIpv6GoogleAccessInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.projectInput">projectInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.releaseChannelInput">releaseChannelInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterReleaseChannel">ContainerClusterReleaseChannel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.removeDefaultNodePoolInput">removeDefaultNodePoolInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.resourceLabelsInput">resourceLabelsInput</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.resourceUsageExportConfigInput">resourceUsageExportConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig">ContainerClusterResourceUsageExportConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.serviceExternalIpsConfigInput">serviceExternalIpsConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterServiceExternalIpsConfig">ContainerClusterServiceExternalIpsConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.subnetworkInput">subnetworkInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.timeoutsInput">timeoutsInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterTimeouts">ContainerClusterTimeouts</a> OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.verticalPodAutoscalingInput">verticalPodAutoscalingInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterVerticalPodAutoscaling">ContainerClusterVerticalPodAutoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.workloadIdentityConfigInput">workloadIdentityConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterWorkloadIdentityConfig">ContainerClusterWorkloadIdentityConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.clusterIpv4Cidr">clusterIpv4Cidr</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.datapathProvider">datapathProvider</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.defaultMaxPodsPerNode">defaultMaxPodsPerNode</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.description">description</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableAutopilot">enableAutopilot</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableBinaryAuthorization">enableBinaryAuthorization</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableIntranodeVisibility">enableIntranodeVisibility</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableKubernetesAlpha">enableKubernetesAlpha</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableL4IlbSubsetting">enableL4IlbSubsetting</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableLegacyAbac">enableLegacyAbac</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableShieldedNodes">enableShieldedNodes</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.enableTpu">enableTpu</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.id">id</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.initialNodeCount">initialNodeCount</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.location">location</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.loggingService">loggingService</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.minMasterVersion">minMasterVersion</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.monitoringService">monitoringService</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.name">name</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.network">network</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.networkingMode">networkingMode</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.nodeLocations">nodeLocations</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.nodeVersion">nodeVersion</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.privateIpv6GoogleAccess">privateIpv6GoogleAccess</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.project">project</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.removeDefaultNodePool">removeDefaultNodePool</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.resourceLabels">resourceLabels</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.subnetwork">subnetwork</a></code> | <code>java.lang.String</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.node"></a>

```java
public Node getNode();
```

- *Type:* software.constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.cdktfStack"></a>

```java
public TerraformStack getCdktfStack();
```

- *Type:* com.hashicorp.cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.friendlyUniqueId"></a>

```java
public java.lang.String getFriendlyUniqueId();
```

- *Type:* java.lang.String

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.terraformMetaArguments"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getTerraformMetaArguments();
```

- *Type:* java.util.Map<java.lang.String, java.lang.Object>

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.terraformResourceType"></a>

```java
public java.lang.String getTerraformResourceType();
```

- *Type:* java.lang.String

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.terraformGeneratorMetadata"></a>

```java
public TerraformProviderGeneratorMetadata getTerraformGeneratorMetadata();
```

- *Type:* com.hashicorp.cdktf.TerraformProviderGeneratorMetadata

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.connection"></a>

```java
public java.lang.Object getConnection();
```

- *Type:* com.hashicorp.cdktf.SSHProvisionerConnection OR com.hashicorp.cdktf.WinrmProvisionerConnection

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.count"></a>

```java
public java.lang.Number getCount();
```

- *Type:* java.lang.Number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.dependsOn"></a>

```java
public java.util.List<java.lang.String> getDependsOn();
```

- *Type:* java.util.List<java.lang.String>

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.forEach"></a>

```java
public ITerraformIterator getForEach();
```

- *Type:* com.hashicorp.cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.lifecycle"></a>

```java
public TerraformResourceLifecycle getLifecycle();
```

- *Type:* com.hashicorp.cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.provider"></a>

```java
public TerraformProvider getProvider();
```

- *Type:* com.hashicorp.cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.provisioners"></a>

```java
public java.lang.Object getProvisioners();
```

- *Type:* java.util.List<com.hashicorp.cdktf.FileProvisioner OR com.hashicorp.cdktf.LocalExecProvisioner OR com.hashicorp.cdktf.RemoteExecProvisioner>

---

##### `addonsConfig`<sup>Required</sup> <a name="addonsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.addonsConfig"></a>

```java
public ContainerClusterAddonsConfigOutputReference getAddonsConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference">ContainerClusterAddonsConfigOutputReference</a>

---

##### `authenticatorGroupsConfig`<sup>Required</sup> <a name="authenticatorGroupsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.authenticatorGroupsConfig"></a>

```java
public ContainerClusterAuthenticatorGroupsConfigOutputReference getAuthenticatorGroupsConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference">ContainerClusterAuthenticatorGroupsConfigOutputReference</a>

---

##### `binaryAuthorization`<sup>Required</sup> <a name="binaryAuthorization" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.binaryAuthorization"></a>

```java
public ContainerClusterBinaryAuthorizationOutputReference getBinaryAuthorization();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference">ContainerClusterBinaryAuthorizationOutputReference</a>

---

##### `clusterAutoscaling`<sup>Required</sup> <a name="clusterAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.clusterAutoscaling"></a>

```java
public ContainerClusterClusterAutoscalingOutputReference getClusterAutoscaling();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference">ContainerClusterClusterAutoscalingOutputReference</a>

---

##### `confidentialNodes`<sup>Required</sup> <a name="confidentialNodes" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.confidentialNodes"></a>

```java
public ContainerClusterConfidentialNodesOutputReference getConfidentialNodes();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference">ContainerClusterConfidentialNodesOutputReference</a>

---

##### `costManagementConfig`<sup>Required</sup> <a name="costManagementConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.costManagementConfig"></a>

```java
public ContainerClusterCostManagementConfigOutputReference getCostManagementConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference">ContainerClusterCostManagementConfigOutputReference</a>

---

##### `databaseEncryption`<sup>Required</sup> <a name="databaseEncryption" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.databaseEncryption"></a>

```java
public ContainerClusterDatabaseEncryptionOutputReference getDatabaseEncryption();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference">ContainerClusterDatabaseEncryptionOutputReference</a>

---

##### `defaultSnatStatus`<sup>Required</sup> <a name="defaultSnatStatus" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.defaultSnatStatus"></a>

```java
public ContainerClusterDefaultSnatStatusOutputReference getDefaultSnatStatus();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDefaultSnatStatusOutputReference">ContainerClusterDefaultSnatStatusOutputReference</a>

---

##### `dnsConfig`<sup>Required</sup> <a name="dnsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.dnsConfig"></a>

```java
public ContainerClusterDnsConfigOutputReference getDnsConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDnsConfigOutputReference">ContainerClusterDnsConfigOutputReference</a>

---

##### `endpoint`<sup>Required</sup> <a name="endpoint" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.endpoint"></a>

```java
public java.lang.String getEndpoint();
```

- *Type:* java.lang.String

---

##### `gatewayApiConfig`<sup>Required</sup> <a name="gatewayApiConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.gatewayApiConfig"></a>

```java
public ContainerClusterGatewayApiConfigOutputReference getGatewayApiConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterGatewayApiConfigOutputReference">ContainerClusterGatewayApiConfigOutputReference</a>

---

##### `ipAllocationPolicy`<sup>Required</sup> <a name="ipAllocationPolicy" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.ipAllocationPolicy"></a>

```java
public ContainerClusterIpAllocationPolicyOutputReference getIpAllocationPolicy();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicyOutputReference">ContainerClusterIpAllocationPolicyOutputReference</a>

---

##### `labelFingerprint`<sup>Required</sup> <a name="labelFingerprint" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.labelFingerprint"></a>

```java
public java.lang.String getLabelFingerprint();
```

- *Type:* java.lang.String

---

##### `loggingConfig`<sup>Required</sup> <a name="loggingConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.loggingConfig"></a>

```java
public ContainerClusterLoggingConfigOutputReference getLoggingConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterLoggingConfigOutputReference">ContainerClusterLoggingConfigOutputReference</a>

---

##### `maintenancePolicy`<sup>Required</sup> <a name="maintenancePolicy" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.maintenancePolicy"></a>

```java
public ContainerClusterMaintenancePolicyOutputReference getMaintenancePolicy();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyOutputReference">ContainerClusterMaintenancePolicyOutputReference</a>

---

##### `masterAuth`<sup>Required</sup> <a name="masterAuth" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.masterAuth"></a>

```java
public ContainerClusterMasterAuthOutputReference getMasterAuth();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthOutputReference">ContainerClusterMasterAuthOutputReference</a>

---

##### `masterAuthorizedNetworksConfig`<sup>Required</sup> <a name="masterAuthorizedNetworksConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.masterAuthorizedNetworksConfig"></a>

```java
public ContainerClusterMasterAuthorizedNetworksConfigOutputReference getMasterAuthorizedNetworksConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfigOutputReference">ContainerClusterMasterAuthorizedNetworksConfigOutputReference</a>

---

##### `masterVersion`<sup>Required</sup> <a name="masterVersion" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.masterVersion"></a>

```java
public java.lang.String getMasterVersion();
```

- *Type:* java.lang.String

---

##### `meshCertificates`<sup>Required</sup> <a name="meshCertificates" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.meshCertificates"></a>

```java
public ContainerClusterMeshCertificatesOutputReference getMeshCertificates();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMeshCertificatesOutputReference">ContainerClusterMeshCertificatesOutputReference</a>

---

##### `monitoringConfig`<sup>Required</sup> <a name="monitoringConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.monitoringConfig"></a>

```java
public ContainerClusterMonitoringConfigOutputReference getMonitoringConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfigOutputReference">ContainerClusterMonitoringConfigOutputReference</a>

---

##### `networkPolicy`<sup>Required</sup> <a name="networkPolicy" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.networkPolicy"></a>

```java
public ContainerClusterNetworkPolicyOutputReference getNetworkPolicy();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicyOutputReference">ContainerClusterNetworkPolicyOutputReference</a>

---

##### `nodeConfig`<sup>Required</sup> <a name="nodeConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.nodeConfig"></a>

```java
public ContainerClusterNodeConfigOutputReference getNodeConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigOutputReference">ContainerClusterNodeConfigOutputReference</a>

---

##### `nodePool`<sup>Required</sup> <a name="nodePool" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.nodePool"></a>

```java
public ContainerClusterNodePoolList getNodePool();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolList">ContainerClusterNodePoolList</a>

---

##### `nodePoolDefaults`<sup>Required</sup> <a name="nodePoolDefaults" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.nodePoolDefaults"></a>

```java
public ContainerClusterNodePoolDefaultsOutputReference getNodePoolDefaults();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaultsOutputReference">ContainerClusterNodePoolDefaultsOutputReference</a>

---

##### `notificationConfig`<sup>Required</sup> <a name="notificationConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.notificationConfig"></a>

```java
public ContainerClusterNotificationConfigOutputReference getNotificationConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigOutputReference">ContainerClusterNotificationConfigOutputReference</a>

---

##### `operation`<sup>Required</sup> <a name="operation" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.operation"></a>

```java
public java.lang.String getOperation();
```

- *Type:* java.lang.String

---

##### `privateClusterConfig`<sup>Required</sup> <a name="privateClusterConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.privateClusterConfig"></a>

```java
public ContainerClusterPrivateClusterConfigOutputReference getPrivateClusterConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfigOutputReference">ContainerClusterPrivateClusterConfigOutputReference</a>

---

##### `releaseChannel`<sup>Required</sup> <a name="releaseChannel" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.releaseChannel"></a>

```java
public ContainerClusterReleaseChannelOutputReference getReleaseChannel();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterReleaseChannelOutputReference">ContainerClusterReleaseChannelOutputReference</a>

---

##### `resourceUsageExportConfig`<sup>Required</sup> <a name="resourceUsageExportConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.resourceUsageExportConfig"></a>

```java
public ContainerClusterResourceUsageExportConfigOutputReference getResourceUsageExportConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfigOutputReference">ContainerClusterResourceUsageExportConfigOutputReference</a>

---

##### `selfLink`<sup>Required</sup> <a name="selfLink" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.selfLink"></a>

```java
public java.lang.String getSelfLink();
```

- *Type:* java.lang.String

---

##### `serviceExternalIpsConfig`<sup>Required</sup> <a name="serviceExternalIpsConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.serviceExternalIpsConfig"></a>

```java
public ContainerClusterServiceExternalIpsConfigOutputReference getServiceExternalIpsConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterServiceExternalIpsConfigOutputReference">ContainerClusterServiceExternalIpsConfigOutputReference</a>

---

##### `servicesIpv4Cidr`<sup>Required</sup> <a name="servicesIpv4Cidr" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.servicesIpv4Cidr"></a>

```java
public java.lang.String getServicesIpv4Cidr();
```

- *Type:* java.lang.String

---

##### `timeouts`<sup>Required</sup> <a name="timeouts" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.timeouts"></a>

```java
public ContainerClusterTimeoutsOutputReference getTimeouts();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterTimeoutsOutputReference">ContainerClusterTimeoutsOutputReference</a>

---

##### `tpuIpv4CidrBlock`<sup>Required</sup> <a name="tpuIpv4CidrBlock" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.tpuIpv4CidrBlock"></a>

```java
public java.lang.String getTpuIpv4CidrBlock();
```

- *Type:* java.lang.String

---

##### `verticalPodAutoscaling`<sup>Required</sup> <a name="verticalPodAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.verticalPodAutoscaling"></a>

```java
public ContainerClusterVerticalPodAutoscalingOutputReference getVerticalPodAutoscaling();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterVerticalPodAutoscalingOutputReference">ContainerClusterVerticalPodAutoscalingOutputReference</a>

---

##### `workloadIdentityConfig`<sup>Required</sup> <a name="workloadIdentityConfig" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.workloadIdentityConfig"></a>

```java
public ContainerClusterWorkloadIdentityConfigOutputReference getWorkloadIdentityConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterWorkloadIdentityConfigOutputReference">ContainerClusterWorkloadIdentityConfigOutputReference</a>

---

##### `addonsConfigInput`<sup>Optional</sup> <a name="addonsConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.addonsConfigInput"></a>

```java
public ContainerClusterAddonsConfig getAddonsConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig">ContainerClusterAddonsConfig</a>

---

##### `authenticatorGroupsConfigInput`<sup>Optional</sup> <a name="authenticatorGroupsConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.authenticatorGroupsConfigInput"></a>

```java
public ContainerClusterAuthenticatorGroupsConfig getAuthenticatorGroupsConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfig">ContainerClusterAuthenticatorGroupsConfig</a>

---

##### `binaryAuthorizationInput`<sup>Optional</sup> <a name="binaryAuthorizationInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.binaryAuthorizationInput"></a>

```java
public ContainerClusterBinaryAuthorization getBinaryAuthorizationInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization">ContainerClusterBinaryAuthorization</a>

---

##### `clusterAutoscalingInput`<sup>Optional</sup> <a name="clusterAutoscalingInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.clusterAutoscalingInput"></a>

```java
public ContainerClusterClusterAutoscaling getClusterAutoscalingInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling">ContainerClusterClusterAutoscaling</a>

---

##### `clusterIpv4CidrInput`<sup>Optional</sup> <a name="clusterIpv4CidrInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.clusterIpv4CidrInput"></a>

```java
public java.lang.String getClusterIpv4CidrInput();
```

- *Type:* java.lang.String

---

##### `confidentialNodesInput`<sup>Optional</sup> <a name="confidentialNodesInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.confidentialNodesInput"></a>

```java
public ContainerClusterConfidentialNodes getConfidentialNodesInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodes">ContainerClusterConfidentialNodes</a>

---

##### `costManagementConfigInput`<sup>Optional</sup> <a name="costManagementConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.costManagementConfigInput"></a>

```java
public ContainerClusterCostManagementConfig getCostManagementConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfig">ContainerClusterCostManagementConfig</a>

---

##### `databaseEncryptionInput`<sup>Optional</sup> <a name="databaseEncryptionInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.databaseEncryptionInput"></a>

```java
public ContainerClusterDatabaseEncryption getDatabaseEncryptionInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryption">ContainerClusterDatabaseEncryption</a>

---

##### `datapathProviderInput`<sup>Optional</sup> <a name="datapathProviderInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.datapathProviderInput"></a>

```java
public java.lang.String getDatapathProviderInput();
```

- *Type:* java.lang.String

---

##### `defaultMaxPodsPerNodeInput`<sup>Optional</sup> <a name="defaultMaxPodsPerNodeInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.defaultMaxPodsPerNodeInput"></a>

```java
public java.lang.Number getDefaultMaxPodsPerNodeInput();
```

- *Type:* java.lang.Number

---

##### `defaultSnatStatusInput`<sup>Optional</sup> <a name="defaultSnatStatusInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.defaultSnatStatusInput"></a>

```java
public ContainerClusterDefaultSnatStatus getDefaultSnatStatusInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDefaultSnatStatus">ContainerClusterDefaultSnatStatus</a>

---

##### `descriptionInput`<sup>Optional</sup> <a name="descriptionInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.descriptionInput"></a>

```java
public java.lang.String getDescriptionInput();
```

- *Type:* java.lang.String

---

##### `dnsConfigInput`<sup>Optional</sup> <a name="dnsConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.dnsConfigInput"></a>

```java
public ContainerClusterDnsConfig getDnsConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig">ContainerClusterDnsConfig</a>

---

##### `enableAutopilotInput`<sup>Optional</sup> <a name="enableAutopilotInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableAutopilotInput"></a>

```java
public java.lang.Object getEnableAutopilotInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableBinaryAuthorizationInput`<sup>Optional</sup> <a name="enableBinaryAuthorizationInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableBinaryAuthorizationInput"></a>

```java
public java.lang.Object getEnableBinaryAuthorizationInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableIntranodeVisibilityInput`<sup>Optional</sup> <a name="enableIntranodeVisibilityInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableIntranodeVisibilityInput"></a>

```java
public java.lang.Object getEnableIntranodeVisibilityInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableKubernetesAlphaInput`<sup>Optional</sup> <a name="enableKubernetesAlphaInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableKubernetesAlphaInput"></a>

```java
public java.lang.Object getEnableKubernetesAlphaInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableL4IlbSubsettingInput`<sup>Optional</sup> <a name="enableL4IlbSubsettingInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableL4IlbSubsettingInput"></a>

```java
public java.lang.Object getEnableL4IlbSubsettingInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableLegacyAbacInput`<sup>Optional</sup> <a name="enableLegacyAbacInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableLegacyAbacInput"></a>

```java
public java.lang.Object getEnableLegacyAbacInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableShieldedNodesInput`<sup>Optional</sup> <a name="enableShieldedNodesInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableShieldedNodesInput"></a>

```java
public java.lang.Object getEnableShieldedNodesInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableTpuInput`<sup>Optional</sup> <a name="enableTpuInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableTpuInput"></a>

```java
public java.lang.Object getEnableTpuInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `gatewayApiConfigInput`<sup>Optional</sup> <a name="gatewayApiConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.gatewayApiConfigInput"></a>

```java
public ContainerClusterGatewayApiConfig getGatewayApiConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterGatewayApiConfig">ContainerClusterGatewayApiConfig</a>

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.idInput"></a>

```java
public java.lang.String getIdInput();
```

- *Type:* java.lang.String

---

##### `initialNodeCountInput`<sup>Optional</sup> <a name="initialNodeCountInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.initialNodeCountInput"></a>

```java
public java.lang.Number getInitialNodeCountInput();
```

- *Type:* java.lang.Number

---

##### `ipAllocationPolicyInput`<sup>Optional</sup> <a name="ipAllocationPolicyInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.ipAllocationPolicyInput"></a>

```java
public ContainerClusterIpAllocationPolicy getIpAllocationPolicyInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy">ContainerClusterIpAllocationPolicy</a>

---

##### `locationInput`<sup>Optional</sup> <a name="locationInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.locationInput"></a>

```java
public java.lang.String getLocationInput();
```

- *Type:* java.lang.String

---

##### `loggingConfigInput`<sup>Optional</sup> <a name="loggingConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.loggingConfigInput"></a>

```java
public ContainerClusterLoggingConfig getLoggingConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterLoggingConfig">ContainerClusterLoggingConfig</a>

---

##### `loggingServiceInput`<sup>Optional</sup> <a name="loggingServiceInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.loggingServiceInput"></a>

```java
public java.lang.String getLoggingServiceInput();
```

- *Type:* java.lang.String

---

##### `maintenancePolicyInput`<sup>Optional</sup> <a name="maintenancePolicyInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.maintenancePolicyInput"></a>

```java
public ContainerClusterMaintenancePolicy getMaintenancePolicyInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy">ContainerClusterMaintenancePolicy</a>

---

##### `masterAuthInput`<sup>Optional</sup> <a name="masterAuthInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.masterAuthInput"></a>

```java
public ContainerClusterMasterAuth getMasterAuthInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuth">ContainerClusterMasterAuth</a>

---

##### `masterAuthorizedNetworksConfigInput`<sup>Optional</sup> <a name="masterAuthorizedNetworksConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.masterAuthorizedNetworksConfigInput"></a>

```java
public ContainerClusterMasterAuthorizedNetworksConfig getMasterAuthorizedNetworksConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfig">ContainerClusterMasterAuthorizedNetworksConfig</a>

---

##### `meshCertificatesInput`<sup>Optional</sup> <a name="meshCertificatesInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.meshCertificatesInput"></a>

```java
public ContainerClusterMeshCertificates getMeshCertificatesInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMeshCertificates">ContainerClusterMeshCertificates</a>

---

##### `minMasterVersionInput`<sup>Optional</sup> <a name="minMasterVersionInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.minMasterVersionInput"></a>

```java
public java.lang.String getMinMasterVersionInput();
```

- *Type:* java.lang.String

---

##### `monitoringConfigInput`<sup>Optional</sup> <a name="monitoringConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.monitoringConfigInput"></a>

```java
public ContainerClusterMonitoringConfig getMonitoringConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfig">ContainerClusterMonitoringConfig</a>

---

##### `monitoringServiceInput`<sup>Optional</sup> <a name="monitoringServiceInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.monitoringServiceInput"></a>

```java
public java.lang.String getMonitoringServiceInput();
```

- *Type:* java.lang.String

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.nameInput"></a>

```java
public java.lang.String getNameInput();
```

- *Type:* java.lang.String

---

##### `networkingModeInput`<sup>Optional</sup> <a name="networkingModeInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.networkingModeInput"></a>

```java
public java.lang.String getNetworkingModeInput();
```

- *Type:* java.lang.String

---

##### `networkInput`<sup>Optional</sup> <a name="networkInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.networkInput"></a>

```java
public java.lang.String getNetworkInput();
```

- *Type:* java.lang.String

---

##### `networkPolicyInput`<sup>Optional</sup> <a name="networkPolicyInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.networkPolicyInput"></a>

```java
public ContainerClusterNetworkPolicy getNetworkPolicyInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicy">ContainerClusterNetworkPolicy</a>

---

##### `nodeConfigInput`<sup>Optional</sup> <a name="nodeConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.nodeConfigInput"></a>

```java
public ContainerClusterNodeConfig getNodeConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig">ContainerClusterNodeConfig</a>

---

##### `nodeLocationsInput`<sup>Optional</sup> <a name="nodeLocationsInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.nodeLocationsInput"></a>

```java
public java.util.List<java.lang.String> getNodeLocationsInput();
```

- *Type:* java.util.List<java.lang.String>

---

##### `nodePoolDefaultsInput`<sup>Optional</sup> <a name="nodePoolDefaultsInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.nodePoolDefaultsInput"></a>

```java
public ContainerClusterNodePoolDefaults getNodePoolDefaultsInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaults">ContainerClusterNodePoolDefaults</a>

---

##### `nodePoolInput`<sup>Optional</sup> <a name="nodePoolInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.nodePoolInput"></a>

```java
public java.lang.Object getNodePoolInput();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool">ContainerClusterNodePool</a>>

---

##### `nodeVersionInput`<sup>Optional</sup> <a name="nodeVersionInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.nodeVersionInput"></a>

```java
public java.lang.String getNodeVersionInput();
```

- *Type:* java.lang.String

---

##### `notificationConfigInput`<sup>Optional</sup> <a name="notificationConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.notificationConfigInput"></a>

```java
public ContainerClusterNotificationConfig getNotificationConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfig">ContainerClusterNotificationConfig</a>

---

##### `privateClusterConfigInput`<sup>Optional</sup> <a name="privateClusterConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.privateClusterConfigInput"></a>

```java
public ContainerClusterPrivateClusterConfig getPrivateClusterConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig">ContainerClusterPrivateClusterConfig</a>

---

##### `privateIpv6GoogleAccessInput`<sup>Optional</sup> <a name="privateIpv6GoogleAccessInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.privateIpv6GoogleAccessInput"></a>

```java
public java.lang.String getPrivateIpv6GoogleAccessInput();
```

- *Type:* java.lang.String

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.projectInput"></a>

```java
public java.lang.String getProjectInput();
```

- *Type:* java.lang.String

---

##### `releaseChannelInput`<sup>Optional</sup> <a name="releaseChannelInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.releaseChannelInput"></a>

```java
public ContainerClusterReleaseChannel getReleaseChannelInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterReleaseChannel">ContainerClusterReleaseChannel</a>

---

##### `removeDefaultNodePoolInput`<sup>Optional</sup> <a name="removeDefaultNodePoolInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.removeDefaultNodePoolInput"></a>

```java
public java.lang.Object getRemoveDefaultNodePoolInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `resourceLabelsInput`<sup>Optional</sup> <a name="resourceLabelsInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.resourceLabelsInput"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getResourceLabelsInput();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

---

##### `resourceUsageExportConfigInput`<sup>Optional</sup> <a name="resourceUsageExportConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.resourceUsageExportConfigInput"></a>

```java
public ContainerClusterResourceUsageExportConfig getResourceUsageExportConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig">ContainerClusterResourceUsageExportConfig</a>

---

##### `serviceExternalIpsConfigInput`<sup>Optional</sup> <a name="serviceExternalIpsConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.serviceExternalIpsConfigInput"></a>

```java
public ContainerClusterServiceExternalIpsConfig getServiceExternalIpsConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterServiceExternalIpsConfig">ContainerClusterServiceExternalIpsConfig</a>

---

##### `subnetworkInput`<sup>Optional</sup> <a name="subnetworkInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.subnetworkInput"></a>

```java
public java.lang.String getSubnetworkInput();
```

- *Type:* java.lang.String

---

##### `timeoutsInput`<sup>Optional</sup> <a name="timeoutsInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.timeoutsInput"></a>

```java
public java.lang.Object getTimeoutsInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterTimeouts">ContainerClusterTimeouts</a> OR com.hashicorp.cdktf.IResolvable

---

##### `verticalPodAutoscalingInput`<sup>Optional</sup> <a name="verticalPodAutoscalingInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.verticalPodAutoscalingInput"></a>

```java
public ContainerClusterVerticalPodAutoscaling getVerticalPodAutoscalingInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterVerticalPodAutoscaling">ContainerClusterVerticalPodAutoscaling</a>

---

##### `workloadIdentityConfigInput`<sup>Optional</sup> <a name="workloadIdentityConfigInput" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.workloadIdentityConfigInput"></a>

```java
public ContainerClusterWorkloadIdentityConfig getWorkloadIdentityConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterWorkloadIdentityConfig">ContainerClusterWorkloadIdentityConfig</a>

---

##### `clusterIpv4Cidr`<sup>Required</sup> <a name="clusterIpv4Cidr" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.clusterIpv4Cidr"></a>

```java
public java.lang.String getClusterIpv4Cidr();
```

- *Type:* java.lang.String

---

##### `datapathProvider`<sup>Required</sup> <a name="datapathProvider" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.datapathProvider"></a>

```java
public java.lang.String getDatapathProvider();
```

- *Type:* java.lang.String

---

##### `defaultMaxPodsPerNode`<sup>Required</sup> <a name="defaultMaxPodsPerNode" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.defaultMaxPodsPerNode"></a>

```java
public java.lang.Number getDefaultMaxPodsPerNode();
```

- *Type:* java.lang.Number

---

##### `description`<sup>Required</sup> <a name="description" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String

---

##### `enableAutopilot`<sup>Required</sup> <a name="enableAutopilot" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableAutopilot"></a>

```java
public java.lang.Object getEnableAutopilot();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableBinaryAuthorization`<sup>Required</sup> <a name="enableBinaryAuthorization" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableBinaryAuthorization"></a>

```java
public java.lang.Object getEnableBinaryAuthorization();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableIntranodeVisibility`<sup>Required</sup> <a name="enableIntranodeVisibility" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableIntranodeVisibility"></a>

```java
public java.lang.Object getEnableIntranodeVisibility();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableKubernetesAlpha`<sup>Required</sup> <a name="enableKubernetesAlpha" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableKubernetesAlpha"></a>

```java
public java.lang.Object getEnableKubernetesAlpha();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableL4IlbSubsetting`<sup>Required</sup> <a name="enableL4IlbSubsetting" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableL4IlbSubsetting"></a>

```java
public java.lang.Object getEnableL4IlbSubsetting();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableLegacyAbac`<sup>Required</sup> <a name="enableLegacyAbac" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableLegacyAbac"></a>

```java
public java.lang.Object getEnableLegacyAbac();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableShieldedNodes`<sup>Required</sup> <a name="enableShieldedNodes" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableShieldedNodes"></a>

```java
public java.lang.Object getEnableShieldedNodes();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableTpu`<sup>Required</sup> <a name="enableTpu" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.enableTpu"></a>

```java
public java.lang.Object getEnableTpu();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.id"></a>

```java
public java.lang.String getId();
```

- *Type:* java.lang.String

---

##### `initialNodeCount`<sup>Required</sup> <a name="initialNodeCount" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.initialNodeCount"></a>

```java
public java.lang.Number getInitialNodeCount();
```

- *Type:* java.lang.Number

---

##### `location`<sup>Required</sup> <a name="location" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.location"></a>

```java
public java.lang.String getLocation();
```

- *Type:* java.lang.String

---

##### `loggingService`<sup>Required</sup> <a name="loggingService" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.loggingService"></a>

```java
public java.lang.String getLoggingService();
```

- *Type:* java.lang.String

---

##### `minMasterVersion`<sup>Required</sup> <a name="minMasterVersion" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.minMasterVersion"></a>

```java
public java.lang.String getMinMasterVersion();
```

- *Type:* java.lang.String

---

##### `monitoringService`<sup>Required</sup> <a name="monitoringService" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.monitoringService"></a>

```java
public java.lang.String getMonitoringService();
```

- *Type:* java.lang.String

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

---

##### `network`<sup>Required</sup> <a name="network" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.network"></a>

```java
public java.lang.String getNetwork();
```

- *Type:* java.lang.String

---

##### `networkingMode`<sup>Required</sup> <a name="networkingMode" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.networkingMode"></a>

```java
public java.lang.String getNetworkingMode();
```

- *Type:* java.lang.String

---

##### `nodeLocations`<sup>Required</sup> <a name="nodeLocations" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.nodeLocations"></a>

```java
public java.util.List<java.lang.String> getNodeLocations();
```

- *Type:* java.util.List<java.lang.String>

---

##### `nodeVersion`<sup>Required</sup> <a name="nodeVersion" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.nodeVersion"></a>

```java
public java.lang.String getNodeVersion();
```

- *Type:* java.lang.String

---

##### `privateIpv6GoogleAccess`<sup>Required</sup> <a name="privateIpv6GoogleAccess" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.privateIpv6GoogleAccess"></a>

```java
public java.lang.String getPrivateIpv6GoogleAccess();
```

- *Type:* java.lang.String

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.project"></a>

```java
public java.lang.String getProject();
```

- *Type:* java.lang.String

---

##### `removeDefaultNodePool`<sup>Required</sup> <a name="removeDefaultNodePool" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.removeDefaultNodePool"></a>

```java
public java.lang.Object getRemoveDefaultNodePool();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `resourceLabels`<sup>Required</sup> <a name="resourceLabels" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.resourceLabels"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getResourceLabels();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

---

##### `subnetwork`<sup>Required</sup> <a name="subnetwork" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.subnetwork"></a>

```java
public java.lang.String getSubnetwork();
```

- *Type:* java.lang.String

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerCluster.property.tfResourceType">tfResourceType</a></code> | <code>java.lang.String</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-google.containerCluster.ContainerCluster.property.tfResourceType"></a>

```java
public java.lang.String getTfResourceType();
```

- *Type:* java.lang.String

---

## Structs <a name="Structs" id="Structs"></a>

### ContainerClusterAddonsConfig <a name="ContainerClusterAddonsConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfig;

ContainerClusterAddonsConfig.builder()
//  .cloudrunConfig(ContainerClusterAddonsConfigCloudrunConfig)
//  .configConnectorConfig(ContainerClusterAddonsConfigConfigConnectorConfig)
//  .dnsCacheConfig(ContainerClusterAddonsConfigDnsCacheConfig)
//  .gcePersistentDiskCsiDriverConfig(ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig)
//  .gcpFilestoreCsiDriverConfig(ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig)
//  .gkeBackupAgentConfig(ContainerClusterAddonsConfigGkeBackupAgentConfig)
//  .horizontalPodAutoscaling(ContainerClusterAddonsConfigHorizontalPodAutoscaling)
//  .httpLoadBalancing(ContainerClusterAddonsConfigHttpLoadBalancing)
//  .networkPolicyConfig(ContainerClusterAddonsConfigNetworkPolicyConfig)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.cloudrunConfig">cloudrunConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfig">ContainerClusterAddonsConfigCloudrunConfig</a></code> | cloudrun_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.configConnectorConfig">configConnectorConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfig">ContainerClusterAddonsConfigConfigConnectorConfig</a></code> | config_connector_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.dnsCacheConfig">dnsCacheConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfig">ContainerClusterAddonsConfigDnsCacheConfig</a></code> | dns_cache_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.gcePersistentDiskCsiDriverConfig">gcePersistentDiskCsiDriverConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a></code> | gce_persistent_disk_csi_driver_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.gcpFilestoreCsiDriverConfig">gcpFilestoreCsiDriverConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a></code> | gcp_filestore_csi_driver_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.gkeBackupAgentConfig">gkeBackupAgentConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfig">ContainerClusterAddonsConfigGkeBackupAgentConfig</a></code> | gke_backup_agent_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.horizontalPodAutoscaling">horizontalPodAutoscaling</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscaling">ContainerClusterAddonsConfigHorizontalPodAutoscaling</a></code> | horizontal_pod_autoscaling block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.httpLoadBalancing">httpLoadBalancing</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancing">ContainerClusterAddonsConfigHttpLoadBalancing</a></code> | http_load_balancing block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.networkPolicyConfig">networkPolicyConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfig">ContainerClusterAddonsConfigNetworkPolicyConfig</a></code> | network_policy_config block. |

---

##### `cloudrunConfig`<sup>Optional</sup> <a name="cloudrunConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.cloudrunConfig"></a>

```java
public ContainerClusterAddonsConfigCloudrunConfig getCloudrunConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfig">ContainerClusterAddonsConfigCloudrunConfig</a>

cloudrun_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cloudrun_config ContainerCluster#cloudrun_config}

---

##### `configConnectorConfig`<sup>Optional</sup> <a name="configConnectorConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.configConnectorConfig"></a>

```java
public ContainerClusterAddonsConfigConfigConnectorConfig getConfigConnectorConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfig">ContainerClusterAddonsConfigConfigConnectorConfig</a>

config_connector_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#config_connector_config ContainerCluster#config_connector_config}

---

##### `dnsCacheConfig`<sup>Optional</sup> <a name="dnsCacheConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.dnsCacheConfig"></a>

```java
public ContainerClusterAddonsConfigDnsCacheConfig getDnsCacheConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfig">ContainerClusterAddonsConfigDnsCacheConfig</a>

dns_cache_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#dns_cache_config ContainerCluster#dns_cache_config}

---

##### `gcePersistentDiskCsiDriverConfig`<sup>Optional</sup> <a name="gcePersistentDiskCsiDriverConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.gcePersistentDiskCsiDriverConfig"></a>

```java
public ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig getGcePersistentDiskCsiDriverConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a>

gce_persistent_disk_csi_driver_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gce_persistent_disk_csi_driver_config ContainerCluster#gce_persistent_disk_csi_driver_config}

---

##### `gcpFilestoreCsiDriverConfig`<sup>Optional</sup> <a name="gcpFilestoreCsiDriverConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.gcpFilestoreCsiDriverConfig"></a>

```java
public ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig getGcpFilestoreCsiDriverConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a>

gcp_filestore_csi_driver_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gcp_filestore_csi_driver_config ContainerCluster#gcp_filestore_csi_driver_config}

---

##### `gkeBackupAgentConfig`<sup>Optional</sup> <a name="gkeBackupAgentConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.gkeBackupAgentConfig"></a>

```java
public ContainerClusterAddonsConfigGkeBackupAgentConfig getGkeBackupAgentConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfig">ContainerClusterAddonsConfigGkeBackupAgentConfig</a>

gke_backup_agent_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gke_backup_agent_config ContainerCluster#gke_backup_agent_config}

---

##### `horizontalPodAutoscaling`<sup>Optional</sup> <a name="horizontalPodAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.horizontalPodAutoscaling"></a>

```java
public ContainerClusterAddonsConfigHorizontalPodAutoscaling getHorizontalPodAutoscaling();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscaling">ContainerClusterAddonsConfigHorizontalPodAutoscaling</a>

horizontal_pod_autoscaling block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#horizontal_pod_autoscaling ContainerCluster#horizontal_pod_autoscaling}

---

##### `httpLoadBalancing`<sup>Optional</sup> <a name="httpLoadBalancing" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.httpLoadBalancing"></a>

```java
public ContainerClusterAddonsConfigHttpLoadBalancing getHttpLoadBalancing();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancing">ContainerClusterAddonsConfigHttpLoadBalancing</a>

http_load_balancing block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#http_load_balancing ContainerCluster#http_load_balancing}

---

##### `networkPolicyConfig`<sup>Optional</sup> <a name="networkPolicyConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig.property.networkPolicyConfig"></a>

```java
public ContainerClusterAddonsConfigNetworkPolicyConfig getNetworkPolicyConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfig">ContainerClusterAddonsConfigNetworkPolicyConfig</a>

network_policy_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#network_policy_config ContainerCluster#network_policy_config}

---

### ContainerClusterAddonsConfigCloudrunConfig <a name="ContainerClusterAddonsConfigCloudrunConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigCloudrunConfig;

ContainerClusterAddonsConfigCloudrunConfig.builder()
    .disabled(java.lang.Boolean)
    .disabled(IResolvable)
//  .loadBalancerType(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfig.property.disabled">disabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfig.property.loadBalancerType">loadBalancerType</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#load_balancer_type ContainerCluster#load_balancer_type}. |

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfig.property.disabled"></a>

```java
public java.lang.Object getDisabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}.

---

##### `loadBalancerType`<sup>Optional</sup> <a name="loadBalancerType" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfig.property.loadBalancerType"></a>

```java
public java.lang.String getLoadBalancerType();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#load_balancer_type ContainerCluster#load_balancer_type}.

---

### ContainerClusterAddonsConfigConfigConnectorConfig <a name="ContainerClusterAddonsConfigConfigConnectorConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigConfigConnectorConfig;

ContainerClusterAddonsConfigConfigConnectorConfig.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfig.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfig.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}.

---

### ContainerClusterAddonsConfigDnsCacheConfig <a name="ContainerClusterAddonsConfigDnsCacheConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigDnsCacheConfig;

ContainerClusterAddonsConfigDnsCacheConfig.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfig.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfig.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}.

---

### ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig <a name="ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig;

ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}.

---

### ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig <a name="ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig;

ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}.

---

### ContainerClusterAddonsConfigGkeBackupAgentConfig <a name="ContainerClusterAddonsConfigGkeBackupAgentConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigGkeBackupAgentConfig;

ContainerClusterAddonsConfigGkeBackupAgentConfig.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfig.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfig.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}.

---

### ContainerClusterAddonsConfigHorizontalPodAutoscaling <a name="ContainerClusterAddonsConfigHorizontalPodAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscaling"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscaling.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigHorizontalPodAutoscaling;

ContainerClusterAddonsConfigHorizontalPodAutoscaling.builder()
    .disabled(java.lang.Boolean)
    .disabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscaling.property.disabled">disabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}. |

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscaling.property.disabled"></a>

```java
public java.lang.Object getDisabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}.

---

### ContainerClusterAddonsConfigHttpLoadBalancing <a name="ContainerClusterAddonsConfigHttpLoadBalancing" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancing"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancing.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigHttpLoadBalancing;

ContainerClusterAddonsConfigHttpLoadBalancing.builder()
    .disabled(java.lang.Boolean)
    .disabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancing.property.disabled">disabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}. |

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancing.property.disabled"></a>

```java
public java.lang.Object getDisabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}.

---

### ContainerClusterAddonsConfigNetworkPolicyConfig <a name="ContainerClusterAddonsConfigNetworkPolicyConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigNetworkPolicyConfig;

ContainerClusterAddonsConfigNetworkPolicyConfig.builder()
    .disabled(java.lang.Boolean)
    .disabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfig.property.disabled">disabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}. |

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfig.property.disabled"></a>

```java
public java.lang.Object getDisabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}.

---

### ContainerClusterAuthenticatorGroupsConfig <a name="ContainerClusterAuthenticatorGroupsConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAuthenticatorGroupsConfig;

ContainerClusterAuthenticatorGroupsConfig.builder()
    .securityGroup(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfig.property.securityGroup">securityGroup</a></code> | <code>java.lang.String</code> | The name of the RBAC security group for use with Google security groups in Kubernetes RBAC. |

---

##### `securityGroup`<sup>Required</sup> <a name="securityGroup" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfig.property.securityGroup"></a>

```java
public java.lang.String getSecurityGroup();
```

- *Type:* java.lang.String

The name of the RBAC security group for use with Google security groups in Kubernetes RBAC.

Group name must be in format gke-security-groups@yourdomain.com.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#security_group ContainerCluster#security_group}

---

### ContainerClusterBinaryAuthorization <a name="ContainerClusterBinaryAuthorization" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterBinaryAuthorization;

ContainerClusterBinaryAuthorization.builder()
//  .enabled(java.lang.Boolean)
//  .enabled(IResolvable)
//  .evaluationMode(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Enable Binary Authorization for this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization.property.evaluationMode">evaluationMode</a></code> | <code>java.lang.String</code> | Mode of operation for Binary Authorization policy evaluation. |

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Enable Binary Authorization for this cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

##### `evaluationMode`<sup>Optional</sup> <a name="evaluationMode" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization.property.evaluationMode"></a>

```java
public java.lang.String getEvaluationMode();
```

- *Type:* java.lang.String

Mode of operation for Binary Authorization policy evaluation.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#evaluation_mode ContainerCluster#evaluation_mode}

---

### ContainerClusterClusterAutoscaling <a name="ContainerClusterClusterAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscaling;

ContainerClusterClusterAutoscaling.builder()
//  .autoProvisioningDefaults(ContainerClusterClusterAutoscalingAutoProvisioningDefaults)
//  .enabled(java.lang.Boolean)
//  .enabled(IResolvable)
//  .resourceLimits(IResolvable)
//  .resourceLimits(java.util.List<ContainerClusterClusterAutoscalingResourceLimits>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling.property.autoProvisioningDefaults">autoProvisioningDefaults</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults">ContainerClusterClusterAutoscalingAutoProvisioningDefaults</a></code> | auto_provisioning_defaults block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether node auto-provisioning is enabled. Resource limits for cpu and memory must be defined to enable node auto-provisioning. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling.property.resourceLimits">resourceLimits</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits">ContainerClusterClusterAutoscalingResourceLimits</a>></code> | resource_limits block. |

---

##### `autoProvisioningDefaults`<sup>Optional</sup> <a name="autoProvisioningDefaults" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling.property.autoProvisioningDefaults"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaults getAutoProvisioningDefaults();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults">ContainerClusterClusterAutoscalingAutoProvisioningDefaults</a>

auto_provisioning_defaults block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#auto_provisioning_defaults ContainerCluster#auto_provisioning_defaults}

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether node auto-provisioning is enabled. Resource limits for cpu and memory must be defined to enable node auto-provisioning.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

##### `resourceLimits`<sup>Optional</sup> <a name="resourceLimits" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling.property.resourceLimits"></a>

```java
public java.lang.Object getResourceLimits();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits">ContainerClusterClusterAutoscalingResourceLimits</a>>

resource_limits block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_limits ContainerCluster#resource_limits}

---

### ContainerClusterClusterAutoscalingAutoProvisioningDefaults <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaults" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults;

ContainerClusterClusterAutoscalingAutoProvisioningDefaults.builder()
//  .bootDiskKmsKey(java.lang.String)
//  .diskSize(java.lang.Number)
//  .diskType(java.lang.String)
//  .imageType(java.lang.String)
//  .management(ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement)
//  .minCpuPlatform(java.lang.String)
//  .oauthScopes(java.util.List<java.lang.String>)
//  .serviceAccount(java.lang.String)
//  .shieldedInstanceConfig(ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig)
//  .upgradeSettings(ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.bootDiskKmsKey">bootDiskKmsKey</a></code> | <code>java.lang.String</code> | The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.diskSize">diskSize</a></code> | <code>java.lang.Number</code> | Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.diskType">diskType</a></code> | <code>java.lang.String</code> | Type of the disk attached to each node. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.imageType">imageType</a></code> | <code>java.lang.String</code> | The default image type used by NAP once a new node pool is being created. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.management">management</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement</a></code> | management block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.minCpuPlatform">minCpuPlatform</a></code> | <code>java.lang.String</code> | Minimum CPU platform to be used by this instance. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.oauthScopes">oauthScopes</a></code> | <code>java.util.List<java.lang.String></code> | Scopes that are used by NAP when creating node pools. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.serviceAccount">serviceAccount</a></code> | <code>java.lang.String</code> | The Google Cloud Platform Service Account to be used by the node VMs. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.shieldedInstanceConfig">shieldedInstanceConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig</a></code> | shielded_instance_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.upgradeSettings">upgradeSettings</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings</a></code> | upgrade_settings block. |

---

##### `bootDiskKmsKey`<sup>Optional</sup> <a name="bootDiskKmsKey" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.bootDiskKmsKey"></a>

```java
public java.lang.String getBootDiskKmsKey();
```

- *Type:* java.lang.String

The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#boot_disk_kms_key ContainerCluster#boot_disk_kms_key}

---

##### `diskSize`<sup>Optional</sup> <a name="diskSize" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.diskSize"></a>

```java
public java.lang.Number getDiskSize();
```

- *Type:* java.lang.Number

Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_size ContainerCluster#disk_size}

---

##### `diskType`<sup>Optional</sup> <a name="diskType" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.diskType"></a>

```java
public java.lang.String getDiskType();
```

- *Type:* java.lang.String

Type of the disk attached to each node.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_type ContainerCluster#disk_type}

---

##### `imageType`<sup>Optional</sup> <a name="imageType" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.imageType"></a>

```java
public java.lang.String getImageType();
```

- *Type:* java.lang.String

The default image type used by NAP once a new node pool is being created.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#image_type ContainerCluster#image_type}

---

##### `management`<sup>Optional</sup> <a name="management" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.management"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement getManagement();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement</a>

management block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#management ContainerCluster#management}

---

##### `minCpuPlatform`<sup>Optional</sup> <a name="minCpuPlatform" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.minCpuPlatform"></a>

```java
public java.lang.String getMinCpuPlatform();
```

- *Type:* java.lang.String

Minimum CPU platform to be used by this instance.

The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as Intel Haswell.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_cpu_platform ContainerCluster#min_cpu_platform}

---

##### `oauthScopes`<sup>Optional</sup> <a name="oauthScopes" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.oauthScopes"></a>

```java
public java.util.List<java.lang.String> getOauthScopes();
```

- *Type:* java.util.List<java.lang.String>

Scopes that are used by NAP when creating node pools.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#oauth_scopes ContainerCluster#oauth_scopes}

---

##### `serviceAccount`<sup>Optional</sup> <a name="serviceAccount" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.serviceAccount"></a>

```java
public java.lang.String getServiceAccount();
```

- *Type:* java.lang.String

The Google Cloud Platform Service Account to be used by the node VMs.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#service_account ContainerCluster#service_account}

---

##### `shieldedInstanceConfig`<sup>Optional</sup> <a name="shieldedInstanceConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.shieldedInstanceConfig"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig getShieldedInstanceConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig</a>

shielded_instance_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#shielded_instance_config ContainerCluster#shielded_instance_config}

---

##### `upgradeSettings`<sup>Optional</sup> <a name="upgradeSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults.property.upgradeSettings"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings getUpgradeSettings();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings</a>

upgrade_settings block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#upgrade_settings ContainerCluster#upgrade_settings}

---

### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement;

ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement.builder()
//  .autoRepair(java.lang.Boolean)
//  .autoRepair(IResolvable)
//  .autoUpgrade(java.lang.Boolean)
//  .autoUpgrade(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement.property.autoRepair">autoRepair</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Specifies whether the node auto-repair is enabled for the node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement.property.autoUpgrade">autoUpgrade</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Specifies whether node auto-upgrade is enabled for the node pool. |

---

##### `autoRepair`<sup>Optional</sup> <a name="autoRepair" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement.property.autoRepair"></a>

```java
public java.lang.Object getAutoRepair();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Specifies whether the node auto-repair is enabled for the node pool.

If enabled, the nodes in this node pool will be monitored and, if they fail health checks too many times, an automatic repair action will be triggered.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#auto_repair ContainerCluster#auto_repair}

---

##### `autoUpgrade`<sup>Optional</sup> <a name="autoUpgrade" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement.property.autoUpgrade"></a>

```java
public java.lang.Object getAutoUpgrade();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Specifies whether node auto-upgrade is enabled for the node pool.

If enabled, node auto-upgrade helps keep the nodes in your node pool up to date with the latest release version of Kubernetes.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#auto_upgrade ContainerCluster#auto_upgrade}

---

### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions;

ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions.builder()
    .build();
```


### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig;

ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig.builder()
//  .enableIntegrityMonitoring(java.lang.Boolean)
//  .enableIntegrityMonitoring(IResolvable)
//  .enableSecureBoot(java.lang.Boolean)
//  .enableSecureBoot(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig.property.enableIntegrityMonitoring">enableIntegrityMonitoring</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Defines whether the instance has integrity monitoring enabled. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig.property.enableSecureBoot">enableSecureBoot</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Defines whether the instance has Secure Boot enabled. |

---

##### `enableIntegrityMonitoring`<sup>Optional</sup> <a name="enableIntegrityMonitoring" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig.property.enableIntegrityMonitoring"></a>

```java
public java.lang.Object getEnableIntegrityMonitoring();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Defines whether the instance has integrity monitoring enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_integrity_monitoring ContainerCluster#enable_integrity_monitoring}

---

##### `enableSecureBoot`<sup>Optional</sup> <a name="enableSecureBoot" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig.property.enableSecureBoot"></a>

```java
public java.lang.Object getEnableSecureBoot();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Defines whether the instance has Secure Boot enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_secure_boot ContainerCluster#enable_secure_boot}

---

### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings;

ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.builder()
//  .blueGreenSettings(ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings)
//  .maxSurge(java.lang.Number)
//  .maxUnavailable(java.lang.Number)
//  .strategy(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.blueGreenSettings">blueGreenSettings</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings</a></code> | blue_green_settings block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.maxSurge">maxSurge</a></code> | <code>java.lang.Number</code> | The maximum number of nodes that can be created beyond the current size of the node pool during the upgrade process. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.maxUnavailable">maxUnavailable</a></code> | <code>java.lang.Number</code> | The maximum number of nodes that can be simultaneously unavailable during the upgrade process. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.strategy">strategy</a></code> | <code>java.lang.String</code> | Update strategy of the node pool. |

---

##### `blueGreenSettings`<sup>Optional</sup> <a name="blueGreenSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.blueGreenSettings"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings getBlueGreenSettings();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings</a>

blue_green_settings block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#blue_green_settings ContainerCluster#blue_green_settings}

---

##### `maxSurge`<sup>Optional</sup> <a name="maxSurge" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.maxSurge"></a>

```java
public java.lang.Number getMaxSurge();
```

- *Type:* java.lang.Number

The maximum number of nodes that can be created beyond the current size of the node pool during the upgrade process.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_surge ContainerCluster#max_surge}

---

##### `maxUnavailable`<sup>Optional</sup> <a name="maxUnavailable" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.maxUnavailable"></a>

```java
public java.lang.Number getMaxUnavailable();
```

- *Type:* java.lang.Number

The maximum number of nodes that can be simultaneously unavailable during the upgrade process.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_unavailable ContainerCluster#max_unavailable}

---

##### `strategy`<sup>Optional</sup> <a name="strategy" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings.property.strategy"></a>

```java
public java.lang.String getStrategy();
```

- *Type:* java.lang.String

Update strategy of the node pool.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#strategy ContainerCluster#strategy}

---

### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings;

ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings.builder()
//  .nodePoolSoakDuration(java.lang.String)
//  .standardRolloutPolicy(ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings.property.nodePoolSoakDuration">nodePoolSoakDuration</a></code> | <code>java.lang.String</code> | Time needed after draining entire blue pool. After this period, blue pool will be cleaned up. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings.property.standardRolloutPolicy">standardRolloutPolicy</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy</a></code> | standard_rollout_policy block. |

---

##### `nodePoolSoakDuration`<sup>Optional</sup> <a name="nodePoolSoakDuration" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings.property.nodePoolSoakDuration"></a>

```java
public java.lang.String getNodePoolSoakDuration();
```

- *Type:* java.lang.String

Time needed after draining entire blue pool. After this period, blue pool will be cleaned up.

A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_pool_soak_duration ContainerCluster#node_pool_soak_duration}

---

##### `standardRolloutPolicy`<sup>Optional</sup> <a name="standardRolloutPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings.property.standardRolloutPolicy"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy getStandardRolloutPolicy();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy</a>

standard_rollout_policy block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#standard_rollout_policy ContainerCluster#standard_rollout_policy}

---

### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy;

ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.builder()
//  .batchNodeCount(java.lang.Number)
//  .batchPercentage(java.lang.Number)
//  .batchSoakDuration(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchNodeCount">batchNodeCount</a></code> | <code>java.lang.Number</code> | Number of blue nodes to drain in a batch. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchPercentage">batchPercentage</a></code> | <code>java.lang.Number</code> | Percentage of the bool pool nodes to drain in a batch. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchSoakDuration">batchSoakDuration</a></code> | <code>java.lang.String</code> | Soak time after each batch gets drained. |

---

##### `batchNodeCount`<sup>Optional</sup> <a name="batchNodeCount" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchNodeCount"></a>

```java
public java.lang.Number getBatchNodeCount();
```

- *Type:* java.lang.Number

Number of blue nodes to drain in a batch.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#batch_node_count ContainerCluster#batch_node_count}

---

##### `batchPercentage`<sup>Optional</sup> <a name="batchPercentage" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchPercentage"></a>

```java
public java.lang.Number getBatchPercentage();
```

- *Type:* java.lang.Number

Percentage of the bool pool nodes to drain in a batch.

The range of this field should be (0.0, 1.0].

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#batch_percentage ContainerCluster#batch_percentage}

---

##### `batchSoakDuration`<sup>Optional</sup> <a name="batchSoakDuration" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchSoakDuration"></a>

```java
public java.lang.String getBatchSoakDuration();
```

- *Type:* java.lang.String

Soak time after each batch gets drained.

A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#batch_soak_duration ContainerCluster#batch_soak_duration}

---

### ContainerClusterClusterAutoscalingResourceLimits <a name="ContainerClusterClusterAutoscalingResourceLimits" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingResourceLimits;

ContainerClusterClusterAutoscalingResourceLimits.builder()
    .resourceType(java.lang.String)
//  .maximum(java.lang.Number)
//  .minimum(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits.property.resourceType">resourceType</a></code> | <code>java.lang.String</code> | The type of the resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits.property.maximum">maximum</a></code> | <code>java.lang.Number</code> | Maximum amount of the resource in the cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits.property.minimum">minimum</a></code> | <code>java.lang.Number</code> | Minimum amount of the resource in the cluster. |

---

##### `resourceType`<sup>Required</sup> <a name="resourceType" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits.property.resourceType"></a>

```java
public java.lang.String getResourceType();
```

- *Type:* java.lang.String

The type of the resource.

For example, cpu and memory. See the guide to using Node Auto-Provisioning for a list of types.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_type ContainerCluster#resource_type}

---

##### `maximum`<sup>Optional</sup> <a name="maximum" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits.property.maximum"></a>

```java
public java.lang.Number getMaximum();
```

- *Type:* java.lang.Number

Maximum amount of the resource in the cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#maximum ContainerCluster#maximum}

---

##### `minimum`<sup>Optional</sup> <a name="minimum" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits.property.minimum"></a>

```java
public java.lang.Number getMinimum();
```

- *Type:* java.lang.Number

Minimum amount of the resource in the cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#minimum ContainerCluster#minimum}

---

### ContainerClusterConfidentialNodes <a name="ContainerClusterConfidentialNodes" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodes"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodes.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterConfidentialNodes;

ContainerClusterConfidentialNodes.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodes.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether Confidential Nodes feature is enabled for all nodes in this cluster. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodes.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether Confidential Nodes feature is enabled for all nodes in this cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

### ContainerClusterConfig <a name="ContainerClusterConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterConfig;

ContainerClusterConfig.builder()
//  .connection(SSHProvisionerConnection)
//  .connection(WinrmProvisionerConnection)
//  .count(java.lang.Number)
//  .dependsOn(java.util.List<ITerraformDependable>)
//  .forEach(ITerraformIterator)
//  .lifecycle(TerraformResourceLifecycle)
//  .provider(TerraformProvider)
//  .provisioners(java.util.List<FileProvisioner)
//  .provisioners(LocalExecProvisioner)
//  .provisioners(RemoteExecProvisioner>)
    .name(java.lang.String)
//  .addonsConfig(ContainerClusterAddonsConfig)
//  .authenticatorGroupsConfig(ContainerClusterAuthenticatorGroupsConfig)
//  .binaryAuthorization(ContainerClusterBinaryAuthorization)
//  .clusterAutoscaling(ContainerClusterClusterAutoscaling)
//  .clusterIpv4Cidr(java.lang.String)
//  .confidentialNodes(ContainerClusterConfidentialNodes)
//  .costManagementConfig(ContainerClusterCostManagementConfig)
//  .databaseEncryption(ContainerClusterDatabaseEncryption)
//  .datapathProvider(java.lang.String)
//  .defaultMaxPodsPerNode(java.lang.Number)
//  .defaultSnatStatus(ContainerClusterDefaultSnatStatus)
//  .description(java.lang.String)
//  .dnsConfig(ContainerClusterDnsConfig)
//  .enableAutopilot(java.lang.Boolean)
//  .enableAutopilot(IResolvable)
//  .enableBinaryAuthorization(java.lang.Boolean)
//  .enableBinaryAuthorization(IResolvable)
//  .enableIntranodeVisibility(java.lang.Boolean)
//  .enableIntranodeVisibility(IResolvable)
//  .enableKubernetesAlpha(java.lang.Boolean)
//  .enableKubernetesAlpha(IResolvable)
//  .enableL4IlbSubsetting(java.lang.Boolean)
//  .enableL4IlbSubsetting(IResolvable)
//  .enableLegacyAbac(java.lang.Boolean)
//  .enableLegacyAbac(IResolvable)
//  .enableShieldedNodes(java.lang.Boolean)
//  .enableShieldedNodes(IResolvable)
//  .enableTpu(java.lang.Boolean)
//  .enableTpu(IResolvable)
//  .gatewayApiConfig(ContainerClusterGatewayApiConfig)
//  .id(java.lang.String)
//  .initialNodeCount(java.lang.Number)
//  .ipAllocationPolicy(ContainerClusterIpAllocationPolicy)
//  .location(java.lang.String)
//  .loggingConfig(ContainerClusterLoggingConfig)
//  .loggingService(java.lang.String)
//  .maintenancePolicy(ContainerClusterMaintenancePolicy)
//  .masterAuth(ContainerClusterMasterAuth)
//  .masterAuthorizedNetworksConfig(ContainerClusterMasterAuthorizedNetworksConfig)
//  .meshCertificates(ContainerClusterMeshCertificates)
//  .minMasterVersion(java.lang.String)
//  .monitoringConfig(ContainerClusterMonitoringConfig)
//  .monitoringService(java.lang.String)
//  .network(java.lang.String)
//  .networkingMode(java.lang.String)
//  .networkPolicy(ContainerClusterNetworkPolicy)
//  .nodeConfig(ContainerClusterNodeConfig)
//  .nodeLocations(java.util.List<java.lang.String>)
//  .nodePool(IResolvable)
//  .nodePool(java.util.List<ContainerClusterNodePool>)
//  .nodePoolDefaults(ContainerClusterNodePoolDefaults)
//  .nodeVersion(java.lang.String)
//  .notificationConfig(ContainerClusterNotificationConfig)
//  .privateClusterConfig(ContainerClusterPrivateClusterConfig)
//  .privateIpv6GoogleAccess(java.lang.String)
//  .project(java.lang.String)
//  .releaseChannel(ContainerClusterReleaseChannel)
//  .removeDefaultNodePool(java.lang.Boolean)
//  .removeDefaultNodePool(IResolvable)
//  .resourceLabels(java.util.Map<java.lang.String, java.lang.String>)
//  .resourceUsageExportConfig(ContainerClusterResourceUsageExportConfig)
//  .serviceExternalIpsConfig(ContainerClusterServiceExternalIpsConfig)
//  .subnetwork(java.lang.String)
//  .timeouts(ContainerClusterTimeouts)
//  .verticalPodAutoscaling(ContainerClusterVerticalPodAutoscaling)
//  .workloadIdentityConfig(ContainerClusterWorkloadIdentityConfig)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.connection">connection</a></code> | <code>com.hashicorp.cdktf.SSHProvisionerConnection OR com.hashicorp.cdktf.WinrmProvisionerConnection</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.count">count</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.dependsOn">dependsOn</a></code> | <code>java.util.List<com.hashicorp.cdktf.ITerraformDependable></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.forEach">forEach</a></code> | <code>com.hashicorp.cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.lifecycle">lifecycle</a></code> | <code>com.hashicorp.cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.provider">provider</a></code> | <code>com.hashicorp.cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.provisioners">provisioners</a></code> | <code>java.util.List<com.hashicorp.cdktf.FileProvisioner OR com.hashicorp.cdktf.LocalExecProvisioner OR com.hashicorp.cdktf.RemoteExecProvisioner></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.name">name</a></code> | <code>java.lang.String</code> | The name of the cluster, unique within the project and location. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.addonsConfig">addonsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig">ContainerClusterAddonsConfig</a></code> | addons_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.authenticatorGroupsConfig">authenticatorGroupsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfig">ContainerClusterAuthenticatorGroupsConfig</a></code> | authenticator_groups_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.binaryAuthorization">binaryAuthorization</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization">ContainerClusterBinaryAuthorization</a></code> | binary_authorization block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.clusterAutoscaling">clusterAutoscaling</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling">ContainerClusterClusterAutoscaling</a></code> | cluster_autoscaling block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.clusterIpv4Cidr">clusterIpv4Cidr</a></code> | <code>java.lang.String</code> | The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.confidentialNodes">confidentialNodes</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodes">ContainerClusterConfidentialNodes</a></code> | confidential_nodes block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.costManagementConfig">costManagementConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfig">ContainerClusterCostManagementConfig</a></code> | cost_management_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.databaseEncryption">databaseEncryption</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryption">ContainerClusterDatabaseEncryption</a></code> | database_encryption block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.datapathProvider">datapathProvider</a></code> | <code>java.lang.String</code> | The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.defaultMaxPodsPerNode">defaultMaxPodsPerNode</a></code> | <code>java.lang.Number</code> | The default maximum number of pods per node in this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.defaultSnatStatus">defaultSnatStatus</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDefaultSnatStatus">ContainerClusterDefaultSnatStatus</a></code> | default_snat_status block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.description">description</a></code> | <code>java.lang.String</code> | Description of the cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.dnsConfig">dnsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig">ContainerClusterDnsConfig</a></code> | dns_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableAutopilot">enableAutopilot</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Enable Autopilot for this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableBinaryAuthorization">enableBinaryAuthorization</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binary Authorization. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableIntranodeVisibility">enableIntranodeVisibility</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether Intra-node visibility is enabled for this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableKubernetesAlpha">enableKubernetesAlpha</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether to enable Kubernetes Alpha features for this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableL4IlbSubsetting">enableL4IlbSubsetting</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether L4ILB Subsetting is enabled for this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableLegacyAbac">enableLegacyAbac</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether the ABAC authorizer is enabled for this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableShieldedNodes">enableShieldedNodes</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Enable Shielded Nodes features on all nodes in this cluster. Defaults to true. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableTpu">enableTpu</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether to enable Cloud TPU resources in this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.gatewayApiConfig">gatewayApiConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterGatewayApiConfig">ContainerClusterGatewayApiConfig</a></code> | gateway_api_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.id">id</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#id ContainerCluster#id}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.initialNodeCount">initialNodeCount</a></code> | <code>java.lang.Number</code> | The number of nodes to create in this cluster's default node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.ipAllocationPolicy">ipAllocationPolicy</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy">ContainerClusterIpAllocationPolicy</a></code> | ip_allocation_policy block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.location">location</a></code> | <code>java.lang.String</code> | The location (region or zone) in which the cluster master will be created, as well as the default node location. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.loggingConfig">loggingConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterLoggingConfig">ContainerClusterLoggingConfig</a></code> | logging_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.loggingService">loggingService</a></code> | <code>java.lang.String</code> | The logging service that the cluster should write logs to. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.maintenancePolicy">maintenancePolicy</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy">ContainerClusterMaintenancePolicy</a></code> | maintenance_policy block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.masterAuth">masterAuth</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuth">ContainerClusterMasterAuth</a></code> | master_auth block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.masterAuthorizedNetworksConfig">masterAuthorizedNetworksConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfig">ContainerClusterMasterAuthorizedNetworksConfig</a></code> | master_authorized_networks_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.meshCertificates">meshCertificates</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMeshCertificates">ContainerClusterMeshCertificates</a></code> | mesh_certificates block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.minMasterVersion">minMasterVersion</a></code> | <code>java.lang.String</code> | The minimum version of the master. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.monitoringConfig">monitoringConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfig">ContainerClusterMonitoringConfig</a></code> | monitoring_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.monitoringService">monitoringService</a></code> | <code>java.lang.String</code> | The monitoring service that the cluster should write metrics to. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.network">network</a></code> | <code>java.lang.String</code> | The name or self_link of the Google Compute Engine network to which the cluster is connected. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.networkingMode">networkingMode</a></code> | <code>java.lang.String</code> | Determines whether alias IPs or routes will be used for pod IPs in the cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.networkPolicy">networkPolicy</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicy">ContainerClusterNetworkPolicy</a></code> | network_policy block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.nodeConfig">nodeConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig">ContainerClusterNodeConfig</a></code> | node_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.nodeLocations">nodeLocations</a></code> | <code>java.util.List<java.lang.String></code> | The list of zones in which the cluster's nodes are located. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.nodePool">nodePool</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool">ContainerClusterNodePool</a>></code> | node_pool block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.nodePoolDefaults">nodePoolDefaults</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaults">ContainerClusterNodePoolDefaults</a></code> | node_pool_defaults block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.nodeVersion">nodeVersion</a></code> | <code>java.lang.String</code> | The Kubernetes version on the nodes. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.notificationConfig">notificationConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfig">ContainerClusterNotificationConfig</a></code> | notification_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.privateClusterConfig">privateClusterConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig">ContainerClusterPrivateClusterConfig</a></code> | private_cluster_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.privateIpv6GoogleAccess">privateIpv6GoogleAccess</a></code> | <code>java.lang.String</code> | The desired state of IPv6 connectivity to Google Services. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.project">project</a></code> | <code>java.lang.String</code> | The ID of the project in which the resource belongs. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.releaseChannel">releaseChannel</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterReleaseChannel">ContainerClusterReleaseChannel</a></code> | release_channel block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.removeDefaultNodePool">removeDefaultNodePool</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | If true, deletes the default node pool upon cluster creation. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.resourceLabels">resourceLabels</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | The GCE resource labels (a map of key/value pairs) to be applied to the cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.resourceUsageExportConfig">resourceUsageExportConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig">ContainerClusterResourceUsageExportConfig</a></code> | resource_usage_export_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.serviceExternalIpsConfig">serviceExternalIpsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterServiceExternalIpsConfig">ContainerClusterServiceExternalIpsConfig</a></code> | service_external_ips_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.subnetwork">subnetwork</a></code> | <code>java.lang.String</code> | The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.timeouts">timeouts</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterTimeouts">ContainerClusterTimeouts</a></code> | timeouts block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.verticalPodAutoscaling">verticalPodAutoscaling</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterVerticalPodAutoscaling">ContainerClusterVerticalPodAutoscaling</a></code> | vertical_pod_autoscaling block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.workloadIdentityConfig">workloadIdentityConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterWorkloadIdentityConfig">ContainerClusterWorkloadIdentityConfig</a></code> | workload_identity_config block. |

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.connection"></a>

```java
public java.lang.Object getConnection();
```

- *Type:* com.hashicorp.cdktf.SSHProvisionerConnection OR com.hashicorp.cdktf.WinrmProvisionerConnection

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.count"></a>

```java
public java.lang.Number getCount();
```

- *Type:* java.lang.Number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.dependsOn"></a>

```java
public java.util.List<ITerraformDependable> getDependsOn();
```

- *Type:* java.util.List<com.hashicorp.cdktf.ITerraformDependable>

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.forEach"></a>

```java
public ITerraformIterator getForEach();
```

- *Type:* com.hashicorp.cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.lifecycle"></a>

```java
public TerraformResourceLifecycle getLifecycle();
```

- *Type:* com.hashicorp.cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.provider"></a>

```java
public TerraformProvider getProvider();
```

- *Type:* com.hashicorp.cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.provisioners"></a>

```java
public java.lang.Object getProvisioners();
```

- *Type:* java.util.List<com.hashicorp.cdktf.FileProvisioner OR com.hashicorp.cdktf.LocalExecProvisioner OR com.hashicorp.cdktf.RemoteExecProvisioner>

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

The name of the cluster, unique within the project and location.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#name ContainerCluster#name}

---

##### `addonsConfig`<sup>Optional</sup> <a name="addonsConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.addonsConfig"></a>

```java
public ContainerClusterAddonsConfig getAddonsConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig">ContainerClusterAddonsConfig</a>

addons_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#addons_config ContainerCluster#addons_config}

---

##### `authenticatorGroupsConfig`<sup>Optional</sup> <a name="authenticatorGroupsConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.authenticatorGroupsConfig"></a>

```java
public ContainerClusterAuthenticatorGroupsConfig getAuthenticatorGroupsConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfig">ContainerClusterAuthenticatorGroupsConfig</a>

authenticator_groups_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#authenticator_groups_config ContainerCluster#authenticator_groups_config}

---

##### `binaryAuthorization`<sup>Optional</sup> <a name="binaryAuthorization" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.binaryAuthorization"></a>

```java
public ContainerClusterBinaryAuthorization getBinaryAuthorization();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization">ContainerClusterBinaryAuthorization</a>

binary_authorization block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#binary_authorization ContainerCluster#binary_authorization}

---

##### `clusterAutoscaling`<sup>Optional</sup> <a name="clusterAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.clusterAutoscaling"></a>

```java
public ContainerClusterClusterAutoscaling getClusterAutoscaling();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling">ContainerClusterClusterAutoscaling</a>

cluster_autoscaling block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_autoscaling ContainerCluster#cluster_autoscaling}

---

##### `clusterIpv4Cidr`<sup>Optional</sup> <a name="clusterIpv4Cidr" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.clusterIpv4Cidr"></a>

```java
public java.lang.String getClusterIpv4Cidr();
```

- *Type:* java.lang.String

The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_ipv4_cidr ContainerCluster#cluster_ipv4_cidr}

---

##### `confidentialNodes`<sup>Optional</sup> <a name="confidentialNodes" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.confidentialNodes"></a>

```java
public ContainerClusterConfidentialNodes getConfidentialNodes();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodes">ContainerClusterConfidentialNodes</a>

confidential_nodes block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#confidential_nodes ContainerCluster#confidential_nodes}

---

##### `costManagementConfig`<sup>Optional</sup> <a name="costManagementConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.costManagementConfig"></a>

```java
public ContainerClusterCostManagementConfig getCostManagementConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfig">ContainerClusterCostManagementConfig</a>

cost_management_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cost_management_config ContainerCluster#cost_management_config}

---

##### `databaseEncryption`<sup>Optional</sup> <a name="databaseEncryption" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.databaseEncryption"></a>

```java
public ContainerClusterDatabaseEncryption getDatabaseEncryption();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryption">ContainerClusterDatabaseEncryption</a>

database_encryption block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#database_encryption ContainerCluster#database_encryption}

---

##### `datapathProvider`<sup>Optional</sup> <a name="datapathProvider" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.datapathProvider"></a>

```java
public java.lang.String getDatapathProvider();
```

- *Type:* java.lang.String

The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#datapath_provider ContainerCluster#datapath_provider}

---

##### `defaultMaxPodsPerNode`<sup>Optional</sup> <a name="defaultMaxPodsPerNode" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.defaultMaxPodsPerNode"></a>

```java
public java.lang.Number getDefaultMaxPodsPerNode();
```

- *Type:* java.lang.Number

The default maximum number of pods per node in this cluster.

This doesn't work on "routes-based" clusters, clusters that don't have IP Aliasing enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#default_max_pods_per_node ContainerCluster#default_max_pods_per_node}

---

##### `defaultSnatStatus`<sup>Optional</sup> <a name="defaultSnatStatus" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.defaultSnatStatus"></a>

```java
public ContainerClusterDefaultSnatStatus getDefaultSnatStatus();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDefaultSnatStatus">ContainerClusterDefaultSnatStatus</a>

default_snat_status block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#default_snat_status ContainerCluster#default_snat_status}

---

##### `description`<sup>Optional</sup> <a name="description" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String

Description of the cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#description ContainerCluster#description}

---

##### `dnsConfig`<sup>Optional</sup> <a name="dnsConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.dnsConfig"></a>

```java
public ContainerClusterDnsConfig getDnsConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig">ContainerClusterDnsConfig</a>

dns_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#dns_config ContainerCluster#dns_config}

---

##### `enableAutopilot`<sup>Optional</sup> <a name="enableAutopilot" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableAutopilot"></a>

```java
public java.lang.Object getEnableAutopilot();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Enable Autopilot for this cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_autopilot ContainerCluster#enable_autopilot}

---

##### `enableBinaryAuthorization`<sup>Optional</sup> <a name="enableBinaryAuthorization" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableBinaryAuthorization"></a>

```java
public java.lang.Object getEnableBinaryAuthorization();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binary Authorization.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_binary_authorization ContainerCluster#enable_binary_authorization}

---

##### `enableIntranodeVisibility`<sup>Optional</sup> <a name="enableIntranodeVisibility" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableIntranodeVisibility"></a>

```java
public java.lang.Object getEnableIntranodeVisibility();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether Intra-node visibility is enabled for this cluster.

This makes same node pod to pod traffic visible for VPC network.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_intranode_visibility ContainerCluster#enable_intranode_visibility}

---

##### `enableKubernetesAlpha`<sup>Optional</sup> <a name="enableKubernetesAlpha" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableKubernetesAlpha"></a>

```java
public java.lang.Object getEnableKubernetesAlpha();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether to enable Kubernetes Alpha features for this cluster.

Note that when this option is enabled, the cluster cannot be upgraded and will be automatically deleted after 30 days.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_kubernetes_alpha ContainerCluster#enable_kubernetes_alpha}

---

##### `enableL4IlbSubsetting`<sup>Optional</sup> <a name="enableL4IlbSubsetting" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableL4IlbSubsetting"></a>

```java
public java.lang.Object getEnableL4IlbSubsetting();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether L4ILB Subsetting is enabled for this cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_l4_ilb_subsetting ContainerCluster#enable_l4_ilb_subsetting}

---

##### `enableLegacyAbac`<sup>Optional</sup> <a name="enableLegacyAbac" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableLegacyAbac"></a>

```java
public java.lang.Object getEnableLegacyAbac();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether the ABAC authorizer is enabled for this cluster.

When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM. Defaults to false.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_legacy_abac ContainerCluster#enable_legacy_abac}

---

##### `enableShieldedNodes`<sup>Optional</sup> <a name="enableShieldedNodes" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableShieldedNodes"></a>

```java
public java.lang.Object getEnableShieldedNodes();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Enable Shielded Nodes features on all nodes in this cluster. Defaults to true.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_shielded_nodes ContainerCluster#enable_shielded_nodes}

---

##### `enableTpu`<sup>Optional</sup> <a name="enableTpu" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.enableTpu"></a>

```java
public java.lang.Object getEnableTpu();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether to enable Cloud TPU resources in this cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_tpu ContainerCluster#enable_tpu}

---

##### `gatewayApiConfig`<sup>Optional</sup> <a name="gatewayApiConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.gatewayApiConfig"></a>

```java
public ContainerClusterGatewayApiConfig getGatewayApiConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterGatewayApiConfig">ContainerClusterGatewayApiConfig</a>

gateway_api_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gateway_api_config ContainerCluster#gateway_api_config}

---

##### `id`<sup>Optional</sup> <a name="id" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.id"></a>

```java
public java.lang.String getId();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#id ContainerCluster#id}.

Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.

---

##### `initialNodeCount`<sup>Optional</sup> <a name="initialNodeCount" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.initialNodeCount"></a>

```java
public java.lang.Number getInitialNodeCount();
```

- *Type:* java.lang.Number

The number of nodes to create in this cluster's default node pool.

In regional or multi-zonal clusters, this is the number of nodes per zone. Must be set if node_pool is not set. If you're using google_container_node_pool objects with no default node pool, you'll need to set this to a value of at least 1, alongside setting remove_default_node_pool to true.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#initial_node_count ContainerCluster#initial_node_count}

---

##### `ipAllocationPolicy`<sup>Optional</sup> <a name="ipAllocationPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.ipAllocationPolicy"></a>

```java
public ContainerClusterIpAllocationPolicy getIpAllocationPolicy();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy">ContainerClusterIpAllocationPolicy</a>

ip_allocation_policy block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#ip_allocation_policy ContainerCluster#ip_allocation_policy}

---

##### `location`<sup>Optional</sup> <a name="location" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.location"></a>

```java
public java.lang.String getLocation();
```

- *Type:* java.lang.String

The location (region or zone) in which the cluster master will be created, as well as the default node location.

If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#location ContainerCluster#location}

---

##### `loggingConfig`<sup>Optional</sup> <a name="loggingConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.loggingConfig"></a>

```java
public ContainerClusterLoggingConfig getLoggingConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterLoggingConfig">ContainerClusterLoggingConfig</a>

logging_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#logging_config ContainerCluster#logging_config}

---

##### `loggingService`<sup>Optional</sup> <a name="loggingService" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.loggingService"></a>

```java
public java.lang.String getLoggingService();
```

- *Type:* java.lang.String

The logging service that the cluster should write logs to.

Available options include logging.googleapis.com(Legacy Stackdriver), logging.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Logging), and none. Defaults to logging.googleapis.com/kubernetes.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#logging_service ContainerCluster#logging_service}

---

##### `maintenancePolicy`<sup>Optional</sup> <a name="maintenancePolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.maintenancePolicy"></a>

```java
public ContainerClusterMaintenancePolicy getMaintenancePolicy();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy">ContainerClusterMaintenancePolicy</a>

maintenance_policy block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#maintenance_policy ContainerCluster#maintenance_policy}

---

##### `masterAuth`<sup>Optional</sup> <a name="masterAuth" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.masterAuth"></a>

```java
public ContainerClusterMasterAuth getMasterAuth();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuth">ContainerClusterMasterAuth</a>

master_auth block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_auth ContainerCluster#master_auth}

---

##### `masterAuthorizedNetworksConfig`<sup>Optional</sup> <a name="masterAuthorizedNetworksConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.masterAuthorizedNetworksConfig"></a>

```java
public ContainerClusterMasterAuthorizedNetworksConfig getMasterAuthorizedNetworksConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfig">ContainerClusterMasterAuthorizedNetworksConfig</a>

master_authorized_networks_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_authorized_networks_config ContainerCluster#master_authorized_networks_config}

---

##### `meshCertificates`<sup>Optional</sup> <a name="meshCertificates" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.meshCertificates"></a>

```java
public ContainerClusterMeshCertificates getMeshCertificates();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMeshCertificates">ContainerClusterMeshCertificates</a>

mesh_certificates block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#mesh_certificates ContainerCluster#mesh_certificates}

---

##### `minMasterVersion`<sup>Optional</sup> <a name="minMasterVersion" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.minMasterVersion"></a>

```java
public java.lang.String getMinMasterVersion();
```

- *Type:* java.lang.String

The minimum version of the master.

GKE will auto-update the master to new versions, so this does not guarantee the current master version--use the read-only master_version field to obtain that. If unset, the cluster's version will be set by GKE to the version of the most recent official release (which is not necessarily the latest version).

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_master_version ContainerCluster#min_master_version}

---

##### `monitoringConfig`<sup>Optional</sup> <a name="monitoringConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.monitoringConfig"></a>

```java
public ContainerClusterMonitoringConfig getMonitoringConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfig">ContainerClusterMonitoringConfig</a>

monitoring_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#monitoring_config ContainerCluster#monitoring_config}

---

##### `monitoringService`<sup>Optional</sup> <a name="monitoringService" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.monitoringService"></a>

```java
public java.lang.String getMonitoringService();
```

- *Type:* java.lang.String

The monitoring service that the cluster should write metrics to.

Automatically send metrics from pods in the cluster to the Google Cloud Monitoring API. VM metrics will be collected by Google Compute Engine regardless of this setting Available options include monitoring.googleapis.com(Legacy Stackdriver), monitoring.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Monitoring), and none. Defaults to monitoring.googleapis.com/kubernetes.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#monitoring_service ContainerCluster#monitoring_service}

---

##### `network`<sup>Optional</sup> <a name="network" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.network"></a>

```java
public java.lang.String getNetwork();
```

- *Type:* java.lang.String

The name or self_link of the Google Compute Engine network to which the cluster is connected.

For Shared VPC, set this to the self link of the shared network.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#network ContainerCluster#network}

---

##### `networkingMode`<sup>Optional</sup> <a name="networkingMode" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.networkingMode"></a>

```java
public java.lang.String getNetworkingMode();
```

- *Type:* java.lang.String

Determines whether alias IPs or routes will be used for pod IPs in the cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#networking_mode ContainerCluster#networking_mode}

---

##### `networkPolicy`<sup>Optional</sup> <a name="networkPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.networkPolicy"></a>

```java
public ContainerClusterNetworkPolicy getNetworkPolicy();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicy">ContainerClusterNetworkPolicy</a>

network_policy block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#network_policy ContainerCluster#network_policy}

---

##### `nodeConfig`<sup>Optional</sup> <a name="nodeConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.nodeConfig"></a>

```java
public ContainerClusterNodeConfig getNodeConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig">ContainerClusterNodeConfig</a>

node_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_config ContainerCluster#node_config}

---

##### `nodeLocations`<sup>Optional</sup> <a name="nodeLocations" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.nodeLocations"></a>

```java
public java.util.List<java.lang.String> getNodeLocations();
```

- *Type:* java.util.List<java.lang.String>

The list of zones in which the cluster's nodes are located.

Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If this is specified for a zonal cluster, omit the cluster's zone.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_locations ContainerCluster#node_locations}

---

##### `nodePool`<sup>Optional</sup> <a name="nodePool" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.nodePool"></a>

```java
public java.lang.Object getNodePool();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool">ContainerClusterNodePool</a>>

node_pool block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_pool ContainerCluster#node_pool}

---

##### `nodePoolDefaults`<sup>Optional</sup> <a name="nodePoolDefaults" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.nodePoolDefaults"></a>

```java
public ContainerClusterNodePoolDefaults getNodePoolDefaults();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaults">ContainerClusterNodePoolDefaults</a>

node_pool_defaults block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_pool_defaults ContainerCluster#node_pool_defaults}

---

##### `nodeVersion`<sup>Optional</sup> <a name="nodeVersion" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.nodeVersion"></a>

```java
public java.lang.String getNodeVersion();
```

- *Type:* java.lang.String

The Kubernetes version on the nodes.

Must either be unset or set to the same value as min_master_version on create. Defaults to the default version set by GKE which is not necessarily the latest version. This only affects nodes in the default node pool. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way. To update nodes in other node pools, use the version attribute on the node pool.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_version ContainerCluster#node_version}

---

##### `notificationConfig`<sup>Optional</sup> <a name="notificationConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.notificationConfig"></a>

```java
public ContainerClusterNotificationConfig getNotificationConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfig">ContainerClusterNotificationConfig</a>

notification_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#notification_config ContainerCluster#notification_config}

---

##### `privateClusterConfig`<sup>Optional</sup> <a name="privateClusterConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.privateClusterConfig"></a>

```java
public ContainerClusterPrivateClusterConfig getPrivateClusterConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig">ContainerClusterPrivateClusterConfig</a>

private_cluster_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#private_cluster_config ContainerCluster#private_cluster_config}

---

##### `privateIpv6GoogleAccess`<sup>Optional</sup> <a name="privateIpv6GoogleAccess" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.privateIpv6GoogleAccess"></a>

```java
public java.lang.String getPrivateIpv6GoogleAccess();
```

- *Type:* java.lang.String

The desired state of IPv6 connectivity to Google Services.

By default, no private IPv6 access to or from Google Services (all access will be via IPv4).

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#private_ipv6_google_access ContainerCluster#private_ipv6_google_access}

---

##### `project`<sup>Optional</sup> <a name="project" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.project"></a>

```java
public java.lang.String getProject();
```

- *Type:* java.lang.String

The ID of the project in which the resource belongs.

If it is not provided, the provider project is used.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#project ContainerCluster#project}

---

##### `releaseChannel`<sup>Optional</sup> <a name="releaseChannel" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.releaseChannel"></a>

```java
public ContainerClusterReleaseChannel getReleaseChannel();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterReleaseChannel">ContainerClusterReleaseChannel</a>

release_channel block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#release_channel ContainerCluster#release_channel}

---

##### `removeDefaultNodePool`<sup>Optional</sup> <a name="removeDefaultNodePool" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.removeDefaultNodePool"></a>

```java
public java.lang.Object getRemoveDefaultNodePool();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

If true, deletes the default node pool upon cluster creation.

If you're using google_container_node_pool resources with no default node pool, this should be set to true, alongside setting initial_node_count to at least 1.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#remove_default_node_pool ContainerCluster#remove_default_node_pool}

---

##### `resourceLabels`<sup>Optional</sup> <a name="resourceLabels" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.resourceLabels"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getResourceLabels();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

The GCE resource labels (a map of key/value pairs) to be applied to the cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_labels ContainerCluster#resource_labels}

---

##### `resourceUsageExportConfig`<sup>Optional</sup> <a name="resourceUsageExportConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.resourceUsageExportConfig"></a>

```java
public ContainerClusterResourceUsageExportConfig getResourceUsageExportConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig">ContainerClusterResourceUsageExportConfig</a>

resource_usage_export_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_usage_export_config ContainerCluster#resource_usage_export_config}

---

##### `serviceExternalIpsConfig`<sup>Optional</sup> <a name="serviceExternalIpsConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.serviceExternalIpsConfig"></a>

```java
public ContainerClusterServiceExternalIpsConfig getServiceExternalIpsConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterServiceExternalIpsConfig">ContainerClusterServiceExternalIpsConfig</a>

service_external_ips_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#service_external_ips_config ContainerCluster#service_external_ips_config}

---

##### `subnetwork`<sup>Optional</sup> <a name="subnetwork" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.subnetwork"></a>

```java
public java.lang.String getSubnetwork();
```

- *Type:* java.lang.String

The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#subnetwork ContainerCluster#subnetwork}

---

##### `timeouts`<sup>Optional</sup> <a name="timeouts" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.timeouts"></a>

```java
public ContainerClusterTimeouts getTimeouts();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterTimeouts">ContainerClusterTimeouts</a>

timeouts block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#timeouts ContainerCluster#timeouts}

---

##### `verticalPodAutoscaling`<sup>Optional</sup> <a name="verticalPodAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.verticalPodAutoscaling"></a>

```java
public ContainerClusterVerticalPodAutoscaling getVerticalPodAutoscaling();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterVerticalPodAutoscaling">ContainerClusterVerticalPodAutoscaling</a>

vertical_pod_autoscaling block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#vertical_pod_autoscaling ContainerCluster#vertical_pod_autoscaling}

---

##### `workloadIdentityConfig`<sup>Optional</sup> <a name="workloadIdentityConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterConfig.property.workloadIdentityConfig"></a>

```java
public ContainerClusterWorkloadIdentityConfig getWorkloadIdentityConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterWorkloadIdentityConfig">ContainerClusterWorkloadIdentityConfig</a>

workload_identity_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#workload_identity_config ContainerCluster#workload_identity_config}

---

### ContainerClusterCostManagementConfig <a name="ContainerClusterCostManagementConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterCostManagementConfig;

ContainerClusterCostManagementConfig.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfig.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether to enable GKE cost allocation. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfig.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether to enable GKE cost allocation.

When you enable GKE cost allocation, the cluster name and namespace of your GKE workloads appear in the labels field of the billing export to BigQuery. Defaults to false.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

### ContainerClusterDatabaseEncryption <a name="ContainerClusterDatabaseEncryption" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryption"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryption.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterDatabaseEncryption;

ContainerClusterDatabaseEncryption.builder()
    .state(java.lang.String)
//  .keyName(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryption.property.state">state</a></code> | <code>java.lang.String</code> | ENCRYPTED or DECRYPTED. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryption.property.keyName">keyName</a></code> | <code>java.lang.String</code> | The key to use to encrypt/decrypt secrets. |

---

##### `state`<sup>Required</sup> <a name="state" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryption.property.state"></a>

```java
public java.lang.String getState();
```

- *Type:* java.lang.String

ENCRYPTED or DECRYPTED.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#state ContainerCluster#state}

---

##### `keyName`<sup>Optional</sup> <a name="keyName" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryption.property.keyName"></a>

```java
public java.lang.String getKeyName();
```

- *Type:* java.lang.String

The key to use to encrypt/decrypt secrets.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key_name ContainerCluster#key_name}

---

### ContainerClusterDefaultSnatStatus <a name="ContainerClusterDefaultSnatStatus" id="@cdktf/provider-google.containerCluster.ContainerClusterDefaultSnatStatus"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterDefaultSnatStatus.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterDefaultSnatStatus;

ContainerClusterDefaultSnatStatus.builder()
    .disabled(java.lang.Boolean)
    .disabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDefaultSnatStatus.property.disabled">disabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic. |

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google.containerCluster.ContainerClusterDefaultSnatStatus.property.disabled"></a>

```java
public java.lang.Object getDisabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}

---

### ContainerClusterDnsConfig <a name="ContainerClusterDnsConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterDnsConfig;

ContainerClusterDnsConfig.builder()
//  .clusterDns(java.lang.String)
//  .clusterDnsDomain(java.lang.String)
//  .clusterDnsScope(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig.property.clusterDns">clusterDns</a></code> | <code>java.lang.String</code> | Which in-cluster DNS provider should be used. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig.property.clusterDnsDomain">clusterDnsDomain</a></code> | <code>java.lang.String</code> | The suffix used for all cluster service records. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig.property.clusterDnsScope">clusterDnsScope</a></code> | <code>java.lang.String</code> | The scope of access to cluster DNS records. |

---

##### `clusterDns`<sup>Optional</sup> <a name="clusterDns" id="@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig.property.clusterDns"></a>

```java
public java.lang.String getClusterDns();
```

- *Type:* java.lang.String

Which in-cluster DNS provider should be used.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_dns ContainerCluster#cluster_dns}

---

##### `clusterDnsDomain`<sup>Optional</sup> <a name="clusterDnsDomain" id="@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig.property.clusterDnsDomain"></a>

```java
public java.lang.String getClusterDnsDomain();
```

- *Type:* java.lang.String

The suffix used for all cluster service records.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_dns_domain ContainerCluster#cluster_dns_domain}

---

##### `clusterDnsScope`<sup>Optional</sup> <a name="clusterDnsScope" id="@cdktf/provider-google.containerCluster.ContainerClusterDnsConfig.property.clusterDnsScope"></a>

```java
public java.lang.String getClusterDnsScope();
```

- *Type:* java.lang.String

The scope of access to cluster DNS records.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_dns_scope ContainerCluster#cluster_dns_scope}

---

### ContainerClusterGatewayApiConfig <a name="ContainerClusterGatewayApiConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterGatewayApiConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterGatewayApiConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterGatewayApiConfig;

ContainerClusterGatewayApiConfig.builder()
    .channel(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterGatewayApiConfig.property.channel">channel</a></code> | <code>java.lang.String</code> | The Gateway API release channel to use for Gateway API. |

---

##### `channel`<sup>Required</sup> <a name="channel" id="@cdktf/provider-google.containerCluster.ContainerClusterGatewayApiConfig.property.channel"></a>

```java
public java.lang.String getChannel();
```

- *Type:* java.lang.String

The Gateway API release channel to use for Gateway API.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#channel ContainerCluster#channel}

---

### ContainerClusterIpAllocationPolicy <a name="ContainerClusterIpAllocationPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterIpAllocationPolicy;

ContainerClusterIpAllocationPolicy.builder()
//  .clusterIpv4CidrBlock(java.lang.String)
//  .clusterSecondaryRangeName(java.lang.String)
//  .servicesIpv4CidrBlock(java.lang.String)
//  .servicesSecondaryRangeName(java.lang.String)
//  .stackType(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy.property.clusterIpv4CidrBlock">clusterIpv4CidrBlock</a></code> | <code>java.lang.String</code> | The IP address range for the cluster pod IPs. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy.property.clusterSecondaryRangeName">clusterSecondaryRangeName</a></code> | <code>java.lang.String</code> | The name of the existing secondary range in the cluster's subnetwork to use for pod IP addresses. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy.property.servicesIpv4CidrBlock">servicesIpv4CidrBlock</a></code> | <code>java.lang.String</code> | The IP address range of the services IPs in this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy.property.servicesSecondaryRangeName">servicesSecondaryRangeName</a></code> | <code>java.lang.String</code> | The name of the existing secondary range in the cluster's subnetwork to use for service ClusterIPs. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy.property.stackType">stackType</a></code> | <code>java.lang.String</code> | The IP Stack type of the cluster. |

---

##### `clusterIpv4CidrBlock`<sup>Optional</sup> <a name="clusterIpv4CidrBlock" id="@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy.property.clusterIpv4CidrBlock"></a>

```java
public java.lang.String getClusterIpv4CidrBlock();
```

- *Type:* java.lang.String

The IP address range for the cluster pod IPs.

Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_ipv4_cidr_block ContainerCluster#cluster_ipv4_cidr_block}

---

##### `clusterSecondaryRangeName`<sup>Optional</sup> <a name="clusterSecondaryRangeName" id="@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy.property.clusterSecondaryRangeName"></a>

```java
public java.lang.String getClusterSecondaryRangeName();
```

- *Type:* java.lang.String

The name of the existing secondary range in the cluster's subnetwork to use for pod IP addresses.

Alternatively, cluster_ipv4_cidr_block can be used to automatically create a GKE-managed one.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_secondary_range_name ContainerCluster#cluster_secondary_range_name}

---

##### `servicesIpv4CidrBlock`<sup>Optional</sup> <a name="servicesIpv4CidrBlock" id="@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy.property.servicesIpv4CidrBlock"></a>

```java
public java.lang.String getServicesIpv4CidrBlock();
```

- *Type:* java.lang.String

The IP address range of the services IPs in this cluster.

Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#services_ipv4_cidr_block ContainerCluster#services_ipv4_cidr_block}

---

##### `servicesSecondaryRangeName`<sup>Optional</sup> <a name="servicesSecondaryRangeName" id="@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy.property.servicesSecondaryRangeName"></a>

```java
public java.lang.String getServicesSecondaryRangeName();
```

- *Type:* java.lang.String

The name of the existing secondary range in the cluster's subnetwork to use for service ClusterIPs.

Alternatively, services_ipv4_cidr_block can be used to automatically create a GKE-managed one.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#services_secondary_range_name ContainerCluster#services_secondary_range_name}

---

##### `stackType`<sup>Optional</sup> <a name="stackType" id="@cdktf/provider-google.containerCluster.ContainerClusterIpAllocationPolicy.property.stackType"></a>

```java
public java.lang.String getStackType();
```

- *Type:* java.lang.String

The IP Stack type of the cluster.

Choose between IPV4 and IPV4_IPV6. Default type is IPV4 Only if not set

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#stack_type ContainerCluster#stack_type}

---

### ContainerClusterLoggingConfig <a name="ContainerClusterLoggingConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterLoggingConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterLoggingConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterLoggingConfig;

ContainerClusterLoggingConfig.builder()
    .enableComponents(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterLoggingConfig.property.enableComponents">enableComponents</a></code> | <code>java.util.List<java.lang.String></code> | GKE components exposing logs. Valid values include SYSTEM_COMPONENTS, APISERVER, CONTROLLER_MANAGER, SCHEDULER, and WORKLOADS. |

---

##### `enableComponents`<sup>Required</sup> <a name="enableComponents" id="@cdktf/provider-google.containerCluster.ContainerClusterLoggingConfig.property.enableComponents"></a>

```java
public java.util.List<java.lang.String> getEnableComponents();
```

- *Type:* java.util.List<java.lang.String>

GKE components exposing logs. Valid values include SYSTEM_COMPONENTS, APISERVER, CONTROLLER_MANAGER, SCHEDULER, and WORKLOADS.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_components ContainerCluster#enable_components}

---

### ContainerClusterMaintenancePolicy <a name="ContainerClusterMaintenancePolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterMaintenancePolicy;

ContainerClusterMaintenancePolicy.builder()
//  .dailyMaintenanceWindow(ContainerClusterMaintenancePolicyDailyMaintenanceWindow)
//  .maintenanceExclusion(IResolvable)
//  .maintenanceExclusion(java.util.List<ContainerClusterMaintenancePolicyMaintenanceExclusion>)
//  .recurringWindow(ContainerClusterMaintenancePolicyRecurringWindow)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy.property.dailyMaintenanceWindow">dailyMaintenanceWindow</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyDailyMaintenanceWindow">ContainerClusterMaintenancePolicyDailyMaintenanceWindow</a></code> | daily_maintenance_window block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy.property.maintenanceExclusion">maintenanceExclusion</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusion">ContainerClusterMaintenancePolicyMaintenanceExclusion</a>></code> | maintenance_exclusion block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy.property.recurringWindow">recurringWindow</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyRecurringWindow">ContainerClusterMaintenancePolicyRecurringWindow</a></code> | recurring_window block. |

---

##### `dailyMaintenanceWindow`<sup>Optional</sup> <a name="dailyMaintenanceWindow" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy.property.dailyMaintenanceWindow"></a>

```java
public ContainerClusterMaintenancePolicyDailyMaintenanceWindow getDailyMaintenanceWindow();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyDailyMaintenanceWindow">ContainerClusterMaintenancePolicyDailyMaintenanceWindow</a>

daily_maintenance_window block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#daily_maintenance_window ContainerCluster#daily_maintenance_window}

---

##### `maintenanceExclusion`<sup>Optional</sup> <a name="maintenanceExclusion" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy.property.maintenanceExclusion"></a>

```java
public java.lang.Object getMaintenanceExclusion();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusion">ContainerClusterMaintenancePolicyMaintenanceExclusion</a>>

maintenance_exclusion block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#maintenance_exclusion ContainerCluster#maintenance_exclusion}

---

##### `recurringWindow`<sup>Optional</sup> <a name="recurringWindow" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicy.property.recurringWindow"></a>

```java
public ContainerClusterMaintenancePolicyRecurringWindow getRecurringWindow();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyRecurringWindow">ContainerClusterMaintenancePolicyRecurringWindow</a>

recurring_window block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#recurring_window ContainerCluster#recurring_window}

---

### ContainerClusterMaintenancePolicyDailyMaintenanceWindow <a name="ContainerClusterMaintenancePolicyDailyMaintenanceWindow" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyDailyMaintenanceWindow"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyDailyMaintenanceWindow.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterMaintenancePolicyDailyMaintenanceWindow;

ContainerClusterMaintenancePolicyDailyMaintenanceWindow.builder()
    .startTime(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyDailyMaintenanceWindow.property.startTime">startTime</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#start_time ContainerCluster#start_time}. |

---

##### `startTime`<sup>Required</sup> <a name="startTime" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyDailyMaintenanceWindow.property.startTime"></a>

```java
public java.lang.String getStartTime();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#start_time ContainerCluster#start_time}.

---

### ContainerClusterMaintenancePolicyMaintenanceExclusion <a name="ContainerClusterMaintenancePolicyMaintenanceExclusion" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusion"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusion.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterMaintenancePolicyMaintenanceExclusion;

ContainerClusterMaintenancePolicyMaintenanceExclusion.builder()
    .endTime(java.lang.String)
    .exclusionName(java.lang.String)
    .startTime(java.lang.String)
//  .exclusionOptions(ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusion.property.endTime">endTime</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#end_time ContainerCluster#end_time}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusion.property.exclusionName">exclusionName</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#exclusion_name ContainerCluster#exclusion_name}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusion.property.startTime">startTime</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#start_time ContainerCluster#start_time}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusion.property.exclusionOptions">exclusionOptions</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions">ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions</a></code> | exclusion_options block. |

---

##### `endTime`<sup>Required</sup> <a name="endTime" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusion.property.endTime"></a>

```java
public java.lang.String getEndTime();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#end_time ContainerCluster#end_time}.

---

##### `exclusionName`<sup>Required</sup> <a name="exclusionName" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusion.property.exclusionName"></a>

```java
public java.lang.String getExclusionName();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#exclusion_name ContainerCluster#exclusion_name}.

---

##### `startTime`<sup>Required</sup> <a name="startTime" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusion.property.startTime"></a>

```java
public java.lang.String getStartTime();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#start_time ContainerCluster#start_time}.

---

##### `exclusionOptions`<sup>Optional</sup> <a name="exclusionOptions" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusion.property.exclusionOptions"></a>

```java
public ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions getExclusionOptions();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions">ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions</a>

exclusion_options block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#exclusion_options ContainerCluster#exclusion_options}

---

### ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions <a name="ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions;

ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions.builder()
    .scope(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions.property.scope">scope</a></code> | <code>java.lang.String</code> | The scope of automatic upgrades to restrict in the exclusion window. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyMaintenanceExclusionExclusionOptions.property.scope"></a>

```java
public java.lang.String getScope();
```

- *Type:* java.lang.String

The scope of automatic upgrades to restrict in the exclusion window.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#scope ContainerCluster#scope}

---

### ContainerClusterMaintenancePolicyRecurringWindow <a name="ContainerClusterMaintenancePolicyRecurringWindow" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyRecurringWindow"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyRecurringWindow.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterMaintenancePolicyRecurringWindow;

ContainerClusterMaintenancePolicyRecurringWindow.builder()
    .endTime(java.lang.String)
    .recurrence(java.lang.String)
    .startTime(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyRecurringWindow.property.endTime">endTime</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#end_time ContainerCluster#end_time}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyRecurringWindow.property.recurrence">recurrence</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#recurrence ContainerCluster#recurrence}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyRecurringWindow.property.startTime">startTime</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#start_time ContainerCluster#start_time}. |

---

##### `endTime`<sup>Required</sup> <a name="endTime" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyRecurringWindow.property.endTime"></a>

```java
public java.lang.String getEndTime();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#end_time ContainerCluster#end_time}.

---

##### `recurrence`<sup>Required</sup> <a name="recurrence" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyRecurringWindow.property.recurrence"></a>

```java
public java.lang.String getRecurrence();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#recurrence ContainerCluster#recurrence}.

---

##### `startTime`<sup>Required</sup> <a name="startTime" id="@cdktf/provider-google.containerCluster.ContainerClusterMaintenancePolicyRecurringWindow.property.startTime"></a>

```java
public java.lang.String getStartTime();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#start_time ContainerCluster#start_time}.

---

### ContainerClusterMasterAuth <a name="ContainerClusterMasterAuth" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuth"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuth.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterMasterAuth;

ContainerClusterMasterAuth.builder()
    .clientCertificateConfig(ContainerClusterMasterAuthClientCertificateConfig)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuth.property.clientCertificateConfig">clientCertificateConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthClientCertificateConfig">ContainerClusterMasterAuthClientCertificateConfig</a></code> | client_certificate_config block. |

---

##### `clientCertificateConfig`<sup>Required</sup> <a name="clientCertificateConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuth.property.clientCertificateConfig"></a>

```java
public ContainerClusterMasterAuthClientCertificateConfig getClientCertificateConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthClientCertificateConfig">ContainerClusterMasterAuthClientCertificateConfig</a>

client_certificate_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#client_certificate_config ContainerCluster#client_certificate_config}

---

### ContainerClusterMasterAuthClientCertificateConfig <a name="ContainerClusterMasterAuthClientCertificateConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthClientCertificateConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthClientCertificateConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterMasterAuthClientCertificateConfig;

ContainerClusterMasterAuthClientCertificateConfig.builder()
    .issueClientCertificate(java.lang.Boolean)
    .issueClientCertificate(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthClientCertificateConfig.property.issueClientCertificate">issueClientCertificate</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether client certificate authorization is enabled for this cluster. |

---

##### `issueClientCertificate`<sup>Required</sup> <a name="issueClientCertificate" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthClientCertificateConfig.property.issueClientCertificate"></a>

```java
public java.lang.Object getIssueClientCertificate();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether client certificate authorization is enabled for this cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#issue_client_certificate ContainerCluster#issue_client_certificate}

---

### ContainerClusterMasterAuthorizedNetworksConfig <a name="ContainerClusterMasterAuthorizedNetworksConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterMasterAuthorizedNetworksConfig;

ContainerClusterMasterAuthorizedNetworksConfig.builder()
//  .cidrBlocks(IResolvable)
//  .cidrBlocks(java.util.List<ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks>)
//  .gcpPublicCidrsAccessEnabled(java.lang.Boolean)
//  .gcpPublicCidrsAccessEnabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfig.property.cidrBlocks">cidrBlocks</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks">ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks</a>></code> | cidr_blocks block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfig.property.gcpPublicCidrsAccessEnabled">gcpPublicCidrsAccessEnabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether master is accessbile via Google Compute Engine Public IP addresses. |

---

##### `cidrBlocks`<sup>Optional</sup> <a name="cidrBlocks" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfig.property.cidrBlocks"></a>

```java
public java.lang.Object getCidrBlocks();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks">ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks</a>>

cidr_blocks block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cidr_blocks ContainerCluster#cidr_blocks}

---

##### `gcpPublicCidrsAccessEnabled`<sup>Optional</sup> <a name="gcpPublicCidrsAccessEnabled" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfig.property.gcpPublicCidrsAccessEnabled"></a>

```java
public java.lang.Object getGcpPublicCidrsAccessEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether master is accessbile via Google Compute Engine Public IP addresses.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gcp_public_cidrs_access_enabled ContainerCluster#gcp_public_cidrs_access_enabled}

---

### ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks <a name="ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks;

ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks.builder()
    .cidrBlock(java.lang.String)
//  .displayName(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks.property.cidrBlock">cidrBlock</a></code> | <code>java.lang.String</code> | External network that can access Kubernetes master through HTTPS. Must be specified in CIDR notation. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks.property.displayName">displayName</a></code> | <code>java.lang.String</code> | Field for users to identify CIDR blocks. |

---

##### `cidrBlock`<sup>Required</sup> <a name="cidrBlock" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks.property.cidrBlock"></a>

```java
public java.lang.String getCidrBlock();
```

- *Type:* java.lang.String

External network that can access Kubernetes master through HTTPS. Must be specified in CIDR notation.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cidr_block ContainerCluster#cidr_block}

---

##### `displayName`<sup>Optional</sup> <a name="displayName" id="@cdktf/provider-google.containerCluster.ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks.property.displayName"></a>

```java
public java.lang.String getDisplayName();
```

- *Type:* java.lang.String

Field for users to identify CIDR blocks.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#display_name ContainerCluster#display_name}

---

### ContainerClusterMeshCertificates <a name="ContainerClusterMeshCertificates" id="@cdktf/provider-google.containerCluster.ContainerClusterMeshCertificates"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterMeshCertificates.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterMeshCertificates;

ContainerClusterMeshCertificates.builder()
    .enableCertificates(java.lang.Boolean)
    .enableCertificates(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMeshCertificates.property.enableCertificates">enableCertificates</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | When enabled the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster. |

---

##### `enableCertificates`<sup>Required</sup> <a name="enableCertificates" id="@cdktf/provider-google.containerCluster.ContainerClusterMeshCertificates.property.enableCertificates"></a>

```java
public java.lang.Object getEnableCertificates();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

When enabled the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_certificates ContainerCluster#enable_certificates}

---

### ContainerClusterMonitoringConfig <a name="ContainerClusterMonitoringConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterMonitoringConfig;

ContainerClusterMonitoringConfig.builder()
    .enableComponents(java.util.List<java.lang.String>)
//  .managedPrometheus(ContainerClusterMonitoringConfigManagedPrometheus)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfig.property.enableComponents">enableComponents</a></code> | <code>java.util.List<java.lang.String></code> | GKE components exposing metrics. Valid values include SYSTEM_COMPONENTS, APISERVER, CONTROLLER_MANAGER, and SCHEDULER. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfig.property.managedPrometheus">managedPrometheus</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfigManagedPrometheus">ContainerClusterMonitoringConfigManagedPrometheus</a></code> | managed_prometheus block. |

---

##### `enableComponents`<sup>Required</sup> <a name="enableComponents" id="@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfig.property.enableComponents"></a>

```java
public java.util.List<java.lang.String> getEnableComponents();
```

- *Type:* java.util.List<java.lang.String>

GKE components exposing metrics. Valid values include SYSTEM_COMPONENTS, APISERVER, CONTROLLER_MANAGER, and SCHEDULER.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_components ContainerCluster#enable_components}

---

##### `managedPrometheus`<sup>Optional</sup> <a name="managedPrometheus" id="@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfig.property.managedPrometheus"></a>

```java
public ContainerClusterMonitoringConfigManagedPrometheus getManagedPrometheus();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfigManagedPrometheus">ContainerClusterMonitoringConfigManagedPrometheus</a>

managed_prometheus block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#managed_prometheus ContainerCluster#managed_prometheus}

---

### ContainerClusterMonitoringConfigManagedPrometheus <a name="ContainerClusterMonitoringConfigManagedPrometheus" id="@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfigManagedPrometheus"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfigManagedPrometheus.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterMonitoringConfigManagedPrometheus;

ContainerClusterMonitoringConfigManagedPrometheus.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfigManagedPrometheus.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether or not the managed collection is enabled. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterMonitoringConfigManagedPrometheus.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether or not the managed collection is enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

### ContainerClusterNetworkPolicy <a name="ContainerClusterNetworkPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicy"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicy.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNetworkPolicy;

ContainerClusterNetworkPolicy.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
//  .provider(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicy.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether network policy is enabled on the cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicy.property.provider">provider</a></code> | <code>java.lang.String</code> | The selected network policy provider. Defaults to PROVIDER_UNSPECIFIED. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicy.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether network policy is enabled on the cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-google.containerCluster.ContainerClusterNetworkPolicy.property.provider"></a>

```java
public java.lang.String getProvider();
```

- *Type:* java.lang.String

The selected network policy provider. Defaults to PROVIDER_UNSPECIFIED.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#provider ContainerCluster#provider}

---

### ContainerClusterNodeConfig <a name="ContainerClusterNodeConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfig;

ContainerClusterNodeConfig.builder()
//  .advancedMachineFeatures(ContainerClusterNodeConfigAdvancedMachineFeatures)
//  .bootDiskKmsKey(java.lang.String)
//  .diskSizeGb(java.lang.Number)
//  .diskType(java.lang.String)
//  .ephemeralStorageLocalSsdConfig(ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig)
//  .gcfsConfig(ContainerClusterNodeConfigGcfsConfig)
//  .guestAccelerator(IResolvable)
//  .guestAccelerator(java.util.List<ContainerClusterNodeConfigGuestAccelerator>)
//  .gvnic(ContainerClusterNodeConfigGvnic)
//  .imageType(java.lang.String)
//  .kubeletConfig(ContainerClusterNodeConfigKubeletConfig)
//  .labels(java.util.Map<java.lang.String, java.lang.String>)
//  .linuxNodeConfig(ContainerClusterNodeConfigLinuxNodeConfig)
//  .localNvmeSsdBlockConfig(ContainerClusterNodeConfigLocalNvmeSsdBlockConfig)
//  .localSsdCount(java.lang.Number)
//  .loggingVariant(java.lang.String)
//  .machineType(java.lang.String)
//  .metadata(java.util.Map<java.lang.String, java.lang.String>)
//  .minCpuPlatform(java.lang.String)
//  .nodeGroup(java.lang.String)
//  .oauthScopes(java.util.List<java.lang.String>)
//  .preemptible(java.lang.Boolean)
//  .preemptible(IResolvable)
//  .reservationAffinity(ContainerClusterNodeConfigReservationAffinity)
//  .resourceLabels(java.util.Map<java.lang.String, java.lang.String>)
//  .serviceAccount(java.lang.String)
//  .shieldedInstanceConfig(ContainerClusterNodeConfigShieldedInstanceConfig)
//  .spot(java.lang.Boolean)
//  .spot(IResolvable)
//  .tags(java.util.List<java.lang.String>)
//  .taint(IResolvable)
//  .taint(java.util.List<ContainerClusterNodeConfigTaint>)
//  .workloadMetadataConfig(ContainerClusterNodeConfigWorkloadMetadataConfig)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.advancedMachineFeatures">advancedMachineFeatures</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigAdvancedMachineFeatures">ContainerClusterNodeConfigAdvancedMachineFeatures</a></code> | advanced_machine_features block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.bootDiskKmsKey">bootDiskKmsKey</a></code> | <code>java.lang.String</code> | The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.diskSizeGb">diskSizeGb</a></code> | <code>java.lang.Number</code> | Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.diskType">diskType</a></code> | <code>java.lang.String</code> | Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.ephemeralStorageLocalSsdConfig">ephemeralStorageLocalSsdConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig">ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig</a></code> | ephemeral_storage_local_ssd_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.gcfsConfig">gcfsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGcfsConfig">ContainerClusterNodeConfigGcfsConfig</a></code> | gcfs_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.guestAccelerator">guestAccelerator</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAccelerator">ContainerClusterNodeConfigGuestAccelerator</a>></code> | List of the type and count of accelerator cards attached to the instance. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.gvnic">gvnic</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGvnic">ContainerClusterNodeConfigGvnic</a></code> | gvnic block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.imageType">imageType</a></code> | <code>java.lang.String</code> | The image type to use for this node. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.kubeletConfig">kubeletConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigKubeletConfig">ContainerClusterNodeConfigKubeletConfig</a></code> | kubelet_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.labels">labels</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | The map of Kubernetes labels (key/value pairs) to be applied to each node. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.linuxNodeConfig">linuxNodeConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigLinuxNodeConfig">ContainerClusterNodeConfigLinuxNodeConfig</a></code> | linux_node_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.localNvmeSsdBlockConfig">localNvmeSsdBlockConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigLocalNvmeSsdBlockConfig">ContainerClusterNodeConfigLocalNvmeSsdBlockConfig</a></code> | local_nvme_ssd_block_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.localSsdCount">localSsdCount</a></code> | <code>java.lang.Number</code> | The number of local SSD disks to be attached to the node. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.loggingVariant">loggingVariant</a></code> | <code>java.lang.String</code> | Type of logging agent that is used as the default value for node pools in the cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.machineType">machineType</a></code> | <code>java.lang.String</code> | The name of a Google Compute Engine machine type. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.metadata">metadata</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | The metadata key/value pairs assigned to instances in the cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.minCpuPlatform">minCpuPlatform</a></code> | <code>java.lang.String</code> | Minimum CPU platform to be used by this instance. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.nodeGroup">nodeGroup</a></code> | <code>java.lang.String</code> | Setting this field will assign instances of this pool to run on the specified node group. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.oauthScopes">oauthScopes</a></code> | <code>java.util.List<java.lang.String></code> | The set of Google API scopes to be made available on all of the node VMs. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.preemptible">preemptible</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether the nodes are created as preemptible VM instances. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.reservationAffinity">reservationAffinity</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigReservationAffinity">ContainerClusterNodeConfigReservationAffinity</a></code> | reservation_affinity block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.resourceLabels">resourceLabels</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | The GCE resource labels (a map of key/value pairs) to be applied to the node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.serviceAccount">serviceAccount</a></code> | <code>java.lang.String</code> | The Google Cloud Platform Service Account to be used by the node VMs. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.shieldedInstanceConfig">shieldedInstanceConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigShieldedInstanceConfig">ContainerClusterNodeConfigShieldedInstanceConfig</a></code> | shielded_instance_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.spot">spot</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether the nodes are created as spot VM instances. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.tags">tags</a></code> | <code>java.util.List<java.lang.String></code> | The list of instance tags applied to all nodes. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.taint">taint</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigTaint">ContainerClusterNodeConfigTaint</a>></code> | List of Kubernetes taints to be applied to each node. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.workloadMetadataConfig">workloadMetadataConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigWorkloadMetadataConfig">ContainerClusterNodeConfigWorkloadMetadataConfig</a></code> | workload_metadata_config block. |

---

##### `advancedMachineFeatures`<sup>Optional</sup> <a name="advancedMachineFeatures" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.advancedMachineFeatures"></a>

```java
public ContainerClusterNodeConfigAdvancedMachineFeatures getAdvancedMachineFeatures();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigAdvancedMachineFeatures">ContainerClusterNodeConfigAdvancedMachineFeatures</a>

advanced_machine_features block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#advanced_machine_features ContainerCluster#advanced_machine_features}

---

##### `bootDiskKmsKey`<sup>Optional</sup> <a name="bootDiskKmsKey" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.bootDiskKmsKey"></a>

```java
public java.lang.String getBootDiskKmsKey();
```

- *Type:* java.lang.String

The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#boot_disk_kms_key ContainerCluster#boot_disk_kms_key}

---

##### `diskSizeGb`<sup>Optional</sup> <a name="diskSizeGb" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.diskSizeGb"></a>

```java
public java.lang.Number getDiskSizeGb();
```

- *Type:* java.lang.Number

Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_size_gb ContainerCluster#disk_size_gb}

---

##### `diskType`<sup>Optional</sup> <a name="diskType" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.diskType"></a>

```java
public java.lang.String getDiskType();
```

- *Type:* java.lang.String

Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_type ContainerCluster#disk_type}

---

##### `ephemeralStorageLocalSsdConfig`<sup>Optional</sup> <a name="ephemeralStorageLocalSsdConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.ephemeralStorageLocalSsdConfig"></a>

```java
public ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig getEphemeralStorageLocalSsdConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig">ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig</a>

ephemeral_storage_local_ssd_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#ephemeral_storage_local_ssd_config ContainerCluster#ephemeral_storage_local_ssd_config}

---

##### `gcfsConfig`<sup>Optional</sup> <a name="gcfsConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.gcfsConfig"></a>

```java
public ContainerClusterNodeConfigGcfsConfig getGcfsConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGcfsConfig">ContainerClusterNodeConfigGcfsConfig</a>

gcfs_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gcfs_config ContainerCluster#gcfs_config}

---

##### `guestAccelerator`<sup>Optional</sup> <a name="guestAccelerator" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.guestAccelerator"></a>

```java
public java.lang.Object getGuestAccelerator();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAccelerator">ContainerClusterNodeConfigGuestAccelerator</a>>

List of the type and count of accelerator cards attached to the instance.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#guest_accelerator ContainerCluster#guest_accelerator}

---

##### `gvnic`<sup>Optional</sup> <a name="gvnic" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.gvnic"></a>

```java
public ContainerClusterNodeConfigGvnic getGvnic();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGvnic">ContainerClusterNodeConfigGvnic</a>

gvnic block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gvnic ContainerCluster#gvnic}

---

##### `imageType`<sup>Optional</sup> <a name="imageType" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.imageType"></a>

```java
public java.lang.String getImageType();
```

- *Type:* java.lang.String

The image type to use for this node.

Note that for a given image type, the latest version of it will be used.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#image_type ContainerCluster#image_type}

---

##### `kubeletConfig`<sup>Optional</sup> <a name="kubeletConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.kubeletConfig"></a>

```java
public ContainerClusterNodeConfigKubeletConfig getKubeletConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigKubeletConfig">ContainerClusterNodeConfigKubeletConfig</a>

kubelet_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#kubelet_config ContainerCluster#kubelet_config}

---

##### `labels`<sup>Optional</sup> <a name="labels" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.labels"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getLabels();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

The map of Kubernetes labels (key/value pairs) to be applied to each node.

These will added in addition to any default label(s) that Kubernetes may apply to the node.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#labels ContainerCluster#labels}

---

##### `linuxNodeConfig`<sup>Optional</sup> <a name="linuxNodeConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.linuxNodeConfig"></a>

```java
public ContainerClusterNodeConfigLinuxNodeConfig getLinuxNodeConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigLinuxNodeConfig">ContainerClusterNodeConfigLinuxNodeConfig</a>

linux_node_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#linux_node_config ContainerCluster#linux_node_config}

---

##### `localNvmeSsdBlockConfig`<sup>Optional</sup> <a name="localNvmeSsdBlockConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.localNvmeSsdBlockConfig"></a>

```java
public ContainerClusterNodeConfigLocalNvmeSsdBlockConfig getLocalNvmeSsdBlockConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigLocalNvmeSsdBlockConfig">ContainerClusterNodeConfigLocalNvmeSsdBlockConfig</a>

local_nvme_ssd_block_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#local_nvme_ssd_block_config ContainerCluster#local_nvme_ssd_block_config}

---

##### `localSsdCount`<sup>Optional</sup> <a name="localSsdCount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.localSsdCount"></a>

```java
public java.lang.Number getLocalSsdCount();
```

- *Type:* java.lang.Number

The number of local SSD disks to be attached to the node.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#local_ssd_count ContainerCluster#local_ssd_count}

---

##### `loggingVariant`<sup>Optional</sup> <a name="loggingVariant" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.loggingVariant"></a>

```java
public java.lang.String getLoggingVariant();
```

- *Type:* java.lang.String

Type of logging agent that is used as the default value for node pools in the cluster.

Valid values include DEFAULT and MAX_THROUGHPUT.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#logging_variant ContainerCluster#logging_variant}

---

##### `machineType`<sup>Optional</sup> <a name="machineType" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.machineType"></a>

```java
public java.lang.String getMachineType();
```

- *Type:* java.lang.String

The name of a Google Compute Engine machine type.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#machine_type ContainerCluster#machine_type}

---

##### `metadata`<sup>Optional</sup> <a name="metadata" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.metadata"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getMetadata();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

The metadata key/value pairs assigned to instances in the cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#metadata ContainerCluster#metadata}

---

##### `minCpuPlatform`<sup>Optional</sup> <a name="minCpuPlatform" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.minCpuPlatform"></a>

```java
public java.lang.String getMinCpuPlatform();
```

- *Type:* java.lang.String

Minimum CPU platform to be used by this instance.

The instance may be scheduled on the specified or newer CPU platform.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_cpu_platform ContainerCluster#min_cpu_platform}

---

##### `nodeGroup`<sup>Optional</sup> <a name="nodeGroup" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.nodeGroup"></a>

```java
public java.lang.String getNodeGroup();
```

- *Type:* java.lang.String

Setting this field will assign instances of this pool to run on the specified node group.

This is useful for running workloads on sole tenant nodes.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_group ContainerCluster#node_group}

---

##### `oauthScopes`<sup>Optional</sup> <a name="oauthScopes" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.oauthScopes"></a>

```java
public java.util.List<java.lang.String> getOauthScopes();
```

- *Type:* java.util.List<java.lang.String>

The set of Google API scopes to be made available on all of the node VMs.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#oauth_scopes ContainerCluster#oauth_scopes}

---

##### `preemptible`<sup>Optional</sup> <a name="preemptible" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.preemptible"></a>

```java
public java.lang.Object getPreemptible();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether the nodes are created as preemptible VM instances.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#preemptible ContainerCluster#preemptible}

---

##### `reservationAffinity`<sup>Optional</sup> <a name="reservationAffinity" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.reservationAffinity"></a>

```java
public ContainerClusterNodeConfigReservationAffinity getReservationAffinity();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigReservationAffinity">ContainerClusterNodeConfigReservationAffinity</a>

reservation_affinity block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#reservation_affinity ContainerCluster#reservation_affinity}

---

##### `resourceLabels`<sup>Optional</sup> <a name="resourceLabels" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.resourceLabels"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getResourceLabels();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

The GCE resource labels (a map of key/value pairs) to be applied to the node pool.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_labels ContainerCluster#resource_labels}

---

##### `serviceAccount`<sup>Optional</sup> <a name="serviceAccount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.serviceAccount"></a>

```java
public java.lang.String getServiceAccount();
```

- *Type:* java.lang.String

The Google Cloud Platform Service Account to be used by the node VMs.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#service_account ContainerCluster#service_account}

---

##### `shieldedInstanceConfig`<sup>Optional</sup> <a name="shieldedInstanceConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.shieldedInstanceConfig"></a>

```java
public ContainerClusterNodeConfigShieldedInstanceConfig getShieldedInstanceConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigShieldedInstanceConfig">ContainerClusterNodeConfigShieldedInstanceConfig</a>

shielded_instance_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#shielded_instance_config ContainerCluster#shielded_instance_config}

---

##### `spot`<sup>Optional</sup> <a name="spot" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.spot"></a>

```java
public java.lang.Object getSpot();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether the nodes are created as spot VM instances.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#spot ContainerCluster#spot}

---

##### `tags`<sup>Optional</sup> <a name="tags" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.tags"></a>

```java
public java.util.List<java.lang.String> getTags();
```

- *Type:* java.util.List<java.lang.String>

The list of instance tags applied to all nodes.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#tags ContainerCluster#tags}

---

##### `taint`<sup>Optional</sup> <a name="taint" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.taint"></a>

```java
public java.lang.Object getTaint();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigTaint">ContainerClusterNodeConfigTaint</a>>

List of Kubernetes taints to be applied to each node.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#taint ContainerCluster#taint}

---

##### `workloadMetadataConfig`<sup>Optional</sup> <a name="workloadMetadataConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfig.property.workloadMetadataConfig"></a>

```java
public ContainerClusterNodeConfigWorkloadMetadataConfig getWorkloadMetadataConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigWorkloadMetadataConfig">ContainerClusterNodeConfigWorkloadMetadataConfig</a>

workload_metadata_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#workload_metadata_config ContainerCluster#workload_metadata_config}

---

### ContainerClusterNodeConfigAdvancedMachineFeatures <a name="ContainerClusterNodeConfigAdvancedMachineFeatures" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigAdvancedMachineFeatures"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigAdvancedMachineFeatures.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfigAdvancedMachineFeatures;

ContainerClusterNodeConfigAdvancedMachineFeatures.builder()
    .threadsPerCore(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigAdvancedMachineFeatures.property.threadsPerCore">threadsPerCore</a></code> | <code>java.lang.Number</code> | The number of threads per physical core. |

---

##### `threadsPerCore`<sup>Required</sup> <a name="threadsPerCore" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigAdvancedMachineFeatures.property.threadsPerCore"></a>

```java
public java.lang.Number getThreadsPerCore();
```

- *Type:* java.lang.Number

The number of threads per physical core.

To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#threads_per_core ContainerCluster#threads_per_core}

---

### ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig <a name="ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig;

ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig.builder()
    .localSsdCount(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig.property.localSsdCount">localSsdCount</a></code> | <code>java.lang.Number</code> | Number of local SSDs to use to back ephemeral storage. |

---

##### `localSsdCount`<sup>Required</sup> <a name="localSsdCount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigEphemeralStorageLocalSsdConfig.property.localSsdCount"></a>

```java
public java.lang.Number getLocalSsdCount();
```

- *Type:* java.lang.Number

Number of local SSDs to use to back ephemeral storage.

Uses NVMe interfaces. Each local SSD must be 375 or 3000 GB in size, and all local SSDs must share the same size.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#local_ssd_count ContainerCluster#local_ssd_count}

---

### ContainerClusterNodeConfigGcfsConfig <a name="ContainerClusterNodeConfigGcfsConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGcfsConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGcfsConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfigGcfsConfig;

ContainerClusterNodeConfigGcfsConfig.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGcfsConfig.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether or not GCFS is enabled. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGcfsConfig.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether or not GCFS is enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

### ContainerClusterNodeConfigGuestAccelerator <a name="ContainerClusterNodeConfigGuestAccelerator" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAccelerator"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAccelerator.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfigGuestAccelerator;

ContainerClusterNodeConfigGuestAccelerator.builder()
//  .count(java.lang.Number)
//  .gpuPartitionSize(java.lang.String)
//  .gpuSharingConfig(IResolvable)
//  .gpuSharingConfig(java.util.List<ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig>)
//  .type(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAccelerator.property.count">count</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#count ContainerCluster#count}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAccelerator.property.gpuPartitionSize">gpuPartitionSize</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_partition_size ContainerCluster#gpu_partition_size}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAccelerator.property.gpuSharingConfig">gpuSharingConfig</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig">ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig</a>></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_sharing_config ContainerCluster#gpu_sharing_config}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAccelerator.property.type">type</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#type ContainerCluster#type}. |

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAccelerator.property.count"></a>

```java
public java.lang.Number getCount();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#count ContainerCluster#count}.

---

##### `gpuPartitionSize`<sup>Optional</sup> <a name="gpuPartitionSize" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAccelerator.property.gpuPartitionSize"></a>

```java
public java.lang.String getGpuPartitionSize();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_partition_size ContainerCluster#gpu_partition_size}.

---

##### `gpuSharingConfig`<sup>Optional</sup> <a name="gpuSharingConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAccelerator.property.gpuSharingConfig"></a>

```java
public java.lang.Object getGpuSharingConfig();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig">ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig</a>>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_sharing_config ContainerCluster#gpu_sharing_config}.

---

##### `type`<sup>Optional</sup> <a name="type" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAccelerator.property.type"></a>

```java
public java.lang.String getType();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#type ContainerCluster#type}.

---

### ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig <a name="ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig;

ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig.builder()
//  .gpuSharingStrategy(java.lang.String)
//  .maxSharedClientsPerGpu(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig.property.gpuSharingStrategy">gpuSharingStrategy</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_sharing_strategy ContainerCluster#gpu_sharing_strategy}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig.property.maxSharedClientsPerGpu">maxSharedClientsPerGpu</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_shared_clients_per_gpu ContainerCluster#max_shared_clients_per_gpu}. |

---

##### `gpuSharingStrategy`<sup>Optional</sup> <a name="gpuSharingStrategy" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig.property.gpuSharingStrategy"></a>

```java
public java.lang.String getGpuSharingStrategy();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_sharing_strategy ContainerCluster#gpu_sharing_strategy}.

---

##### `maxSharedClientsPerGpu`<sup>Optional</sup> <a name="maxSharedClientsPerGpu" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGuestAcceleratorGpuSharingConfig.property.maxSharedClientsPerGpu"></a>

```java
public java.lang.Number getMaxSharedClientsPerGpu();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_shared_clients_per_gpu ContainerCluster#max_shared_clients_per_gpu}.

---

### ContainerClusterNodeConfigGvnic <a name="ContainerClusterNodeConfigGvnic" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGvnic"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGvnic.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfigGvnic;

ContainerClusterNodeConfigGvnic.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGvnic.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether or not gvnic is enabled. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigGvnic.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether or not gvnic is enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

### ContainerClusterNodeConfigKubeletConfig <a name="ContainerClusterNodeConfigKubeletConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigKubeletConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigKubeletConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfigKubeletConfig;

ContainerClusterNodeConfigKubeletConfig.builder()
    .cpuManagerPolicy(java.lang.String)
//  .cpuCfsQuota(java.lang.Boolean)
//  .cpuCfsQuota(IResolvable)
//  .cpuCfsQuotaPeriod(java.lang.String)
//  .podPidsLimit(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigKubeletConfig.property.cpuManagerPolicy">cpuManagerPolicy</a></code> | <code>java.lang.String</code> | Control the CPU management policy on the node. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigKubeletConfig.property.cpuCfsQuota">cpuCfsQuota</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Enable CPU CFS quota enforcement for containers that specify CPU limits. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigKubeletConfig.property.cpuCfsQuotaPeriod">cpuCfsQuotaPeriod</a></code> | <code>java.lang.String</code> | Set the CPU CFS quota period value 'cpu.cfs_period_us'. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigKubeletConfig.property.podPidsLimit">podPidsLimit</a></code> | <code>java.lang.Number</code> | Controls the maximum number of processes allowed to run in a pod. |

---

##### `cpuManagerPolicy`<sup>Required</sup> <a name="cpuManagerPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigKubeletConfig.property.cpuManagerPolicy"></a>

```java
public java.lang.String getCpuManagerPolicy();
```

- *Type:* java.lang.String

Control the CPU management policy on the node.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cpu_manager_policy ContainerCluster#cpu_manager_policy}

---

##### `cpuCfsQuota`<sup>Optional</sup> <a name="cpuCfsQuota" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigKubeletConfig.property.cpuCfsQuota"></a>

```java
public java.lang.Object getCpuCfsQuota();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Enable CPU CFS quota enforcement for containers that specify CPU limits.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cpu_cfs_quota ContainerCluster#cpu_cfs_quota}

---

##### `cpuCfsQuotaPeriod`<sup>Optional</sup> <a name="cpuCfsQuotaPeriod" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigKubeletConfig.property.cpuCfsQuotaPeriod"></a>

```java
public java.lang.String getCpuCfsQuotaPeriod();
```

- *Type:* java.lang.String

Set the CPU CFS quota period value 'cpu.cfs_period_us'.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cpu_cfs_quota_period ContainerCluster#cpu_cfs_quota_period}

---

##### `podPidsLimit`<sup>Optional</sup> <a name="podPidsLimit" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigKubeletConfig.property.podPidsLimit"></a>

```java
public java.lang.Number getPodPidsLimit();
```

- *Type:* java.lang.Number

Controls the maximum number of processes allowed to run in a pod.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#pod_pids_limit ContainerCluster#pod_pids_limit}

---

### ContainerClusterNodeConfigLinuxNodeConfig <a name="ContainerClusterNodeConfigLinuxNodeConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigLinuxNodeConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigLinuxNodeConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfigLinuxNodeConfig;

ContainerClusterNodeConfigLinuxNodeConfig.builder()
    .sysctls(java.util.Map<java.lang.String, java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigLinuxNodeConfig.property.sysctls">sysctls</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | The Linux kernel parameters to be applied to the nodes and all pods running on the nodes. |

---

##### `sysctls`<sup>Required</sup> <a name="sysctls" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigLinuxNodeConfig.property.sysctls"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getSysctls();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

The Linux kernel parameters to be applied to the nodes and all pods running on the nodes.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#sysctls ContainerCluster#sysctls}

---

### ContainerClusterNodeConfigLocalNvmeSsdBlockConfig <a name="ContainerClusterNodeConfigLocalNvmeSsdBlockConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigLocalNvmeSsdBlockConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigLocalNvmeSsdBlockConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfigLocalNvmeSsdBlockConfig;

ContainerClusterNodeConfigLocalNvmeSsdBlockConfig.builder()
    .localSsdCount(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigLocalNvmeSsdBlockConfig.property.localSsdCount">localSsdCount</a></code> | <code>java.lang.Number</code> | Number of raw-block local NVMe SSD disks to be attached to the node. |

---

##### `localSsdCount`<sup>Required</sup> <a name="localSsdCount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigLocalNvmeSsdBlockConfig.property.localSsdCount"></a>

```java
public java.lang.Number getLocalSsdCount();
```

- *Type:* java.lang.Number

Number of raw-block local NVMe SSD disks to be attached to the node.

Each local SSD is 375 GB in size.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#local_ssd_count ContainerCluster#local_ssd_count}

---

### ContainerClusterNodeConfigReservationAffinity <a name="ContainerClusterNodeConfigReservationAffinity" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigReservationAffinity"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigReservationAffinity.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfigReservationAffinity;

ContainerClusterNodeConfigReservationAffinity.builder()
    .consumeReservationType(java.lang.String)
//  .key(java.lang.String)
//  .values(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigReservationAffinity.property.consumeReservationType">consumeReservationType</a></code> | <code>java.lang.String</code> | Corresponds to the type of reservation consumption. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigReservationAffinity.property.key">key</a></code> | <code>java.lang.String</code> | The label key of a reservation resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigReservationAffinity.property.values">values</a></code> | <code>java.util.List<java.lang.String></code> | The label values of the reservation resource. |

---

##### `consumeReservationType`<sup>Required</sup> <a name="consumeReservationType" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigReservationAffinity.property.consumeReservationType"></a>

```java
public java.lang.String getConsumeReservationType();
```

- *Type:* java.lang.String

Corresponds to the type of reservation consumption.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#consume_reservation_type ContainerCluster#consume_reservation_type}

---

##### `key`<sup>Optional</sup> <a name="key" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigReservationAffinity.property.key"></a>

```java
public java.lang.String getKey();
```

- *Type:* java.lang.String

The label key of a reservation resource.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key ContainerCluster#key}

---

##### `values`<sup>Optional</sup> <a name="values" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigReservationAffinity.property.values"></a>

```java
public java.util.List<java.lang.String> getValues();
```

- *Type:* java.util.List<java.lang.String>

The label values of the reservation resource.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#values ContainerCluster#values}

---

### ContainerClusterNodeConfigShieldedInstanceConfig <a name="ContainerClusterNodeConfigShieldedInstanceConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigShieldedInstanceConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigShieldedInstanceConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfigShieldedInstanceConfig;

ContainerClusterNodeConfigShieldedInstanceConfig.builder()
//  .enableIntegrityMonitoring(java.lang.Boolean)
//  .enableIntegrityMonitoring(IResolvable)
//  .enableSecureBoot(java.lang.Boolean)
//  .enableSecureBoot(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigShieldedInstanceConfig.property.enableIntegrityMonitoring">enableIntegrityMonitoring</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Defines whether the instance has integrity monitoring enabled. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigShieldedInstanceConfig.property.enableSecureBoot">enableSecureBoot</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Defines whether the instance has Secure Boot enabled. |

---

##### `enableIntegrityMonitoring`<sup>Optional</sup> <a name="enableIntegrityMonitoring" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigShieldedInstanceConfig.property.enableIntegrityMonitoring"></a>

```java
public java.lang.Object getEnableIntegrityMonitoring();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Defines whether the instance has integrity monitoring enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_integrity_monitoring ContainerCluster#enable_integrity_monitoring}

---

##### `enableSecureBoot`<sup>Optional</sup> <a name="enableSecureBoot" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigShieldedInstanceConfig.property.enableSecureBoot"></a>

```java
public java.lang.Object getEnableSecureBoot();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Defines whether the instance has Secure Boot enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_secure_boot ContainerCluster#enable_secure_boot}

---

### ContainerClusterNodeConfigTaint <a name="ContainerClusterNodeConfigTaint" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigTaint"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigTaint.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfigTaint;

ContainerClusterNodeConfigTaint.builder()
//  .effect(java.lang.String)
//  .key(java.lang.String)
//  .value(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigTaint.property.effect">effect</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#effect ContainerCluster#effect}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigTaint.property.key">key</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key ContainerCluster#key}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigTaint.property.value">value</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#value ContainerCluster#value}. |

---

##### `effect`<sup>Optional</sup> <a name="effect" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigTaint.property.effect"></a>

```java
public java.lang.String getEffect();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#effect ContainerCluster#effect}.

---

##### `key`<sup>Optional</sup> <a name="key" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigTaint.property.key"></a>

```java
public java.lang.String getKey();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key ContainerCluster#key}.

---

##### `value`<sup>Optional</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigTaint.property.value"></a>

```java
public java.lang.String getValue();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#value ContainerCluster#value}.

---

### ContainerClusterNodeConfigWorkloadMetadataConfig <a name="ContainerClusterNodeConfigWorkloadMetadataConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigWorkloadMetadataConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigWorkloadMetadataConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodeConfigWorkloadMetadataConfig;

ContainerClusterNodeConfigWorkloadMetadataConfig.builder()
    .mode(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigWorkloadMetadataConfig.property.mode">mode</a></code> | <code>java.lang.String</code> | Mode is the configuration for how to expose metadata to workloads running on the node. |

---

##### `mode`<sup>Required</sup> <a name="mode" id="@cdktf/provider-google.containerCluster.ContainerClusterNodeConfigWorkloadMetadataConfig.property.mode"></a>

```java
public java.lang.String getMode();
```

- *Type:* java.lang.String

Mode is the configuration for how to expose metadata to workloads running on the node.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#mode ContainerCluster#mode}

---

### ContainerClusterNodePool <a name="ContainerClusterNodePool" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePool;

ContainerClusterNodePool.builder()
//  .autoscaling(ContainerClusterNodePoolAutoscaling)
//  .initialNodeCount(java.lang.Number)
//  .management(ContainerClusterNodePoolManagement)
//  .maxPodsPerNode(java.lang.Number)
//  .name(java.lang.String)
//  .namePrefix(java.lang.String)
//  .networkConfig(ContainerClusterNodePoolNetworkConfig)
//  .nodeConfig(ContainerClusterNodePoolNodeConfig)
//  .nodeCount(java.lang.Number)
//  .nodeLocations(java.util.List<java.lang.String>)
//  .placementPolicy(ContainerClusterNodePoolPlacementPolicy)
//  .upgradeSettings(ContainerClusterNodePoolUpgradeSettings)
//  .version(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.autoscaling">autoscaling</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling">ContainerClusterNodePoolAutoscaling</a></code> | autoscaling block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.initialNodeCount">initialNodeCount</a></code> | <code>java.lang.Number</code> | The initial number of nodes for the pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.management">management</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolManagement">ContainerClusterNodePoolManagement</a></code> | management block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.maxPodsPerNode">maxPodsPerNode</a></code> | <code>java.lang.Number</code> | The maximum number of pods per node in this node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.name">name</a></code> | <code>java.lang.String</code> | The name of the node pool. If left blank, Terraform will auto-generate a unique name. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.namePrefix">namePrefix</a></code> | <code>java.lang.String</code> | Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.networkConfig">networkConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNetworkConfig">ContainerClusterNodePoolNetworkConfig</a></code> | network_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.nodeConfig">nodeConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig">ContainerClusterNodePoolNodeConfig</a></code> | node_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.nodeCount">nodeCount</a></code> | <code>java.lang.Number</code> | The number of nodes per instance group. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.nodeLocations">nodeLocations</a></code> | <code>java.util.List<java.lang.String></code> | The list of zones in which the node pool's nodes should be located. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.placementPolicy">placementPolicy</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolPlacementPolicy">ContainerClusterNodePoolPlacementPolicy</a></code> | placement_policy block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.upgradeSettings">upgradeSettings</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettings">ContainerClusterNodePoolUpgradeSettings</a></code> | upgrade_settings block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.version">version</a></code> | <code>java.lang.String</code> | The Kubernetes version for the nodes in this pool. |

---

##### `autoscaling`<sup>Optional</sup> <a name="autoscaling" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.autoscaling"></a>

```java
public ContainerClusterNodePoolAutoscaling getAutoscaling();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling">ContainerClusterNodePoolAutoscaling</a>

autoscaling block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#autoscaling ContainerCluster#autoscaling}

---

##### `initialNodeCount`<sup>Optional</sup> <a name="initialNodeCount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.initialNodeCount"></a>

```java
public java.lang.Number getInitialNodeCount();
```

- *Type:* java.lang.Number

The initial number of nodes for the pool.

In regional or multi-zonal clusters, this is the number of nodes per zone. Changing this will force recreation of the resource.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#initial_node_count ContainerCluster#initial_node_count}

---

##### `management`<sup>Optional</sup> <a name="management" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.management"></a>

```java
public ContainerClusterNodePoolManagement getManagement();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolManagement">ContainerClusterNodePoolManagement</a>

management block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#management ContainerCluster#management}

---

##### `maxPodsPerNode`<sup>Optional</sup> <a name="maxPodsPerNode" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.maxPodsPerNode"></a>

```java
public java.lang.Number getMaxPodsPerNode();
```

- *Type:* java.lang.Number

The maximum number of pods per node in this node pool.

Note that this does not work on node pools which are "route-based" - that is, node pools belonging to clusters that do not have IP Aliasing enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_pods_per_node ContainerCluster#max_pods_per_node}

---

##### `name`<sup>Optional</sup> <a name="name" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.name"></a>

```java
public java.lang.String getName();
```

- *Type:* java.lang.String

The name of the node pool. If left blank, Terraform will auto-generate a unique name.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#name ContainerCluster#name}

---

##### `namePrefix`<sup>Optional</sup> <a name="namePrefix" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.namePrefix"></a>

```java
public java.lang.String getNamePrefix();
```

- *Type:* java.lang.String

Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#name_prefix ContainerCluster#name_prefix}

---

##### `networkConfig`<sup>Optional</sup> <a name="networkConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.networkConfig"></a>

```java
public ContainerClusterNodePoolNetworkConfig getNetworkConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNetworkConfig">ContainerClusterNodePoolNetworkConfig</a>

network_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#network_config ContainerCluster#network_config}

---

##### `nodeConfig`<sup>Optional</sup> <a name="nodeConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.nodeConfig"></a>

```java
public ContainerClusterNodePoolNodeConfig getNodeConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig">ContainerClusterNodePoolNodeConfig</a>

node_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_config ContainerCluster#node_config}

---

##### `nodeCount`<sup>Optional</sup> <a name="nodeCount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.nodeCount"></a>

```java
public java.lang.Number getNodeCount();
```

- *Type:* java.lang.Number

The number of nodes per instance group.

This field can be used to update the number of nodes per instance group but should not be used alongside autoscaling.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_count ContainerCluster#node_count}

---

##### `nodeLocations`<sup>Optional</sup> <a name="nodeLocations" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.nodeLocations"></a>

```java
public java.util.List<java.lang.String> getNodeLocations();
```

- *Type:* java.util.List<java.lang.String>

The list of zones in which the node pool's nodes should be located.

Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If unspecified, the cluster-level node_locations will be used.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_locations ContainerCluster#node_locations}

---

##### `placementPolicy`<sup>Optional</sup> <a name="placementPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.placementPolicy"></a>

```java
public ContainerClusterNodePoolPlacementPolicy getPlacementPolicy();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolPlacementPolicy">ContainerClusterNodePoolPlacementPolicy</a>

placement_policy block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#placement_policy ContainerCluster#placement_policy}

---

##### `upgradeSettings`<sup>Optional</sup> <a name="upgradeSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.upgradeSettings"></a>

```java
public ContainerClusterNodePoolUpgradeSettings getUpgradeSettings();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettings">ContainerClusterNodePoolUpgradeSettings</a>

upgrade_settings block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#upgrade_settings ContainerCluster#upgrade_settings}

---

##### `version`<sup>Optional</sup> <a name="version" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePool.property.version"></a>

```java
public java.lang.String getVersion();
```

- *Type:* java.lang.String

The Kubernetes version for the nodes in this pool.

Note that if this field and auto_upgrade are both specified, they will fight each other for what the node version should be, so setting both is highly discouraged. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#version ContainerCluster#version}

---

### ContainerClusterNodePoolAutoscaling <a name="ContainerClusterNodePoolAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolAutoscaling;

ContainerClusterNodePoolAutoscaling.builder()
//  .locationPolicy(java.lang.String)
//  .maxNodeCount(java.lang.Number)
//  .minNodeCount(java.lang.Number)
//  .totalMaxNodeCount(java.lang.Number)
//  .totalMinNodeCount(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling.property.locationPolicy">locationPolicy</a></code> | <code>java.lang.String</code> | Location policy specifies the algorithm used when scaling-up the node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling.property.maxNodeCount">maxNodeCount</a></code> | <code>java.lang.Number</code> | Maximum number of nodes per zone in the node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling.property.minNodeCount">minNodeCount</a></code> | <code>java.lang.Number</code> | Minimum number of nodes per zone in the node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling.property.totalMaxNodeCount">totalMaxNodeCount</a></code> | <code>java.lang.Number</code> | Maximum number of all nodes in the node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling.property.totalMinNodeCount">totalMinNodeCount</a></code> | <code>java.lang.Number</code> | Minimum number of all nodes in the node pool. |

---

##### `locationPolicy`<sup>Optional</sup> <a name="locationPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling.property.locationPolicy"></a>

```java
public java.lang.String getLocationPolicy();
```

- *Type:* java.lang.String

Location policy specifies the algorithm used when scaling-up the node pool.

"BALANCED" - Is a best effort policy that aims to balance the sizes of available zones. "ANY" - Instructs the cluster autoscaler to prioritize utilization of unused reservations, and reduces preemption risk for Spot VMs.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#location_policy ContainerCluster#location_policy}

---

##### `maxNodeCount`<sup>Optional</sup> <a name="maxNodeCount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling.property.maxNodeCount"></a>

```java
public java.lang.Number getMaxNodeCount();
```

- *Type:* java.lang.Number

Maximum number of nodes per zone in the node pool.

Must be >= min_node_count. Cannot be used with total limits.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_node_count ContainerCluster#max_node_count}

---

##### `minNodeCount`<sup>Optional</sup> <a name="minNodeCount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling.property.minNodeCount"></a>

```java
public java.lang.Number getMinNodeCount();
```

- *Type:* java.lang.Number

Minimum number of nodes per zone in the node pool.

Must be >=0 and <= max_node_count. Cannot be used with total limits.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_node_count ContainerCluster#min_node_count}

---

##### `totalMaxNodeCount`<sup>Optional</sup> <a name="totalMaxNodeCount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling.property.totalMaxNodeCount"></a>

```java
public java.lang.Number getTotalMaxNodeCount();
```

- *Type:* java.lang.Number

Maximum number of all nodes in the node pool.

Must be >= total_min_node_count. Cannot be used with per zone limits.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#total_max_node_count ContainerCluster#total_max_node_count}

---

##### `totalMinNodeCount`<sup>Optional</sup> <a name="totalMinNodeCount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolAutoscaling.property.totalMinNodeCount"></a>

```java
public java.lang.Number getTotalMinNodeCount();
```

- *Type:* java.lang.Number

Minimum number of all nodes in the node pool.

Must be >=0 and <= total_max_node_count. Cannot be used with per zone limits.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#total_min_node_count ContainerCluster#total_min_node_count}

---

### ContainerClusterNodePoolDefaults <a name="ContainerClusterNodePoolDefaults" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaults"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaults.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolDefaults;

ContainerClusterNodePoolDefaults.builder()
//  .nodeConfigDefaults(ContainerClusterNodePoolDefaultsNodeConfigDefaults)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaults.property.nodeConfigDefaults">nodeConfigDefaults</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaultsNodeConfigDefaults">ContainerClusterNodePoolDefaultsNodeConfigDefaults</a></code> | node_config_defaults block. |

---

##### `nodeConfigDefaults`<sup>Optional</sup> <a name="nodeConfigDefaults" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaults.property.nodeConfigDefaults"></a>

```java
public ContainerClusterNodePoolDefaultsNodeConfigDefaults getNodeConfigDefaults();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaultsNodeConfigDefaults">ContainerClusterNodePoolDefaultsNodeConfigDefaults</a>

node_config_defaults block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_config_defaults ContainerCluster#node_config_defaults}

---

### ContainerClusterNodePoolDefaultsNodeConfigDefaults <a name="ContainerClusterNodePoolDefaultsNodeConfigDefaults" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaultsNodeConfigDefaults"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaultsNodeConfigDefaults.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolDefaultsNodeConfigDefaults;

ContainerClusterNodePoolDefaultsNodeConfigDefaults.builder()
//  .loggingVariant(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaultsNodeConfigDefaults.property.loggingVariant">loggingVariant</a></code> | <code>java.lang.String</code> | Type of logging agent that is used as the default value for node pools in the cluster. |

---

##### `loggingVariant`<sup>Optional</sup> <a name="loggingVariant" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolDefaultsNodeConfigDefaults.property.loggingVariant"></a>

```java
public java.lang.String getLoggingVariant();
```

- *Type:* java.lang.String

Type of logging agent that is used as the default value for node pools in the cluster.

Valid values include DEFAULT and MAX_THROUGHPUT.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#logging_variant ContainerCluster#logging_variant}

---

### ContainerClusterNodePoolManagement <a name="ContainerClusterNodePoolManagement" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolManagement"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolManagement.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolManagement;

ContainerClusterNodePoolManagement.builder()
//  .autoRepair(java.lang.Boolean)
//  .autoRepair(IResolvable)
//  .autoUpgrade(java.lang.Boolean)
//  .autoUpgrade(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolManagement.property.autoRepair">autoRepair</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether the nodes will be automatically repaired. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolManagement.property.autoUpgrade">autoUpgrade</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether the nodes will be automatically upgraded. |

---

##### `autoRepair`<sup>Optional</sup> <a name="autoRepair" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolManagement.property.autoRepair"></a>

```java
public java.lang.Object getAutoRepair();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether the nodes will be automatically repaired.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#auto_repair ContainerCluster#auto_repair}

---

##### `autoUpgrade`<sup>Optional</sup> <a name="autoUpgrade" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolManagement.property.autoUpgrade"></a>

```java
public java.lang.Object getAutoUpgrade();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether the nodes will be automatically upgraded.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#auto_upgrade ContainerCluster#auto_upgrade}

---

### ContainerClusterNodePoolNetworkConfig <a name="ContainerClusterNodePoolNetworkConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNetworkConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNetworkConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNetworkConfig;

ContainerClusterNodePoolNetworkConfig.builder()
//  .createPodRange(java.lang.Boolean)
//  .createPodRange(IResolvable)
//  .enablePrivateNodes(java.lang.Boolean)
//  .enablePrivateNodes(IResolvable)
//  .podIpv4CidrBlock(java.lang.String)
//  .podRange(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNetworkConfig.property.createPodRange">createPodRange</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether to create a new range for pod IPs in this node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNetworkConfig.property.enablePrivateNodes">enablePrivateNodes</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether nodes have internal IP addresses only. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNetworkConfig.property.podIpv4CidrBlock">podIpv4CidrBlock</a></code> | <code>java.lang.String</code> | The IP address range for pod IPs in this node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNetworkConfig.property.podRange">podRange</a></code> | <code>java.lang.String</code> | The ID of the secondary range for pod IPs. |

---

##### `createPodRange`<sup>Optional</sup> <a name="createPodRange" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNetworkConfig.property.createPodRange"></a>

```java
public java.lang.Object getCreatePodRange();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether to create a new range for pod IPs in this node pool.

Defaults are provided for pod_range and pod_ipv4_cidr_block if they are not specified.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#create_pod_range ContainerCluster#create_pod_range}

---

##### `enablePrivateNodes`<sup>Optional</sup> <a name="enablePrivateNodes" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNetworkConfig.property.enablePrivateNodes"></a>

```java
public java.lang.Object getEnablePrivateNodes();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether nodes have internal IP addresses only.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_private_nodes ContainerCluster#enable_private_nodes}

---

##### `podIpv4CidrBlock`<sup>Optional</sup> <a name="podIpv4CidrBlock" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNetworkConfig.property.podIpv4CidrBlock"></a>

```java
public java.lang.String getPodIpv4CidrBlock();
```

- *Type:* java.lang.String

The IP address range for pod IPs in this node pool.

Only applicable if create_pod_range is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) to pick a specific range to use.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#pod_ipv4_cidr_block ContainerCluster#pod_ipv4_cidr_block}

---

##### `podRange`<sup>Optional</sup> <a name="podRange" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNetworkConfig.property.podRange"></a>

```java
public java.lang.String getPodRange();
```

- *Type:* java.lang.String

The ID of the secondary range for pod IPs.

If create_pod_range is true, this ID is used for the new range. If create_pod_range is false, uses an existing secondary range with this ID.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#pod_range ContainerCluster#pod_range}

---

### ContainerClusterNodePoolNodeConfig <a name="ContainerClusterNodePoolNodeConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfig;

ContainerClusterNodePoolNodeConfig.builder()
//  .advancedMachineFeatures(ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures)
//  .bootDiskKmsKey(java.lang.String)
//  .diskSizeGb(java.lang.Number)
//  .diskType(java.lang.String)
//  .ephemeralStorageLocalSsdConfig(ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig)
//  .gcfsConfig(ContainerClusterNodePoolNodeConfigGcfsConfig)
//  .guestAccelerator(IResolvable)
//  .guestAccelerator(java.util.List<ContainerClusterNodePoolNodeConfigGuestAccelerator>)
//  .gvnic(ContainerClusterNodePoolNodeConfigGvnic)
//  .imageType(java.lang.String)
//  .kubeletConfig(ContainerClusterNodePoolNodeConfigKubeletConfig)
//  .labels(java.util.Map<java.lang.String, java.lang.String>)
//  .linuxNodeConfig(ContainerClusterNodePoolNodeConfigLinuxNodeConfig)
//  .localNvmeSsdBlockConfig(ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig)
//  .localSsdCount(java.lang.Number)
//  .loggingVariant(java.lang.String)
//  .machineType(java.lang.String)
//  .metadata(java.util.Map<java.lang.String, java.lang.String>)
//  .minCpuPlatform(java.lang.String)
//  .nodeGroup(java.lang.String)
//  .oauthScopes(java.util.List<java.lang.String>)
//  .preemptible(java.lang.Boolean)
//  .preemptible(IResolvable)
//  .reservationAffinity(ContainerClusterNodePoolNodeConfigReservationAffinity)
//  .resourceLabels(java.util.Map<java.lang.String, java.lang.String>)
//  .serviceAccount(java.lang.String)
//  .shieldedInstanceConfig(ContainerClusterNodePoolNodeConfigShieldedInstanceConfig)
//  .spot(java.lang.Boolean)
//  .spot(IResolvable)
//  .tags(java.util.List<java.lang.String>)
//  .taint(IResolvable)
//  .taint(java.util.List<ContainerClusterNodePoolNodeConfigTaint>)
//  .workloadMetadataConfig(ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.advancedMachineFeatures">advancedMachineFeatures</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures">ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures</a></code> | advanced_machine_features block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.bootDiskKmsKey">bootDiskKmsKey</a></code> | <code>java.lang.String</code> | The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.diskSizeGb">diskSizeGb</a></code> | <code>java.lang.Number</code> | Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.diskType">diskType</a></code> | <code>java.lang.String</code> | Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.ephemeralStorageLocalSsdConfig">ephemeralStorageLocalSsdConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig">ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig</a></code> | ephemeral_storage_local_ssd_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.gcfsConfig">gcfsConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGcfsConfig">ContainerClusterNodePoolNodeConfigGcfsConfig</a></code> | gcfs_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.guestAccelerator">guestAccelerator</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAccelerator">ContainerClusterNodePoolNodeConfigGuestAccelerator</a>></code> | List of the type and count of accelerator cards attached to the instance. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.gvnic">gvnic</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGvnic">ContainerClusterNodePoolNodeConfigGvnic</a></code> | gvnic block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.imageType">imageType</a></code> | <code>java.lang.String</code> | The image type to use for this node. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.kubeletConfig">kubeletConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigKubeletConfig">ContainerClusterNodePoolNodeConfigKubeletConfig</a></code> | kubelet_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.labels">labels</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | The map of Kubernetes labels (key/value pairs) to be applied to each node. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.linuxNodeConfig">linuxNodeConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigLinuxNodeConfig">ContainerClusterNodePoolNodeConfigLinuxNodeConfig</a></code> | linux_node_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.localNvmeSsdBlockConfig">localNvmeSsdBlockConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig">ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig</a></code> | local_nvme_ssd_block_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.localSsdCount">localSsdCount</a></code> | <code>java.lang.Number</code> | The number of local SSD disks to be attached to the node. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.loggingVariant">loggingVariant</a></code> | <code>java.lang.String</code> | Type of logging agent that is used as the default value for node pools in the cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.machineType">machineType</a></code> | <code>java.lang.String</code> | The name of a Google Compute Engine machine type. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.metadata">metadata</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | The metadata key/value pairs assigned to instances in the cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.minCpuPlatform">minCpuPlatform</a></code> | <code>java.lang.String</code> | Minimum CPU platform to be used by this instance. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.nodeGroup">nodeGroup</a></code> | <code>java.lang.String</code> | Setting this field will assign instances of this pool to run on the specified node group. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.oauthScopes">oauthScopes</a></code> | <code>java.util.List<java.lang.String></code> | The set of Google API scopes to be made available on all of the node VMs. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.preemptible">preemptible</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether the nodes are created as preemptible VM instances. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.reservationAffinity">reservationAffinity</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigReservationAffinity">ContainerClusterNodePoolNodeConfigReservationAffinity</a></code> | reservation_affinity block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.resourceLabels">resourceLabels</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | The GCE resource labels (a map of key/value pairs) to be applied to the node pool. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.serviceAccount">serviceAccount</a></code> | <code>java.lang.String</code> | The Google Cloud Platform Service Account to be used by the node VMs. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.shieldedInstanceConfig">shieldedInstanceConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigShieldedInstanceConfig">ContainerClusterNodePoolNodeConfigShieldedInstanceConfig</a></code> | shielded_instance_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.spot">spot</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether the nodes are created as spot VM instances. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.tags">tags</a></code> | <code>java.util.List<java.lang.String></code> | The list of instance tags applied to all nodes. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.taint">taint</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigTaint">ContainerClusterNodePoolNodeConfigTaint</a>></code> | List of Kubernetes taints to be applied to each node. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.workloadMetadataConfig">workloadMetadataConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig">ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig</a></code> | workload_metadata_config block. |

---

##### `advancedMachineFeatures`<sup>Optional</sup> <a name="advancedMachineFeatures" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.advancedMachineFeatures"></a>

```java
public ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures getAdvancedMachineFeatures();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures">ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures</a>

advanced_machine_features block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#advanced_machine_features ContainerCluster#advanced_machine_features}

---

##### `bootDiskKmsKey`<sup>Optional</sup> <a name="bootDiskKmsKey" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.bootDiskKmsKey"></a>

```java
public java.lang.String getBootDiskKmsKey();
```

- *Type:* java.lang.String

The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#boot_disk_kms_key ContainerCluster#boot_disk_kms_key}

---

##### `diskSizeGb`<sup>Optional</sup> <a name="diskSizeGb" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.diskSizeGb"></a>

```java
public java.lang.Number getDiskSizeGb();
```

- *Type:* java.lang.Number

Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_size_gb ContainerCluster#disk_size_gb}

---

##### `diskType`<sup>Optional</sup> <a name="diskType" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.diskType"></a>

```java
public java.lang.String getDiskType();
```

- *Type:* java.lang.String

Type of the disk attached to each node. Such as pd-standard, pd-balanced or pd-ssd.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_type ContainerCluster#disk_type}

---

##### `ephemeralStorageLocalSsdConfig`<sup>Optional</sup> <a name="ephemeralStorageLocalSsdConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.ephemeralStorageLocalSsdConfig"></a>

```java
public ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig getEphemeralStorageLocalSsdConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig">ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig</a>

ephemeral_storage_local_ssd_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#ephemeral_storage_local_ssd_config ContainerCluster#ephemeral_storage_local_ssd_config}

---

##### `gcfsConfig`<sup>Optional</sup> <a name="gcfsConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.gcfsConfig"></a>

```java
public ContainerClusterNodePoolNodeConfigGcfsConfig getGcfsConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGcfsConfig">ContainerClusterNodePoolNodeConfigGcfsConfig</a>

gcfs_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gcfs_config ContainerCluster#gcfs_config}

---

##### `guestAccelerator`<sup>Optional</sup> <a name="guestAccelerator" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.guestAccelerator"></a>

```java
public java.lang.Object getGuestAccelerator();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAccelerator">ContainerClusterNodePoolNodeConfigGuestAccelerator</a>>

List of the type and count of accelerator cards attached to the instance.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#guest_accelerator ContainerCluster#guest_accelerator}

---

##### `gvnic`<sup>Optional</sup> <a name="gvnic" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.gvnic"></a>

```java
public ContainerClusterNodePoolNodeConfigGvnic getGvnic();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGvnic">ContainerClusterNodePoolNodeConfigGvnic</a>

gvnic block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gvnic ContainerCluster#gvnic}

---

##### `imageType`<sup>Optional</sup> <a name="imageType" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.imageType"></a>

```java
public java.lang.String getImageType();
```

- *Type:* java.lang.String

The image type to use for this node.

Note that for a given image type, the latest version of it will be used.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#image_type ContainerCluster#image_type}

---

##### `kubeletConfig`<sup>Optional</sup> <a name="kubeletConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.kubeletConfig"></a>

```java
public ContainerClusterNodePoolNodeConfigKubeletConfig getKubeletConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigKubeletConfig">ContainerClusterNodePoolNodeConfigKubeletConfig</a>

kubelet_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#kubelet_config ContainerCluster#kubelet_config}

---

##### `labels`<sup>Optional</sup> <a name="labels" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.labels"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getLabels();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

The map of Kubernetes labels (key/value pairs) to be applied to each node.

These will added in addition to any default label(s) that Kubernetes may apply to the node.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#labels ContainerCluster#labels}

---

##### `linuxNodeConfig`<sup>Optional</sup> <a name="linuxNodeConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.linuxNodeConfig"></a>

```java
public ContainerClusterNodePoolNodeConfigLinuxNodeConfig getLinuxNodeConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigLinuxNodeConfig">ContainerClusterNodePoolNodeConfigLinuxNodeConfig</a>

linux_node_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#linux_node_config ContainerCluster#linux_node_config}

---

##### `localNvmeSsdBlockConfig`<sup>Optional</sup> <a name="localNvmeSsdBlockConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.localNvmeSsdBlockConfig"></a>

```java
public ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig getLocalNvmeSsdBlockConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig">ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig</a>

local_nvme_ssd_block_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#local_nvme_ssd_block_config ContainerCluster#local_nvme_ssd_block_config}

---

##### `localSsdCount`<sup>Optional</sup> <a name="localSsdCount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.localSsdCount"></a>

```java
public java.lang.Number getLocalSsdCount();
```

- *Type:* java.lang.Number

The number of local SSD disks to be attached to the node.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#local_ssd_count ContainerCluster#local_ssd_count}

---

##### `loggingVariant`<sup>Optional</sup> <a name="loggingVariant" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.loggingVariant"></a>

```java
public java.lang.String getLoggingVariant();
```

- *Type:* java.lang.String

Type of logging agent that is used as the default value for node pools in the cluster.

Valid values include DEFAULT and MAX_THROUGHPUT.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#logging_variant ContainerCluster#logging_variant}

---

##### `machineType`<sup>Optional</sup> <a name="machineType" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.machineType"></a>

```java
public java.lang.String getMachineType();
```

- *Type:* java.lang.String

The name of a Google Compute Engine machine type.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#machine_type ContainerCluster#machine_type}

---

##### `metadata`<sup>Optional</sup> <a name="metadata" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.metadata"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getMetadata();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

The metadata key/value pairs assigned to instances in the cluster.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#metadata ContainerCluster#metadata}

---

##### `minCpuPlatform`<sup>Optional</sup> <a name="minCpuPlatform" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.minCpuPlatform"></a>

```java
public java.lang.String getMinCpuPlatform();
```

- *Type:* java.lang.String

Minimum CPU platform to be used by this instance.

The instance may be scheduled on the specified or newer CPU platform.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_cpu_platform ContainerCluster#min_cpu_platform}

---

##### `nodeGroup`<sup>Optional</sup> <a name="nodeGroup" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.nodeGroup"></a>

```java
public java.lang.String getNodeGroup();
```

- *Type:* java.lang.String

Setting this field will assign instances of this pool to run on the specified node group.

This is useful for running workloads on sole tenant nodes.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_group ContainerCluster#node_group}

---

##### `oauthScopes`<sup>Optional</sup> <a name="oauthScopes" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.oauthScopes"></a>

```java
public java.util.List<java.lang.String> getOauthScopes();
```

- *Type:* java.util.List<java.lang.String>

The set of Google API scopes to be made available on all of the node VMs.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#oauth_scopes ContainerCluster#oauth_scopes}

---

##### `preemptible`<sup>Optional</sup> <a name="preemptible" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.preemptible"></a>

```java
public java.lang.Object getPreemptible();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether the nodes are created as preemptible VM instances.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#preemptible ContainerCluster#preemptible}

---

##### `reservationAffinity`<sup>Optional</sup> <a name="reservationAffinity" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.reservationAffinity"></a>

```java
public ContainerClusterNodePoolNodeConfigReservationAffinity getReservationAffinity();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigReservationAffinity">ContainerClusterNodePoolNodeConfigReservationAffinity</a>

reservation_affinity block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#reservation_affinity ContainerCluster#reservation_affinity}

---

##### `resourceLabels`<sup>Optional</sup> <a name="resourceLabels" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.resourceLabels"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getResourceLabels();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

The GCE resource labels (a map of key/value pairs) to be applied to the node pool.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_labels ContainerCluster#resource_labels}

---

##### `serviceAccount`<sup>Optional</sup> <a name="serviceAccount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.serviceAccount"></a>

```java
public java.lang.String getServiceAccount();
```

- *Type:* java.lang.String

The Google Cloud Platform Service Account to be used by the node VMs.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#service_account ContainerCluster#service_account}

---

##### `shieldedInstanceConfig`<sup>Optional</sup> <a name="shieldedInstanceConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.shieldedInstanceConfig"></a>

```java
public ContainerClusterNodePoolNodeConfigShieldedInstanceConfig getShieldedInstanceConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigShieldedInstanceConfig">ContainerClusterNodePoolNodeConfigShieldedInstanceConfig</a>

shielded_instance_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#shielded_instance_config ContainerCluster#shielded_instance_config}

---

##### `spot`<sup>Optional</sup> <a name="spot" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.spot"></a>

```java
public java.lang.Object getSpot();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether the nodes are created as spot VM instances.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#spot ContainerCluster#spot}

---

##### `tags`<sup>Optional</sup> <a name="tags" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.tags"></a>

```java
public java.util.List<java.lang.String> getTags();
```

- *Type:* java.util.List<java.lang.String>

The list of instance tags applied to all nodes.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#tags ContainerCluster#tags}

---

##### `taint`<sup>Optional</sup> <a name="taint" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.taint"></a>

```java
public java.lang.Object getTaint();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigTaint">ContainerClusterNodePoolNodeConfigTaint</a>>

List of Kubernetes taints to be applied to each node.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#taint ContainerCluster#taint}

---

##### `workloadMetadataConfig`<sup>Optional</sup> <a name="workloadMetadataConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfig.property.workloadMetadataConfig"></a>

```java
public ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig getWorkloadMetadataConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig">ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig</a>

workload_metadata_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#workload_metadata_config ContainerCluster#workload_metadata_config}

---

### ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures <a name="ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures;

ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures.builder()
    .threadsPerCore(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures.property.threadsPerCore">threadsPerCore</a></code> | <code>java.lang.Number</code> | The number of threads per physical core. |

---

##### `threadsPerCore`<sup>Required</sup> <a name="threadsPerCore" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigAdvancedMachineFeatures.property.threadsPerCore"></a>

```java
public java.lang.Number getThreadsPerCore();
```

- *Type:* java.lang.Number

The number of threads per physical core.

To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#threads_per_core ContainerCluster#threads_per_core}

---

### ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig <a name="ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig;

ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig.builder()
    .localSsdCount(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig.property.localSsdCount">localSsdCount</a></code> | <code>java.lang.Number</code> | Number of local SSDs to use to back ephemeral storage. |

---

##### `localSsdCount`<sup>Required</sup> <a name="localSsdCount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigEphemeralStorageLocalSsdConfig.property.localSsdCount"></a>

```java
public java.lang.Number getLocalSsdCount();
```

- *Type:* java.lang.Number

Number of local SSDs to use to back ephemeral storage.

Uses NVMe interfaces. Each local SSD must be 375 or 3000 GB in size, and all local SSDs must share the same size.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#local_ssd_count ContainerCluster#local_ssd_count}

---

### ContainerClusterNodePoolNodeConfigGcfsConfig <a name="ContainerClusterNodePoolNodeConfigGcfsConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGcfsConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGcfsConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfigGcfsConfig;

ContainerClusterNodePoolNodeConfigGcfsConfig.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGcfsConfig.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether or not GCFS is enabled. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGcfsConfig.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether or not GCFS is enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

### ContainerClusterNodePoolNodeConfigGuestAccelerator <a name="ContainerClusterNodePoolNodeConfigGuestAccelerator" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAccelerator"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAccelerator.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfigGuestAccelerator;

ContainerClusterNodePoolNodeConfigGuestAccelerator.builder()
//  .count(java.lang.Number)
//  .gpuPartitionSize(java.lang.String)
//  .gpuSharingConfig(IResolvable)
//  .gpuSharingConfig(java.util.List<ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig>)
//  .type(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAccelerator.property.count">count</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#count ContainerCluster#count}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAccelerator.property.gpuPartitionSize">gpuPartitionSize</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_partition_size ContainerCluster#gpu_partition_size}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAccelerator.property.gpuSharingConfig">gpuSharingConfig</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig">ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig</a>></code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_sharing_config ContainerCluster#gpu_sharing_config}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAccelerator.property.type">type</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#type ContainerCluster#type}. |

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAccelerator.property.count"></a>

```java
public java.lang.Number getCount();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#count ContainerCluster#count}.

---

##### `gpuPartitionSize`<sup>Optional</sup> <a name="gpuPartitionSize" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAccelerator.property.gpuPartitionSize"></a>

```java
public java.lang.String getGpuPartitionSize();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_partition_size ContainerCluster#gpu_partition_size}.

---

##### `gpuSharingConfig`<sup>Optional</sup> <a name="gpuSharingConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAccelerator.property.gpuSharingConfig"></a>

```java
public java.lang.Object getGpuSharingConfig();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig">ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig</a>>

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_sharing_config ContainerCluster#gpu_sharing_config}.

---

##### `type`<sup>Optional</sup> <a name="type" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAccelerator.property.type"></a>

```java
public java.lang.String getType();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#type ContainerCluster#type}.

---

### ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig <a name="ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig;

ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig.builder()
//  .gpuSharingStrategy(java.lang.String)
//  .maxSharedClientsPerGpu(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig.property.gpuSharingStrategy">gpuSharingStrategy</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_sharing_strategy ContainerCluster#gpu_sharing_strategy}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig.property.maxSharedClientsPerGpu">maxSharedClientsPerGpu</a></code> | <code>java.lang.Number</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_shared_clients_per_gpu ContainerCluster#max_shared_clients_per_gpu}. |

---

##### `gpuSharingStrategy`<sup>Optional</sup> <a name="gpuSharingStrategy" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig.property.gpuSharingStrategy"></a>

```java
public java.lang.String getGpuSharingStrategy();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_sharing_strategy ContainerCluster#gpu_sharing_strategy}.

---

##### `maxSharedClientsPerGpu`<sup>Optional</sup> <a name="maxSharedClientsPerGpu" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGuestAcceleratorGpuSharingConfig.property.maxSharedClientsPerGpu"></a>

```java
public java.lang.Number getMaxSharedClientsPerGpu();
```

- *Type:* java.lang.Number

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_shared_clients_per_gpu ContainerCluster#max_shared_clients_per_gpu}.

---

### ContainerClusterNodePoolNodeConfigGvnic <a name="ContainerClusterNodePoolNodeConfigGvnic" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGvnic"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGvnic.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfigGvnic;

ContainerClusterNodePoolNodeConfigGvnic.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGvnic.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether or not gvnic is enabled. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigGvnic.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether or not gvnic is enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

### ContainerClusterNodePoolNodeConfigKubeletConfig <a name="ContainerClusterNodePoolNodeConfigKubeletConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigKubeletConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigKubeletConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfigKubeletConfig;

ContainerClusterNodePoolNodeConfigKubeletConfig.builder()
    .cpuManagerPolicy(java.lang.String)
//  .cpuCfsQuota(java.lang.Boolean)
//  .cpuCfsQuota(IResolvable)
//  .cpuCfsQuotaPeriod(java.lang.String)
//  .podPidsLimit(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigKubeletConfig.property.cpuManagerPolicy">cpuManagerPolicy</a></code> | <code>java.lang.String</code> | Control the CPU management policy on the node. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigKubeletConfig.property.cpuCfsQuota">cpuCfsQuota</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Enable CPU CFS quota enforcement for containers that specify CPU limits. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigKubeletConfig.property.cpuCfsQuotaPeriod">cpuCfsQuotaPeriod</a></code> | <code>java.lang.String</code> | Set the CPU CFS quota period value 'cpu.cfs_period_us'. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigKubeletConfig.property.podPidsLimit">podPidsLimit</a></code> | <code>java.lang.Number</code> | Controls the maximum number of processes allowed to run in a pod. |

---

##### `cpuManagerPolicy`<sup>Required</sup> <a name="cpuManagerPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigKubeletConfig.property.cpuManagerPolicy"></a>

```java
public java.lang.String getCpuManagerPolicy();
```

- *Type:* java.lang.String

Control the CPU management policy on the node.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cpu_manager_policy ContainerCluster#cpu_manager_policy}

---

##### `cpuCfsQuota`<sup>Optional</sup> <a name="cpuCfsQuota" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigKubeletConfig.property.cpuCfsQuota"></a>

```java
public java.lang.Object getCpuCfsQuota();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Enable CPU CFS quota enforcement for containers that specify CPU limits.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cpu_cfs_quota ContainerCluster#cpu_cfs_quota}

---

##### `cpuCfsQuotaPeriod`<sup>Optional</sup> <a name="cpuCfsQuotaPeriod" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigKubeletConfig.property.cpuCfsQuotaPeriod"></a>

```java
public java.lang.String getCpuCfsQuotaPeriod();
```

- *Type:* java.lang.String

Set the CPU CFS quota period value 'cpu.cfs_period_us'.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cpu_cfs_quota_period ContainerCluster#cpu_cfs_quota_period}

---

##### `podPidsLimit`<sup>Optional</sup> <a name="podPidsLimit" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigKubeletConfig.property.podPidsLimit"></a>

```java
public java.lang.Number getPodPidsLimit();
```

- *Type:* java.lang.Number

Controls the maximum number of processes allowed to run in a pod.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#pod_pids_limit ContainerCluster#pod_pids_limit}

---

### ContainerClusterNodePoolNodeConfigLinuxNodeConfig <a name="ContainerClusterNodePoolNodeConfigLinuxNodeConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigLinuxNodeConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigLinuxNodeConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfigLinuxNodeConfig;

ContainerClusterNodePoolNodeConfigLinuxNodeConfig.builder()
    .sysctls(java.util.Map<java.lang.String, java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigLinuxNodeConfig.property.sysctls">sysctls</a></code> | <code>java.util.Map<java.lang.String, java.lang.String></code> | The Linux kernel parameters to be applied to the nodes and all pods running on the nodes. |

---

##### `sysctls`<sup>Required</sup> <a name="sysctls" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigLinuxNodeConfig.property.sysctls"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getSysctls();
```

- *Type:* java.util.Map<java.lang.String, java.lang.String>

The Linux kernel parameters to be applied to the nodes and all pods running on the nodes.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#sysctls ContainerCluster#sysctls}

---

### ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig <a name="ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig;

ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig.builder()
    .localSsdCount(java.lang.Number)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig.property.localSsdCount">localSsdCount</a></code> | <code>java.lang.Number</code> | Number of raw-block local NVMe SSD disks to be attached to the node. |

---

##### `localSsdCount`<sup>Required</sup> <a name="localSsdCount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigLocalNvmeSsdBlockConfig.property.localSsdCount"></a>

```java
public java.lang.Number getLocalSsdCount();
```

- *Type:* java.lang.Number

Number of raw-block local NVMe SSD disks to be attached to the node.

Each local SSD is 375 GB in size.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#local_ssd_count ContainerCluster#local_ssd_count}

---

### ContainerClusterNodePoolNodeConfigReservationAffinity <a name="ContainerClusterNodePoolNodeConfigReservationAffinity" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigReservationAffinity"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigReservationAffinity.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfigReservationAffinity;

ContainerClusterNodePoolNodeConfigReservationAffinity.builder()
    .consumeReservationType(java.lang.String)
//  .key(java.lang.String)
//  .values(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigReservationAffinity.property.consumeReservationType">consumeReservationType</a></code> | <code>java.lang.String</code> | Corresponds to the type of reservation consumption. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigReservationAffinity.property.key">key</a></code> | <code>java.lang.String</code> | The label key of a reservation resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigReservationAffinity.property.values">values</a></code> | <code>java.util.List<java.lang.String></code> | The label values of the reservation resource. |

---

##### `consumeReservationType`<sup>Required</sup> <a name="consumeReservationType" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigReservationAffinity.property.consumeReservationType"></a>

```java
public java.lang.String getConsumeReservationType();
```

- *Type:* java.lang.String

Corresponds to the type of reservation consumption.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#consume_reservation_type ContainerCluster#consume_reservation_type}

---

##### `key`<sup>Optional</sup> <a name="key" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigReservationAffinity.property.key"></a>

```java
public java.lang.String getKey();
```

- *Type:* java.lang.String

The label key of a reservation resource.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key ContainerCluster#key}

---

##### `values`<sup>Optional</sup> <a name="values" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigReservationAffinity.property.values"></a>

```java
public java.util.List<java.lang.String> getValues();
```

- *Type:* java.util.List<java.lang.String>

The label values of the reservation resource.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#values ContainerCluster#values}

---

### ContainerClusterNodePoolNodeConfigShieldedInstanceConfig <a name="ContainerClusterNodePoolNodeConfigShieldedInstanceConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigShieldedInstanceConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigShieldedInstanceConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfigShieldedInstanceConfig;

ContainerClusterNodePoolNodeConfigShieldedInstanceConfig.builder()
//  .enableIntegrityMonitoring(java.lang.Boolean)
//  .enableIntegrityMonitoring(IResolvable)
//  .enableSecureBoot(java.lang.Boolean)
//  .enableSecureBoot(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigShieldedInstanceConfig.property.enableIntegrityMonitoring">enableIntegrityMonitoring</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Defines whether the instance has integrity monitoring enabled. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigShieldedInstanceConfig.property.enableSecureBoot">enableSecureBoot</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Defines whether the instance has Secure Boot enabled. |

---

##### `enableIntegrityMonitoring`<sup>Optional</sup> <a name="enableIntegrityMonitoring" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigShieldedInstanceConfig.property.enableIntegrityMonitoring"></a>

```java
public java.lang.Object getEnableIntegrityMonitoring();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Defines whether the instance has integrity monitoring enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_integrity_monitoring ContainerCluster#enable_integrity_monitoring}

---

##### `enableSecureBoot`<sup>Optional</sup> <a name="enableSecureBoot" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigShieldedInstanceConfig.property.enableSecureBoot"></a>

```java
public java.lang.Object getEnableSecureBoot();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Defines whether the instance has Secure Boot enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_secure_boot ContainerCluster#enable_secure_boot}

---

### ContainerClusterNodePoolNodeConfigTaint <a name="ContainerClusterNodePoolNodeConfigTaint" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigTaint"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigTaint.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfigTaint;

ContainerClusterNodePoolNodeConfigTaint.builder()
//  .effect(java.lang.String)
//  .key(java.lang.String)
//  .value(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigTaint.property.effect">effect</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#effect ContainerCluster#effect}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigTaint.property.key">key</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key ContainerCluster#key}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigTaint.property.value">value</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#value ContainerCluster#value}. |

---

##### `effect`<sup>Optional</sup> <a name="effect" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigTaint.property.effect"></a>

```java
public java.lang.String getEffect();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#effect ContainerCluster#effect}.

---

##### `key`<sup>Optional</sup> <a name="key" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigTaint.property.key"></a>

```java
public java.lang.String getKey();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key ContainerCluster#key}.

---

##### `value`<sup>Optional</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigTaint.property.value"></a>

```java
public java.lang.String getValue();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#value ContainerCluster#value}.

---

### ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig <a name="ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig;

ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig.builder()
    .mode(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig.property.mode">mode</a></code> | <code>java.lang.String</code> | Mode is the configuration for how to expose metadata to workloads running on the node. |

---

##### `mode`<sup>Required</sup> <a name="mode" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig.property.mode"></a>

```java
public java.lang.String getMode();
```

- *Type:* java.lang.String

Mode is the configuration for how to expose metadata to workloads running on the node.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#mode ContainerCluster#mode}

---

### ContainerClusterNodePoolPlacementPolicy <a name="ContainerClusterNodePoolPlacementPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolPlacementPolicy"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolPlacementPolicy.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolPlacementPolicy;

ContainerClusterNodePoolPlacementPolicy.builder()
    .type(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolPlacementPolicy.property.type">type</a></code> | <code>java.lang.String</code> | Type defines the type of placement policy. |

---

##### `type`<sup>Required</sup> <a name="type" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolPlacementPolicy.property.type"></a>

```java
public java.lang.String getType();
```

- *Type:* java.lang.String

Type defines the type of placement policy.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#type ContainerCluster#type}

---

### ContainerClusterNodePoolUpgradeSettings <a name="ContainerClusterNodePoolUpgradeSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettings"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettings.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolUpgradeSettings;

ContainerClusterNodePoolUpgradeSettings.builder()
//  .blueGreenSettings(ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings)
//  .maxSurge(java.lang.Number)
//  .maxUnavailable(java.lang.Number)
//  .strategy(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettings.property.blueGreenSettings">blueGreenSettings</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings">ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings</a></code> | blue_green_settings block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettings.property.maxSurge">maxSurge</a></code> | <code>java.lang.Number</code> | The number of additional nodes that can be added to the node pool during an upgrade. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettings.property.maxUnavailable">maxUnavailable</a></code> | <code>java.lang.Number</code> | The number of nodes that can be simultaneously unavailable during an upgrade. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettings.property.strategy">strategy</a></code> | <code>java.lang.String</code> | Update strategy for the given nodepool. |

---

##### `blueGreenSettings`<sup>Optional</sup> <a name="blueGreenSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettings.property.blueGreenSettings"></a>

```java
public ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings getBlueGreenSettings();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings">ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings</a>

blue_green_settings block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#blue_green_settings ContainerCluster#blue_green_settings}

---

##### `maxSurge`<sup>Optional</sup> <a name="maxSurge" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettings.property.maxSurge"></a>

```java
public java.lang.Number getMaxSurge();
```

- *Type:* java.lang.Number

The number of additional nodes that can be added to the node pool during an upgrade.

Increasing max_surge raises the number of nodes that can be upgraded simultaneously. Can be set to 0 or greater.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_surge ContainerCluster#max_surge}

---

##### `maxUnavailable`<sup>Optional</sup> <a name="maxUnavailable" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettings.property.maxUnavailable"></a>

```java
public java.lang.Number getMaxUnavailable();
```

- *Type:* java.lang.Number

The number of nodes that can be simultaneously unavailable during an upgrade.

Increasing max_unavailable raises the number of nodes that can be upgraded in parallel. Can be set to 0 or greater.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_unavailable ContainerCluster#max_unavailable}

---

##### `strategy`<sup>Optional</sup> <a name="strategy" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettings.property.strategy"></a>

```java
public java.lang.String getStrategy();
```

- *Type:* java.lang.String

Update strategy for the given nodepool.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#strategy ContainerCluster#strategy}

---

### ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings <a name="ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings;

ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings.builder()
    .standardRolloutPolicy(ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy)
//  .nodePoolSoakDuration(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings.property.standardRolloutPolicy">standardRolloutPolicy</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy">ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy</a></code> | standard_rollout_policy block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings.property.nodePoolSoakDuration">nodePoolSoakDuration</a></code> | <code>java.lang.String</code> | Time needed after draining entire blue pool. After this period, blue pool will be cleaned up. |

---

##### `standardRolloutPolicy`<sup>Required</sup> <a name="standardRolloutPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings.property.standardRolloutPolicy"></a>

```java
public ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy getStandardRolloutPolicy();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy">ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy</a>

standard_rollout_policy block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#standard_rollout_policy ContainerCluster#standard_rollout_policy}

---

##### `nodePoolSoakDuration`<sup>Optional</sup> <a name="nodePoolSoakDuration" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettings.property.nodePoolSoakDuration"></a>

```java
public java.lang.String getNodePoolSoakDuration();
```

- *Type:* java.lang.String

Time needed after draining entire blue pool. After this period, blue pool will be cleaned up.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_pool_soak_duration ContainerCluster#node_pool_soak_duration}

---

### ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy <a name="ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy;

ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.builder()
//  .batchNodeCount(java.lang.Number)
//  .batchPercentage(java.lang.Number)
//  .batchSoakDuration(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchNodeCount">batchNodeCount</a></code> | <code>java.lang.Number</code> | Number of blue nodes to drain in a batch. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchPercentage">batchPercentage</a></code> | <code>java.lang.Number</code> | Percentage of the blue pool nodes to drain in a batch. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchSoakDuration">batchSoakDuration</a></code> | <code>java.lang.String</code> | Soak time after each batch gets drained. |

---

##### `batchNodeCount`<sup>Optional</sup> <a name="batchNodeCount" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchNodeCount"></a>

```java
public java.lang.Number getBatchNodeCount();
```

- *Type:* java.lang.Number

Number of blue nodes to drain in a batch.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#batch_node_count ContainerCluster#batch_node_count}

---

##### `batchPercentage`<sup>Optional</sup> <a name="batchPercentage" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchPercentage"></a>

```java
public java.lang.Number getBatchPercentage();
```

- *Type:* java.lang.Number

Percentage of the blue pool nodes to drain in a batch.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#batch_percentage ContainerCluster#batch_percentage}

---

##### `batchSoakDuration`<sup>Optional</sup> <a name="batchSoakDuration" id="@cdktf/provider-google.containerCluster.ContainerClusterNodePoolUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy.property.batchSoakDuration"></a>

```java
public java.lang.String getBatchSoakDuration();
```

- *Type:* java.lang.String

Soak time after each batch gets drained.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#batch_soak_duration ContainerCluster#batch_soak_duration}

---

### ContainerClusterNotificationConfig <a name="ContainerClusterNotificationConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNotificationConfig;

ContainerClusterNotificationConfig.builder()
    .pubsub(ContainerClusterNotificationConfigPubsub)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfig.property.pubsub">pubsub</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsub">ContainerClusterNotificationConfigPubsub</a></code> | pubsub block. |

---

##### `pubsub`<sup>Required</sup> <a name="pubsub" id="@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfig.property.pubsub"></a>

```java
public ContainerClusterNotificationConfigPubsub getPubsub();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsub">ContainerClusterNotificationConfigPubsub</a>

pubsub block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#pubsub ContainerCluster#pubsub}

---

### ContainerClusterNotificationConfigPubsub <a name="ContainerClusterNotificationConfigPubsub" id="@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsub"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsub.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNotificationConfigPubsub;

ContainerClusterNotificationConfigPubsub.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
//  .filter(ContainerClusterNotificationConfigPubsubFilter)
//  .topic(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsub.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether or not the notification config is enabled. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsub.property.filter">filter</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsubFilter">ContainerClusterNotificationConfigPubsubFilter</a></code> | filter block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsub.property.topic">topic</a></code> | <code>java.lang.String</code> | The pubsub topic to push upgrade notifications to. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsub.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether or not the notification config is enabled.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

##### `filter`<sup>Optional</sup> <a name="filter" id="@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsub.property.filter"></a>

```java
public ContainerClusterNotificationConfigPubsubFilter getFilter();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsubFilter">ContainerClusterNotificationConfigPubsubFilter</a>

filter block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#filter ContainerCluster#filter}

---

##### `topic`<sup>Optional</sup> <a name="topic" id="@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsub.property.topic"></a>

```java
public java.lang.String getTopic();
```

- *Type:* java.lang.String

The pubsub topic to push upgrade notifications to.

Must be in the same project as the cluster. Must be in the format: projects/{project}/topics/{topic}.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#topic ContainerCluster#topic}

---

### ContainerClusterNotificationConfigPubsubFilter <a name="ContainerClusterNotificationConfigPubsubFilter" id="@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsubFilter"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsubFilter.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterNotificationConfigPubsubFilter;

ContainerClusterNotificationConfigPubsubFilter.builder()
    .eventType(java.util.List<java.lang.String>)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsubFilter.property.eventType">eventType</a></code> | <code>java.util.List<java.lang.String></code> | Can be used to filter what notifications are sent. Valid values include include UPGRADE_AVAILABLE_EVENT, UPGRADE_EVENT and SECURITY_BULLETIN_EVENT. |

---

##### `eventType`<sup>Required</sup> <a name="eventType" id="@cdktf/provider-google.containerCluster.ContainerClusterNotificationConfigPubsubFilter.property.eventType"></a>

```java
public java.util.List<java.lang.String> getEventType();
```

- *Type:* java.util.List<java.lang.String>

Can be used to filter what notifications are sent. Valid values include include UPGRADE_AVAILABLE_EVENT, UPGRADE_EVENT and SECURITY_BULLETIN_EVENT.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#event_type ContainerCluster#event_type}

---

### ContainerClusterPrivateClusterConfig <a name="ContainerClusterPrivateClusterConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterPrivateClusterConfig;

ContainerClusterPrivateClusterConfig.builder()
//  .enablePrivateEndpoint(java.lang.Boolean)
//  .enablePrivateEndpoint(IResolvable)
//  .enablePrivateNodes(java.lang.Boolean)
//  .enablePrivateNodes(IResolvable)
//  .masterGlobalAccessConfig(ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig)
//  .masterIpv4CidrBlock(java.lang.String)
//  .privateEndpointSubnetwork(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig.property.enablePrivateEndpoint">enablePrivateEndpoint</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | When true, the cluster's private endpoint is used as the cluster endpoint and access through the public endpoint is disabled. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig.property.enablePrivateNodes">enablePrivateNodes</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Enables the private cluster feature, creating a private endpoint on the cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig.property.masterGlobalAccessConfig">masterGlobalAccessConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig">ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig</a></code> | master_global_access_config block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig.property.masterIpv4CidrBlock">masterIpv4CidrBlock</a></code> | <code>java.lang.String</code> | The IP range in CIDR notation to use for the hosted master network. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig.property.privateEndpointSubnetwork">privateEndpointSubnetwork</a></code> | <code>java.lang.String</code> | Subnetwork in cluster's network where master's endpoint will be provisioned. |

---

##### `enablePrivateEndpoint`<sup>Optional</sup> <a name="enablePrivateEndpoint" id="@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig.property.enablePrivateEndpoint"></a>

```java
public java.lang.Object getEnablePrivateEndpoint();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

When true, the cluster's private endpoint is used as the cluster endpoint and access through the public endpoint is disabled.

When false, either endpoint can be used. This field only applies to private clusters, when enable_private_nodes is true.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_private_endpoint ContainerCluster#enable_private_endpoint}

---

##### `enablePrivateNodes`<sup>Optional</sup> <a name="enablePrivateNodes" id="@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig.property.enablePrivateNodes"></a>

```java
public java.lang.Object getEnablePrivateNodes();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Enables the private cluster feature, creating a private endpoint on the cluster.

In a private cluster, nodes only have RFC 1918 private addresses and communicate with the master's private endpoint via private networking.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_private_nodes ContainerCluster#enable_private_nodes}

---

##### `masterGlobalAccessConfig`<sup>Optional</sup> <a name="masterGlobalAccessConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig.property.masterGlobalAccessConfig"></a>

```java
public ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig getMasterGlobalAccessConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig">ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig</a>

master_global_access_config block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_global_access_config ContainerCluster#master_global_access_config}

---

##### `masterIpv4CidrBlock`<sup>Optional</sup> <a name="masterIpv4CidrBlock" id="@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig.property.masterIpv4CidrBlock"></a>

```java
public java.lang.String getMasterIpv4CidrBlock();
```

- *Type:* java.lang.String

The IP range in CIDR notation to use for the hosted master network.

This range will be used for assigning private IP addresses to the cluster master(s) and the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network, and it must be a /28 subnet. See Private Cluster Limitations for more details. This field only applies to private clusters, when enable_private_nodes is true.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_ipv4_cidr_block ContainerCluster#master_ipv4_cidr_block}

---

##### `privateEndpointSubnetwork`<sup>Optional</sup> <a name="privateEndpointSubnetwork" id="@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfig.property.privateEndpointSubnetwork"></a>

```java
public java.lang.String getPrivateEndpointSubnetwork();
```

- *Type:* java.lang.String

Subnetwork in cluster's network where master's endpoint will be provisioned.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#private_endpoint_subnetwork ContainerCluster#private_endpoint_subnetwork}

---

### ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig <a name="ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig;

ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether the cluster master is accessible globally or not. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether the cluster master is accessible globally or not.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

### ContainerClusterReleaseChannel <a name="ContainerClusterReleaseChannel" id="@cdktf/provider-google.containerCluster.ContainerClusterReleaseChannel"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterReleaseChannel.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterReleaseChannel;

ContainerClusterReleaseChannel.builder()
    .channel(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterReleaseChannel.property.channel">channel</a></code> | <code>java.lang.String</code> | The selected release channel. |

---

##### `channel`<sup>Required</sup> <a name="channel" id="@cdktf/provider-google.containerCluster.ContainerClusterReleaseChannel.property.channel"></a>

```java
public java.lang.String getChannel();
```

- *Type:* java.lang.String

The selected release channel.

Accepted values are:
UNSPECIFIED: Not set.
RAPID: Weekly upgrade cadence; Early testers and developers who requires new features.
REGULAR: Multiple per month upgrade cadence; Production users who need features not yet offered in the Stable channel.
STABLE: Every few months upgrade cadence; Production users who need stability above all else, and for whom frequent upgrades are too risky.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#channel ContainerCluster#channel}

---

### ContainerClusterResourceUsageExportConfig <a name="ContainerClusterResourceUsageExportConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterResourceUsageExportConfig;

ContainerClusterResourceUsageExportConfig.builder()
    .bigqueryDestination(ContainerClusterResourceUsageExportConfigBigqueryDestination)
//  .enableNetworkEgressMetering(java.lang.Boolean)
//  .enableNetworkEgressMetering(IResolvable)
//  .enableResourceConsumptionMetering(java.lang.Boolean)
//  .enableResourceConsumptionMetering(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig.property.bigqueryDestination">bigqueryDestination</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfigBigqueryDestination">ContainerClusterResourceUsageExportConfigBigqueryDestination</a></code> | bigquery_destination block. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig.property.enableNetworkEgressMetering">enableNetworkEgressMetering</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether to enable network egress metering for this cluster. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig.property.enableResourceConsumptionMetering">enableResourceConsumptionMetering</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Whether to enable resource consumption metering on this cluster. |

---

##### `bigqueryDestination`<sup>Required</sup> <a name="bigqueryDestination" id="@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig.property.bigqueryDestination"></a>

```java
public ContainerClusterResourceUsageExportConfigBigqueryDestination getBigqueryDestination();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfigBigqueryDestination">ContainerClusterResourceUsageExportConfigBigqueryDestination</a>

bigquery_destination block.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#bigquery_destination ContainerCluster#bigquery_destination}

---

##### `enableNetworkEgressMetering`<sup>Optional</sup> <a name="enableNetworkEgressMetering" id="@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig.property.enableNetworkEgressMetering"></a>

```java
public java.lang.Object getEnableNetworkEgressMetering();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether to enable network egress metering for this cluster.

If enabled, a daemonset will be created in the cluster to meter network egress traffic.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_network_egress_metering ContainerCluster#enable_network_egress_metering}

---

##### `enableResourceConsumptionMetering`<sup>Optional</sup> <a name="enableResourceConsumptionMetering" id="@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfig.property.enableResourceConsumptionMetering"></a>

```java
public java.lang.Object getEnableResourceConsumptionMetering();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Whether to enable resource consumption metering on this cluster.

When enabled, a table will be created in the resource export BigQuery dataset to store resource consumption data. The resulting table can be joined with the resource usage table or with BigQuery billing export. Defaults to true.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_resource_consumption_metering ContainerCluster#enable_resource_consumption_metering}

---

### ContainerClusterResourceUsageExportConfigBigqueryDestination <a name="ContainerClusterResourceUsageExportConfigBigqueryDestination" id="@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfigBigqueryDestination"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfigBigqueryDestination.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterResourceUsageExportConfigBigqueryDestination;

ContainerClusterResourceUsageExportConfigBigqueryDestination.builder()
    .datasetId(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfigBigqueryDestination.property.datasetId">datasetId</a></code> | <code>java.lang.String</code> | The ID of a BigQuery Dataset. |

---

##### `datasetId`<sup>Required</sup> <a name="datasetId" id="@cdktf/provider-google.containerCluster.ContainerClusterResourceUsageExportConfigBigqueryDestination.property.datasetId"></a>

```java
public java.lang.String getDatasetId();
```

- *Type:* java.lang.String

The ID of a BigQuery Dataset.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#dataset_id ContainerCluster#dataset_id}

---

### ContainerClusterServiceExternalIpsConfig <a name="ContainerClusterServiceExternalIpsConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterServiceExternalIpsConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterServiceExternalIpsConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterServiceExternalIpsConfig;

ContainerClusterServiceExternalIpsConfig.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterServiceExternalIpsConfig.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | When enabled, services with exterenal ips specified will be allowed. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterServiceExternalIpsConfig.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

When enabled, services with exterenal ips specified will be allowed.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

### ContainerClusterTimeouts <a name="ContainerClusterTimeouts" id="@cdktf/provider-google.containerCluster.ContainerClusterTimeouts"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterTimeouts.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterTimeouts;

ContainerClusterTimeouts.builder()
//  .create(java.lang.String)
//  .delete(java.lang.String)
//  .read(java.lang.String)
//  .update(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterTimeouts.property.create">create</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#create ContainerCluster#create}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterTimeouts.property.delete">delete</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#delete ContainerCluster#delete}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterTimeouts.property.read">read</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#read ContainerCluster#read}. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterTimeouts.property.update">update</a></code> | <code>java.lang.String</code> | Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#update ContainerCluster#update}. |

---

##### `create`<sup>Optional</sup> <a name="create" id="@cdktf/provider-google.containerCluster.ContainerClusterTimeouts.property.create"></a>

```java
public java.lang.String getCreate();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#create ContainerCluster#create}.

---

##### `delete`<sup>Optional</sup> <a name="delete" id="@cdktf/provider-google.containerCluster.ContainerClusterTimeouts.property.delete"></a>

```java
public java.lang.String getDelete();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#delete ContainerCluster#delete}.

---

##### `read`<sup>Optional</sup> <a name="read" id="@cdktf/provider-google.containerCluster.ContainerClusterTimeouts.property.read"></a>

```java
public java.lang.String getRead();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#read ContainerCluster#read}.

---

##### `update`<sup>Optional</sup> <a name="update" id="@cdktf/provider-google.containerCluster.ContainerClusterTimeouts.property.update"></a>

```java
public java.lang.String getUpdate();
```

- *Type:* java.lang.String

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#update ContainerCluster#update}.

---

### ContainerClusterVerticalPodAutoscaling <a name="ContainerClusterVerticalPodAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerClusterVerticalPodAutoscaling"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterVerticalPodAutoscaling.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterVerticalPodAutoscaling;

ContainerClusterVerticalPodAutoscaling.builder()
    .enabled(java.lang.Boolean)
    .enabled(IResolvable)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterVerticalPodAutoscaling.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | Enables vertical pod autoscaling. |

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterVerticalPodAutoscaling.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

Enables vertical pod autoscaling.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}

---

### ContainerClusterWorkloadIdentityConfig <a name="ContainerClusterWorkloadIdentityConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterWorkloadIdentityConfig"></a>

#### Initializer <a name="Initializer" id="@cdktf/provider-google.containerCluster.ContainerClusterWorkloadIdentityConfig.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterWorkloadIdentityConfig;

ContainerClusterWorkloadIdentityConfig.builder()
//  .workloadPool(java.lang.String)
    .build();
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterWorkloadIdentityConfig.property.workloadPool">workloadPool</a></code> | <code>java.lang.String</code> | The workload pool to attach all Kubernetes service accounts to. |

---

##### `workloadPool`<sup>Optional</sup> <a name="workloadPool" id="@cdktf/provider-google.containerCluster.ContainerClusterWorkloadIdentityConfig.property.workloadPool"></a>

```java
public java.lang.String getWorkloadPool();
```

- *Type:* java.lang.String

The workload pool to attach all Kubernetes service accounts to.

Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#workload_pool ContainerCluster#workload_pool}

---

## Classes <a name="Classes" id="Classes"></a>

### ContainerClusterAddonsConfigCloudrunConfigOutputReference <a name="ContainerClusterAddonsConfigCloudrunConfigOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference;

new ContainerClusterAddonsConfigCloudrunConfigOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.resetLoadBalancerType">resetLoadBalancerType</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetLoadBalancerType` <a name="resetLoadBalancerType" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.resetLoadBalancerType"></a>

```java
public void resetLoadBalancerType()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.disabledInput">disabledInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.loadBalancerTypeInput">loadBalancerTypeInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.disabled">disabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.loadBalancerType">loadBalancerType</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfig">ContainerClusterAddonsConfigCloudrunConfig</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `disabledInput`<sup>Optional</sup> <a name="disabledInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.disabledInput"></a>

```java
public java.lang.Object getDisabledInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `loadBalancerTypeInput`<sup>Optional</sup> <a name="loadBalancerTypeInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.loadBalancerTypeInput"></a>

```java
public java.lang.String getLoadBalancerTypeInput();
```

- *Type:* java.lang.String

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.disabled"></a>

```java
public java.lang.Object getDisabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `loadBalancerType`<sup>Required</sup> <a name="loadBalancerType" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.loadBalancerType"></a>

```java
public java.lang.String getLoadBalancerType();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference.property.internalValue"></a>

```java
public ContainerClusterAddonsConfigCloudrunConfig getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfig">ContainerClusterAddonsConfigCloudrunConfig</a>

---


### ContainerClusterAddonsConfigConfigConnectorConfigOutputReference <a name="ContainerClusterAddonsConfigConfigConnectorConfigOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference;

new ContainerClusterAddonsConfigConfigConnectorConfigOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.enabledInput">enabledInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfig">ContainerClusterAddonsConfigConfigConnectorConfig</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `enabledInput`<sup>Optional</sup> <a name="enabledInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.enabledInput"></a>

```java
public java.lang.Object getEnabledInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference.property.internalValue"></a>

```java
public ContainerClusterAddonsConfigConfigConnectorConfig getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfig">ContainerClusterAddonsConfigConfigConnectorConfig</a>

---


### ContainerClusterAddonsConfigDnsCacheConfigOutputReference <a name="ContainerClusterAddonsConfigDnsCacheConfigOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference;

new ContainerClusterAddonsConfigDnsCacheConfigOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.enabledInput">enabledInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfig">ContainerClusterAddonsConfigDnsCacheConfig</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `enabledInput`<sup>Optional</sup> <a name="enabledInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.enabledInput"></a>

```java
public java.lang.Object getEnabledInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference.property.internalValue"></a>

```java
public ContainerClusterAddonsConfigDnsCacheConfig getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfig">ContainerClusterAddonsConfigDnsCacheConfig</a>

---


### ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference <a name="ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference;

new ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.enabledInput">enabledInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `enabledInput`<sup>Optional</sup> <a name="enabledInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.enabledInput"></a>

```java
public java.lang.Object getEnabledInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference.property.internalValue"></a>

```java
public ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a>

---


### ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference <a name="ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference;

new ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.enabledInput">enabledInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `enabledInput`<sup>Optional</sup> <a name="enabledInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.enabledInput"></a>

```java
public java.lang.Object getEnabledInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference.property.internalValue"></a>

```java
public ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a>

---


### ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference <a name="ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference;

new ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.enabledInput">enabledInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfig">ContainerClusterAddonsConfigGkeBackupAgentConfig</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `enabledInput`<sup>Optional</sup> <a name="enabledInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.enabledInput"></a>

```java
public java.lang.Object getEnabledInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference.property.internalValue"></a>

```java
public ContainerClusterAddonsConfigGkeBackupAgentConfig getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfig">ContainerClusterAddonsConfigGkeBackupAgentConfig</a>

---


### ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference <a name="ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference;

new ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.disabledInput">disabledInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.disabled">disabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscaling">ContainerClusterAddonsConfigHorizontalPodAutoscaling</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `disabledInput`<sup>Optional</sup> <a name="disabledInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.disabledInput"></a>

```java
public java.lang.Object getDisabledInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.disabled"></a>

```java
public java.lang.Object getDisabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference.property.internalValue"></a>

```java
public ContainerClusterAddonsConfigHorizontalPodAutoscaling getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscaling">ContainerClusterAddonsConfigHorizontalPodAutoscaling</a>

---


### ContainerClusterAddonsConfigHttpLoadBalancingOutputReference <a name="ContainerClusterAddonsConfigHttpLoadBalancingOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference;

new ContainerClusterAddonsConfigHttpLoadBalancingOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.disabledInput">disabledInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.disabled">disabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancing">ContainerClusterAddonsConfigHttpLoadBalancing</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `disabledInput`<sup>Optional</sup> <a name="disabledInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.disabledInput"></a>

```java
public java.lang.Object getDisabledInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.disabled"></a>

```java
public java.lang.Object getDisabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference.property.internalValue"></a>

```java
public ContainerClusterAddonsConfigHttpLoadBalancing getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancing">ContainerClusterAddonsConfigHttpLoadBalancing</a>

---


### ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference <a name="ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference;

new ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.disabledInput">disabledInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.disabled">disabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfig">ContainerClusterAddonsConfigNetworkPolicyConfig</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `disabledInput`<sup>Optional</sup> <a name="disabledInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.disabledInput"></a>

```java
public java.lang.Object getDisabledInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `disabled`<sup>Required</sup> <a name="disabled" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.disabled"></a>

```java
public java.lang.Object getDisabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference.property.internalValue"></a>

```java
public ContainerClusterAddonsConfigNetworkPolicyConfig getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfig">ContainerClusterAddonsConfigNetworkPolicyConfig</a>

---


### ContainerClusterAddonsConfigOutputReference <a name="ContainerClusterAddonsConfigOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAddonsConfigOutputReference;

new ContainerClusterAddonsConfigOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putCloudrunConfig">putCloudrunConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putConfigConnectorConfig">putConfigConnectorConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putDnsCacheConfig">putDnsCacheConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putGcePersistentDiskCsiDriverConfig">putGcePersistentDiskCsiDriverConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putGcpFilestoreCsiDriverConfig">putGcpFilestoreCsiDriverConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putGkeBackupAgentConfig">putGkeBackupAgentConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putHorizontalPodAutoscaling">putHorizontalPodAutoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putHttpLoadBalancing">putHttpLoadBalancing</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putNetworkPolicyConfig">putNetworkPolicyConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetCloudrunConfig">resetCloudrunConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetConfigConnectorConfig">resetConfigConnectorConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetDnsCacheConfig">resetDnsCacheConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetGcePersistentDiskCsiDriverConfig">resetGcePersistentDiskCsiDriverConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetGcpFilestoreCsiDriverConfig">resetGcpFilestoreCsiDriverConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetGkeBackupAgentConfig">resetGkeBackupAgentConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetHorizontalPodAutoscaling">resetHorizontalPodAutoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetHttpLoadBalancing">resetHttpLoadBalancing</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetNetworkPolicyConfig">resetNetworkPolicyConfig</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `putCloudrunConfig` <a name="putCloudrunConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putCloudrunConfig"></a>

```java
public void putCloudrunConfig(ContainerClusterAddonsConfigCloudrunConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putCloudrunConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfig">ContainerClusterAddonsConfigCloudrunConfig</a>

---

##### `putConfigConnectorConfig` <a name="putConfigConnectorConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putConfigConnectorConfig"></a>

```java
public void putConfigConnectorConfig(ContainerClusterAddonsConfigConfigConnectorConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putConfigConnectorConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfig">ContainerClusterAddonsConfigConfigConnectorConfig</a>

---

##### `putDnsCacheConfig` <a name="putDnsCacheConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putDnsCacheConfig"></a>

```java
public void putDnsCacheConfig(ContainerClusterAddonsConfigDnsCacheConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putDnsCacheConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfig">ContainerClusterAddonsConfigDnsCacheConfig</a>

---

##### `putGcePersistentDiskCsiDriverConfig` <a name="putGcePersistentDiskCsiDriverConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putGcePersistentDiskCsiDriverConfig"></a>

```java
public void putGcePersistentDiskCsiDriverConfig(ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putGcePersistentDiskCsiDriverConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a>

---

##### `putGcpFilestoreCsiDriverConfig` <a name="putGcpFilestoreCsiDriverConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putGcpFilestoreCsiDriverConfig"></a>

```java
public void putGcpFilestoreCsiDriverConfig(ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putGcpFilestoreCsiDriverConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a>

---

##### `putGkeBackupAgentConfig` <a name="putGkeBackupAgentConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putGkeBackupAgentConfig"></a>

```java
public void putGkeBackupAgentConfig(ContainerClusterAddonsConfigGkeBackupAgentConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putGkeBackupAgentConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfig">ContainerClusterAddonsConfigGkeBackupAgentConfig</a>

---

##### `putHorizontalPodAutoscaling` <a name="putHorizontalPodAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putHorizontalPodAutoscaling"></a>

```java
public void putHorizontalPodAutoscaling(ContainerClusterAddonsConfigHorizontalPodAutoscaling value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putHorizontalPodAutoscaling.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscaling">ContainerClusterAddonsConfigHorizontalPodAutoscaling</a>

---

##### `putHttpLoadBalancing` <a name="putHttpLoadBalancing" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putHttpLoadBalancing"></a>

```java
public void putHttpLoadBalancing(ContainerClusterAddonsConfigHttpLoadBalancing value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putHttpLoadBalancing.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancing">ContainerClusterAddonsConfigHttpLoadBalancing</a>

---

##### `putNetworkPolicyConfig` <a name="putNetworkPolicyConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putNetworkPolicyConfig"></a>

```java
public void putNetworkPolicyConfig(ContainerClusterAddonsConfigNetworkPolicyConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.putNetworkPolicyConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfig">ContainerClusterAddonsConfigNetworkPolicyConfig</a>

---

##### `resetCloudrunConfig` <a name="resetCloudrunConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetCloudrunConfig"></a>

```java
public void resetCloudrunConfig()
```

##### `resetConfigConnectorConfig` <a name="resetConfigConnectorConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetConfigConnectorConfig"></a>

```java
public void resetConfigConnectorConfig()
```

##### `resetDnsCacheConfig` <a name="resetDnsCacheConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetDnsCacheConfig"></a>

```java
public void resetDnsCacheConfig()
```

##### `resetGcePersistentDiskCsiDriverConfig` <a name="resetGcePersistentDiskCsiDriverConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetGcePersistentDiskCsiDriverConfig"></a>

```java
public void resetGcePersistentDiskCsiDriverConfig()
```

##### `resetGcpFilestoreCsiDriverConfig` <a name="resetGcpFilestoreCsiDriverConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetGcpFilestoreCsiDriverConfig"></a>

```java
public void resetGcpFilestoreCsiDriverConfig()
```

##### `resetGkeBackupAgentConfig` <a name="resetGkeBackupAgentConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetGkeBackupAgentConfig"></a>

```java
public void resetGkeBackupAgentConfig()
```

##### `resetHorizontalPodAutoscaling` <a name="resetHorizontalPodAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetHorizontalPodAutoscaling"></a>

```java
public void resetHorizontalPodAutoscaling()
```

##### `resetHttpLoadBalancing` <a name="resetHttpLoadBalancing" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetHttpLoadBalancing"></a>

```java
public void resetHttpLoadBalancing()
```

##### `resetNetworkPolicyConfig` <a name="resetNetworkPolicyConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.resetNetworkPolicyConfig"></a>

```java
public void resetNetworkPolicyConfig()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.cloudrunConfig">cloudrunConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference">ContainerClusterAddonsConfigCloudrunConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.configConnectorConfig">configConnectorConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference">ContainerClusterAddonsConfigConfigConnectorConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.dnsCacheConfig">dnsCacheConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference">ContainerClusterAddonsConfigDnsCacheConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.gcePersistentDiskCsiDriverConfig">gcePersistentDiskCsiDriverConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference">ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.gcpFilestoreCsiDriverConfig">gcpFilestoreCsiDriverConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference">ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.gkeBackupAgentConfig">gkeBackupAgentConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference">ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.horizontalPodAutoscaling">horizontalPodAutoscaling</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference">ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.httpLoadBalancing">httpLoadBalancing</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference">ContainerClusterAddonsConfigHttpLoadBalancingOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.networkPolicyConfig">networkPolicyConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference">ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.cloudrunConfigInput">cloudrunConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfig">ContainerClusterAddonsConfigCloudrunConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.configConnectorConfigInput">configConnectorConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfig">ContainerClusterAddonsConfigConfigConnectorConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.dnsCacheConfigInput">dnsCacheConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfig">ContainerClusterAddonsConfigDnsCacheConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.gcePersistentDiskCsiDriverConfigInput">gcePersistentDiskCsiDriverConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.gcpFilestoreCsiDriverConfigInput">gcpFilestoreCsiDriverConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.gkeBackupAgentConfigInput">gkeBackupAgentConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfig">ContainerClusterAddonsConfigGkeBackupAgentConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.horizontalPodAutoscalingInput">horizontalPodAutoscalingInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscaling">ContainerClusterAddonsConfigHorizontalPodAutoscaling</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.httpLoadBalancingInput">httpLoadBalancingInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancing">ContainerClusterAddonsConfigHttpLoadBalancing</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.networkPolicyConfigInput">networkPolicyConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfig">ContainerClusterAddonsConfigNetworkPolicyConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig">ContainerClusterAddonsConfig</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `cloudrunConfig`<sup>Required</sup> <a name="cloudrunConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.cloudrunConfig"></a>

```java
public ContainerClusterAddonsConfigCloudrunConfigOutputReference getCloudrunConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfigOutputReference">ContainerClusterAddonsConfigCloudrunConfigOutputReference</a>

---

##### `configConnectorConfig`<sup>Required</sup> <a name="configConnectorConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.configConnectorConfig"></a>

```java
public ContainerClusterAddonsConfigConfigConnectorConfigOutputReference getConfigConnectorConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfigOutputReference">ContainerClusterAddonsConfigConfigConnectorConfigOutputReference</a>

---

##### `dnsCacheConfig`<sup>Required</sup> <a name="dnsCacheConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.dnsCacheConfig"></a>

```java
public ContainerClusterAddonsConfigDnsCacheConfigOutputReference getDnsCacheConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfigOutputReference">ContainerClusterAddonsConfigDnsCacheConfigOutputReference</a>

---

##### `gcePersistentDiskCsiDriverConfig`<sup>Required</sup> <a name="gcePersistentDiskCsiDriverConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.gcePersistentDiskCsiDriverConfig"></a>

```java
public ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference getGcePersistentDiskCsiDriverConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference">ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfigOutputReference</a>

---

##### `gcpFilestoreCsiDriverConfig`<sup>Required</sup> <a name="gcpFilestoreCsiDriverConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.gcpFilestoreCsiDriverConfig"></a>

```java
public ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference getGcpFilestoreCsiDriverConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference">ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfigOutputReference</a>

---

##### `gkeBackupAgentConfig`<sup>Required</sup> <a name="gkeBackupAgentConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.gkeBackupAgentConfig"></a>

```java
public ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference getGkeBackupAgentConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference">ContainerClusterAddonsConfigGkeBackupAgentConfigOutputReference</a>

---

##### `horizontalPodAutoscaling`<sup>Required</sup> <a name="horizontalPodAutoscaling" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.horizontalPodAutoscaling"></a>

```java
public ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference getHorizontalPodAutoscaling();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference">ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference</a>

---

##### `httpLoadBalancing`<sup>Required</sup> <a name="httpLoadBalancing" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.httpLoadBalancing"></a>

```java
public ContainerClusterAddonsConfigHttpLoadBalancingOutputReference getHttpLoadBalancing();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancingOutputReference">ContainerClusterAddonsConfigHttpLoadBalancingOutputReference</a>

---

##### `networkPolicyConfig`<sup>Required</sup> <a name="networkPolicyConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.networkPolicyConfig"></a>

```java
public ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference getNetworkPolicyConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference">ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference</a>

---

##### `cloudrunConfigInput`<sup>Optional</sup> <a name="cloudrunConfigInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.cloudrunConfigInput"></a>

```java
public ContainerClusterAddonsConfigCloudrunConfig getCloudrunConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigCloudrunConfig">ContainerClusterAddonsConfigCloudrunConfig</a>

---

##### `configConnectorConfigInput`<sup>Optional</sup> <a name="configConnectorConfigInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.configConnectorConfigInput"></a>

```java
public ContainerClusterAddonsConfigConfigConnectorConfig getConfigConnectorConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigConfigConnectorConfig">ContainerClusterAddonsConfigConfigConnectorConfig</a>

---

##### `dnsCacheConfigInput`<sup>Optional</sup> <a name="dnsCacheConfigInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.dnsCacheConfigInput"></a>

```java
public ContainerClusterAddonsConfigDnsCacheConfig getDnsCacheConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigDnsCacheConfig">ContainerClusterAddonsConfigDnsCacheConfig</a>

---

##### `gcePersistentDiskCsiDriverConfigInput`<sup>Optional</sup> <a name="gcePersistentDiskCsiDriverConfigInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.gcePersistentDiskCsiDriverConfigInput"></a>

```java
public ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig getGcePersistentDiskCsiDriverConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig">ContainerClusterAddonsConfigGcePersistentDiskCsiDriverConfig</a>

---

##### `gcpFilestoreCsiDriverConfigInput`<sup>Optional</sup> <a name="gcpFilestoreCsiDriverConfigInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.gcpFilestoreCsiDriverConfigInput"></a>

```java
public ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig getGcpFilestoreCsiDriverConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig">ContainerClusterAddonsConfigGcpFilestoreCsiDriverConfig</a>

---

##### `gkeBackupAgentConfigInput`<sup>Optional</sup> <a name="gkeBackupAgentConfigInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.gkeBackupAgentConfigInput"></a>

```java
public ContainerClusterAddonsConfigGkeBackupAgentConfig getGkeBackupAgentConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigGkeBackupAgentConfig">ContainerClusterAddonsConfigGkeBackupAgentConfig</a>

---

##### `horizontalPodAutoscalingInput`<sup>Optional</sup> <a name="horizontalPodAutoscalingInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.horizontalPodAutoscalingInput"></a>

```java
public ContainerClusterAddonsConfigHorizontalPodAutoscaling getHorizontalPodAutoscalingInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHorizontalPodAutoscaling">ContainerClusterAddonsConfigHorizontalPodAutoscaling</a>

---

##### `httpLoadBalancingInput`<sup>Optional</sup> <a name="httpLoadBalancingInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.httpLoadBalancingInput"></a>

```java
public ContainerClusterAddonsConfigHttpLoadBalancing getHttpLoadBalancingInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigHttpLoadBalancing">ContainerClusterAddonsConfigHttpLoadBalancing</a>

---

##### `networkPolicyConfigInput`<sup>Optional</sup> <a name="networkPolicyConfigInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.networkPolicyConfigInput"></a>

```java
public ContainerClusterAddonsConfigNetworkPolicyConfig getNetworkPolicyConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigNetworkPolicyConfig">ContainerClusterAddonsConfigNetworkPolicyConfig</a>

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfigOutputReference.property.internalValue"></a>

```java
public ContainerClusterAddonsConfig getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAddonsConfig">ContainerClusterAddonsConfig</a>

---


### ContainerClusterAuthenticatorGroupsConfigOutputReference <a name="ContainerClusterAuthenticatorGroupsConfigOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterAuthenticatorGroupsConfigOutputReference;

new ContainerClusterAuthenticatorGroupsConfigOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.property.securityGroupInput">securityGroupInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.property.securityGroup">securityGroup</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfig">ContainerClusterAuthenticatorGroupsConfig</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `securityGroupInput`<sup>Optional</sup> <a name="securityGroupInput" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.property.securityGroupInput"></a>

```java
public java.lang.String getSecurityGroupInput();
```

- *Type:* java.lang.String

---

##### `securityGroup`<sup>Required</sup> <a name="securityGroup" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.property.securityGroup"></a>

```java
public java.lang.String getSecurityGroup();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfigOutputReference.property.internalValue"></a>

```java
public ContainerClusterAuthenticatorGroupsConfig getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterAuthenticatorGroupsConfig">ContainerClusterAuthenticatorGroupsConfig</a>

---


### ContainerClusterBinaryAuthorizationOutputReference <a name="ContainerClusterBinaryAuthorizationOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterBinaryAuthorizationOutputReference;

new ContainerClusterBinaryAuthorizationOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.resetEnabled">resetEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.resetEvaluationMode">resetEvaluationMode</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetEnabled` <a name="resetEnabled" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.resetEnabled"></a>

```java
public void resetEnabled()
```

##### `resetEvaluationMode` <a name="resetEvaluationMode" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.resetEvaluationMode"></a>

```java
public void resetEvaluationMode()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.enabledInput">enabledInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.evaluationModeInput">evaluationModeInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.evaluationMode">evaluationMode</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization">ContainerClusterBinaryAuthorization</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `enabledInput`<sup>Optional</sup> <a name="enabledInput" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.enabledInput"></a>

```java
public java.lang.Object getEnabledInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `evaluationModeInput`<sup>Optional</sup> <a name="evaluationModeInput" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.evaluationModeInput"></a>

```java
public java.lang.String getEvaluationModeInput();
```

- *Type:* java.lang.String

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `evaluationMode`<sup>Required</sup> <a name="evaluationMode" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.evaluationMode"></a>

```java
public java.lang.String getEvaluationMode();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorizationOutputReference.property.internalValue"></a>

```java
public ContainerClusterBinaryAuthorization getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterBinaryAuthorization">ContainerClusterBinaryAuthorization</a>

---


### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference;

new ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resetAutoRepair">resetAutoRepair</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resetAutoUpgrade">resetAutoUpgrade</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetAutoRepair` <a name="resetAutoRepair" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resetAutoRepair"></a>

```java
public void resetAutoRepair()
```

##### `resetAutoUpgrade` <a name="resetAutoUpgrade" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.resetAutoUpgrade"></a>

```java
public void resetAutoUpgrade()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.upgradeOptions">upgradeOptions</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoRepairInput">autoRepairInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoUpgradeInput">autoUpgradeInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoRepair">autoRepair</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoUpgrade">autoUpgrade</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `upgradeOptions`<sup>Required</sup> <a name="upgradeOptions" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.upgradeOptions"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList getUpgradeOptions();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList</a>

---

##### `autoRepairInput`<sup>Optional</sup> <a name="autoRepairInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoRepairInput"></a>

```java
public java.lang.Object getAutoRepairInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `autoUpgradeInput`<sup>Optional</sup> <a name="autoUpgradeInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoUpgradeInput"></a>

```java
public java.lang.Object getAutoUpgradeInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `autoRepair`<sup>Required</sup> <a name="autoRepair" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoRepair"></a>

```java
public java.lang.Object getAutoRepair();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `autoUpgrade`<sup>Required</sup> <a name="autoUpgrade" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.autoUpgrade"></a>

```java
public java.lang.Object getAutoUpgrade();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference.property.internalValue"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement</a>

---


### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList;

new ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList(IInterpolatingParent terraformResource, java.lang.String terraformAttribute, java.lang.Boolean wrapsSet);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer.parameter.wrapsSet">wrapsSet</a></code> | <code>java.lang.Boolean</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

##### `wrapsSet`<sup>Required</sup> <a name="wrapsSet" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.Initializer.parameter.wrapsSet"></a>

- *Type:* java.lang.Boolean

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.get">get</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `get` <a name="get" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.get"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference get(java.lang.Number index)
```

###### `index`<sup>Required</sup> <a name="index" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.get.parameter.index"></a>

- *Type:* java.lang.Number

the index of the item to return.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsList.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---


### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference;

new ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute, java.lang.Number complexObjectIndex, java.lang.Boolean complexObjectIsFromSet);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.complexObjectIndex">complexObjectIndex</a></code> | <code>java.lang.Number</code> | the index of this item in the list. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.complexObjectIsFromSet">complexObjectIsFromSet</a></code> | <code>java.lang.Boolean</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

##### `complexObjectIndex`<sup>Required</sup> <a name="complexObjectIndex" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.complexObjectIndex"></a>

- *Type:* java.lang.Number

the index of this item in the list.

---

##### `complexObjectIsFromSet`<sup>Required</sup> <a name="complexObjectIsFromSet" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.Initializer.parameter.complexObjectIsFromSet"></a>

- *Type:* java.lang.Boolean

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.property.autoUpgradeStartTime">autoUpgradeStartTime</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.property.description">description</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `autoUpgradeStartTime`<sup>Required</sup> <a name="autoUpgradeStartTime" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.property.autoUpgradeStartTime"></a>

```java
public java.lang.String getAutoUpgradeStartTime();
```

- *Type:* java.lang.String

---

##### `description`<sup>Required</sup> <a name="description" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.property.description"></a>

```java
public java.lang.String getDescription();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptionsOutputReference.property.internalValue"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementUpgradeOptions</a>

---


### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference;

new ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.putManagement">putManagement</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.putShieldedInstanceConfig">putShieldedInstanceConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.putUpgradeSettings">putUpgradeSettings</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetBootDiskKmsKey">resetBootDiskKmsKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetDiskSize">resetDiskSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetDiskType">resetDiskType</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetImageType">resetImageType</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetManagement">resetManagement</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetMinCpuPlatform">resetMinCpuPlatform</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetOauthScopes">resetOauthScopes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetServiceAccount">resetServiceAccount</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetShieldedInstanceConfig">resetShieldedInstanceConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetUpgradeSettings">resetUpgradeSettings</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `putManagement` <a name="putManagement" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.putManagement"></a>

```java
public void putManagement(ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.putManagement.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement</a>

---

##### `putShieldedInstanceConfig` <a name="putShieldedInstanceConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.putShieldedInstanceConfig"></a>

```java
public void putShieldedInstanceConfig(ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.putShieldedInstanceConfig.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig</a>

---

##### `putUpgradeSettings` <a name="putUpgradeSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.putUpgradeSettings"></a>

```java
public void putUpgradeSettings(ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.putUpgradeSettings.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings</a>

---

##### `resetBootDiskKmsKey` <a name="resetBootDiskKmsKey" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetBootDiskKmsKey"></a>

```java
public void resetBootDiskKmsKey()
```

##### `resetDiskSize` <a name="resetDiskSize" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetDiskSize"></a>

```java
public void resetDiskSize()
```

##### `resetDiskType` <a name="resetDiskType" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetDiskType"></a>

```java
public void resetDiskType()
```

##### `resetImageType` <a name="resetImageType" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetImageType"></a>

```java
public void resetImageType()
```

##### `resetManagement` <a name="resetManagement" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetManagement"></a>

```java
public void resetManagement()
```

##### `resetMinCpuPlatform` <a name="resetMinCpuPlatform" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetMinCpuPlatform"></a>

```java
public void resetMinCpuPlatform()
```

##### `resetOauthScopes` <a name="resetOauthScopes" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetOauthScopes"></a>

```java
public void resetOauthScopes()
```

##### `resetServiceAccount` <a name="resetServiceAccount" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetServiceAccount"></a>

```java
public void resetServiceAccount()
```

##### `resetShieldedInstanceConfig` <a name="resetShieldedInstanceConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetShieldedInstanceConfig"></a>

```java
public void resetShieldedInstanceConfig()
```

##### `resetUpgradeSettings` <a name="resetUpgradeSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.resetUpgradeSettings"></a>

```java
public void resetUpgradeSettings()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.management">management</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.shieldedInstanceConfig">shieldedInstanceConfig</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.upgradeSettings">upgradeSettings</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.bootDiskKmsKeyInput">bootDiskKmsKeyInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.diskSizeInput">diskSizeInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.diskTypeInput">diskTypeInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.imageTypeInput">imageTypeInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.managementInput">managementInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.minCpuPlatformInput">minCpuPlatformInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.oauthScopesInput">oauthScopesInput</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.serviceAccountInput">serviceAccountInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.shieldedInstanceConfigInput">shieldedInstanceConfigInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.upgradeSettingsInput">upgradeSettingsInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.bootDiskKmsKey">bootDiskKmsKey</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.diskSize">diskSize</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.diskType">diskType</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.imageType">imageType</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.minCpuPlatform">minCpuPlatform</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.oauthScopes">oauthScopes</a></code> | <code>java.util.List<java.lang.String></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.serviceAccount">serviceAccount</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults">ContainerClusterClusterAutoscalingAutoProvisioningDefaults</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `management`<sup>Required</sup> <a name="management" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.management"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference getManagement();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagementOutputReference</a>

---

##### `shieldedInstanceConfig`<sup>Required</sup> <a name="shieldedInstanceConfig" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.shieldedInstanceConfig"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference getShieldedInstanceConfig();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference</a>

---

##### `upgradeSettings`<sup>Required</sup> <a name="upgradeSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.upgradeSettings"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference getUpgradeSettings();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference</a>

---

##### `bootDiskKmsKeyInput`<sup>Optional</sup> <a name="bootDiskKmsKeyInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.bootDiskKmsKeyInput"></a>

```java
public java.lang.String getBootDiskKmsKeyInput();
```

- *Type:* java.lang.String

---

##### `diskSizeInput`<sup>Optional</sup> <a name="diskSizeInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.diskSizeInput"></a>

```java
public java.lang.Number getDiskSizeInput();
```

- *Type:* java.lang.Number

---

##### `diskTypeInput`<sup>Optional</sup> <a name="diskTypeInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.diskTypeInput"></a>

```java
public java.lang.String getDiskTypeInput();
```

- *Type:* java.lang.String

---

##### `imageTypeInput`<sup>Optional</sup> <a name="imageTypeInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.imageTypeInput"></a>

```java
public java.lang.String getImageTypeInput();
```

- *Type:* java.lang.String

---

##### `managementInput`<sup>Optional</sup> <a name="managementInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.managementInput"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement getManagementInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsManagement</a>

---

##### `minCpuPlatformInput`<sup>Optional</sup> <a name="minCpuPlatformInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.minCpuPlatformInput"></a>

```java
public java.lang.String getMinCpuPlatformInput();
```

- *Type:* java.lang.String

---

##### `oauthScopesInput`<sup>Optional</sup> <a name="oauthScopesInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.oauthScopesInput"></a>

```java
public java.util.List<java.lang.String> getOauthScopesInput();
```

- *Type:* java.util.List<java.lang.String>

---

##### `serviceAccountInput`<sup>Optional</sup> <a name="serviceAccountInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.serviceAccountInput"></a>

```java
public java.lang.String getServiceAccountInput();
```

- *Type:* java.lang.String

---

##### `shieldedInstanceConfigInput`<sup>Optional</sup> <a name="shieldedInstanceConfigInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.shieldedInstanceConfigInput"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig getShieldedInstanceConfigInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig</a>

---

##### `upgradeSettingsInput`<sup>Optional</sup> <a name="upgradeSettingsInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.upgradeSettingsInput"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings getUpgradeSettingsInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings</a>

---

##### `bootDiskKmsKey`<sup>Required</sup> <a name="bootDiskKmsKey" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.bootDiskKmsKey"></a>

```java
public java.lang.String getBootDiskKmsKey();
```

- *Type:* java.lang.String

---

##### `diskSize`<sup>Required</sup> <a name="diskSize" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.diskSize"></a>

```java
public java.lang.Number getDiskSize();
```

- *Type:* java.lang.Number

---

##### `diskType`<sup>Required</sup> <a name="diskType" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.diskType"></a>

```java
public java.lang.String getDiskType();
```

- *Type:* java.lang.String

---

##### `imageType`<sup>Required</sup> <a name="imageType" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.imageType"></a>

```java
public java.lang.String getImageType();
```

- *Type:* java.lang.String

---

##### `minCpuPlatform`<sup>Required</sup> <a name="minCpuPlatform" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.minCpuPlatform"></a>

```java
public java.lang.String getMinCpuPlatform();
```

- *Type:* java.lang.String

---

##### `oauthScopes`<sup>Required</sup> <a name="oauthScopes" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.oauthScopes"></a>

```java
public java.util.List<java.lang.String> getOauthScopes();
```

- *Type:* java.util.List<java.lang.String>

---

##### `serviceAccount`<sup>Required</sup> <a name="serviceAccount" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.serviceAccount"></a>

```java
public java.lang.String getServiceAccount();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference.property.internalValue"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaults getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults">ContainerClusterClusterAutoscalingAutoProvisioningDefaults</a>

---


### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference;

new ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.resetEnableIntegrityMonitoring">resetEnableIntegrityMonitoring</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.resetEnableSecureBoot">resetEnableSecureBoot</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetEnableIntegrityMonitoring` <a name="resetEnableIntegrityMonitoring" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.resetEnableIntegrityMonitoring"></a>

```java
public void resetEnableIntegrityMonitoring()
```

##### `resetEnableSecureBoot` <a name="resetEnableSecureBoot" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.resetEnableSecureBoot"></a>

```java
public void resetEnableSecureBoot()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.enableIntegrityMonitoringInput">enableIntegrityMonitoringInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.enableSecureBootInput">enableSecureBootInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.enableIntegrityMonitoring">enableIntegrityMonitoring</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.enableSecureBoot">enableSecureBoot</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `enableIntegrityMonitoringInput`<sup>Optional</sup> <a name="enableIntegrityMonitoringInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.enableIntegrityMonitoringInput"></a>

```java
public java.lang.Object getEnableIntegrityMonitoringInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableSecureBootInput`<sup>Optional</sup> <a name="enableSecureBootInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.enableSecureBootInput"></a>

```java
public java.lang.Object getEnableSecureBootInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableIntegrityMonitoring`<sup>Required</sup> <a name="enableIntegrityMonitoring" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.enableIntegrityMonitoring"></a>

```java
public java.lang.Object getEnableIntegrityMonitoring();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enableSecureBoot`<sup>Required</sup> <a name="enableSecureBoot" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.enableSecureBoot"></a>

```java
public java.lang.Object getEnableSecureBoot();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfigOutputReference.property.internalValue"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsShieldedInstanceConfig</a>

---


### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference;

new ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.putStandardRolloutPolicy">putStandardRolloutPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.resetNodePoolSoakDuration">resetNodePoolSoakDuration</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.resetStandardRolloutPolicy">resetStandardRolloutPolicy</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `putStandardRolloutPolicy` <a name="putStandardRolloutPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.putStandardRolloutPolicy"></a>

```java
public void putStandardRolloutPolicy(ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.putStandardRolloutPolicy.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy</a>

---

##### `resetNodePoolSoakDuration` <a name="resetNodePoolSoakDuration" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.resetNodePoolSoakDuration"></a>

```java
public void resetNodePoolSoakDuration()
```

##### `resetStandardRolloutPolicy` <a name="resetStandardRolloutPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.resetStandardRolloutPolicy"></a>

```java
public void resetStandardRolloutPolicy()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.standardRolloutPolicy">standardRolloutPolicy</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.nodePoolSoakDurationInput">nodePoolSoakDurationInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.standardRolloutPolicyInput">standardRolloutPolicyInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.nodePoolSoakDuration">nodePoolSoakDuration</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `standardRolloutPolicy`<sup>Required</sup> <a name="standardRolloutPolicy" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.standardRolloutPolicy"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference getStandardRolloutPolicy();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference</a>

---

##### `nodePoolSoakDurationInput`<sup>Optional</sup> <a name="nodePoolSoakDurationInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.nodePoolSoakDurationInput"></a>

```java
public java.lang.String getNodePoolSoakDurationInput();
```

- *Type:* java.lang.String

---

##### `standardRolloutPolicyInput`<sup>Optional</sup> <a name="standardRolloutPolicyInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.standardRolloutPolicyInput"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy getStandardRolloutPolicyInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy</a>

---

##### `nodePoolSoakDuration`<sup>Required</sup> <a name="nodePoolSoakDuration" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.nodePoolSoakDuration"></a>

```java
public java.lang.String getNodePoolSoakDuration();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference.property.internalValue"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings</a>

---


### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference;

new ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.resetBatchNodeCount">resetBatchNodeCount</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.resetBatchPercentage">resetBatchPercentage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.resetBatchSoakDuration">resetBatchSoakDuration</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetBatchNodeCount` <a name="resetBatchNodeCount" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.resetBatchNodeCount"></a>

```java
public void resetBatchNodeCount()
```

##### `resetBatchPercentage` <a name="resetBatchPercentage" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.resetBatchPercentage"></a>

```java
public void resetBatchPercentage()
```

##### `resetBatchSoakDuration` <a name="resetBatchSoakDuration" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.resetBatchSoakDuration"></a>

```java
public void resetBatchSoakDuration()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.batchNodeCountInput">batchNodeCountInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.batchPercentageInput">batchPercentageInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.batchSoakDurationInput">batchSoakDurationInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.batchNodeCount">batchNodeCount</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.batchPercentage">batchPercentage</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.batchSoakDuration">batchSoakDuration</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `batchNodeCountInput`<sup>Optional</sup> <a name="batchNodeCountInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.batchNodeCountInput"></a>

```java
public java.lang.Number getBatchNodeCountInput();
```

- *Type:* java.lang.Number

---

##### `batchPercentageInput`<sup>Optional</sup> <a name="batchPercentageInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.batchPercentageInput"></a>

```java
public java.lang.Number getBatchPercentageInput();
```

- *Type:* java.lang.Number

---

##### `batchSoakDurationInput`<sup>Optional</sup> <a name="batchSoakDurationInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.batchSoakDurationInput"></a>

```java
public java.lang.String getBatchSoakDurationInput();
```

- *Type:* java.lang.String

---

##### `batchNodeCount`<sup>Required</sup> <a name="batchNodeCount" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.batchNodeCount"></a>

```java
public java.lang.Number getBatchNodeCount();
```

- *Type:* java.lang.Number

---

##### `batchPercentage`<sup>Required</sup> <a name="batchPercentage" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.batchPercentage"></a>

```java
public java.lang.Number getBatchPercentage();
```

- *Type:* java.lang.Number

---

##### `batchSoakDuration`<sup>Required</sup> <a name="batchSoakDuration" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.batchSoakDuration"></a>

```java
public java.lang.String getBatchSoakDuration();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicyOutputReference.property.internalValue"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsStandardRolloutPolicy</a>

---


### ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference <a name="ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference;

new ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.putBlueGreenSettings">putBlueGreenSettings</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.resetBlueGreenSettings">resetBlueGreenSettings</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.resetMaxSurge">resetMaxSurge</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.resetMaxUnavailable">resetMaxUnavailable</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.resetStrategy">resetStrategy</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `putBlueGreenSettings` <a name="putBlueGreenSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.putBlueGreenSettings"></a>

```java
public void putBlueGreenSettings(ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.putBlueGreenSettings.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings</a>

---

##### `resetBlueGreenSettings` <a name="resetBlueGreenSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.resetBlueGreenSettings"></a>

```java
public void resetBlueGreenSettings()
```

##### `resetMaxSurge` <a name="resetMaxSurge" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.resetMaxSurge"></a>

```java
public void resetMaxSurge()
```

##### `resetMaxUnavailable` <a name="resetMaxUnavailable" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.resetMaxUnavailable"></a>

```java
public void resetMaxUnavailable()
```

##### `resetStrategy` <a name="resetStrategy" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.resetStrategy"></a>

```java
public void resetStrategy()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.blueGreenSettings">blueGreenSettings</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.blueGreenSettingsInput">blueGreenSettingsInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.maxSurgeInput">maxSurgeInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.maxUnavailableInput">maxUnavailableInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.strategyInput">strategyInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.maxSurge">maxSurge</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.maxUnavailable">maxUnavailable</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.strategy">strategy</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `blueGreenSettings`<sup>Required</sup> <a name="blueGreenSettings" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.blueGreenSettings"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference getBlueGreenSettings();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettingsOutputReference</a>

---

##### `blueGreenSettingsInput`<sup>Optional</sup> <a name="blueGreenSettingsInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.blueGreenSettingsInput"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings getBlueGreenSettingsInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsBlueGreenSettings</a>

---

##### `maxSurgeInput`<sup>Optional</sup> <a name="maxSurgeInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.maxSurgeInput"></a>

```java
public java.lang.Number getMaxSurgeInput();
```

- *Type:* java.lang.Number

---

##### `maxUnavailableInput`<sup>Optional</sup> <a name="maxUnavailableInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.maxUnavailableInput"></a>

```java
public java.lang.Number getMaxUnavailableInput();
```

- *Type:* java.lang.Number

---

##### `strategyInput`<sup>Optional</sup> <a name="strategyInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.strategyInput"></a>

```java
public java.lang.String getStrategyInput();
```

- *Type:* java.lang.String

---

##### `maxSurge`<sup>Required</sup> <a name="maxSurge" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.maxSurge"></a>

```java
public java.lang.Number getMaxSurge();
```

- *Type:* java.lang.Number

---

##### `maxUnavailable`<sup>Required</sup> <a name="maxUnavailable" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.maxUnavailable"></a>

```java
public java.lang.Number getMaxUnavailable();
```

- *Type:* java.lang.Number

---

##### `strategy`<sup>Required</sup> <a name="strategy" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.strategy"></a>

```java
public java.lang.String getStrategy();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettingsOutputReference.property.internalValue"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsUpgradeSettings</a>

---


### ContainerClusterClusterAutoscalingOutputReference <a name="ContainerClusterClusterAutoscalingOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingOutputReference;

new ContainerClusterClusterAutoscalingOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.putAutoProvisioningDefaults">putAutoProvisioningDefaults</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.putResourceLimits">putResourceLimits</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.resetAutoProvisioningDefaults">resetAutoProvisioningDefaults</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.resetEnabled">resetEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.resetResourceLimits">resetResourceLimits</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `putAutoProvisioningDefaults` <a name="putAutoProvisioningDefaults" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.putAutoProvisioningDefaults"></a>

```java
public void putAutoProvisioningDefaults(ContainerClusterClusterAutoscalingAutoProvisioningDefaults value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.putAutoProvisioningDefaults.parameter.value"></a>

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults">ContainerClusterClusterAutoscalingAutoProvisioningDefaults</a>

---

##### `putResourceLimits` <a name="putResourceLimits" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.putResourceLimits"></a>

```java
public void putResourceLimits(IResolvable OR java.util.List<ContainerClusterClusterAutoscalingResourceLimits> value)
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.putResourceLimits.parameter.value"></a>

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits">ContainerClusterClusterAutoscalingResourceLimits</a>>

---

##### `resetAutoProvisioningDefaults` <a name="resetAutoProvisioningDefaults" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.resetAutoProvisioningDefaults"></a>

```java
public void resetAutoProvisioningDefaults()
```

##### `resetEnabled` <a name="resetEnabled" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.resetEnabled"></a>

```java
public void resetEnabled()
```

##### `resetResourceLimits` <a name="resetResourceLimits" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.resetResourceLimits"></a>

```java
public void resetResourceLimits()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.autoProvisioningDefaults">autoProvisioningDefaults</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.resourceLimits">resourceLimits</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList">ContainerClusterClusterAutoscalingResourceLimitsList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.autoProvisioningDefaultsInput">autoProvisioningDefaultsInput</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults">ContainerClusterClusterAutoscalingAutoProvisioningDefaults</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.enabledInput">enabledInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.resourceLimitsInput">resourceLimitsInput</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits">ContainerClusterClusterAutoscalingResourceLimits</a>></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling">ContainerClusterClusterAutoscaling</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `autoProvisioningDefaults`<sup>Required</sup> <a name="autoProvisioningDefaults" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.autoProvisioningDefaults"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference getAutoProvisioningDefaults();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference">ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference</a>

---

##### `resourceLimits`<sup>Required</sup> <a name="resourceLimits" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.resourceLimits"></a>

```java
public ContainerClusterClusterAutoscalingResourceLimitsList getResourceLimits();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList">ContainerClusterClusterAutoscalingResourceLimitsList</a>

---

##### `autoProvisioningDefaultsInput`<sup>Optional</sup> <a name="autoProvisioningDefaultsInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.autoProvisioningDefaultsInput"></a>

```java
public ContainerClusterClusterAutoscalingAutoProvisioningDefaults getAutoProvisioningDefaultsInput();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingAutoProvisioningDefaults">ContainerClusterClusterAutoscalingAutoProvisioningDefaults</a>

---

##### `enabledInput`<sup>Optional</sup> <a name="enabledInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.enabledInput"></a>

```java
public java.lang.Object getEnabledInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `resourceLimitsInput`<sup>Optional</sup> <a name="resourceLimitsInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.resourceLimitsInput"></a>

```java
public java.lang.Object getResourceLimitsInput();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits">ContainerClusterClusterAutoscalingResourceLimits</a>>

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingOutputReference.property.internalValue"></a>

```java
public ContainerClusterClusterAutoscaling getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscaling">ContainerClusterClusterAutoscaling</a>

---


### ContainerClusterClusterAutoscalingResourceLimitsList <a name="ContainerClusterClusterAutoscalingResourceLimitsList" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingResourceLimitsList;

new ContainerClusterClusterAutoscalingResourceLimitsList(IInterpolatingParent terraformResource, java.lang.String terraformAttribute, java.lang.Boolean wrapsSet);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.Initializer.parameter.wrapsSet">wrapsSet</a></code> | <code>java.lang.Boolean</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

##### `wrapsSet`<sup>Required</sup> <a name="wrapsSet" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.Initializer.parameter.wrapsSet"></a>

- *Type:* java.lang.Boolean

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.get">get</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `get` <a name="get" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.get"></a>

```java
public ContainerClusterClusterAutoscalingResourceLimitsOutputReference get(java.lang.Number index)
```

###### `index`<sup>Required</sup> <a name="index" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.get.parameter.index"></a>

- *Type:* java.lang.Number

the index of the item to return.

---


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.property.internalValue">internalValue</a></code> | <code>com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits">ContainerClusterClusterAutoscalingResourceLimits</a>></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsList.property.internalValue"></a>

```java
public java.lang.Object getInternalValue();
```

- *Type:* com.hashicorp.cdktf.IResolvable OR java.util.List<<a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits">ContainerClusterClusterAutoscalingResourceLimits</a>>

---


### ContainerClusterClusterAutoscalingResourceLimitsOutputReference <a name="ContainerClusterClusterAutoscalingResourceLimitsOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference;

new ContainerClusterClusterAutoscalingResourceLimitsOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute, java.lang.Number complexObjectIndex, java.lang.Boolean complexObjectIsFromSet);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.Initializer.parameter.complexObjectIndex">complexObjectIndex</a></code> | <code>java.lang.Number</code> | the index of this item in the list. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.Initializer.parameter.complexObjectIsFromSet">complexObjectIsFromSet</a></code> | <code>java.lang.Boolean</code> | whether the list is wrapping a set (will add tolist() to be able to access an item via an index). |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

##### `complexObjectIndex`<sup>Required</sup> <a name="complexObjectIndex" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.Initializer.parameter.complexObjectIndex"></a>

- *Type:* java.lang.Number

the index of this item in the list.

---

##### `complexObjectIsFromSet`<sup>Required</sup> <a name="complexObjectIsFromSet" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.Initializer.parameter.complexObjectIsFromSet"></a>

- *Type:* java.lang.Boolean

whether the list is wrapping a set (will add tolist() to be able to access an item via an index).

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.resetMaximum">resetMaximum</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.resetMinimum">resetMinimum</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.

##### `resetMaximum` <a name="resetMaximum" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.resetMaximum"></a>

```java
public void resetMaximum()
```

##### `resetMinimum` <a name="resetMinimum" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.resetMinimum"></a>

```java
public void resetMinimum()
```


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.maximumInput">maximumInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.minimumInput">minimumInput</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.resourceTypeInput">resourceTypeInput</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.maximum">maximum</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.minimum">minimum</a></code> | <code>java.lang.Number</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.resourceType">resourceType</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits">ContainerClusterClusterAutoscalingResourceLimits</a> OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `maximumInput`<sup>Optional</sup> <a name="maximumInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.maximumInput"></a>

```java
public java.lang.Number getMaximumInput();
```

- *Type:* java.lang.Number

---

##### `minimumInput`<sup>Optional</sup> <a name="minimumInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.minimumInput"></a>

```java
public java.lang.Number getMinimumInput();
```

- *Type:* java.lang.Number

---

##### `resourceTypeInput`<sup>Optional</sup> <a name="resourceTypeInput" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.resourceTypeInput"></a>

```java
public java.lang.String getResourceTypeInput();
```

- *Type:* java.lang.String

---

##### `maximum`<sup>Required</sup> <a name="maximum" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.maximum"></a>

```java
public java.lang.Number getMaximum();
```

- *Type:* java.lang.Number

---

##### `minimum`<sup>Required</sup> <a name="minimum" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.minimum"></a>

```java
public java.lang.Number getMinimum();
```

- *Type:* java.lang.Number

---

##### `resourceType`<sup>Required</sup> <a name="resourceType" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.resourceType"></a>

```java
public java.lang.String getResourceType();
```

- *Type:* java.lang.String

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimitsOutputReference.property.internalValue"></a>

```java
public java.lang.Object getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterClusterAutoscalingResourceLimits">ContainerClusterClusterAutoscalingResourceLimits</a> OR com.hashicorp.cdktf.IResolvable

---


### ContainerClusterConfidentialNodesOutputReference <a name="ContainerClusterConfidentialNodesOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterConfidentialNodesOutputReference;

new ContainerClusterConfidentialNodesOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.property.enabledInput">enabledInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodes">ContainerClusterConfidentialNodes</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `enabledInput`<sup>Optional</sup> <a name="enabledInput" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.property.enabledInput"></a>

```java
public java.lang.Object getEnabledInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodesOutputReference.property.internalValue"></a>

```java
public ContainerClusterConfidentialNodes getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterConfidentialNodes">ContainerClusterConfidentialNodes</a>

---


### ContainerClusterCostManagementConfigOutputReference <a name="ContainerClusterCostManagementConfigOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterCostManagementConfigOutputReference;

new ContainerClusterCostManagementConfigOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.toString"></a>

```java
public java.lang.String toString()
```

Return a string representation of this resolvable object.

Returns a reversible string representation.


#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.property.creationStack">creationStack</a></code> | <code>java.util.List<java.lang.String></code> | The creation stack of this resolvable which will be appended to errors thrown during resolution. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.property.fqn">fqn</a></code> | <code>java.lang.String</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.property.enabledInput">enabledInput</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.property.enabled">enabled</a></code> | <code>java.lang.Boolean OR com.hashicorp.cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.property.internalValue">internalValue</a></code> | <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfig">ContainerClusterCostManagementConfig</a></code> | *No description.* |

---

##### `creationStack`<sup>Required</sup> <a name="creationStack" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.property.creationStack"></a>

```java
public java.util.List<java.lang.String> getCreationStack();
```

- *Type:* java.util.List<java.lang.String>

The creation stack of this resolvable which will be appended to errors thrown during resolution.

If this returns an empty array the stack will not be attached.

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.property.fqn"></a>

```java
public java.lang.String getFqn();
```

- *Type:* java.lang.String

---

##### `enabledInput`<sup>Optional</sup> <a name="enabledInput" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.property.enabledInput"></a>

```java
public java.lang.Object getEnabledInput();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `enabled`<sup>Required</sup> <a name="enabled" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.property.enabled"></a>

```java
public java.lang.Object getEnabled();
```

- *Type:* java.lang.Boolean OR com.hashicorp.cdktf.IResolvable

---

##### `internalValue`<sup>Optional</sup> <a name="internalValue" id="@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfigOutputReference.property.internalValue"></a>

```java
public ContainerClusterCostManagementConfig getInternalValue();
```

- *Type:* <a href="#@cdktf/provider-google.containerCluster.ContainerClusterCostManagementConfig">ContainerClusterCostManagementConfig</a>

---


### ContainerClusterDatabaseEncryptionOutputReference <a name="ContainerClusterDatabaseEncryptionOutputReference" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference"></a>

#### Initializers <a name="Initializers" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.Initializer"></a>

```java
import com.hashicorp.cdktf.providers.google.container_cluster.ContainerClusterDatabaseEncryptionOutputReference;

new ContainerClusterDatabaseEncryptionOutputReference(IInterpolatingParent terraformResource, java.lang.String terraformAttribute);
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.Initializer.parameter.terraformResource">terraformResource</a></code> | <code>com.hashicorp.cdktf.IInterpolatingParent</code> | The parent resource. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.Initializer.parameter.terraformAttribute">terraformAttribute</a></code> | <code>java.lang.String</code> | The attribute on the parent resource this class is referencing. |

---

##### `terraformResource`<sup>Required</sup> <a name="terraformResource" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.Initializer.parameter.terraformResource"></a>

- *Type:* com.hashicorp.cdktf.IInterpolatingParent

The parent resource.

---

##### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.Initializer.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

The attribute on the parent resource this class is referencing.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.computeFqn">computeFqn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.resolve">resolve</a></code> | Produce the Token's value at resolution time. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.toString">toString</a></code> | Return a string representation of this resolvable object. |
| <code><a href="#@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.resetKeyName">resetKeyName</a></code> | *No description.* |

---

##### `computeFqn` <a name="computeFqn" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.computeFqn"></a>

```java
public java.lang.String computeFqn()
```

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getAnyMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Object> getAnyMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getBooleanAttribute"></a>

```java
public IResolvable getBooleanAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getBooleanMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Boolean> getBooleanMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getListAttribute"></a>

```java
public java.util.List<java.lang.String> getListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getNumberAttribute"></a>

```java
public java.lang.Number getNumberAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getNumberListAttribute"></a>

```java
public java.util.List<java.lang.Number> getNumberListAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getNumberMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.Number> getNumberMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getStringAttribute"></a>

```java
public java.lang.String getStringAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getStringMapAttribute"></a>

```java
public java.util.Map<java.lang.String, java.lang.String> getStringMapAttribute(java.lang.String terraformAttribute)
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* java.lang.String

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.interpolationForAttribute"></a>

```java
public IResolvable interpolationForAttribute(java.lang.String property)
```

###### `property`<sup>Required</sup> <a name="property" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.interpolationForAttribute.parameter.property"></a>

- *Type:* java.lang.String

---

##### `resolve` <a name="resolve" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.resolve"></a>

```java
public java.lang.Object resolve(IResolveContext _context)
```

Produce the Token's value at resolution time.

###### `_context`<sup>Required</sup> <a name="_context" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.resolve.parameter._context"></a>

- *Type:* com.hashicorp.cdktf.IResolveContext

---

##### `toString` <a name="toString" id="@cdktf/provider-google.containerCluster.ContainerClusterDatabaseEncryptionOutputReference.toString"></a>

```java
public java.lan