import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccessContextManagerServicePerimeterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the ServicePerimeter and its use. Does not affect
  behavior.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#description AccessContextManagerServicePerimeter#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#id AccessContextManagerServicePerimeter#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource name for the ServicePerimeter. The short_name component must
  begin with a letter and only include alphanumeric and '_'.
  Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#name AccessContextManagerServicePerimeter#name}
    */
    readonly name: string;
    /**
    * The AccessPolicy this ServicePerimeter lives in.
  Format: accessPolicies/{policy_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#parent AccessContextManagerServicePerimeter#parent}
    */
    readonly parent: string;
    /**
    * Specifies the type of the Perimeter. There are two types: regular and
  bridge. Regular Service Perimeter contains resources, access levels,
  and restricted services. Every resource can be in at most
  ONE regular Service Perimeter.
  
  In addition to being in a regular service perimeter, a resource can also
  be in zero or more perimeter bridges. A perimeter bridge only contains
  resources. Cross project operations are permitted if all effected
  resources share some perimeter (whether bridge or regular). Perimeter
  Bridge does not contain access levels or services: those are governed
  entirely by the regular perimeter that resource is in.
  
  Perimeter Bridges are typically useful when building more complex
  topologies with many independent perimeters that need to share some data
  with a common perimeter, but should not be able to share data among
  themselves. Default value: "PERIMETER_TYPE_REGULAR" Possible values: ["PERIMETER_TYPE_REGULAR", "PERIMETER_TYPE_BRIDGE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#perimeter_type AccessContextManagerServicePerimeter#perimeter_type}
    */
    readonly perimeterType?: string;
    /**
    * Human readable title. Must be unique within the Policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#title AccessContextManagerServicePerimeter#title}
    */
    readonly title: string;
    /**
    * Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly exists
  for all Service Perimeters, and that spec is identical to the status for those
  Service Perimeters. When this flag is set, it inhibits the generation of the
  implicit spec, thereby allowing the user to explicitly provide a
  configuration ("spec") to use in a dry-run version of the Service Perimeter.
  This allows the user to test changes to the enforced config ("status") without
  actually enforcing them. This testing is done through analyzing the differences
  between currently enforced and suggested restrictions. useExplicitDryRunSpec must
  bet set to True if any of the fields in the spec are set to non-default values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#use_explicit_dry_run_spec AccessContextManagerServicePerimeter#use_explicit_dry_run_spec}
    */
    readonly useExplicitDryRunSpec?: boolean | cdktf.IResolvable;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#spec AccessContextManagerServicePerimeter#spec}
    */
    readonly spec?: AccessContextManagerServicePerimeterSpec;
    /**
    * status block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#status AccessContextManagerServicePerimeter#status}
    */
    readonly status?: AccessContextManagerServicePerimeterStatus;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#timeouts AccessContextManagerServicePerimeter#timeouts}
    */
    readonly timeouts?: AccessContextManagerServicePerimeterTimeouts;
}
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom {
    /**
    * A list of identities that are allowed access through this 'EgressPolicy'.
  Should be in the format of email address. The email address should
  represent individual user or service account only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identities AccessContextManagerServicePerimeter#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access to outside the
  perimeter. If left unspecified, then members of 'identities' field will
  be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identity_type AccessContextManagerServicePerimeter#identity_type}
    */
    readonly identityType?: string;
}
export declare function accessContextManagerServicePerimeterSpecEgressPoliciesEgressFromToTerraform(struct?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFromOutputReference | AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom): any;
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
}
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors {
    /**
    * Value for 'method' should be a valid method name for the corresponding
  'serviceName' in 'ApiOperation'. If '*' used as value for method,
  then ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method AccessContextManagerServicePerimeter#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
  corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#permission AccessContextManagerServicePerimeter#permission}
    */
    readonly permission?: string;
}
export declare function accessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectorsToTerraform(struct?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable | undefined);
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _permission?;
    get permission(): string;
    set permission(value: string);
    resetPermission(): void;
    get permissionInput(): string | undefined;
}
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectorsOutputReference;
}
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
  'EgressPolicy' want to allow. A single 'ApiOperation' with serviceName
  field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#service_name AccessContextManagerServicePerimeter#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method_selectors AccessContextManagerServicePerimeter#method_selectors}
    */
    readonly methodSelectors?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsToTerraform(struct?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _methodSelectors;
    get methodSelectors(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectorsList;
    putMethodSelectors(value: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable): void;
    resetMethodSelectors(): void;
    get methodSelectorsInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors[] | undefined;
}
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsOutputReference;
}
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo {
    /**
    * A list of external resources that are allowed to be accessed. A request
  matches if it contains an external resource in this list (Example:
  s3://bucket/path). Currently '*' is not allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#external_resources AccessContextManagerServicePerimeter#external_resources}
    */
    readonly externalResources?: string[];
    /**
    * A list of resources, currently only projects in the form
  'projects/<projectnumber>', that match this to stanza. A request matches
  if it contains a resource in this list. If * is specified for resources,
  then this 'EgressTo' rule will authorize access to all resources outside
  the perimeter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resources AccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#operations AccessContextManagerServicePerimeter#operations}
    */
    readonly operations?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterSpecEgressPoliciesEgressToToTerraform(struct?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOutputReference | AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo): any;
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo | undefined);
    private _externalResources?;
    get externalResources(): string[];
    set externalResources(value: string[]);
    resetExternalResources(): void;
    get externalResourcesInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations;
    get operations(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsList;
    putOperations(value: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | cdktf.IResolvable): void;
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimeterSpecEgressPolicies {
    /**
    * egress_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#egress_from AccessContextManagerServicePerimeter#egress_from}
    */
    readonly egressFrom?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom;
    /**
    * egress_to block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#egress_to AccessContextManagerServicePerimeter#egress_to}
    */
    readonly egressTo?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo;
}
export declare function accessContextManagerServicePerimeterSpecEgressPoliciesToTerraform(struct?: AccessContextManagerServicePerimeterSpecEgressPolicies | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterSpecEgressPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecEgressPolicies | cdktf.IResolvable | undefined);
    private _egressFrom;
    get egressFrom(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFromOutputReference;
    putEgressFrom(value: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom): void;
    resetEgressFrom(): void;
    get egressFromInput(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom | undefined;
    private _egressTo;
    get egressTo(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOutputReference;
    putEgressTo(value: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo): void;
    resetEgressTo(): void;
    get egressToInput(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo | undefined;
}
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterSpecEgressPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterSpecEgressPoliciesOutputReference;
}
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources {
    /**
    * An 'AccessLevel' resource name that allow resources within the
  'ServicePerimeters' to be accessed from the internet. 'AccessLevels' listed
  must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
  'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
  resources within the perimeter can only be accessed via Google Cloud calls
  with request origins within the perimeter.
  Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
  If * is specified, then all IngressSources will be allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#access_level AccessContextManagerServicePerimeter#access_level}
    */
    readonly accessLevel?: string;
    /**
    * A Google Cloud resource that is allowed to ingress the perimeter.
  Requests from these resources will be allowed to access perimeter data.
  Currently only projects are allowed. Format 'projects/{project_number}'
  The project may be in any Google Cloud organization, not just the
  organization that the perimeter is defined in. '*' is not allowed, the case
  of allowing all Google Cloud resources only is not supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resource AccessContextManagerServicePerimeter#resource}
    */
    readonly resource?: string;
}
export declare function accessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSourcesToTerraform(struct?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources | cdktf.IResolvable | undefined);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    resetAccessLevel(): void;
    get accessLevelInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    resetResource(): void;
    get resourceInput(): string | undefined;
}
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSourcesOutputReference;
}
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom {
    /**
    * A list of identities that are allowed access through this ingress policy.
  Should be in the format of email address. The email address should represent
  individual user or service account only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identities AccessContextManagerServicePerimeter#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access from outside the
  perimeter. If left unspecified, then members of 'identities' field will be
  allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identity_type AccessContextManagerServicePerimeter#identity_type}
    */
    readonly identityType?: string;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#sources AccessContextManagerServicePerimeter#sources}
    */
    readonly sources?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterSpecIngressPoliciesIngressFromToTerraform(struct?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromOutputReference | AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom): any;
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
    private _sources;
    get sources(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSourcesList;
    putSources(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | cdktf.IResolvable): void;
    resetSources(): void;
    get sourcesInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | undefined;
}
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors {
    /**
    * Value for method should be a valid method name for the corresponding
  serviceName in 'ApiOperation'. If '*' used as value for 'method', then
  ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method AccessContextManagerServicePerimeter#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
  corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#permission AccessContextManagerServicePerimeter#permission}
    */
    readonly permission?: string;
}
export declare function accessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectorsToTerraform(struct?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable | undefined);
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _permission?;
    get permission(): string;
    set permission(value: string);
    resetPermission(): void;
    get permissionInput(): string | undefined;
}
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectorsOutputReference;
}
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
  'EgressPolicy' want to allow. A single 'ApiOperation' with 'serviceName'
  field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#service_name AccessContextManagerServicePerimeter#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method_selectors AccessContextManagerServicePerimeter#method_selectors}
    */
    readonly methodSelectors?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsToTerraform(struct?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _methodSelectors;
    get methodSelectors(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectorsList;
    putMethodSelectors(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable): void;
    resetMethodSelectors(): void;
    get methodSelectorsInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors[] | undefined;
}
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsOutputReference;
}
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo {
    /**
    * A list of resources, currently only projects in the form
  'projects/<projectnumber>', protected by this 'ServicePerimeter'
  that are allowed to be accessed by sources defined in the
  corresponding 'IngressFrom'. A request matches if it contains
  a resource in this list. If '*' is specified for resources,
  then this 'IngressTo' rule will authorize access to all
  resources inside the perimeter, provided that the request
  also matches the 'operations' field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resources AccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#operations AccessContextManagerServicePerimeter#operations}
    */
    readonly operations?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterSpecIngressPoliciesIngressToToTerraform(struct?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOutputReference | AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo): any;
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo | undefined);
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations;
    get operations(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsList;
    putOperations(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | cdktf.IResolvable): void;
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimeterSpecIngressPolicies {
    /**
    * ingress_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#ingress_from AccessContextManagerServicePerimeter#ingress_from}
    */
    readonly ingressFrom?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom;
    /**
    * ingress_to block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#ingress_to AccessContextManagerServicePerimeter#ingress_to}
    */
    readonly ingressTo?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo;
}
export declare function accessContextManagerServicePerimeterSpecIngressPoliciesToTerraform(struct?: AccessContextManagerServicePerimeterSpecIngressPolicies | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterSpecIngressPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecIngressPolicies | cdktf.IResolvable | undefined);
    private _ingressFrom;
    get ingressFrom(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromOutputReference;
    putIngressFrom(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom): void;
    resetIngressFrom(): void;
    get ingressFromInput(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom | undefined;
    private _ingressTo;
    get ingressTo(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOutputReference;
    putIngressTo(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo): void;
    resetIngressTo(): void;
    get ingressToInput(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo | undefined;
}
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterSpecIngressPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterSpecIngressPoliciesOutputReference;
}
export interface AccessContextManagerServicePerimeterSpecVpcAccessibleServices {
    /**
    * The list of APIs usable within the Service Perimeter.
  Must be empty unless 'enableRestriction' is True.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#allowed_services AccessContextManagerServicePerimeter#allowed_services}
    */
    readonly allowedServices?: string[];
    /**
    * Whether to restrict API calls within the Service Perimeter to the
  list of APIs specified in 'allowedServices'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#enable_restriction AccessContextManagerServicePerimeter#enable_restriction}
    */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterSpecVpcAccessibleServicesToTerraform(struct?: AccessContextManagerServicePerimeterSpecVpcAccessibleServicesOutputReference | AccessContextManagerServicePerimeterSpecVpcAccessibleServices): any;
export declare class AccessContextManagerServicePerimeterSpecVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterSpecVpcAccessibleServices | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpecVpcAccessibleServices | undefined);
    private _allowedServices?;
    get allowedServices(): string[];
    set allowedServices(value: string[]);
    resetAllowedServices(): void;
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    get enableRestriction(): boolean | cdktf.IResolvable;
    set enableRestriction(value: boolean | cdktf.IResolvable);
    resetEnableRestriction(): void;
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
export interface AccessContextManagerServicePerimeterSpec {
    /**
    * A list of AccessLevel resource names that allow resources within
  the ServicePerimeter to be accessed from the internet.
  AccessLevels listed must be in the same policy as this
  ServicePerimeter. Referencing a nonexistent AccessLevel is a
  syntax error. If no AccessLevel names are listed, resources within
  the perimeter can only be accessed via GCP calls with request
  origins within the perimeter. For Service Perimeter Bridge, must
  be empty.
  
  Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#access_levels AccessContextManagerServicePerimeter#access_levels}
    */
    readonly accessLevels?: string[];
    /**
    * A list of GCP resources that are inside of the service perimeter.
  Currently only projects are allowed.
  Format: projects/{project_number}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resources AccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * GCP services that are subject to the Service Perimeter
  restrictions. Must contain a list of services. For example, if
  'storage.googleapis.com' is specified, access to the storage
  buckets inside the perimeter must meet the perimeter's access
  restrictions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#restricted_services AccessContextManagerServicePerimeter#restricted_services}
    */
    readonly restrictedServices?: string[];
    /**
    * egress_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#egress_policies AccessContextManagerServicePerimeter#egress_policies}
    */
    readonly egressPolicies?: AccessContextManagerServicePerimeterSpecEgressPolicies[] | cdktf.IResolvable;
    /**
    * ingress_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#ingress_policies AccessContextManagerServicePerimeter#ingress_policies}
    */
    readonly ingressPolicies?: AccessContextManagerServicePerimeterSpecIngressPolicies[] | cdktf.IResolvable;
    /**
    * vpc_accessible_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#vpc_accessible_services AccessContextManagerServicePerimeter#vpc_accessible_services}
    */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimeterSpecVpcAccessibleServices;
}
export declare function accessContextManagerServicePerimeterSpecToTerraform(struct?: AccessContextManagerServicePerimeterSpecOutputReference | AccessContextManagerServicePerimeterSpec): any;
export declare class AccessContextManagerServicePerimeterSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterSpec | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterSpec | undefined);
    private _accessLevels?;
    get accessLevels(): string[];
    set accessLevels(value: string[]);
    resetAccessLevels(): void;
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    get restrictedServices(): string[];
    set restrictedServices(value: string[]);
    resetRestrictedServices(): void;
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies;
    get egressPolicies(): AccessContextManagerServicePerimeterSpecEgressPoliciesList;
    putEgressPolicies(value: AccessContextManagerServicePerimeterSpecEgressPolicies[] | cdktf.IResolvable): void;
    resetEgressPolicies(): void;
    get egressPoliciesInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterSpecEgressPolicies[] | undefined;
    private _ingressPolicies;
    get ingressPolicies(): AccessContextManagerServicePerimeterSpecIngressPoliciesList;
    putIngressPolicies(value: AccessContextManagerServicePerimeterSpecIngressPolicies[] | cdktf.IResolvable): void;
    resetIngressPolicies(): void;
    get ingressPoliciesInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterSpecIngressPolicies[] | undefined;
    private _vpcAccessibleServices;
    get vpcAccessibleServices(): AccessContextManagerServicePerimeterSpecVpcAccessibleServicesOutputReference;
    putVpcAccessibleServices(value: AccessContextManagerServicePerimeterSpecVpcAccessibleServices): void;
    resetVpcAccessibleServices(): void;
    get vpcAccessibleServicesInput(): AccessContextManagerServicePerimeterSpecVpcAccessibleServices | undefined;
}
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom {
    /**
    * A list of identities that are allowed access through this 'EgressPolicy'.
  Should be in the format of email address. The email address should
  represent individual user or service account only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identities AccessContextManagerServicePerimeter#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access to outside the
  perimeter. If left unspecified, then members of 'identities' field will
  be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identity_type AccessContextManagerServicePerimeter#identity_type}
    */
    readonly identityType?: string;
}
export declare function accessContextManagerServicePerimeterStatusEgressPoliciesEgressFromToTerraform(struct?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFromOutputReference | AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom): any;
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
}
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors {
    /**
    * Value for 'method' should be a valid method name for the corresponding
  'serviceName' in 'ApiOperation'. If '*' used as value for method,
  then ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method AccessContextManagerServicePerimeter#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
  corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#permission AccessContextManagerServicePerimeter#permission}
    */
    readonly permission?: string;
}
export declare function accessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectorsToTerraform(struct?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable | undefined);
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _permission?;
    get permission(): string;
    set permission(value: string);
    resetPermission(): void;
    get permissionInput(): string | undefined;
}
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectorsOutputReference;
}
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
  'EgressPolicy' want to allow. A single 'ApiOperation' with serviceName
  field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#service_name AccessContextManagerServicePerimeter#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method_selectors AccessContextManagerServicePerimeter#method_selectors}
    */
    readonly methodSelectors?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsToTerraform(struct?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _methodSelectors;
    get methodSelectors(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectorsList;
    putMethodSelectors(value: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable): void;
    resetMethodSelectors(): void;
    get methodSelectorsInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors[] | undefined;
}
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsOutputReference;
}
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo {
    /**
    * A list of external resources that are allowed to be accessed. A request
  matches if it contains an external resource in this list (Example:
  s3://bucket/path). Currently '*' is not allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#external_resources AccessContextManagerServicePerimeter#external_resources}
    */
    readonly externalResources?: string[];
    /**
    * A list of resources, currently only projects in the form
  'projects/<projectnumber>', that match this to stanza. A request matches
  if it contains a resource in this list. If * is specified for resources,
  then this 'EgressTo' rule will authorize access to all resources outside
  the perimeter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resources AccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#operations AccessContextManagerServicePerimeter#operations}
    */
    readonly operations?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterStatusEgressPoliciesEgressToToTerraform(struct?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOutputReference | AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo): any;
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo | undefined);
    private _externalResources?;
    get externalResources(): string[];
    set externalResources(value: string[]);
    resetExternalResources(): void;
    get externalResourcesInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations;
    get operations(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsList;
    putOperations(value: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | cdktf.IResolvable): void;
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimeterStatusEgressPolicies {
    /**
    * egress_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#egress_from AccessContextManagerServicePerimeter#egress_from}
    */
    readonly egressFrom?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom;
    /**
    * egress_to block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#egress_to AccessContextManagerServicePerimeter#egress_to}
    */
    readonly egressTo?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo;
}
export declare function accessContextManagerServicePerimeterStatusEgressPoliciesToTerraform(struct?: AccessContextManagerServicePerimeterStatusEgressPolicies | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterStatusEgressPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusEgressPolicies | cdktf.IResolvable | undefined);
    private _egressFrom;
    get egressFrom(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFromOutputReference;
    putEgressFrom(value: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom): void;
    resetEgressFrom(): void;
    get egressFromInput(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom | undefined;
    private _egressTo;
    get egressTo(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOutputReference;
    putEgressTo(value: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo): void;
    resetEgressTo(): void;
    get egressToInput(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo | undefined;
}
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterStatusEgressPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterStatusEgressPoliciesOutputReference;
}
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources {
    /**
    * An 'AccessLevel' resource name that allow resources within the
  'ServicePerimeters' to be accessed from the internet. 'AccessLevels' listed
  must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
  'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
  resources within the perimeter can only be accessed via Google Cloud calls
  with request origins within the perimeter.
  Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
  If * is specified, then all IngressSources will be allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#access_level AccessContextManagerServicePerimeter#access_level}
    */
    readonly accessLevel?: string;
    /**
    * A Google Cloud resource that is allowed to ingress the perimeter.
  Requests from these resources will be allowed to access perimeter data.
  Currently only projects are allowed. Format 'projects/{project_number}'
  The project may be in any Google Cloud organization, not just the
  organization that the perimeter is defined in. '*' is not allowed, the case
  of allowing all Google Cloud resources only is not supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resource AccessContextManagerServicePerimeter#resource}
    */
    readonly resource?: string;
}
export declare function accessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSourcesToTerraform(struct?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources | cdktf.IResolvable | undefined);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    resetAccessLevel(): void;
    get accessLevelInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    resetResource(): void;
    get resourceInput(): string | undefined;
}
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSourcesOutputReference;
}
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom {
    /**
    * A list of identities that are allowed access through this ingress policy.
  Should be in the format of email address. The email address should represent
  individual user or service account only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identities AccessContextManagerServicePerimeter#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access from outside the
  perimeter. If left unspecified, then members of 'identities' field will be
  allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#identity_type AccessContextManagerServicePerimeter#identity_type}
    */
    readonly identityType?: string;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#sources AccessContextManagerServicePerimeter#sources}
    */
    readonly sources?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterStatusIngressPoliciesIngressFromToTerraform(struct?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromOutputReference | AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom): any;
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
    private _sources;
    get sources(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSourcesList;
    putSources(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | cdktf.IResolvable): void;
    resetSources(): void;
    get sourcesInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | undefined;
}
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors {
    /**
    * Value for method should be a valid method name for the corresponding
  serviceName in 'ApiOperation'. If '*' used as value for 'method', then
  ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method AccessContextManagerServicePerimeter#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
  corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#permission AccessContextManagerServicePerimeter#permission}
    */
    readonly permission?: string;
}
export declare function accessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectorsToTerraform(struct?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable | undefined);
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _permission?;
    get permission(): string;
    set permission(value: string);
    resetPermission(): void;
    get permissionInput(): string | undefined;
}
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectorsOutputReference;
}
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
  'EgressPolicy' want to allow. A single 'ApiOperation' with 'serviceName'
  field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#service_name AccessContextManagerServicePerimeter#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#method_selectors AccessContextManagerServicePerimeter#method_selectors}
    */
    readonly methodSelectors?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsToTerraform(struct?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _methodSelectors;
    get methodSelectors(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectorsList;
    putMethodSelectors(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable): void;
    resetMethodSelectors(): void;
    get methodSelectorsInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors[] | undefined;
}
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsOutputReference;
}
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo {
    /**
    * A list of resources, currently only projects in the form
  'projects/<projectnumber>', protected by this 'ServicePerimeter'
  that are allowed to be accessed by sources defined in the
  corresponding 'IngressFrom'. A request matches if it contains
  a resource in this list. If '*' is specified for resources,
  then this 'IngressTo' rule will authorize access to all
  resources inside the perimeter, provided that the request
  also matches the 'operations' field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resources AccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#operations AccessContextManagerServicePerimeter#operations}
    */
    readonly operations?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterStatusIngressPoliciesIngressToToTerraform(struct?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOutputReference | AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo): any;
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo | undefined);
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations;
    get operations(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsList;
    putOperations(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | cdktf.IResolvable): void;
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | undefined;
}
export interface AccessContextManagerServicePerimeterStatusIngressPolicies {
    /**
    * ingress_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#ingress_from AccessContextManagerServicePerimeter#ingress_from}
    */
    readonly ingressFrom?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom;
    /**
    * ingress_to block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#ingress_to AccessContextManagerServicePerimeter#ingress_to}
    */
    readonly ingressTo?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo;
}
export declare function accessContextManagerServicePerimeterStatusIngressPoliciesToTerraform(struct?: AccessContextManagerServicePerimeterStatusIngressPolicies | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessContextManagerServicePerimeterStatusIngressPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusIngressPolicies | cdktf.IResolvable | undefined);
    private _ingressFrom;
    get ingressFrom(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromOutputReference;
    putIngressFrom(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom): void;
    resetIngressFrom(): void;
    get ingressFromInput(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom | undefined;
    private _ingressTo;
    get ingressTo(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOutputReference;
    putIngressTo(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo): void;
    resetIngressTo(): void;
    get ingressToInput(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo | undefined;
}
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessContextManagerServicePerimeterStatusIngressPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessContextManagerServicePerimeterStatusIngressPoliciesOutputReference;
}
export interface AccessContextManagerServicePerimeterStatusVpcAccessibleServices {
    /**
    * The list of APIs usable within the Service Perimeter.
  Must be empty unless 'enableRestriction' is True.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#allowed_services AccessContextManagerServicePerimeter#allowed_services}
    */
    readonly allowedServices?: string[];
    /**
    * Whether to restrict API calls within the Service Perimeter to the
  list of APIs specified in 'allowedServices'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#enable_restriction AccessContextManagerServicePerimeter#enable_restriction}
    */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimeterStatusVpcAccessibleServicesToTerraform(struct?: AccessContextManagerServicePerimeterStatusVpcAccessibleServicesOutputReference | AccessContextManagerServicePerimeterStatusVpcAccessibleServices): any;
export declare class AccessContextManagerServicePerimeterStatusVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterStatusVpcAccessibleServices | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatusVpcAccessibleServices | undefined);
    private _allowedServices?;
    get allowedServices(): string[];
    set allowedServices(value: string[]);
    resetAllowedServices(): void;
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    get enableRestriction(): boolean | cdktf.IResolvable;
    set enableRestriction(value: boolean | cdktf.IResolvable);
    resetEnableRestriction(): void;
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
export interface AccessContextManagerServicePerimeterStatus {
    /**
    * A list of AccessLevel resource names that allow resources within
  the ServicePerimeter to be accessed from the internet.
  AccessLevels listed must be in the same policy as this
  ServicePerimeter. Referencing a nonexistent AccessLevel is a
  syntax error. If no AccessLevel names are listed, resources within
  the perimeter can only be accessed via GCP calls with request
  origins within the perimeter. For Service Perimeter Bridge, must
  be empty.
  
  Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#access_levels AccessContextManagerServicePerimeter#access_levels}
    */
    readonly accessLevels?: string[];
    /**
    * A list of GCP resources that are inside of the service perimeter.
  Currently only projects are allowed.
  Format: projects/{project_number}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#resources AccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * GCP services that are subject to the Service Perimeter
  restrictions. Must contain a list of services. For example, if
  'storage.googleapis.com' is specified, access to the storage
  buckets inside the perimeter must meet the perimeter's access
  restrictions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#restricted_services AccessContextManagerServicePerimeter#restricted_services}
    */
    readonly restrictedServices?: string[];
    /**
    * egress_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#egress_policies AccessContextManagerServicePerimeter#egress_policies}
    */
    readonly egressPolicies?: AccessContextManagerServicePerimeterStatusEgressPolicies[] | cdktf.IResolvable;
    /**
    * ingress_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#ingress_policies AccessContextManagerServicePerimeter#ingress_policies}
    */
    readonly ingressPolicies?: AccessContextManagerServicePerimeterStatusIngressPolicies[] | cdktf.IResolvable;
    /**
    * vpc_accessible_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#vpc_accessible_services AccessContextManagerServicePerimeter#vpc_accessible_services}
    */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimeterStatusVpcAccessibleServices;
}
export declare function accessContextManagerServicePerimeterStatusToTerraform(struct?: AccessContextManagerServicePerimeterStatusOutputReference | AccessContextManagerServicePerimeterStatus): any;
export declare class AccessContextManagerServicePerimeterStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterStatus | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterStatus | undefined);
    private _accessLevels?;
    get accessLevels(): string[];
    set accessLevels(value: string[]);
    resetAccessLevels(): void;
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    get restrictedServices(): string[];
    set restrictedServices(value: string[]);
    resetRestrictedServices(): void;
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies;
    get egressPolicies(): AccessContextManagerServicePerimeterStatusEgressPoliciesList;
    putEgressPolicies(value: AccessContextManagerServicePerimeterStatusEgressPolicies[] | cdktf.IResolvable): void;
    resetEgressPolicies(): void;
    get egressPoliciesInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterStatusEgressPolicies[] | undefined;
    private _ingressPolicies;
    get ingressPolicies(): AccessContextManagerServicePerimeterStatusIngressPoliciesList;
    putIngressPolicies(value: AccessContextManagerServicePerimeterStatusIngressPolicies[] | cdktf.IResolvable): void;
    resetIngressPolicies(): void;
    get ingressPoliciesInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterStatusIngressPolicies[] | undefined;
    private _vpcAccessibleServices;
    get vpcAccessibleServices(): AccessContextManagerServicePerimeterStatusVpcAccessibleServicesOutputReference;
    putVpcAccessibleServices(value: AccessContextManagerServicePerimeterStatusVpcAccessibleServices): void;
    resetVpcAccessibleServices(): void;
    get vpcAccessibleServicesInput(): AccessContextManagerServicePerimeterStatusVpcAccessibleServices | undefined;
}
export interface AccessContextManagerServicePerimeterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#create AccessContextManagerServicePerimeter#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#delete AccessContextManagerServicePerimeter#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter#update AccessContextManagerServicePerimeter#update}
    */
    readonly update?: string;
}
export declare function accessContextManagerServicePerimeterTimeoutsToTerraform(struct?: AccessContextManagerServicePerimeterTimeoutsOutputReference | AccessContextManagerServicePerimeterTimeouts | cdktf.IResolvable): any;
export declare class AccessContextManagerServicePerimeterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerServicePerimeterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AccessContextManagerServicePerimeterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter google_access_context_manager_service_perimeter}
*/
export declare class AccessContextManagerServicePerimeter extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_service_perimeter";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter google_access_context_manager_service_perimeter} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AccessContextManagerServicePerimeterConfig
    */
    constructor(scope: Construct, id: string, config: AccessContextManagerServicePerimeterConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _perimeterType?;
    get perimeterType(): string;
    set perimeterType(value: string);
    resetPerimeterType(): void;
    get perimeterTypeInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    get updateTime(): string;
    private _useExplicitDryRunSpec?;
    get useExplicitDryRunSpec(): boolean | cdktf.IResolvable;
    set useExplicitDryRunSpec(value: boolean | cdktf.IResolvable);
    resetUseExplicitDryRunSpec(): void;
    get useExplicitDryRunSpecInput(): boolean | cdktf.IResolvable | undefined;
    private _spec;
    get spec(): AccessContextManagerServicePerimeterSpecOutputReference;
    putSpec(value: AccessContextManagerServicePerimeterSpec): void;
    resetSpec(): void;
    get specInput(): AccessContextManagerServicePerimeterSpec | undefined;
    private _status;
    get status(): AccessContextManagerServicePerimeterStatusOutputReference;
    putStatus(value: AccessContextManagerServicePerimeterStatus): void;
    resetStatus(): void;
    get statusInput(): AccessContextManagerServicePerimeterStatus | undefined;
    private _timeouts;
    get timeouts(): AccessContextManagerServicePerimeterTimeoutsOutputReference;
    putTimeouts(value: AccessContextManagerServicePerimeterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AccessContextManagerServicePerimeterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
