import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AlloydbClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the alloydb cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#cluster_id AlloydbCluster#cluster_id}
    */
    readonly clusterId: string;
    /**
    * User-settable and human-readable display name for the Cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#display_name AlloydbCluster#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#id AlloydbCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-defined labels for the alloydb cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#labels AlloydbCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the alloydb cluster should reside.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#location AlloydbCluster#location}
    */
    readonly location?: string;
    /**
    * The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
  
  "projects/{projectNumber}/global/networks/{network_id}".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#network AlloydbCluster#network}
    */
    readonly network: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#project AlloydbCluster#project}
    */
    readonly project?: string;
    /**
    * automated_backup_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#automated_backup_policy AlloydbCluster#automated_backup_policy}
    */
    readonly automatedBackupPolicy?: AlloydbClusterAutomatedBackupPolicy;
    /**
    * initial_user block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#initial_user AlloydbCluster#initial_user}
    */
    readonly initialUser?: AlloydbClusterInitialUser;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#timeouts AlloydbCluster#timeouts}
    */
    readonly timeouts?: AlloydbClusterTimeouts;
}
export interface AlloydbClusterBackupSource {
}
export declare function alloydbClusterBackupSourceToTerraform(struct?: AlloydbClusterBackupSource): any;
export declare class AlloydbClusterBackupSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AlloydbClusterBackupSource | undefined;
    set internalValue(value: AlloydbClusterBackupSource | undefined);
    get backupName(): string;
}
export declare class AlloydbClusterBackupSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AlloydbClusterBackupSourceOutputReference;
}
export interface AlloydbClusterMigrationSource {
}
export declare function alloydbClusterMigrationSourceToTerraform(struct?: AlloydbClusterMigrationSource): any;
export declare class AlloydbClusterMigrationSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AlloydbClusterMigrationSource | undefined;
    set internalValue(value: AlloydbClusterMigrationSource | undefined);
    get hostPort(): string;
    get referenceId(): string;
    get sourceType(): string;
}
export declare class AlloydbClusterMigrationSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AlloydbClusterMigrationSourceOutputReference;
}
export interface AlloydbClusterAutomatedBackupPolicyQuantityBasedRetention {
    /**
    * The number of backups to retain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#count AlloydbCluster#count}
    */
    readonly count?: number;
}
export declare function alloydbClusterAutomatedBackupPolicyQuantityBasedRetentionToTerraform(struct?: AlloydbClusterAutomatedBackupPolicyQuantityBasedRetentionOutputReference | AlloydbClusterAutomatedBackupPolicyQuantityBasedRetention): any;
export declare class AlloydbClusterAutomatedBackupPolicyQuantityBasedRetentionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AlloydbClusterAutomatedBackupPolicyQuantityBasedRetention | undefined;
    set internalValue(value: AlloydbClusterAutomatedBackupPolicyQuantityBasedRetention | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
}
export interface AlloydbClusterAutomatedBackupPolicyTimeBasedRetention {
    /**
    * The retention period.
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#retention_period AlloydbCluster#retention_period}
    */
    readonly retentionPeriod?: string;
}
export declare function alloydbClusterAutomatedBackupPolicyTimeBasedRetentionToTerraform(struct?: AlloydbClusterAutomatedBackupPolicyTimeBasedRetentionOutputReference | AlloydbClusterAutomatedBackupPolicyTimeBasedRetention): any;
export declare class AlloydbClusterAutomatedBackupPolicyTimeBasedRetentionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AlloydbClusterAutomatedBackupPolicyTimeBasedRetention | undefined;
    set internalValue(value: AlloydbClusterAutomatedBackupPolicyTimeBasedRetention | undefined);
    private _retentionPeriod?;
    get retentionPeriod(): string;
    set retentionPeriod(value: string);
    resetRetentionPeriod(): void;
    get retentionPeriodInput(): string | undefined;
}
export interface AlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes {
    /**
    * Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#hours AlloydbCluster#hours}
    */
    readonly hours?: number;
    /**
    * Minutes of hour of day. Must be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#minutes AlloydbCluster#minutes}
    */
    readonly minutes?: number;
    /**
    * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#nanos AlloydbCluster#nanos}
    */
    readonly nanos?: number;
    /**
    * Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#seconds AlloydbCluster#seconds}
    */
    readonly seconds?: number;
}
export declare function alloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesToTerraform(struct?: AlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes | cdktf.IResolvable): any;
export declare class AlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes | cdktf.IResolvable | undefined;
    set internalValue(value: AlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes | cdktf.IResolvable | undefined);
    private _hours?;
    get hours(): number;
    set hours(value: number);
    resetHours(): void;
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    resetMinutes(): void;
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    resetSeconds(): void;
    get secondsInput(): number | undefined;
}
export declare class AlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesOutputReference;
}
export interface AlloydbClusterAutomatedBackupPolicyWeeklySchedule {
    /**
    * The days of the week to perform a backup. At least one day of the week must be provided. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#days_of_week AlloydbCluster#days_of_week}
    */
    readonly daysOfWeek?: string[];
    /**
    * start_times block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#start_times AlloydbCluster#start_times}
    */
    readonly startTimes: AlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes[] | cdktf.IResolvable;
}
export declare function alloydbClusterAutomatedBackupPolicyWeeklyScheduleToTerraform(struct?: AlloydbClusterAutomatedBackupPolicyWeeklyScheduleOutputReference | AlloydbClusterAutomatedBackupPolicyWeeklySchedule): any;
export declare class AlloydbClusterAutomatedBackupPolicyWeeklyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AlloydbClusterAutomatedBackupPolicyWeeklySchedule | undefined;
    set internalValue(value: AlloydbClusterAutomatedBackupPolicyWeeklySchedule | undefined);
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    resetDaysOfWeek(): void;
    get daysOfWeekInput(): string[] | undefined;
    private _startTimes;
    get startTimes(): AlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimesList;
    putStartTimes(value: AlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes[] | cdktf.IResolvable): void;
    get startTimesInput(): cdktf.IResolvable | AlloydbClusterAutomatedBackupPolicyWeeklyScheduleStartTimes[] | undefined;
}
export interface AlloydbClusterAutomatedBackupPolicy {
    /**
    * The length of the time window during which a backup can be taken. If a backup does not succeed within this time window, it will be canceled and considered failed.
  
  The backup window must be at least 5 minutes long. There is no upper bound on the window. If not set, it will default to 1 hour.
  
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#backup_window AlloydbCluster#backup_window}
    */
    readonly backupWindow?: string;
    /**
    * Whether automated backups are enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#enabled AlloydbCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Labels to apply to backups created using this configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#labels AlloydbCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#location AlloydbCluster#location}
    */
    readonly location?: string;
    /**
    * quantity_based_retention block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#quantity_based_retention AlloydbCluster#quantity_based_retention}
    */
    readonly quantityBasedRetention?: AlloydbClusterAutomatedBackupPolicyQuantityBasedRetention;
    /**
    * time_based_retention block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#time_based_retention AlloydbCluster#time_based_retention}
    */
    readonly timeBasedRetention?: AlloydbClusterAutomatedBackupPolicyTimeBasedRetention;
    /**
    * weekly_schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#weekly_schedule AlloydbCluster#weekly_schedule}
    */
    readonly weeklySchedule?: AlloydbClusterAutomatedBackupPolicyWeeklySchedule;
}
export declare function alloydbClusterAutomatedBackupPolicyToTerraform(struct?: AlloydbClusterAutomatedBackupPolicyOutputReference | AlloydbClusterAutomatedBackupPolicy): any;
export declare class AlloydbClusterAutomatedBackupPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AlloydbClusterAutomatedBackupPolicy | undefined;
    set internalValue(value: AlloydbClusterAutomatedBackupPolicy | undefined);
    private _backupWindow?;
    get backupWindow(): string;
    set backupWindow(value: string);
    resetBackupWindow(): void;
    get backupWindowInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _quantityBasedRetention;
    get quantityBasedRetention(): AlloydbClusterAutomatedBackupPolicyQuantityBasedRetentionOutputReference;
    putQuantityBasedRetention(value: AlloydbClusterAutomatedBackupPolicyQuantityBasedRetention): void;
    resetQuantityBasedRetention(): void;
    get quantityBasedRetentionInput(): AlloydbClusterAutomatedBackupPolicyQuantityBasedRetention | undefined;
    private _timeBasedRetention;
    get timeBasedRetention(): AlloydbClusterAutomatedBackupPolicyTimeBasedRetentionOutputReference;
    putTimeBasedRetention(value: AlloydbClusterAutomatedBackupPolicyTimeBasedRetention): void;
    resetTimeBasedRetention(): void;
    get timeBasedRetentionInput(): AlloydbClusterAutomatedBackupPolicyTimeBasedRetention | undefined;
    private _weeklySchedule;
    get weeklySchedule(): AlloydbClusterAutomatedBackupPolicyWeeklyScheduleOutputReference;
    putWeeklySchedule(value: AlloydbClusterAutomatedBackupPolicyWeeklySchedule): void;
    resetWeeklySchedule(): void;
    get weeklyScheduleInput(): AlloydbClusterAutomatedBackupPolicyWeeklySchedule | undefined;
}
export interface AlloydbClusterInitialUser {
    /**
    * The initial password for the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#password AlloydbCluster#password}
    */
    readonly password: string;
    /**
    * The database username.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#user AlloydbCluster#user}
    */
    readonly user?: string;
}
export declare function alloydbClusterInitialUserToTerraform(struct?: AlloydbClusterInitialUserOutputReference | AlloydbClusterInitialUser): any;
export declare class AlloydbClusterInitialUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AlloydbClusterInitialUser | undefined;
    set internalValue(value: AlloydbClusterInitialUser | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface AlloydbClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#create AlloydbCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#delete AlloydbCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster#update AlloydbCluster#update}
    */
    readonly update?: string;
}
export declare function alloydbClusterTimeoutsToTerraform(struct?: AlloydbClusterTimeoutsOutputReference | AlloydbClusterTimeouts | cdktf.IResolvable): any;
export declare class AlloydbClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AlloydbClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AlloydbClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster google_alloydb_cluster}
*/
export declare class AlloydbCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_alloydb_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/alloydb_cluster google_alloydb_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AlloydbClusterConfig
    */
    constructor(scope: Construct, id: string, config: AlloydbClusterConfig);
    private _backupSource;
    get backupSource(): AlloydbClusterBackupSourceList;
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    get databaseVersion(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _migrationSource;
    get migrationSource(): AlloydbClusterMigrationSourceList;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get uid(): string;
    private _automatedBackupPolicy;
    get automatedBackupPolicy(): AlloydbClusterAutomatedBackupPolicyOutputReference;
    putAutomatedBackupPolicy(value: AlloydbClusterAutomatedBackupPolicy): void;
    resetAutomatedBackupPolicy(): void;
    get automatedBackupPolicyInput(): AlloydbClusterAutomatedBackupPolicy | undefined;
    private _initialUser;
    get initialUser(): AlloydbClusterInitialUserOutputReference;
    putInitialUser(value: AlloydbClusterInitialUser): void;
    resetInitialUser(): void;
    get initialUserInput(): AlloydbClusterInitialUser | undefined;
    private _timeouts;
    get timeouts(): AlloydbClusterTimeoutsOutputReference;
    putTimeouts(value: AlloydbClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AlloydbClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
