import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeAddonsConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#id ApigeeAddonsConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the Apigee organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#org ApigeeAddonsConfig#org}
    */
    readonly org: string;
    /**
    * addons_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#addons_config ApigeeAddonsConfig#addons_config}
    */
    readonly addonsConfig?: ApigeeAddonsConfigAddonsConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#timeouts ApigeeAddonsConfig#timeouts}
    */
    readonly timeouts?: ApigeeAddonsConfigTimeouts;
}
export interface ApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig {
    /**
    * Flag that specifies whether the Advanced API Ops add-on is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#enabled ApigeeAddonsConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function apigeeAddonsConfigAddonsConfigAdvancedApiOpsConfigToTerraform(struct?: ApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfigOutputReference | ApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig): any;
export declare class ApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig | undefined;
    set internalValue(value: ApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ApigeeAddonsConfigAddonsConfigApiSecurityConfig {
    /**
    * Flag that specifies whether the Advanced API Ops add-on is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#enabled ApigeeAddonsConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function apigeeAddonsConfigAddonsConfigApiSecurityConfigToTerraform(struct?: ApigeeAddonsConfigAddonsConfigApiSecurityConfigOutputReference | ApigeeAddonsConfigAddonsConfigApiSecurityConfig): any;
export declare class ApigeeAddonsConfigAddonsConfigApiSecurityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeAddonsConfigAddonsConfigApiSecurityConfig | undefined;
    set internalValue(value: ApigeeAddonsConfigAddonsConfigApiSecurityConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get expiresAt(): string;
}
export interface ApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig {
    /**
    * Flag that specifies whether the Advanced API Ops add-on is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#enabled ApigeeAddonsConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function apigeeAddonsConfigAddonsConfigConnectorsPlatformConfigToTerraform(struct?: ApigeeAddonsConfigAddonsConfigConnectorsPlatformConfigOutputReference | ApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig): any;
export declare class ApigeeAddonsConfigAddonsConfigConnectorsPlatformConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig | undefined;
    set internalValue(value: ApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get expiresAt(): string;
}
export interface ApigeeAddonsConfigAddonsConfigIntegrationConfig {
    /**
    * Flag that specifies whether the Advanced API Ops add-on is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#enabled ApigeeAddonsConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function apigeeAddonsConfigAddonsConfigIntegrationConfigToTerraform(struct?: ApigeeAddonsConfigAddonsConfigIntegrationConfigOutputReference | ApigeeAddonsConfigAddonsConfigIntegrationConfig): any;
export declare class ApigeeAddonsConfigAddonsConfigIntegrationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeAddonsConfigAddonsConfigIntegrationConfig | undefined;
    set internalValue(value: ApigeeAddonsConfigAddonsConfigIntegrationConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ApigeeAddonsConfigAddonsConfigMonetizationConfig {
    /**
    * Flag that specifies whether the Advanced API Ops add-on is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#enabled ApigeeAddonsConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function apigeeAddonsConfigAddonsConfigMonetizationConfigToTerraform(struct?: ApigeeAddonsConfigAddonsConfigMonetizationConfigOutputReference | ApigeeAddonsConfigAddonsConfigMonetizationConfig): any;
export declare class ApigeeAddonsConfigAddonsConfigMonetizationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeAddonsConfigAddonsConfigMonetizationConfig | undefined;
    set internalValue(value: ApigeeAddonsConfigAddonsConfigMonetizationConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ApigeeAddonsConfigAddonsConfig {
    /**
    * advanced_api_ops_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#advanced_api_ops_config ApigeeAddonsConfig#advanced_api_ops_config}
    */
    readonly advancedApiOpsConfig?: ApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig;
    /**
    * api_security_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#api_security_config ApigeeAddonsConfig#api_security_config}
    */
    readonly apiSecurityConfig?: ApigeeAddonsConfigAddonsConfigApiSecurityConfig;
    /**
    * connectors_platform_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#connectors_platform_config ApigeeAddonsConfig#connectors_platform_config}
    */
    readonly connectorsPlatformConfig?: ApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig;
    /**
    * integration_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#integration_config ApigeeAddonsConfig#integration_config}
    */
    readonly integrationConfig?: ApigeeAddonsConfigAddonsConfigIntegrationConfig;
    /**
    * monetization_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#monetization_config ApigeeAddonsConfig#monetization_config}
    */
    readonly monetizationConfig?: ApigeeAddonsConfigAddonsConfigMonetizationConfig;
}
export declare function apigeeAddonsConfigAddonsConfigToTerraform(struct?: ApigeeAddonsConfigAddonsConfigOutputReference | ApigeeAddonsConfigAddonsConfig): any;
export declare class ApigeeAddonsConfigAddonsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeAddonsConfigAddonsConfig | undefined;
    set internalValue(value: ApigeeAddonsConfigAddonsConfig | undefined);
    private _advancedApiOpsConfig;
    get advancedApiOpsConfig(): ApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfigOutputReference;
    putAdvancedApiOpsConfig(value: ApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig): void;
    resetAdvancedApiOpsConfig(): void;
    get advancedApiOpsConfigInput(): ApigeeAddonsConfigAddonsConfigAdvancedApiOpsConfig | undefined;
    private _apiSecurityConfig;
    get apiSecurityConfig(): ApigeeAddonsConfigAddonsConfigApiSecurityConfigOutputReference;
    putApiSecurityConfig(value: ApigeeAddonsConfigAddonsConfigApiSecurityConfig): void;
    resetApiSecurityConfig(): void;
    get apiSecurityConfigInput(): ApigeeAddonsConfigAddonsConfigApiSecurityConfig | undefined;
    private _connectorsPlatformConfig;
    get connectorsPlatformConfig(): ApigeeAddonsConfigAddonsConfigConnectorsPlatformConfigOutputReference;
    putConnectorsPlatformConfig(value: ApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig): void;
    resetConnectorsPlatformConfig(): void;
    get connectorsPlatformConfigInput(): ApigeeAddonsConfigAddonsConfigConnectorsPlatformConfig | undefined;
    private _integrationConfig;
    get integrationConfig(): ApigeeAddonsConfigAddonsConfigIntegrationConfigOutputReference;
    putIntegrationConfig(value: ApigeeAddonsConfigAddonsConfigIntegrationConfig): void;
    resetIntegrationConfig(): void;
    get integrationConfigInput(): ApigeeAddonsConfigAddonsConfigIntegrationConfig | undefined;
    private _monetizationConfig;
    get monetizationConfig(): ApigeeAddonsConfigAddonsConfigMonetizationConfigOutputReference;
    putMonetizationConfig(value: ApigeeAddonsConfigAddonsConfigMonetizationConfig): void;
    resetMonetizationConfig(): void;
    get monetizationConfigInput(): ApigeeAddonsConfigAddonsConfigMonetizationConfig | undefined;
}
export interface ApigeeAddonsConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#create ApigeeAddonsConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#delete ApigeeAddonsConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config#update ApigeeAddonsConfig#update}
    */
    readonly update?: string;
}
export declare function apigeeAddonsConfigTimeoutsToTerraform(struct?: ApigeeAddonsConfigTimeoutsOutputReference | ApigeeAddonsConfigTimeouts | cdktf.IResolvable): any;
export declare class ApigeeAddonsConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeAddonsConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApigeeAddonsConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config google_apigee_addons_config}
*/
export declare class ApigeeAddonsConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_addons_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_addons_config google_apigee_addons_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeAddonsConfigConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeAddonsConfigConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _org?;
    get org(): string;
    set org(value: string);
    get orgInput(): string | undefined;
    private _addonsConfig;
    get addonsConfig(): ApigeeAddonsConfigAddonsConfigOutputReference;
    putAddonsConfig(value: ApigeeAddonsConfigAddonsConfig): void;
    resetAddonsConfig(): void;
    get addonsConfigInput(): ApigeeAddonsConfigAddonsConfig | undefined;
    private _timeouts;
    get timeouts(): ApigeeAddonsConfigTimeoutsOutputReference;
    putTimeouts(value: ApigeeAddonsConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApigeeAddonsConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
