import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeEnvKeystoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Apigee environment group associated with the Apigee environment,
  in the format 'organizations/{{org_name}}/environments/{{env_name}}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_keystore#env_id ApigeeEnvKeystore#env_id}
    */
    readonly envId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_keystore#id ApigeeEnvKeystore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the newly created keystore.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_keystore#name ApigeeEnvKeystore#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_keystore#timeouts ApigeeEnvKeystore#timeouts}
    */
    readonly timeouts?: ApigeeEnvKeystoreTimeouts;
}
export interface ApigeeEnvKeystoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_keystore#create ApigeeEnvKeystore#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_keystore#delete ApigeeEnvKeystore#delete}
    */
    readonly delete?: string;
}
export declare function apigeeEnvKeystoreTimeoutsToTerraform(struct?: ApigeeEnvKeystoreTimeoutsOutputReference | ApigeeEnvKeystoreTimeouts | cdktf.IResolvable): any;
export declare class ApigeeEnvKeystoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeEnvKeystoreTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApigeeEnvKeystoreTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_env_keystore google_apigee_env_keystore}
*/
export declare class ApigeeEnvKeystore extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_env_keystore";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_env_keystore google_apigee_env_keystore} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeEnvKeystoreConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeEnvKeystoreConfig);
    get aliases(): string[];
    private _envId?;
    get envId(): string;
    set envId(value: string);
    get envIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApigeeEnvKeystoreTimeoutsOutputReference;
    putTimeouts(value: ApigeeEnvKeystoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApigeeEnvKeystoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
