import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeEnvReferencesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. A human-readable description of this reference.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_references#description ApigeeEnvReferences#description}
    */
    readonly description?: string;
    /**
    * The Apigee environment group associated with the Apigee environment,
  in the format 'organizations/{{org_name}}/environments/{{env_name}}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_references#env_id ApigeeEnvReferences#env_id}
    */
    readonly envId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_references#id ApigeeEnvReferences#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Required. The resource id of this reference. Values must match the regular expression [\w\s-.]+.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_references#name ApigeeEnvReferences#name}
    */
    readonly name: string;
    /**
    * Required. The id of the resource to which this reference refers. Must be the id of a resource that exists in the parent environment and is of the given resourceType.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_references#refers ApigeeEnvReferences#refers}
    */
    readonly refers: string;
    /**
    * The type of resource referred to by this reference. Valid values are 'KeyStore' or 'TrustStore'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_references#resource_type ApigeeEnvReferences#resource_type}
    */
    readonly resourceType: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_references#timeouts ApigeeEnvReferences#timeouts}
    */
    readonly timeouts?: ApigeeEnvReferencesTimeouts;
}
export interface ApigeeEnvReferencesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_references#create ApigeeEnvReferences#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_env_references#delete ApigeeEnvReferences#delete}
    */
    readonly delete?: string;
}
export declare function apigeeEnvReferencesTimeoutsToTerraform(struct?: ApigeeEnvReferencesTimeoutsOutputReference | ApigeeEnvReferencesTimeouts | cdktf.IResolvable): any;
export declare class ApigeeEnvReferencesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeEnvReferencesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApigeeEnvReferencesTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_env_references google_apigee_env_references}
*/
export declare class ApigeeEnvReferences extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_env_references";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_env_references google_apigee_env_references} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeEnvReferencesConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeEnvReferencesConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _envId?;
    get envId(): string;
    set envId(value: string);
    get envIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _refers?;
    get refers(): string;
    set refers(value: string);
    get refersInput(): string | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    get resourceTypeInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApigeeEnvReferencesTimeoutsOutputReference;
    putTimeouts(value: ApigeeEnvReferencesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApigeeEnvReferencesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
