import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeFlowhookConfig extends cdktf.TerraformMetaArguments {
    /**
    * Flag that specifies whether execution should continue if the flow hook throws an exception. Set to true to continue execution. Set to false to stop execution if the flow hook throws an exception. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_flowhook#continue_on_error ApigeeFlowhook#continue_on_error}
    */
    readonly continueOnError?: boolean | cdktf.IResolvable;
    /**
    * Description of the flow hook.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_flowhook#description ApigeeFlowhook#description}
    */
    readonly description?: string;
    /**
    * The resource ID of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_flowhook#environment ApigeeFlowhook#environment}
    */
    readonly environment: string;
    /**
    * Where in the API call flow the flow hook is invoked. Must be one of PreProxyFlowHook, PostProxyFlowHook, PreTargetFlowHook, or PostTargetFlowHook.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_flowhook#flow_hook_point ApigeeFlowhook#flow_hook_point}
    */
    readonly flowHookPoint: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_flowhook#id ApigeeFlowhook#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The Apigee Organization associated with the environment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_flowhook#org_id ApigeeFlowhook#org_id}
    */
    readonly orgId: string;
    /**
    * Id of the Sharedflow attaching to a flowhook point.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_flowhook#sharedflow ApigeeFlowhook#sharedflow}
    */
    readonly sharedflow: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_flowhook#timeouts ApigeeFlowhook#timeouts}
    */
    readonly timeouts?: ApigeeFlowhookTimeouts;
}
export interface ApigeeFlowhookTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_flowhook#create ApigeeFlowhook#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_flowhook#delete ApigeeFlowhook#delete}
    */
    readonly delete?: string;
}
export declare function apigeeFlowhookTimeoutsToTerraform(struct?: ApigeeFlowhookTimeoutsOutputReference | ApigeeFlowhookTimeouts | cdktf.IResolvable): any;
export declare class ApigeeFlowhookTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeFlowhookTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApigeeFlowhookTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_flowhook google_apigee_flowhook}
*/
export declare class ApigeeFlowhook extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_flowhook";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_flowhook google_apigee_flowhook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeFlowhookConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeFlowhookConfig);
    private _continueOnError?;
    get continueOnError(): boolean | cdktf.IResolvable;
    set continueOnError(value: boolean | cdktf.IResolvable);
    resetContinueOnError(): void;
    get continueOnErrorInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    private _flowHookPoint?;
    get flowHookPoint(): string;
    set flowHookPoint(value: string);
    get flowHookPointInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _sharedflow?;
    get sharedflow(): string;
    set sharedflow(value: string);
    get sharedflowInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApigeeFlowhookTimeoutsOutputReference;
    putTimeouts(value: ApigeeFlowhookTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApigeeFlowhookTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
