import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeKeystoresAliasesKeyCertFileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Alias Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#alias ApigeeKeystoresAliasesKeyCertFile#alias}
    */
    readonly alias: string;
    /**
    * Cert content
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#cert ApigeeKeystoresAliasesKeyCertFile#cert}
    */
    readonly cert: string;
    /**
    * Environment associated with the alias
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#environment ApigeeKeystoresAliasesKeyCertFile#environment}
    */
    readonly environment: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#id ApigeeKeystoresAliasesKeyCertFile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Private Key content, omit if uploading to truststore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#key ApigeeKeystoresAliasesKeyCertFile#key}
    */
    readonly key?: string;
    /**
    * Keystore Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#keystore ApigeeKeystoresAliasesKeyCertFile#keystore}
    */
    readonly keystore: string;
    /**
    * Organization ID associated with the alias
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#org_id ApigeeKeystoresAliasesKeyCertFile#org_id}
    */
    readonly orgId: string;
    /**
    * Password for the Private Key if it's encrypted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#password ApigeeKeystoresAliasesKeyCertFile#password}
    */
    readonly password?: string;
    /**
    * certs_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#certs_info ApigeeKeystoresAliasesKeyCertFile#certs_info}
    */
    readonly certsInfo?: ApigeeKeystoresAliasesKeyCertFileCertsInfo;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#timeouts ApigeeKeystoresAliasesKeyCertFile#timeouts}
    */
    readonly timeouts?: ApigeeKeystoresAliasesKeyCertFileTimeouts;
}
export interface ApigeeKeystoresAliasesKeyCertFileCertsInfoCertInfo {
    /**
    * X.509 basic constraints extension.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#basic_constraints ApigeeKeystoresAliasesKeyCertFile#basic_constraints}
    */
    readonly basicConstraints?: string;
    /**
    * X.509 notAfter validity period in milliseconds since epoch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#expiry_date ApigeeKeystoresAliasesKeyCertFile#expiry_date}
    */
    readonly expiryDate?: string;
    /**
    * Flag that specifies whether the certificate is valid.
  Flag is set to Yes if the certificate is valid, No if expired, or Not yet if not yet valid.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#is_valid ApigeeKeystoresAliasesKeyCertFile#is_valid}
    */
    readonly isValid?: string;
    /**
    * X.509 issuer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#issuer ApigeeKeystoresAliasesKeyCertFile#issuer}
    */
    readonly issuer?: string;
    /**
    * Public key component of the X.509 subject public key info.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#public_key ApigeeKeystoresAliasesKeyCertFile#public_key}
    */
    readonly publicKey?: string;
    /**
    * X.509 serial number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#serial_number ApigeeKeystoresAliasesKeyCertFile#serial_number}
    */
    readonly serialNumber?: string;
    /**
    * X.509 signatureAlgorithm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#sig_alg_name ApigeeKeystoresAliasesKeyCertFile#sig_alg_name}
    */
    readonly sigAlgName?: string;
    /**
    * X.509 subject.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#subject ApigeeKeystoresAliasesKeyCertFile#subject}
    */
    readonly subject?: string;
    /**
    * X.509 subject alternative names (SANs) extension.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#subject_alternative_names ApigeeKeystoresAliasesKeyCertFile#subject_alternative_names}
    */
    readonly subjectAlternativeNames?: string[];
    /**
    * X.509 notBefore validity period in milliseconds since epoch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#valid_from ApigeeKeystoresAliasesKeyCertFile#valid_from}
    */
    readonly validFrom?: string;
    /**
    * X.509 version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#version ApigeeKeystoresAliasesKeyCertFile#version}
    */
    readonly version?: number;
}
export declare function apigeeKeystoresAliasesKeyCertFileCertsInfoCertInfoToTerraform(struct?: ApigeeKeystoresAliasesKeyCertFileCertsInfoCertInfo | cdktf.IResolvable): any;
export declare class ApigeeKeystoresAliasesKeyCertFileCertsInfoCertInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApigeeKeystoresAliasesKeyCertFileCertsInfoCertInfo | cdktf.IResolvable | undefined;
    set internalValue(value: ApigeeKeystoresAliasesKeyCertFileCertsInfoCertInfo | cdktf.IResolvable | undefined);
    private _basicConstraints?;
    get basicConstraints(): string;
    set basicConstraints(value: string);
    resetBasicConstraints(): void;
    get basicConstraintsInput(): string | undefined;
    private _expiryDate?;
    get expiryDate(): string;
    set expiryDate(value: string);
    resetExpiryDate(): void;
    get expiryDateInput(): string | undefined;
    private _isValid?;
    get isValid(): string;
    set isValid(value: string);
    resetIsValid(): void;
    get isValidInput(): string | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _publicKey?;
    get publicKey(): string;
    set publicKey(value: string);
    resetPublicKey(): void;
    get publicKeyInput(): string | undefined;
    private _serialNumber?;
    get serialNumber(): string;
    set serialNumber(value: string);
    resetSerialNumber(): void;
    get serialNumberInput(): string | undefined;
    private _sigAlgName?;
    get sigAlgName(): string;
    set sigAlgName(value: string);
    resetSigAlgName(): void;
    get sigAlgNameInput(): string | undefined;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    resetSubject(): void;
    get subjectInput(): string | undefined;
    private _subjectAlternativeNames?;
    get subjectAlternativeNames(): string[];
    set subjectAlternativeNames(value: string[]);
    resetSubjectAlternativeNames(): void;
    get subjectAlternativeNamesInput(): string[] | undefined;
    private _validFrom?;
    get validFrom(): string;
    set validFrom(value: string);
    resetValidFrom(): void;
    get validFromInput(): string | undefined;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
}
export declare class ApigeeKeystoresAliasesKeyCertFileCertsInfoCertInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApigeeKeystoresAliasesKeyCertFileCertsInfoCertInfo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApigeeKeystoresAliasesKeyCertFileCertsInfoCertInfoOutputReference;
}
export interface ApigeeKeystoresAliasesKeyCertFileCertsInfo {
    /**
    * cert_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#cert_info ApigeeKeystoresAliasesKeyCertFile#cert_info}
    */
    readonly certInfo?: ApigeeKeystoresAliasesKeyCertFileCertsInfoCertInfo[] | cdktf.IResolvable;
}
export declare function apigeeKeystoresAliasesKeyCertFileCertsInfoToTerraform(struct?: ApigeeKeystoresAliasesKeyCertFileCertsInfoOutputReference | ApigeeKeystoresAliasesKeyCertFileCertsInfo): any;
export declare class ApigeeKeystoresAliasesKeyCertFileCertsInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeKeystoresAliasesKeyCertFileCertsInfo | undefined;
    set internalValue(value: ApigeeKeystoresAliasesKeyCertFileCertsInfo | undefined);
    private _certInfo;
    get certInfo(): ApigeeKeystoresAliasesKeyCertFileCertsInfoCertInfoList;
    putCertInfo(value: ApigeeKeystoresAliasesKeyCertFileCertsInfoCertInfo[] | cdktf.IResolvable): void;
    resetCertInfo(): void;
    get certInfoInput(): cdktf.IResolvable | ApigeeKeystoresAliasesKeyCertFileCertsInfoCertInfo[] | undefined;
}
export interface ApigeeKeystoresAliasesKeyCertFileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#create ApigeeKeystoresAliasesKeyCertFile#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#delete ApigeeKeystoresAliasesKeyCertFile#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#read ApigeeKeystoresAliasesKeyCertFile#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file#update ApigeeKeystoresAliasesKeyCertFile#update}
    */
    readonly update?: string;
}
export declare function apigeeKeystoresAliasesKeyCertFileTimeoutsToTerraform(struct?: ApigeeKeystoresAliasesKeyCertFileTimeoutsOutputReference | ApigeeKeystoresAliasesKeyCertFileTimeouts | cdktf.IResolvable): any;
export declare class ApigeeKeystoresAliasesKeyCertFileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeKeystoresAliasesKeyCertFileTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApigeeKeystoresAliasesKeyCertFileTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file google_apigee_keystores_aliases_key_cert_file}
*/
export declare class ApigeeKeystoresAliasesKeyCertFile extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_keystores_aliases_key_cert_file";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_key_cert_file google_apigee_keystores_aliases_key_cert_file} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeKeystoresAliasesKeyCertFileConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeKeystoresAliasesKeyCertFileConfig);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    get aliasInput(): string | undefined;
    private _cert?;
    get cert(): string;
    set cert(value: string);
    get certInput(): string | undefined;
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _keystore?;
    get keystore(): string;
    set keystore(value: string);
    get keystoreInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    get type(): string;
    private _certsInfo;
    get certsInfo(): ApigeeKeystoresAliasesKeyCertFileCertsInfoOutputReference;
    putCertsInfo(value: ApigeeKeystoresAliasesKeyCertFileCertsInfo): void;
    resetCertsInfo(): void;
    get certsInfoInput(): ApigeeKeystoresAliasesKeyCertFileCertsInfo | undefined;
    private _timeouts;
    get timeouts(): ApigeeKeystoresAliasesKeyCertFileTimeoutsOutputReference;
    putTimeouts(value: ApigeeKeystoresAliasesKeyCertFileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApigeeKeystoresAliasesKeyCertFileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
