import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeKeystoresAliasesPkcs12Config extends cdktf.TerraformMetaArguments {
    /**
    * Alias Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_pkcs12#alias ApigeeKeystoresAliasesPkcs12#alias}
    */
    readonly alias: string;
    /**
    * Environment associated with the alias
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_pkcs12#environment ApigeeKeystoresAliasesPkcs12#environment}
    */
    readonly environment: string;
    /**
    * Cert content
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_pkcs12#file ApigeeKeystoresAliasesPkcs12#file}
    */
    readonly file: string;
    /**
    * Hash of the pkcs file
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_pkcs12#filehash ApigeeKeystoresAliasesPkcs12#filehash}
    */
    readonly filehash: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_pkcs12#id ApigeeKeystoresAliasesPkcs12#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Keystore Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_pkcs12#keystore ApigeeKeystoresAliasesPkcs12#keystore}
    */
    readonly keystore: string;
    /**
    * Organization ID associated with the alias
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_pkcs12#org_id ApigeeKeystoresAliasesPkcs12#org_id}
    */
    readonly orgId: string;
    /**
    * Password for the Private Key if it's encrypted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_pkcs12#password ApigeeKeystoresAliasesPkcs12#password}
    */
    readonly password?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_pkcs12#timeouts ApigeeKeystoresAliasesPkcs12#timeouts}
    */
    readonly timeouts?: ApigeeKeystoresAliasesPkcs12Timeouts;
}
export interface ApigeeKeystoresAliasesPkcs12CertsInfoCertInfo {
}
export declare function apigeeKeystoresAliasesPkcs12CertsInfoCertInfoToTerraform(struct?: ApigeeKeystoresAliasesPkcs12CertsInfoCertInfo): any;
export declare class ApigeeKeystoresAliasesPkcs12CertsInfoCertInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApigeeKeystoresAliasesPkcs12CertsInfoCertInfo | undefined;
    set internalValue(value: ApigeeKeystoresAliasesPkcs12CertsInfoCertInfo | undefined);
    get basicConstraints(): string;
    get expiryDate(): string;
    get isValid(): string;
    get issuer(): string;
    get publicKey(): string;
    get serialNumber(): string;
    get sigAlgName(): string;
    get subject(): string;
    get subjectAlternativeNames(): string[];
    get validFrom(): string;
    get version(): number;
}
export declare class ApigeeKeystoresAliasesPkcs12CertsInfoCertInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApigeeKeystoresAliasesPkcs12CertsInfoCertInfoOutputReference;
}
export interface ApigeeKeystoresAliasesPkcs12CertsInfo {
}
export declare function apigeeKeystoresAliasesPkcs12CertsInfoToTerraform(struct?: ApigeeKeystoresAliasesPkcs12CertsInfo): any;
export declare class ApigeeKeystoresAliasesPkcs12CertsInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApigeeKeystoresAliasesPkcs12CertsInfo | undefined;
    set internalValue(value: ApigeeKeystoresAliasesPkcs12CertsInfo | undefined);
    private _certInfo;
    get certInfo(): ApigeeKeystoresAliasesPkcs12CertsInfoCertInfoList;
}
export declare class ApigeeKeystoresAliasesPkcs12CertsInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApigeeKeystoresAliasesPkcs12CertsInfoOutputReference;
}
export interface ApigeeKeystoresAliasesPkcs12Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_pkcs12#create ApigeeKeystoresAliasesPkcs12#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_pkcs12#delete ApigeeKeystoresAliasesPkcs12#delete}
    */
    readonly delete?: string;
}
export declare function apigeeKeystoresAliasesPkcs12TimeoutsToTerraform(struct?: ApigeeKeystoresAliasesPkcs12TimeoutsOutputReference | ApigeeKeystoresAliasesPkcs12Timeouts | cdktf.IResolvable): any;
export declare class ApigeeKeystoresAliasesPkcs12TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeKeystoresAliasesPkcs12Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApigeeKeystoresAliasesPkcs12Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_pkcs12 google_apigee_keystores_aliases_pkcs12}
*/
export declare class ApigeeKeystoresAliasesPkcs12 extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_keystores_aliases_pkcs12";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_pkcs12 google_apigee_keystores_aliases_pkcs12} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeKeystoresAliasesPkcs12Config
    */
    constructor(scope: Construct, id: string, config: ApigeeKeystoresAliasesPkcs12Config);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    get aliasInput(): string | undefined;
    private _certsInfo;
    get certsInfo(): ApigeeKeystoresAliasesPkcs12CertsInfoList;
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    private _file?;
    get file(): string;
    set file(value: string);
    get fileInput(): string | undefined;
    private _filehash?;
    get filehash(): string;
    set filehash(value: string);
    get filehashInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keystore?;
    get keystore(): string;
    set keystore(value: string);
    get keystoreInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    get type(): string;
    private _timeouts;
    get timeouts(): ApigeeKeystoresAliasesPkcs12TimeoutsOutputReference;
    putTimeouts(value: ApigeeKeystoresAliasesPkcs12Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApigeeKeystoresAliasesPkcs12Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
