import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeKeystoresAliasesSelfSignedCertConfig extends cdktf.TerraformMetaArguments {
    /**
    * Alias for the key/certificate pair. Values must match the regular expression [\w\s-.]{1,255}.
  This must be provided for all formats except selfsignedcert; self-signed certs may specify the alias in either
  this parameter or the JSON body.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#alias ApigeeKeystoresAliasesSelfSignedCert#alias}
    */
    readonly alias: string;
    /**
    * Validity duration of certificate, in days. Accepts positive non-zero value. Defaults to 365.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#cert_validity_in_days ApigeeKeystoresAliasesSelfSignedCert#cert_validity_in_days}
    */
    readonly certValidityInDays?: number;
    /**
    * The Apigee environment name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#environment ApigeeKeystoresAliasesSelfSignedCert#environment}
    */
    readonly environment: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#id ApigeeKeystoresAliasesSelfSignedCert#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key size. Default and maximum value is 2048 bits.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#key_size ApigeeKeystoresAliasesSelfSignedCert#key_size}
    */
    readonly keySize?: string;
    /**
    * The Apigee keystore name associated in an Apigee environment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#keystore ApigeeKeystoresAliasesSelfSignedCert#keystore}
    */
    readonly keystore: string;
    /**
    * The Apigee Organization name associated with the Apigee environment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#org_id ApigeeKeystoresAliasesSelfSignedCert#org_id}
    */
    readonly orgId: string;
    /**
    * Signature algorithm to generate private key. Valid values are SHA512withRSA, SHA384withRSA, and SHA256withRSA
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#sig_alg ApigeeKeystoresAliasesSelfSignedCert#sig_alg}
    */
    readonly sigAlg: string;
    /**
    * subject block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#subject ApigeeKeystoresAliasesSelfSignedCert#subject}
    */
    readonly subject: ApigeeKeystoresAliasesSelfSignedCertSubject;
    /**
    * subject_alternative_dns_names block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#subject_alternative_dns_names ApigeeKeystoresAliasesSelfSignedCert#subject_alternative_dns_names}
    */
    readonly subjectAlternativeDnsNames?: ApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#timeouts ApigeeKeystoresAliasesSelfSignedCert#timeouts}
    */
    readonly timeouts?: ApigeeKeystoresAliasesSelfSignedCertTimeouts;
}
export interface ApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfo {
}
export declare function apigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfoToTerraform(struct?: ApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfo): any;
export declare class ApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfo | undefined;
    set internalValue(value: ApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfo | undefined);
    get basicConstraints(): string;
    get expiryDate(): string;
    get isValid(): string;
    get issuer(): string;
    get publicKey(): string;
    get serialNumber(): string;
    get sigAlgName(): string;
    get subject(): string;
    get subjectAlternativeNames(): string[];
    get validFrom(): string;
    get version(): number;
}
export declare class ApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfoOutputReference;
}
export interface ApigeeKeystoresAliasesSelfSignedCertCertsInfo {
}
export declare function apigeeKeystoresAliasesSelfSignedCertCertsInfoToTerraform(struct?: ApigeeKeystoresAliasesSelfSignedCertCertsInfo): any;
export declare class ApigeeKeystoresAliasesSelfSignedCertCertsInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApigeeKeystoresAliasesSelfSignedCertCertsInfo | undefined;
    set internalValue(value: ApigeeKeystoresAliasesSelfSignedCertCertsInfo | undefined);
    private _certInfo;
    get certInfo(): ApigeeKeystoresAliasesSelfSignedCertCertsInfoCertInfoList;
}
export declare class ApigeeKeystoresAliasesSelfSignedCertCertsInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApigeeKeystoresAliasesSelfSignedCertCertsInfoOutputReference;
}
export interface ApigeeKeystoresAliasesSelfSignedCertSubject {
    /**
    * Common name of the organization. Maximum length is 64 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#common_name ApigeeKeystoresAliasesSelfSignedCert#common_name}
    */
    readonly commonName?: string;
    /**
    * Two-letter country code. Example, IN for India, US for United States of America.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#country_code ApigeeKeystoresAliasesSelfSignedCert#country_code}
    */
    readonly countryCode?: string;
    /**
    * Email address. Max 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#email ApigeeKeystoresAliasesSelfSignedCert#email}
    */
    readonly email?: string;
    /**
    * City or town name. Maximum length is 128 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#locality ApigeeKeystoresAliasesSelfSignedCert#locality}
    */
    readonly locality?: string;
    /**
    * Organization name. Maximum length is 64 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#org ApigeeKeystoresAliasesSelfSignedCert#org}
    */
    readonly org?: string;
    /**
    * Organization team name. Maximum length is 64 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#org_unit ApigeeKeystoresAliasesSelfSignedCert#org_unit}
    */
    readonly orgUnit?: string;
    /**
    * State or district name. Maximum length is 128 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#state ApigeeKeystoresAliasesSelfSignedCert#state}
    */
    readonly state?: string;
}
export declare function apigeeKeystoresAliasesSelfSignedCertSubjectToTerraform(struct?: ApigeeKeystoresAliasesSelfSignedCertSubjectOutputReference | ApigeeKeystoresAliasesSelfSignedCertSubject): any;
export declare class ApigeeKeystoresAliasesSelfSignedCertSubjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeKeystoresAliasesSelfSignedCertSubject | undefined;
    set internalValue(value: ApigeeKeystoresAliasesSelfSignedCertSubject | undefined);
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    resetCommonName(): void;
    get commonNameInput(): string | undefined;
    private _countryCode?;
    get countryCode(): string;
    set countryCode(value: string);
    resetCountryCode(): void;
    get countryCodeInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _locality?;
    get locality(): string;
    set locality(value: string);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _org?;
    get org(): string;
    set org(value: string);
    resetOrg(): void;
    get orgInput(): string | undefined;
    private _orgUnit?;
    get orgUnit(): string;
    set orgUnit(value: string);
    resetOrgUnit(): void;
    get orgUnitInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
}
export interface ApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames {
    /**
    * Subject Alternative Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#subject_alternative_name ApigeeKeystoresAliasesSelfSignedCert#subject_alternative_name}
    */
    readonly subjectAlternativeName?: string;
}
export declare function apigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesToTerraform(struct?: ApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesOutputReference | ApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames): any;
export declare class ApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames | undefined;
    set internalValue(value: ApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames | undefined);
    private _subjectAlternativeName?;
    get subjectAlternativeName(): string;
    set subjectAlternativeName(value: string);
    resetSubjectAlternativeName(): void;
    get subjectAlternativeNameInput(): string | undefined;
}
export interface ApigeeKeystoresAliasesSelfSignedCertTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#create ApigeeKeystoresAliasesSelfSignedCert#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert#delete ApigeeKeystoresAliasesSelfSignedCert#delete}
    */
    readonly delete?: string;
}
export declare function apigeeKeystoresAliasesSelfSignedCertTimeoutsToTerraform(struct?: ApigeeKeystoresAliasesSelfSignedCertTimeoutsOutputReference | ApigeeKeystoresAliasesSelfSignedCertTimeouts | cdktf.IResolvable): any;
export declare class ApigeeKeystoresAliasesSelfSignedCertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeKeystoresAliasesSelfSignedCertTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApigeeKeystoresAliasesSelfSignedCertTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert google_apigee_keystores_aliases_self_signed_cert}
*/
export declare class ApigeeKeystoresAliasesSelfSignedCert extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_keystores_aliases_self_signed_cert";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_keystores_aliases_self_signed_cert google_apigee_keystores_aliases_self_signed_cert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeKeystoresAliasesSelfSignedCertConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeKeystoresAliasesSelfSignedCertConfig);
    private _alias?;
    get alias(): string;
    set alias(value: string);
    get aliasInput(): string | undefined;
    private _certValidityInDays?;
    get certValidityInDays(): number;
    set certValidityInDays(value: number);
    resetCertValidityInDays(): void;
    get certValidityInDaysInput(): number | undefined;
    private _certsInfo;
    get certsInfo(): ApigeeKeystoresAliasesSelfSignedCertCertsInfoList;
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keySize?;
    get keySize(): string;
    set keySize(value: string);
    resetKeySize(): void;
    get keySizeInput(): string | undefined;
    private _keystore?;
    get keystore(): string;
    set keystore(value: string);
    get keystoreInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _sigAlg?;
    get sigAlg(): string;
    set sigAlg(value: string);
    get sigAlgInput(): string | undefined;
    get type(): string;
    private _subject;
    get subject(): ApigeeKeystoresAliasesSelfSignedCertSubjectOutputReference;
    putSubject(value: ApigeeKeystoresAliasesSelfSignedCertSubject): void;
    get subjectInput(): ApigeeKeystoresAliasesSelfSignedCertSubject | undefined;
    private _subjectAlternativeDnsNames;
    get subjectAlternativeDnsNames(): ApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNamesOutputReference;
    putSubjectAlternativeDnsNames(value: ApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames): void;
    resetSubjectAlternativeDnsNames(): void;
    get subjectAlternativeDnsNamesInput(): ApigeeKeystoresAliasesSelfSignedCertSubjectAlternativeDnsNames | undefined;
    private _timeouts;
    get timeouts(): ApigeeKeystoresAliasesSelfSignedCertTimeoutsOutputReference;
    putTimeouts(value: ApigeeKeystoresAliasesSelfSignedCertTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApigeeKeystoresAliasesSelfSignedCertTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
