import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeSharedflowDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The resource ID of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sharedflow_deployment#environment ApigeeSharedflowDeployment#environment}
    */
    readonly environment: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sharedflow_deployment#id ApigeeSharedflowDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The Apigee Organization associated with the Apigee instance
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sharedflow_deployment#org_id ApigeeSharedflowDeployment#org_id}
    */
    readonly orgId: string;
    /**
    * Revision of the Sharedflow to be deployed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sharedflow_deployment#revision ApigeeSharedflowDeployment#revision}
    */
    readonly revision: string;
    /**
    * The service account represents the identity of the deployed proxy, and determines what permissions it has. The format must be {ACCOUNT_ID}@{PROJECT}.iam.gserviceaccount.com.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sharedflow_deployment#service_account ApigeeSharedflowDeployment#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Id of the Sharedflow to be deployed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sharedflow_deployment#sharedflow_id ApigeeSharedflowDeployment#sharedflow_id}
    */
    readonly sharedflowId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sharedflow_deployment#timeouts ApigeeSharedflowDeployment#timeouts}
    */
    readonly timeouts?: ApigeeSharedflowDeploymentTimeouts;
}
export interface ApigeeSharedflowDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sharedflow_deployment#create ApigeeSharedflowDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sharedflow_deployment#delete ApigeeSharedflowDeployment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sharedflow_deployment#update ApigeeSharedflowDeployment#update}
    */
    readonly update?: string;
}
export declare function apigeeSharedflowDeploymentTimeoutsToTerraform(struct?: ApigeeSharedflowDeploymentTimeoutsOutputReference | ApigeeSharedflowDeploymentTimeouts | cdktf.IResolvable): any;
export declare class ApigeeSharedflowDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeSharedflowDeploymentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApigeeSharedflowDeploymentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_sharedflow_deployment google_apigee_sharedflow_deployment}
*/
export declare class ApigeeSharedflowDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_sharedflow_deployment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_sharedflow_deployment google_apigee_sharedflow_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeSharedflowDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeSharedflowDeploymentConfig);
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    get revisionInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _sharedflowId?;
    get sharedflowId(): string;
    set sharedflowId(value: string);
    get sharedflowIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApigeeSharedflowDeploymentTimeoutsOutputReference;
    putTimeouts(value: ApigeeSharedflowDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApigeeSharedflowDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
