import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeSyncAuthorizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sync_authorization#id ApigeeSyncAuthorization#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Array of service accounts to grant access to control plane resources, each specified using the following format: 'serviceAccount:service-account-name'.
  
  The 'service-account-name' is formatted like an email address. For example: my-synchronizer-manager-serviceAccount@my_project_id.iam.gserviceaccount.com
  
  You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
  
  The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sync_authorization#identities ApigeeSyncAuthorization#identities}
    */
    readonly identities: string[];
    /**
    * Name of the Apigee organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sync_authorization#name ApigeeSyncAuthorization#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sync_authorization#timeouts ApigeeSyncAuthorization#timeouts}
    */
    readonly timeouts?: ApigeeSyncAuthorizationTimeouts;
}
export interface ApigeeSyncAuthorizationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sync_authorization#create ApigeeSyncAuthorization#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sync_authorization#delete ApigeeSyncAuthorization#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_sync_authorization#update ApigeeSyncAuthorization#update}
    */
    readonly update?: string;
}
export declare function apigeeSyncAuthorizationTimeoutsToTerraform(struct?: ApigeeSyncAuthorizationTimeoutsOutputReference | ApigeeSyncAuthorizationTimeouts | cdktf.IResolvable): any;
export declare class ApigeeSyncAuthorizationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeSyncAuthorizationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApigeeSyncAuthorizationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_sync_authorization google_apigee_sync_authorization}
*/
export declare class ApigeeSyncAuthorization extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_sync_authorization";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_sync_authorization google_apigee_sync_authorization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeSyncAuthorizationConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeSyncAuthorizationConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    get identitiesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApigeeSyncAuthorizationTimeoutsOutputReference;
    putTimeouts(value: ApigeeSyncAuthorizationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApigeeSyncAuthorizationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
