import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ArtifactRegistryRepositoryIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository_iam_binding#id ArtifactRegistryRepositoryIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository_iam_binding#location ArtifactRegistryRepositoryIamBinding#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository_iam_binding#members ArtifactRegistryRepositoryIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository_iam_binding#project ArtifactRegistryRepositoryIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository_iam_binding#repository ArtifactRegistryRepositoryIamBinding#repository}
    */
    readonly repository: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository_iam_binding#role ArtifactRegistryRepositoryIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository_iam_binding#condition ArtifactRegistryRepositoryIamBinding#condition}
    */
    readonly condition?: ArtifactRegistryRepositoryIamBindingCondition;
}
export interface ArtifactRegistryRepositoryIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository_iam_binding#description ArtifactRegistryRepositoryIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository_iam_binding#expression ArtifactRegistryRepositoryIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository_iam_binding#title ArtifactRegistryRepositoryIamBinding#title}
    */
    readonly title: string;
}
export declare function artifactRegistryRepositoryIamBindingConditionToTerraform(struct?: ArtifactRegistryRepositoryIamBindingConditionOutputReference | ArtifactRegistryRepositoryIamBindingCondition): any;
export declare class ArtifactRegistryRepositoryIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArtifactRegistryRepositoryIamBindingCondition | undefined;
    set internalValue(value: ArtifactRegistryRepositoryIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository_iam_binding google_artifact_registry_repository_iam_binding}
*/
export declare class ArtifactRegistryRepositoryIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_artifact_registry_repository_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository_iam_binding google_artifact_registry_repository_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ArtifactRegistryRepositoryIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: ArtifactRegistryRepositoryIamBindingConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): ArtifactRegistryRepositoryIamBindingConditionOutputReference;
    putCondition(value: ArtifactRegistryRepositoryIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): ArtifactRegistryRepositoryIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
