import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ArtifactRegistryRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * The user-provided description of the repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#description ArtifactRegistryRepository#description}
    */
    readonly description?: string;
    /**
    * The format of packages that are stored in the repository. Supported formats
  can be found [here](https://cloud.google.com/artifact-registry/docs/supported-formats).
  You can only create alpha formats if you are a member of the
  [alpha user group](https://cloud.google.com/artifact-registry/docs/supported-formats#alpha-access).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#format ArtifactRegistryRepository#format}
    */
    readonly format: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#id ArtifactRegistryRepository#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The Cloud KMS resource name of the customer managed encryption key that’s
  used to encrypt the contents of the Repository. Has the form:
  'projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key'.
  This value may not be changed after the Repository has been created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#kms_key_name ArtifactRegistryRepository#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * Labels with user-defined metadata.
  This field may contain up to 64 entries. Label keys and values may be no
  longer than 63 characters. Label keys must begin with a lowercase letter
  and may only contain lowercase letters, numeric characters, underscores,
  and dashes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#labels ArtifactRegistryRepository#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the location this repository is located in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#location ArtifactRegistryRepository#location}
    */
    readonly location?: string;
    /**
    * The mode configures the repository to serve artifacts from different sources. Default value: "STANDARD_REPOSITORY" Possible values: ["STANDARD_REPOSITORY", "VIRTUAL_REPOSITORY", "REMOTE_REPOSITORY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#mode ArtifactRegistryRepository#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#project ArtifactRegistryRepository#project}
    */
    readonly project?: string;
    /**
    * The last part of the repository name, for example:
  "repo1"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#repository_id ArtifactRegistryRepository#repository_id}
    */
    readonly repositoryId: string;
    /**
    * docker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#docker_config ArtifactRegistryRepository#docker_config}
    */
    readonly dockerConfig?: ArtifactRegistryRepositoryDockerConfig;
    /**
    * maven_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#maven_config ArtifactRegistryRepository#maven_config}
    */
    readonly mavenConfig?: ArtifactRegistryRepositoryMavenConfig;
    /**
    * remote_repository_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#remote_repository_config ArtifactRegistryRepository#remote_repository_config}
    */
    readonly remoteRepositoryConfig?: ArtifactRegistryRepositoryRemoteRepositoryConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#timeouts ArtifactRegistryRepository#timeouts}
    */
    readonly timeouts?: ArtifactRegistryRepositoryTimeouts;
    /**
    * virtual_repository_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#virtual_repository_config ArtifactRegistryRepository#virtual_repository_config}
    */
    readonly virtualRepositoryConfig?: ArtifactRegistryRepositoryVirtualRepositoryConfig;
}
export interface ArtifactRegistryRepositoryDockerConfig {
    /**
    * The repository which enabled this flag prevents all tags from being modified, moved or deleted. This does not prevent tags from being created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#immutable_tags ArtifactRegistryRepository#immutable_tags}
    */
    readonly immutableTags?: boolean | cdktf.IResolvable;
}
export declare function artifactRegistryRepositoryDockerConfigToTerraform(struct?: ArtifactRegistryRepositoryDockerConfigOutputReference | ArtifactRegistryRepositoryDockerConfig): any;
export declare class ArtifactRegistryRepositoryDockerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArtifactRegistryRepositoryDockerConfig | undefined;
    set internalValue(value: ArtifactRegistryRepositoryDockerConfig | undefined);
    private _immutableTags?;
    get immutableTags(): boolean | cdktf.IResolvable;
    set immutableTags(value: boolean | cdktf.IResolvable);
    resetImmutableTags(): void;
    get immutableTagsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ArtifactRegistryRepositoryMavenConfig {
    /**
    * The repository with this flag will allow publishing the same
  snapshot versions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#allow_snapshot_overwrites ArtifactRegistryRepository#allow_snapshot_overwrites}
    */
    readonly allowSnapshotOverwrites?: boolean | cdktf.IResolvable;
    /**
    * Version policy defines the versions that the registry will accept. Default value: "VERSION_POLICY_UNSPECIFIED" Possible values: ["VERSION_POLICY_UNSPECIFIED", "RELEASE", "SNAPSHOT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#version_policy ArtifactRegistryRepository#version_policy}
    */
    readonly versionPolicy?: string;
}
export declare function artifactRegistryRepositoryMavenConfigToTerraform(struct?: ArtifactRegistryRepositoryMavenConfigOutputReference | ArtifactRegistryRepositoryMavenConfig): any;
export declare class ArtifactRegistryRepositoryMavenConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArtifactRegistryRepositoryMavenConfig | undefined;
    set internalValue(value: ArtifactRegistryRepositoryMavenConfig | undefined);
    private _allowSnapshotOverwrites?;
    get allowSnapshotOverwrites(): boolean | cdktf.IResolvable;
    set allowSnapshotOverwrites(value: boolean | cdktf.IResolvable);
    resetAllowSnapshotOverwrites(): void;
    get allowSnapshotOverwritesInput(): boolean | cdktf.IResolvable | undefined;
    private _versionPolicy?;
    get versionPolicy(): string;
    set versionPolicy(value: string);
    resetVersionPolicy(): void;
    get versionPolicyInput(): string | undefined;
}
export interface ArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository {
    /**
    * Address of the remote repository. Default value: "DOCKER_HUB" Possible values: ["DOCKER_HUB"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#public_repository ArtifactRegistryRepository#public_repository}
    */
    readonly publicRepository?: string;
}
export declare function artifactRegistryRepositoryRemoteRepositoryConfigDockerRepositoryToTerraform(struct?: ArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepositoryOutputReference | ArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository): any;
export declare class ArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository | undefined;
    set internalValue(value: ArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository | undefined);
    private _publicRepository?;
    get publicRepository(): string;
    set publicRepository(value: string);
    resetPublicRepository(): void;
    get publicRepositoryInput(): string | undefined;
}
export interface ArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository {
    /**
    * Address of the remote repository. Default value: "MAVEN_CENTRAL" Possible values: ["MAVEN_CENTRAL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#public_repository ArtifactRegistryRepository#public_repository}
    */
    readonly publicRepository?: string;
}
export declare function artifactRegistryRepositoryRemoteRepositoryConfigMavenRepositoryToTerraform(struct?: ArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepositoryOutputReference | ArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository): any;
export declare class ArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository | undefined;
    set internalValue(value: ArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository | undefined);
    private _publicRepository?;
    get publicRepository(): string;
    set publicRepository(value: string);
    resetPublicRepository(): void;
    get publicRepositoryInput(): string | undefined;
}
export interface ArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository {
    /**
    * Address of the remote repository. Default value: "NPMJS" Possible values: ["NPMJS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#public_repository ArtifactRegistryRepository#public_repository}
    */
    readonly publicRepository?: string;
}
export declare function artifactRegistryRepositoryRemoteRepositoryConfigNpmRepositoryToTerraform(struct?: ArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepositoryOutputReference | ArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository): any;
export declare class ArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository | undefined;
    set internalValue(value: ArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository | undefined);
    private _publicRepository?;
    get publicRepository(): string;
    set publicRepository(value: string);
    resetPublicRepository(): void;
    get publicRepositoryInput(): string | undefined;
}
export interface ArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository {
    /**
    * Address of the remote repository. Default value: "PYPI" Possible values: ["PYPI"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#public_repository ArtifactRegistryRepository#public_repository}
    */
    readonly publicRepository?: string;
}
export declare function artifactRegistryRepositoryRemoteRepositoryConfigPythonRepositoryToTerraform(struct?: ArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepositoryOutputReference | ArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository): any;
export declare class ArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository | undefined;
    set internalValue(value: ArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository | undefined);
    private _publicRepository?;
    get publicRepository(): string;
    set publicRepository(value: string);
    resetPublicRepository(): void;
    get publicRepositoryInput(): string | undefined;
}
export interface ArtifactRegistryRepositoryRemoteRepositoryConfig {
    /**
    * The description of the remote source.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#description ArtifactRegistryRepository#description}
    */
    readonly description?: string;
    /**
    * docker_repository block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#docker_repository ArtifactRegistryRepository#docker_repository}
    */
    readonly dockerRepository?: ArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository;
    /**
    * maven_repository block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#maven_repository ArtifactRegistryRepository#maven_repository}
    */
    readonly mavenRepository?: ArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository;
    /**
    * npm_repository block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#npm_repository ArtifactRegistryRepository#npm_repository}
    */
    readonly npmRepository?: ArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository;
    /**
    * python_repository block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#python_repository ArtifactRegistryRepository#python_repository}
    */
    readonly pythonRepository?: ArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository;
}
export declare function artifactRegistryRepositoryRemoteRepositoryConfigToTerraform(struct?: ArtifactRegistryRepositoryRemoteRepositoryConfigOutputReference | ArtifactRegistryRepositoryRemoteRepositoryConfig): any;
export declare class ArtifactRegistryRepositoryRemoteRepositoryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArtifactRegistryRepositoryRemoteRepositoryConfig | undefined;
    set internalValue(value: ArtifactRegistryRepositoryRemoteRepositoryConfig | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dockerRepository;
    get dockerRepository(): ArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepositoryOutputReference;
    putDockerRepository(value: ArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository): void;
    resetDockerRepository(): void;
    get dockerRepositoryInput(): ArtifactRegistryRepositoryRemoteRepositoryConfigDockerRepository | undefined;
    private _mavenRepository;
    get mavenRepository(): ArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepositoryOutputReference;
    putMavenRepository(value: ArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository): void;
    resetMavenRepository(): void;
    get mavenRepositoryInput(): ArtifactRegistryRepositoryRemoteRepositoryConfigMavenRepository | undefined;
    private _npmRepository;
    get npmRepository(): ArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepositoryOutputReference;
    putNpmRepository(value: ArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository): void;
    resetNpmRepository(): void;
    get npmRepositoryInput(): ArtifactRegistryRepositoryRemoteRepositoryConfigNpmRepository | undefined;
    private _pythonRepository;
    get pythonRepository(): ArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepositoryOutputReference;
    putPythonRepository(value: ArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository): void;
    resetPythonRepository(): void;
    get pythonRepositoryInput(): ArtifactRegistryRepositoryRemoteRepositoryConfigPythonRepository | undefined;
}
export interface ArtifactRegistryRepositoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#create ArtifactRegistryRepository#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#delete ArtifactRegistryRepository#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#update ArtifactRegistryRepository#update}
    */
    readonly update?: string;
}
export declare function artifactRegistryRepositoryTimeoutsToTerraform(struct?: ArtifactRegistryRepositoryTimeoutsOutputReference | ArtifactRegistryRepositoryTimeouts | cdktf.IResolvable): any;
export declare class ArtifactRegistryRepositoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArtifactRegistryRepositoryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ArtifactRegistryRepositoryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies {
    /**
    * The user-provided ID of the upstream policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#id ArtifactRegistryRepository#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Entries with a greater priority value take precedence in the pull order.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#priority ArtifactRegistryRepository#priority}
    */
    readonly priority?: number;
    /**
    * A reference to the repository resource, for example:
  "projects/p1/locations/us-central1/repository/repo1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#repository ArtifactRegistryRepository#repository}
    */
    readonly repository?: string;
}
export declare function artifactRegistryRepositoryVirtualRepositoryConfigUpstreamPoliciesToTerraform(struct?: ArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies | cdktf.IResolvable): any;
export declare class ArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: ArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    resetRepository(): void;
    get repositoryInput(): string | undefined;
}
export declare class ArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPoliciesOutputReference;
}
export interface ArtifactRegistryRepositoryVirtualRepositoryConfig {
    /**
    * upstream_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository#upstream_policies ArtifactRegistryRepository#upstream_policies}
    */
    readonly upstreamPolicies?: ArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies[] | cdktf.IResolvable;
}
export declare function artifactRegistryRepositoryVirtualRepositoryConfigToTerraform(struct?: ArtifactRegistryRepositoryVirtualRepositoryConfigOutputReference | ArtifactRegistryRepositoryVirtualRepositoryConfig): any;
export declare class ArtifactRegistryRepositoryVirtualRepositoryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArtifactRegistryRepositoryVirtualRepositoryConfig | undefined;
    set internalValue(value: ArtifactRegistryRepositoryVirtualRepositoryConfig | undefined);
    private _upstreamPolicies;
    get upstreamPolicies(): ArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPoliciesList;
    putUpstreamPolicies(value: ArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies[] | cdktf.IResolvable): void;
    resetUpstreamPolicies(): void;
    get upstreamPoliciesInput(): cdktf.IResolvable | ArtifactRegistryRepositoryVirtualRepositoryConfigUpstreamPolicies[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository google_artifact_registry_repository}
*/
export declare class ArtifactRegistryRepository extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_artifact_registry_repository";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/artifact_registry_repository google_artifact_registry_repository} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ArtifactRegistryRepositoryConfig
    */
    constructor(scope: Construct, id: string, config: ArtifactRegistryRepositoryConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    get formatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _repositoryId?;
    get repositoryId(): string;
    set repositoryId(value: string);
    get repositoryIdInput(): string | undefined;
    get updateTime(): string;
    private _dockerConfig;
    get dockerConfig(): ArtifactRegistryRepositoryDockerConfigOutputReference;
    putDockerConfig(value: ArtifactRegistryRepositoryDockerConfig): void;
    resetDockerConfig(): void;
    get dockerConfigInput(): ArtifactRegistryRepositoryDockerConfig | undefined;
    private _mavenConfig;
    get mavenConfig(): ArtifactRegistryRepositoryMavenConfigOutputReference;
    putMavenConfig(value: ArtifactRegistryRepositoryMavenConfig): void;
    resetMavenConfig(): void;
    get mavenConfigInput(): ArtifactRegistryRepositoryMavenConfig | undefined;
    private _remoteRepositoryConfig;
    get remoteRepositoryConfig(): ArtifactRegistryRepositoryRemoteRepositoryConfigOutputReference;
    putRemoteRepositoryConfig(value: ArtifactRegistryRepositoryRemoteRepositoryConfig): void;
    resetRemoteRepositoryConfig(): void;
    get remoteRepositoryConfigInput(): ArtifactRegistryRepositoryRemoteRepositoryConfig | undefined;
    private _timeouts;
    get timeouts(): ArtifactRegistryRepositoryTimeoutsOutputReference;
    putTimeouts(value: ArtifactRegistryRepositoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ArtifactRegistryRepositoryTimeouts | undefined;
    private _virtualRepositoryConfig;
    get virtualRepositoryConfig(): ArtifactRegistryRepositoryVirtualRepositoryConfigOutputReference;
    putVirtualRepositoryConfig(value: ArtifactRegistryRepositoryVirtualRepositoryConfig): void;
    resetVirtualRepositoryConfig(): void;
    get virtualRepositoryConfigInput(): ArtifactRegistryRepositoryVirtualRepositoryConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
