import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryDatapolicyDataPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-assigned (human readable) ID of the data policy that needs to be unique within a project. Used as {dataPolicyId} in part of the resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy#data_policy_id BigqueryDatapolicyDataPolicy#data_policy_id}
    */
    readonly dataPolicyId: string;
    /**
    * The enrollment level of the service. Possible values: ["COLUMN_LEVEL_SECURITY_POLICY", "DATA_MASKING_POLICY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy#data_policy_type BigqueryDatapolicyDataPolicy#data_policy_type}
    */
    readonly dataPolicyType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy#id BigqueryDatapolicyDataPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the location of the data policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy#location BigqueryDatapolicyDataPolicy#location}
    */
    readonly location: string;
    /**
    * Policy tag resource name, in the format of projects/{project_number}/locations/{locationId}/taxonomies/{taxonomyId}/policyTags/{policyTag_id}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy#policy_tag BigqueryDatapolicyDataPolicy#policy_tag}
    */
    readonly policyTag: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy#project BigqueryDatapolicyDataPolicy#project}
    */
    readonly project?: string;
    /**
    * data_masking_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy#data_masking_policy BigqueryDatapolicyDataPolicy#data_masking_policy}
    */
    readonly dataMaskingPolicy?: BigqueryDatapolicyDataPolicyDataMaskingPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy#timeouts BigqueryDatapolicyDataPolicy#timeouts}
    */
    readonly timeouts?: BigqueryDatapolicyDataPolicyTimeouts;
}
export interface BigqueryDatapolicyDataPolicyDataMaskingPolicy {
    /**
    * The available masking rules. Learn more here: https://cloud.google.com/bigquery/docs/column-data-masking-intro#masking_options. Possible values: ["SHA256", "ALWAYS_NULL", "DEFAULT_MASKING_VALUE", "LAST_FOUR_CHARACTERS", "FIRST_FOUR_CHARACTERS", "EMAIL_MASK", "DATE_YEAR_MASK"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy#predefined_expression BigqueryDatapolicyDataPolicy#predefined_expression}
    */
    readonly predefinedExpression: string;
}
export declare function bigqueryDatapolicyDataPolicyDataMaskingPolicyToTerraform(struct?: BigqueryDatapolicyDataPolicyDataMaskingPolicyOutputReference | BigqueryDatapolicyDataPolicyDataMaskingPolicy): any;
export declare class BigqueryDatapolicyDataPolicyDataMaskingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryDatapolicyDataPolicyDataMaskingPolicy | undefined;
    set internalValue(value: BigqueryDatapolicyDataPolicyDataMaskingPolicy | undefined);
    private _predefinedExpression?;
    get predefinedExpression(): string;
    set predefinedExpression(value: string);
    get predefinedExpressionInput(): string | undefined;
}
export interface BigqueryDatapolicyDataPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy#create BigqueryDatapolicyDataPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy#delete BigqueryDatapolicyDataPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy#update BigqueryDatapolicyDataPolicy#update}
    */
    readonly update?: string;
}
export declare function bigqueryDatapolicyDataPolicyTimeoutsToTerraform(struct?: BigqueryDatapolicyDataPolicyTimeoutsOutputReference | BigqueryDatapolicyDataPolicyTimeouts | cdktf.IResolvable): any;
export declare class BigqueryDatapolicyDataPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryDatapolicyDataPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BigqueryDatapolicyDataPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy google_bigquery_datapolicy_data_policy}
*/
export declare class BigqueryDatapolicyDataPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_datapolicy_data_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_datapolicy_data_policy google_bigquery_datapolicy_data_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BigqueryDatapolicyDataPolicyConfig
    */
    constructor(scope: Construct, id: string, config: BigqueryDatapolicyDataPolicyConfig);
    private _dataPolicyId?;
    get dataPolicyId(): string;
    set dataPolicyId(value: string);
    get dataPolicyIdInput(): string | undefined;
    private _dataPolicyType?;
    get dataPolicyType(): string;
    set dataPolicyType(value: string);
    get dataPolicyTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _policyTag?;
    get policyTag(): string;
    set policyTag(value: string);
    get policyTagInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _dataMaskingPolicy;
    get dataMaskingPolicy(): BigqueryDatapolicyDataPolicyDataMaskingPolicyOutputReference;
    putDataMaskingPolicy(value: BigqueryDatapolicyDataPolicyDataMaskingPolicy): void;
    resetDataMaskingPolicy(): void;
    get dataMaskingPolicyInput(): BigqueryDatapolicyDataPolicyDataMaskingPolicy | undefined;
    private _timeouts;
    get timeouts(): BigqueryDatapolicyDataPolicyTimeoutsOutputReference;
    putTimeouts(value: BigqueryDatapolicyDataPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BigqueryDatapolicyDataPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
