import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CertificateManagerCertificateMapConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map#description CertificateManagerCertificateMap#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map#id CertificateManagerCertificateMap#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of labels associated with a Certificate Map resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map#labels CertificateManagerCertificateMap#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * A user-defined name of the Certificate Map. Certificate Map names must be unique
  globally and match the pattern 'projects/*\/locations/*\/certificateMaps/*'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map#name CertificateManagerCertificateMap#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map#project CertificateManagerCertificateMap#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map#timeouts CertificateManagerCertificateMap#timeouts}
    */
    readonly timeouts?: CertificateManagerCertificateMapTimeouts;
}
export interface CertificateManagerCertificateMapGclbTargetsIpConfigs {
}
export declare function certificateManagerCertificateMapGclbTargetsIpConfigsToTerraform(struct?: CertificateManagerCertificateMapGclbTargetsIpConfigs): any;
export declare class CertificateManagerCertificateMapGclbTargetsIpConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CertificateManagerCertificateMapGclbTargetsIpConfigs | undefined;
    set internalValue(value: CertificateManagerCertificateMapGclbTargetsIpConfigs | undefined);
    get ipAddress(): string;
    get ports(): number[];
}
export declare class CertificateManagerCertificateMapGclbTargetsIpConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CertificateManagerCertificateMapGclbTargetsIpConfigsOutputReference;
}
export interface CertificateManagerCertificateMapGclbTargets {
}
export declare function certificateManagerCertificateMapGclbTargetsToTerraform(struct?: CertificateManagerCertificateMapGclbTargets): any;
export declare class CertificateManagerCertificateMapGclbTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CertificateManagerCertificateMapGclbTargets | undefined;
    set internalValue(value: CertificateManagerCertificateMapGclbTargets | undefined);
    private _ipConfigs;
    get ipConfigs(): CertificateManagerCertificateMapGclbTargetsIpConfigsList;
    get targetHttpsProxy(): string;
    get targetSslProxy(): string;
}
export declare class CertificateManagerCertificateMapGclbTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CertificateManagerCertificateMapGclbTargetsOutputReference;
}
export interface CertificateManagerCertificateMapTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map#create CertificateManagerCertificateMap#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map#delete CertificateManagerCertificateMap#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map#update CertificateManagerCertificateMap#update}
    */
    readonly update?: string;
}
export declare function certificateManagerCertificateMapTimeoutsToTerraform(struct?: CertificateManagerCertificateMapTimeoutsOutputReference | CertificateManagerCertificateMapTimeouts | cdktf.IResolvable): any;
export declare class CertificateManagerCertificateMapTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CertificateManagerCertificateMapTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CertificateManagerCertificateMapTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map google_certificate_manager_certificate_map}
*/
export declare class CertificateManagerCertificateMap extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_certificate_manager_certificate_map";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map google_certificate_manager_certificate_map} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CertificateManagerCertificateMapConfig
    */
    constructor(scope: Construct, id: string, config: CertificateManagerCertificateMapConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _gclbTargets;
    get gclbTargets(): CertificateManagerCertificateMapGclbTargetsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): CertificateManagerCertificateMapTimeoutsOutputReference;
    putTimeouts(value: CertificateManagerCertificateMapTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CertificateManagerCertificateMapTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
