import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudRunDomainMappingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#id CloudRunDomainMapping#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the cloud run instance. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#location CloudRunDomainMapping#location}
    */
    readonly location: string;
    /**
    * Name should be a [verified](https://support.google.com/webmasters/answer/9008080) domain
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#name CloudRunDomainMapping#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#project CloudRunDomainMapping#project}
    */
    readonly project?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#metadata CloudRunDomainMapping#metadata}
    */
    readonly metadata: CloudRunDomainMappingMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#spec CloudRunDomainMapping#spec}
    */
    readonly spec: CloudRunDomainMappingSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#timeouts CloudRunDomainMapping#timeouts}
    */
    readonly timeouts?: CloudRunDomainMappingTimeouts;
}
export interface CloudRunDomainMappingStatusConditions {
}
export declare function cloudRunDomainMappingStatusConditionsToTerraform(struct?: CloudRunDomainMappingStatusConditions): any;
export declare class CloudRunDomainMappingStatusConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunDomainMappingStatusConditions | undefined;
    set internalValue(value: CloudRunDomainMappingStatusConditions | undefined);
    get message(): string;
    get reason(): string;
    get status(): string;
    get type(): string;
}
export declare class CloudRunDomainMappingStatusConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunDomainMappingStatusConditionsOutputReference;
}
export interface CloudRunDomainMappingStatusResourceRecords {
}
export declare function cloudRunDomainMappingStatusResourceRecordsToTerraform(struct?: CloudRunDomainMappingStatusResourceRecords): any;
export declare class CloudRunDomainMappingStatusResourceRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunDomainMappingStatusResourceRecords | undefined;
    set internalValue(value: CloudRunDomainMappingStatusResourceRecords | undefined);
    get name(): string;
    get rrdata(): string;
    get type(): string;
}
export declare class CloudRunDomainMappingStatusResourceRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunDomainMappingStatusResourceRecordsOutputReference;
}
export interface CloudRunDomainMappingStatus {
}
export declare function cloudRunDomainMappingStatusToTerraform(struct?: CloudRunDomainMappingStatus): any;
export declare class CloudRunDomainMappingStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunDomainMappingStatus | undefined;
    set internalValue(value: CloudRunDomainMappingStatus | undefined);
    private _conditions;
    get conditions(): CloudRunDomainMappingStatusConditionsList;
    get mappedRouteName(): string;
    get observedGeneration(): number;
    private _resourceRecords;
    get resourceRecords(): CloudRunDomainMappingStatusResourceRecordsList;
}
export declare class CloudRunDomainMappingStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunDomainMappingStatusOutputReference;
}
export interface CloudRunDomainMappingMetadata {
    /**
    * Annotations is a key value map stored with a resource that
  may be set by external tools to store and retrieve arbitrary metadata. More
  info: http://kubernetes.io/docs/user-guide/annotations
  
  **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
  If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
  or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#annotations CloudRunDomainMapping#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize
  (scope and select) objects. May match selectors of replication controllers
  and routes.
  More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#labels CloudRunDomainMapping#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * In Cloud Run the namespace must be equal to either the
  project ID or project number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#namespace CloudRunDomainMapping#namespace}
    */
    readonly namespace: string;
}
export declare function cloudRunDomainMappingMetadataToTerraform(struct?: CloudRunDomainMappingMetadataOutputReference | CloudRunDomainMappingMetadata): any;
export declare class CloudRunDomainMappingMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunDomainMappingMetadata | undefined;
    set internalValue(value: CloudRunDomainMappingMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export interface CloudRunDomainMappingSpec {
    /**
    * The mode of the certificate. Default value: "AUTOMATIC" Possible values: ["NONE", "AUTOMATIC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#certificate_mode CloudRunDomainMapping#certificate_mode}
    */
    readonly certificateMode?: string;
    /**
    * If set, the mapping will override any mapping set before this spec was set.
  It is recommended that the user leaves this empty to receive an error
  warning about a potential conflict and only set it once the respective UI
  has given such a warning.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#force_override CloudRunDomainMapping#force_override}
    */
    readonly forceOverride?: boolean | cdktf.IResolvable;
    /**
    * The name of the Cloud Run Service that this DomainMapping applies to.
  The route must exist.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#route_name CloudRunDomainMapping#route_name}
    */
    readonly routeName: string;
}
export declare function cloudRunDomainMappingSpecToTerraform(struct?: CloudRunDomainMappingSpecOutputReference | CloudRunDomainMappingSpec): any;
export declare class CloudRunDomainMappingSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunDomainMappingSpec | undefined;
    set internalValue(value: CloudRunDomainMappingSpec | undefined);
    private _certificateMode?;
    get certificateMode(): string;
    set certificateMode(value: string);
    resetCertificateMode(): void;
    get certificateModeInput(): string | undefined;
    private _forceOverride?;
    get forceOverride(): boolean | cdktf.IResolvable;
    set forceOverride(value: boolean | cdktf.IResolvable);
    resetForceOverride(): void;
    get forceOverrideInput(): boolean | cdktf.IResolvable | undefined;
    private _routeName?;
    get routeName(): string;
    set routeName(value: string);
    get routeNameInput(): string | undefined;
}
export interface CloudRunDomainMappingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#create CloudRunDomainMapping#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping#delete CloudRunDomainMapping#delete}
    */
    readonly delete?: string;
}
export declare function cloudRunDomainMappingTimeoutsToTerraform(struct?: CloudRunDomainMappingTimeoutsOutputReference | CloudRunDomainMappingTimeouts | cdktf.IResolvable): any;
export declare class CloudRunDomainMappingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunDomainMappingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunDomainMappingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping google_cloud_run_domain_mapping}
*/
export declare class CloudRunDomainMapping extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_run_domain_mapping";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_domain_mapping google_cloud_run_domain_mapping} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudRunDomainMappingConfig
    */
    constructor(scope: Construct, id: string, config: CloudRunDomainMappingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _status;
    get status(): CloudRunDomainMappingStatusList;
    private _metadata;
    get metadata(): CloudRunDomainMappingMetadataOutputReference;
    putMetadata(value: CloudRunDomainMappingMetadata): void;
    get metadataInput(): CloudRunDomainMappingMetadata | undefined;
    private _spec;
    get spec(): CloudRunDomainMappingSpecOutputReference;
    putSpec(value: CloudRunDomainMappingSpec): void;
    get specInput(): CloudRunDomainMappingSpec | undefined;
    private _timeouts;
    get timeouts(): CloudRunDomainMappingTimeoutsOutputReference;
    putTimeouts(value: CloudRunDomainMappingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CloudRunDomainMappingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
