import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudRunV2JobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Arbitrary identifier for the API client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#client CloudRunV2Job#client}
    */
    readonly client?: string;
    /**
    * Arbitrary version identifier for the API client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#client_version CloudRunV2Job#client_version}
    */
    readonly clientVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#id CloudRunV2Job#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * KRM-style labels for the resource. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels Cloud Run will populate some labels with 'run.googleapis.com' or 'serving.knative.dev' namespaces. Those labels are read-only, and user changes will not be preserved.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#labels CloudRunV2Job#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The launch stage as defined by Google Cloud Platform Launch Stages. Cloud Run supports ALPHA, BETA, and GA. If no value is specified, GA is assumed. Possible values: ["UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#launch_stage CloudRunV2Job#launch_stage}
    */
    readonly launchStage?: string;
    /**
    * The location of the cloud run job
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#location CloudRunV2Job#location}
    */
    readonly location?: string;
    /**
    * Name of the Job.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#name CloudRunV2Job#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#project CloudRunV2Job#project}
    */
    readonly project?: string;
    /**
    * binary_authorization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#binary_authorization CloudRunV2Job#binary_authorization}
    */
    readonly binaryAuthorization?: CloudRunV2JobBinaryAuthorization;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#template CloudRunV2Job#template}
    */
    readonly template: CloudRunV2JobTemplate;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#timeouts CloudRunV2Job#timeouts}
    */
    readonly timeouts?: CloudRunV2JobTimeouts;
}
export interface CloudRunV2JobConditions {
}
export declare function cloudRunV2JobConditionsToTerraform(struct?: CloudRunV2JobConditions): any;
export declare class CloudRunV2JobConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2JobConditions | undefined;
    set internalValue(value: CloudRunV2JobConditions | undefined);
    get executionReason(): string;
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get revisionReason(): string;
    get severity(): string;
    get state(): string;
    get type(): string;
}
export declare class CloudRunV2JobConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2JobConditionsOutputReference;
}
export interface CloudRunV2JobLatestCreatedExecution {
}
export declare function cloudRunV2JobLatestCreatedExecutionToTerraform(struct?: CloudRunV2JobLatestCreatedExecution): any;
export declare class CloudRunV2JobLatestCreatedExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2JobLatestCreatedExecution | undefined;
    set internalValue(value: CloudRunV2JobLatestCreatedExecution | undefined);
    get completionTime(): string;
    get createTime(): string;
    get name(): string;
}
export declare class CloudRunV2JobLatestCreatedExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2JobLatestCreatedExecutionOutputReference;
}
export interface CloudRunV2JobTerminalCondition {
}
export declare function cloudRunV2JobTerminalConditionToTerraform(struct?: CloudRunV2JobTerminalCondition): any;
export declare class CloudRunV2JobTerminalConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2JobTerminalCondition | undefined;
    set internalValue(value: CloudRunV2JobTerminalCondition | undefined);
    get executionReason(): string;
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get revisionReason(): string;
    get severity(): string;
    get state(): string;
    get type(): string;
}
export declare class CloudRunV2JobTerminalConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2JobTerminalConditionOutputReference;
}
export interface CloudRunV2JobBinaryAuthorization {
    /**
    * If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#breakglass_justification CloudRunV2Job#breakglass_justification}
    */
    readonly breakglassJustification?: string;
    /**
    * If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#use_default CloudRunV2Job#use_default}
    */
    readonly useDefault?: boolean | cdktf.IResolvable;
}
export declare function cloudRunV2JobBinaryAuthorizationToTerraform(struct?: CloudRunV2JobBinaryAuthorizationOutputReference | CloudRunV2JobBinaryAuthorization): any;
export declare class CloudRunV2JobBinaryAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobBinaryAuthorization | undefined;
    set internalValue(value: CloudRunV2JobBinaryAuthorization | undefined);
    private _breakglassJustification?;
    get breakglassJustification(): string;
    set breakglassJustification(value: string);
    resetBreakglassJustification(): void;
    get breakglassJustificationInput(): string | undefined;
    private _useDefault?;
    get useDefault(): boolean | cdktf.IResolvable;
    set useDefault(value: boolean | cdktf.IResolvable);
    resetUseDefault(): void;
    get useDefaultInput(): boolean | cdktf.IResolvable | undefined;
}
export interface CloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef {
    /**
    * The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#secret CloudRunV2Job#secret}
    */
    readonly secret: string;
    /**
    * The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#version CloudRunV2Job#version}
    */
    readonly version: string;
}
export declare function cloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefOutputReference | CloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef): any;
export declare class CloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef | undefined);
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface CloudRunV2JobTemplateTemplateContainersEnvValueSource {
    /**
    * secret_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#secret_key_ref CloudRunV2Job#secret_key_ref}
    */
    readonly secretKeyRef?: CloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef;
}
export declare function cloudRunV2JobTemplateTemplateContainersEnvValueSourceToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersEnvValueSourceOutputReference | CloudRunV2JobTemplateTemplateContainersEnvValueSource): any;
export declare class CloudRunV2JobTemplateTemplateContainersEnvValueSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersEnvValueSource | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersEnvValueSource | undefined);
    private _secretKeyRef;
    get secretKeyRef(): CloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefOutputReference;
    putSecretKeyRef(value: CloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef): void;
    resetSecretKeyRef(): void;
    get secretKeyRefInput(): CloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef | undefined;
}
export interface CloudRunV2JobTemplateTemplateContainersEnv {
    /**
    * Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#name CloudRunV2Job#name}
    */
    readonly name: string;
    /**
    * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#value CloudRunV2Job#value}
    */
    readonly value?: string;
    /**
    * value_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#value_source CloudRunV2Job#value_source}
    */
    readonly valueSource?: CloudRunV2JobTemplateTemplateContainersEnvValueSource;
}
export declare function cloudRunV2JobTemplateTemplateContainersEnvToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersEnv | cdktf.IResolvable): any;
export declare class CloudRunV2JobTemplateTemplateContainersEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersEnv | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _valueSource;
    get valueSource(): CloudRunV2JobTemplateTemplateContainersEnvValueSourceOutputReference;
    putValueSource(value: CloudRunV2JobTemplateTemplateContainersEnvValueSource): void;
    resetValueSource(): void;
    get valueSourceInput(): CloudRunV2JobTemplateTemplateContainersEnvValueSource | undefined;
}
export declare class CloudRunV2JobTemplateTemplateContainersEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2JobTemplateTemplateContainersEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2JobTemplateTemplateContainersEnvOutputReference;
}
export interface CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetHttpHeaders {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#name CloudRunV2Job#name}
    */
    readonly name: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#value CloudRunV2Job#value}
    */
    readonly value?: string;
}
export declare function cloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetHttpHeadersToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable): any;
export declare class CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetHttpHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetHttpHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetHttpHeadersOutputReference;
}
export interface CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGet {
    /**
    * Path to access on the HTTP server. Defaults to '/'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#path CloudRunV2Job#path}
    */
    readonly path?: string;
    /**
    * http_headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#http_headers CloudRunV2Job#http_headers}
    */
    readonly httpHeaders?: CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
}
export declare function cloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetOutputReference | CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGet): any;
export declare class CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGet | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGet | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _httpHeaders;
    get httpHeaders(): CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetHttpHeadersList;
    putHttpHeaders(value: CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetHttpHeaders[] | cdktf.IResolvable): void;
    resetHttpHeaders(): void;
    get httpHeadersInput(): cdktf.IResolvable | CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetHttpHeaders[] | undefined;
}
export interface CloudRunV2JobTemplateTemplateContainersLivenessProbeTcpSocket {
    /**
    * Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#port CloudRunV2Job#port}
    */
    readonly port?: number;
}
export declare function cloudRunV2JobTemplateTemplateContainersLivenessProbeTcpSocketToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersLivenessProbeTcpSocketOutputReference | CloudRunV2JobTemplateTemplateContainersLivenessProbeTcpSocket): any;
export declare class CloudRunV2JobTemplateTemplateContainersLivenessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersLivenessProbeTcpSocket | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersLivenessProbeTcpSocket | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
}
export interface CloudRunV2JobTemplateTemplateContainersLivenessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#failure_threshold CloudRunV2Job#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#initial_delay_seconds CloudRunV2Job#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#period_seconds CloudRunV2Job#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#timeout_seconds CloudRunV2Job#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#http_get CloudRunV2Job#http_get}
    */
    readonly httpGet?: CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#tcp_socket CloudRunV2Job#tcp_socket}
    */
    readonly tcpSocket?: CloudRunV2JobTemplateTemplateContainersLivenessProbeTcpSocket;
}
export declare function cloudRunV2JobTemplateTemplateContainersLivenessProbeToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersLivenessProbeOutputReference | CloudRunV2JobTemplateTemplateContainersLivenessProbe): any;
export declare class CloudRunV2JobTemplateTemplateContainersLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersLivenessProbe | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersLivenessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _httpGet;
    get httpGet(): CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGetOutputReference;
    putHttpGet(value: CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): CloudRunV2JobTemplateTemplateContainersLivenessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): CloudRunV2JobTemplateTemplateContainersLivenessProbeTcpSocketOutputReference;
    putTcpSocket(value: CloudRunV2JobTemplateTemplateContainersLivenessProbeTcpSocket): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): CloudRunV2JobTemplateTemplateContainersLivenessProbeTcpSocket | undefined;
}
export interface CloudRunV2JobTemplateTemplateContainersPorts {
    /**
    * Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#container_port CloudRunV2Job#container_port}
    */
    readonly containerPort?: number;
    /**
    * If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#name CloudRunV2Job#name}
    */
    readonly name?: string;
}
export declare function cloudRunV2JobTemplateTemplateContainersPortsToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersPorts | cdktf.IResolvable): any;
export declare class CloudRunV2JobTemplateTemplateContainersPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersPorts | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersPorts | cdktf.IResolvable | undefined);
    private _containerPort?;
    get containerPort(): number;
    set containerPort(value: number);
    resetContainerPort(): void;
    get containerPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class CloudRunV2JobTemplateTemplateContainersPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2JobTemplateTemplateContainersPorts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2JobTemplateTemplateContainersPortsOutputReference;
}
export interface CloudRunV2JobTemplateTemplateContainersResources {
    /**
    * Only memory and CPU are supported. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#limits CloudRunV2Job#limits}
    */
    readonly limits?: {
        [key: string]: string;
    };
}
export declare function cloudRunV2JobTemplateTemplateContainersResourcesToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersResourcesOutputReference | CloudRunV2JobTemplateTemplateContainersResources): any;
export declare class CloudRunV2JobTemplateTemplateContainersResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersResources | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersResources | undefined);
    private _limits?;
    get limits(): {
        [key: string]: string;
    };
    set limits(value: {
        [key: string]: string;
    });
    resetLimits(): void;
    get limitsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetHttpHeaders {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#name CloudRunV2Job#name}
    */
    readonly name: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#value CloudRunV2Job#value}
    */
    readonly value?: string;
}
export declare function cloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetHttpHeadersToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable): any;
export declare class CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetHttpHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetHttpHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetHttpHeadersOutputReference;
}
export interface CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGet {
    /**
    * Path to access on the HTTP server. Defaults to '/'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#path CloudRunV2Job#path}
    */
    readonly path?: string;
    /**
    * http_headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#http_headers CloudRunV2Job#http_headers}
    */
    readonly httpHeaders?: CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
}
export declare function cloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetOutputReference | CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGet): any;
export declare class CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGet | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGet | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _httpHeaders;
    get httpHeaders(): CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetHttpHeadersList;
    putHttpHeaders(value: CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetHttpHeaders[] | cdktf.IResolvable): void;
    resetHttpHeaders(): void;
    get httpHeadersInput(): cdktf.IResolvable | CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetHttpHeaders[] | undefined;
}
export interface CloudRunV2JobTemplateTemplateContainersStartupProbeTcpSocket {
    /**
    * Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#port CloudRunV2Job#port}
    */
    readonly port?: number;
}
export declare function cloudRunV2JobTemplateTemplateContainersStartupProbeTcpSocketToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersStartupProbeTcpSocketOutputReference | CloudRunV2JobTemplateTemplateContainersStartupProbeTcpSocket): any;
export declare class CloudRunV2JobTemplateTemplateContainersStartupProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersStartupProbeTcpSocket | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersStartupProbeTcpSocket | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
}
export interface CloudRunV2JobTemplateTemplateContainersStartupProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#failure_threshold CloudRunV2Job#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#initial_delay_seconds CloudRunV2Job#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#period_seconds CloudRunV2Job#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#timeout_seconds CloudRunV2Job#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#http_get CloudRunV2Job#http_get}
    */
    readonly httpGet?: CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#tcp_socket CloudRunV2Job#tcp_socket}
    */
    readonly tcpSocket?: CloudRunV2JobTemplateTemplateContainersStartupProbeTcpSocket;
}
export declare function cloudRunV2JobTemplateTemplateContainersStartupProbeToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersStartupProbeOutputReference | CloudRunV2JobTemplateTemplateContainersStartupProbe): any;
export declare class CloudRunV2JobTemplateTemplateContainersStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersStartupProbe | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersStartupProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _httpGet;
    get httpGet(): CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGetOutputReference;
    putHttpGet(value: CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): CloudRunV2JobTemplateTemplateContainersStartupProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): CloudRunV2JobTemplateTemplateContainersStartupProbeTcpSocketOutputReference;
    putTcpSocket(value: CloudRunV2JobTemplateTemplateContainersStartupProbeTcpSocket): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): CloudRunV2JobTemplateTemplateContainersStartupProbeTcpSocket | undefined;
}
export interface CloudRunV2JobTemplateTemplateContainersVolumeMounts {
    /**
    * Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#mount_path CloudRunV2Job#mount_path}
    */
    readonly mountPath: string;
    /**
    * This must match the Name of a Volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#name CloudRunV2Job#name}
    */
    readonly name: string;
}
export declare function cloudRunV2JobTemplateTemplateContainersVolumeMountsToTerraform(struct?: CloudRunV2JobTemplateTemplateContainersVolumeMounts | cdktf.IResolvable): any;
export declare class CloudRunV2JobTemplateTemplateContainersVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2JobTemplateTemplateContainersVolumeMounts | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainersVolumeMounts | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class CloudRunV2JobTemplateTemplateContainersVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2JobTemplateTemplateContainersVolumeMounts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2JobTemplateTemplateContainersVolumeMountsOutputReference;
}
export interface CloudRunV2JobTemplateTemplateContainers {
    /**
    * Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#args CloudRunV2Job#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#command CloudRunV2Job#command}
    */
    readonly command?: string[];
    /**
    * URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#image CloudRunV2Job#image}
    */
    readonly image: string;
    /**
    * Name of the container specified as a DNS_LABEL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#name CloudRunV2Job#name}
    */
    readonly name?: string;
    /**
    * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#working_dir CloudRunV2Job#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#env CloudRunV2Job#env}
    */
    readonly env?: CloudRunV2JobTemplateTemplateContainersEnv[] | cdktf.IResolvable;
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#liveness_probe CloudRunV2Job#liveness_probe}
    */
    readonly livenessProbe?: CloudRunV2JobTemplateTemplateContainersLivenessProbe;
    /**
    * ports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#ports CloudRunV2Job#ports}
    */
    readonly ports?: CloudRunV2JobTemplateTemplateContainersPorts[] | cdktf.IResolvable;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#resources CloudRunV2Job#resources}
    */
    readonly resources?: CloudRunV2JobTemplateTemplateContainersResources;
    /**
    * startup_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#startup_probe CloudRunV2Job#startup_probe}
    */
    readonly startupProbe?: CloudRunV2JobTemplateTemplateContainersStartupProbe;
    /**
    * volume_mounts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#volume_mounts CloudRunV2Job#volume_mounts}
    */
    readonly volumeMounts?: CloudRunV2JobTemplateTemplateContainersVolumeMounts[] | cdktf.IResolvable;
}
export declare function cloudRunV2JobTemplateTemplateContainersToTerraform(struct?: CloudRunV2JobTemplateTemplateContainers | cdktf.IResolvable): any;
export declare class CloudRunV2JobTemplateTemplateContainersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2JobTemplateTemplateContainers | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateContainers | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _env;
    get env(): CloudRunV2JobTemplateTemplateContainersEnvList;
    putEnv(value: CloudRunV2JobTemplateTemplateContainersEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | CloudRunV2JobTemplateTemplateContainersEnv[] | undefined;
    private _livenessProbe;
    get livenessProbe(): CloudRunV2JobTemplateTemplateContainersLivenessProbeOutputReference;
    putLivenessProbe(value: CloudRunV2JobTemplateTemplateContainersLivenessProbe): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): CloudRunV2JobTemplateTemplateContainersLivenessProbe | undefined;
    private _ports;
    get ports(): CloudRunV2JobTemplateTemplateContainersPortsList;
    putPorts(value: CloudRunV2JobTemplateTemplateContainersPorts[] | cdktf.IResolvable): void;
    resetPorts(): void;
    get portsInput(): cdktf.IResolvable | CloudRunV2JobTemplateTemplateContainersPorts[] | undefined;
    private _resources;
    get resources(): CloudRunV2JobTemplateTemplateContainersResourcesOutputReference;
    putResources(value: CloudRunV2JobTemplateTemplateContainersResources): void;
    resetResources(): void;
    get resourcesInput(): CloudRunV2JobTemplateTemplateContainersResources | undefined;
    private _startupProbe;
    get startupProbe(): CloudRunV2JobTemplateTemplateContainersStartupProbeOutputReference;
    putStartupProbe(value: CloudRunV2JobTemplateTemplateContainersStartupProbe): void;
    resetStartupProbe(): void;
    get startupProbeInput(): CloudRunV2JobTemplateTemplateContainersStartupProbe | undefined;
    private _volumeMounts;
    get volumeMounts(): CloudRunV2JobTemplateTemplateContainersVolumeMountsList;
    putVolumeMounts(value: CloudRunV2JobTemplateTemplateContainersVolumeMounts[] | cdktf.IResolvable): void;
    resetVolumeMounts(): void;
    get volumeMountsInput(): cdktf.IResolvable | CloudRunV2JobTemplateTemplateContainersVolumeMounts[] | undefined;
}
export declare class CloudRunV2JobTemplateTemplateContainersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2JobTemplateTemplateContainers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2JobTemplateTemplateContainersOutputReference;
}
export interface CloudRunV2JobTemplateTemplateVolumesCloudSqlInstance {
    /**
    * The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#instances CloudRunV2Job#instances}
    */
    readonly instances?: string[];
}
export declare function cloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceToTerraform(struct?: CloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceOutputReference | CloudRunV2JobTemplateTemplateVolumesCloudSqlInstance): any;
export declare class CloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplateTemplateVolumesCloudSqlInstance | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateVolumesCloudSqlInstance | undefined);
    private _instances?;
    get instances(): string[];
    set instances(value: string[]);
    resetInstances(): void;
    get instancesInput(): string[] | undefined;
}
export interface CloudRunV2JobTemplateTemplateVolumesSecretItems {
    /**
    * Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#mode CloudRunV2Job#mode}
    */
    readonly mode: number;
    /**
    * The relative path of the secret in the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#path CloudRunV2Job#path}
    */
    readonly path: string;
    /**
    * The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#version CloudRunV2Job#version}
    */
    readonly version: string;
}
export declare function cloudRunV2JobTemplateTemplateVolumesSecretItemsToTerraform(struct?: CloudRunV2JobTemplateTemplateVolumesSecretItems | cdktf.IResolvable): any;
export declare class CloudRunV2JobTemplateTemplateVolumesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2JobTemplateTemplateVolumesSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateVolumesSecretItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): number;
    set mode(value: number);
    get modeInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export declare class CloudRunV2JobTemplateTemplateVolumesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2JobTemplateTemplateVolumesSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2JobTemplateTemplateVolumesSecretItemsOutputReference;
}
export interface CloudRunV2JobTemplateTemplateVolumesSecret {
    /**
    * Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#default_mode CloudRunV2Job#default_mode}
    */
    readonly defaultMode?: number;
    /**
    * The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#secret CloudRunV2Job#secret}
    */
    readonly secret: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#items CloudRunV2Job#items}
    */
    readonly items?: CloudRunV2JobTemplateTemplateVolumesSecretItems[] | cdktf.IResolvable;
}
export declare function cloudRunV2JobTemplateTemplateVolumesSecretToTerraform(struct?: CloudRunV2JobTemplateTemplateVolumesSecretOutputReference | CloudRunV2JobTemplateTemplateVolumesSecret): any;
export declare class CloudRunV2JobTemplateTemplateVolumesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplateTemplateVolumesSecret | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateVolumesSecret | undefined);
    private _defaultMode?;
    get defaultMode(): number;
    set defaultMode(value: number);
    resetDefaultMode(): void;
    get defaultModeInput(): number | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _items;
    get items(): CloudRunV2JobTemplateTemplateVolumesSecretItemsList;
    putItems(value: CloudRunV2JobTemplateTemplateVolumesSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | CloudRunV2JobTemplateTemplateVolumesSecretItems[] | undefined;
}
export interface CloudRunV2JobTemplateTemplateVolumes {
    /**
    * Volume's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#name CloudRunV2Job#name}
    */
    readonly name: string;
    /**
    * cloud_sql_instance block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#cloud_sql_instance CloudRunV2Job#cloud_sql_instance}
    */
    readonly cloudSqlInstance?: CloudRunV2JobTemplateTemplateVolumesCloudSqlInstance;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#secret CloudRunV2Job#secret}
    */
    readonly secret?: CloudRunV2JobTemplateTemplateVolumesSecret;
}
export declare function cloudRunV2JobTemplateTemplateVolumesToTerraform(struct?: CloudRunV2JobTemplateTemplateVolumes | cdktf.IResolvable): any;
export declare class CloudRunV2JobTemplateTemplateVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2JobTemplateTemplateVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateVolumes | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _cloudSqlInstance;
    get cloudSqlInstance(): CloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceOutputReference;
    putCloudSqlInstance(value: CloudRunV2JobTemplateTemplateVolumesCloudSqlInstance): void;
    resetCloudSqlInstance(): void;
    get cloudSqlInstanceInput(): CloudRunV2JobTemplateTemplateVolumesCloudSqlInstance | undefined;
    private _secret;
    get secret(): CloudRunV2JobTemplateTemplateVolumesSecretOutputReference;
    putSecret(value: CloudRunV2JobTemplateTemplateVolumesSecret): void;
    resetSecret(): void;
    get secretInput(): CloudRunV2JobTemplateTemplateVolumesSecret | undefined;
}
export declare class CloudRunV2JobTemplateTemplateVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2JobTemplateTemplateVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2JobTemplateTemplateVolumesOutputReference;
}
export interface CloudRunV2JobTemplateTemplateVpcAccess {
    /**
    * VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#connector CloudRunV2Job#connector}
    */
    readonly connector?: string;
    /**
    * Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#egress CloudRunV2Job#egress}
    */
    readonly egress?: string;
}
export declare function cloudRunV2JobTemplateTemplateVpcAccessToTerraform(struct?: CloudRunV2JobTemplateTemplateVpcAccessOutputReference | CloudRunV2JobTemplateTemplateVpcAccess): any;
export declare class CloudRunV2JobTemplateTemplateVpcAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplateTemplateVpcAccess | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplateVpcAccess | undefined);
    private _connector?;
    get connector(): string;
    set connector(value: string);
    resetConnector(): void;
    get connectorInput(): string | undefined;
    private _egress?;
    get egress(): string;
    set egress(value: string);
    resetEgress(): void;
    get egressInput(): string | undefined;
}
export interface CloudRunV2JobTemplateTemplate {
    /**
    * A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#encryption_key CloudRunV2Job#encryption_key}
    */
    readonly encryptionKey?: string;
    /**
    * The execution environment being used to host this Task. Possible values: ["EXECUTION_ENVIRONMENT_GEN1", "EXECUTION_ENVIRONMENT_GEN2"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#execution_environment CloudRunV2Job#execution_environment}
    */
    readonly executionEnvironment?: string;
    /**
    * Number of retries allowed per Task, before marking this Task failed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#max_retries CloudRunV2Job#max_retries}
    */
    readonly maxRetries?: number;
    /**
    * Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#service_account CloudRunV2Job#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
  
  A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#timeout CloudRunV2Job#timeout}
    */
    readonly timeout?: string;
    /**
    * containers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#containers CloudRunV2Job#containers}
    */
    readonly containers?: CloudRunV2JobTemplateTemplateContainers[] | cdktf.IResolvable;
    /**
    * volumes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#volumes CloudRunV2Job#volumes}
    */
    readonly volumes?: CloudRunV2JobTemplateTemplateVolumes[] | cdktf.IResolvable;
    /**
    * vpc_access block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#vpc_access CloudRunV2Job#vpc_access}
    */
    readonly vpcAccess?: CloudRunV2JobTemplateTemplateVpcAccess;
}
export declare function cloudRunV2JobTemplateTemplateToTerraform(struct?: CloudRunV2JobTemplateTemplateOutputReference | CloudRunV2JobTemplateTemplate): any;
export declare class CloudRunV2JobTemplateTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplateTemplate | undefined;
    set internalValue(value: CloudRunV2JobTemplateTemplate | undefined);
    private _encryptionKey?;
    get encryptionKey(): string;
    set encryptionKey(value: string);
    resetEncryptionKey(): void;
    get encryptionKeyInput(): string | undefined;
    private _executionEnvironment?;
    get executionEnvironment(): string;
    set executionEnvironment(value: string);
    resetExecutionEnvironment(): void;
    get executionEnvironmentInput(): string | undefined;
    private _maxRetries?;
    get maxRetries(): number;
    set maxRetries(value: number);
    resetMaxRetries(): void;
    get maxRetriesInput(): number | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _containers;
    get containers(): CloudRunV2JobTemplateTemplateContainersList;
    putContainers(value: CloudRunV2JobTemplateTemplateContainers[] | cdktf.IResolvable): void;
    resetContainers(): void;
    get containersInput(): cdktf.IResolvable | CloudRunV2JobTemplateTemplateContainers[] | undefined;
    private _volumes;
    get volumes(): CloudRunV2JobTemplateTemplateVolumesList;
    putVolumes(value: CloudRunV2JobTemplateTemplateVolumes[] | cdktf.IResolvable): void;
    resetVolumes(): void;
    get volumesInput(): cdktf.IResolvable | CloudRunV2JobTemplateTemplateVolumes[] | undefined;
    private _vpcAccess;
    get vpcAccess(): CloudRunV2JobTemplateTemplateVpcAccessOutputReference;
    putVpcAccess(value: CloudRunV2JobTemplateTemplateVpcAccess): void;
    resetVpcAccess(): void;
    get vpcAccessInput(): CloudRunV2JobTemplateTemplateVpcAccess | undefined;
}
export interface CloudRunV2JobTemplate {
    /**
    * KRM-style labels for the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#labels CloudRunV2Job#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#parallelism CloudRunV2Job#parallelism}
    */
    readonly parallelism?: number;
    /**
    * Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#task_count CloudRunV2Job#task_count}
    */
    readonly taskCount?: number;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#template CloudRunV2Job#template}
    */
    readonly template: CloudRunV2JobTemplateTemplate;
}
export declare function cloudRunV2JobTemplateToTerraform(struct?: CloudRunV2JobTemplateOutputReference | CloudRunV2JobTemplate): any;
export declare class CloudRunV2JobTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTemplate | undefined;
    set internalValue(value: CloudRunV2JobTemplate | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _parallelism?;
    get parallelism(): number;
    set parallelism(value: number);
    resetParallelism(): void;
    get parallelismInput(): number | undefined;
    private _taskCount?;
    get taskCount(): number;
    set taskCount(value: number);
    resetTaskCount(): void;
    get taskCountInput(): number | undefined;
    private _template;
    get template(): CloudRunV2JobTemplateTemplateOutputReference;
    putTemplate(value: CloudRunV2JobTemplateTemplate): void;
    get templateInput(): CloudRunV2JobTemplateTemplate | undefined;
}
export interface CloudRunV2JobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#create CloudRunV2Job#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#delete CloudRunV2Job#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job#update CloudRunV2Job#update}
    */
    readonly update?: string;
}
export declare function cloudRunV2JobTimeoutsToTerraform(struct?: CloudRunV2JobTimeoutsOutputReference | CloudRunV2JobTimeouts | cdktf.IResolvable): any;
export declare class CloudRunV2JobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2JobTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2JobTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job google_cloud_run_v2_job}
*/
export declare class CloudRunV2Job extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_run_v2_job";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_job google_cloud_run_v2_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudRunV2JobConfig
    */
    constructor(scope: Construct, id: string, config: CloudRunV2JobConfig);
    private _client?;
    get client(): string;
    set client(value: string);
    resetClient(): void;
    get clientInput(): string | undefined;
    private _clientVersion?;
    get clientVersion(): string;
    set clientVersion(value: string);
    resetClientVersion(): void;
    get clientVersionInput(): string | undefined;
    private _conditions;
    get conditions(): CloudRunV2JobConditionsList;
    get etag(): string;
    get executionCount(): number;
    get generation(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _latestCreatedExecution;
    get latestCreatedExecution(): CloudRunV2JobLatestCreatedExecutionList;
    private _launchStage?;
    get launchStage(): string;
    set launchStage(value: string);
    resetLaunchStage(): void;
    get launchStageInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get observedGeneration(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    private _terminalCondition;
    get terminalCondition(): CloudRunV2JobTerminalConditionList;
    get uid(): string;
    private _binaryAuthorization;
    get binaryAuthorization(): CloudRunV2JobBinaryAuthorizationOutputReference;
    putBinaryAuthorization(value: CloudRunV2JobBinaryAuthorization): void;
    resetBinaryAuthorization(): void;
    get binaryAuthorizationInput(): CloudRunV2JobBinaryAuthorization | undefined;
    private _template;
    get template(): CloudRunV2JobTemplateOutputReference;
    putTemplate(value: CloudRunV2JobTemplate): void;
    get templateInput(): CloudRunV2JobTemplate | undefined;
    private _timeouts;
    get timeouts(): CloudRunV2JobTimeoutsOutputReference;
    putTimeouts(value: CloudRunV2JobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CloudRunV2JobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
