import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudRunV2ServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects. Cloud Run will populate some annotations using 'run.googleapis.com' or 'serving.knative.dev' namespaces. This field follows Kubernetes annotations' namespacing, limits, and rules. More info: https://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#annotations CloudRunV2Service#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Arbitrary identifier for the API client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#client CloudRunV2Service#client}
    */
    readonly client?: string;
    /**
    * Arbitrary version identifier for the API client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#client_version CloudRunV2Service#client_version}
    */
    readonly clientVersion?: string;
    /**
    * User-provided description of the Service. This field currently has a 512-character limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#description CloudRunV2Service#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#id CloudRunV2Service#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no revision is active. Possible values: ["INGRESS_TRAFFIC_ALL", "INGRESS_TRAFFIC_INTERNAL_ONLY", "INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#ingress CloudRunV2Service#ingress}
    */
    readonly ingress?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels Cloud Run will populate some labels with 'run.googleapis.com' or 'serving.knative.dev' namespaces. Those labels are read-only, and user changes will not be preserved.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#labels CloudRunV2Service#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The launch stage as defined by Google Cloud Platform Launch Stages. Cloud Run supports ALPHA, BETA, and GA. If no value is specified, GA is assumed. Possible values: ["UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#launch_stage CloudRunV2Service#launch_stage}
    */
    readonly launchStage?: string;
    /**
    * The location of the cloud run service
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#location CloudRunV2Service#location}
    */
    readonly location?: string;
    /**
    * Name of the Service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#name CloudRunV2Service#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#project CloudRunV2Service#project}
    */
    readonly project?: string;
    /**
    * binary_authorization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#binary_authorization CloudRunV2Service#binary_authorization}
    */
    readonly binaryAuthorization?: CloudRunV2ServiceBinaryAuthorization;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#template CloudRunV2Service#template}
    */
    readonly template: CloudRunV2ServiceTemplate;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#timeouts CloudRunV2Service#timeouts}
    */
    readonly timeouts?: CloudRunV2ServiceTimeouts;
    /**
    * traffic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#traffic CloudRunV2Service#traffic}
    */
    readonly traffic?: CloudRunV2ServiceTraffic[] | cdktf.IResolvable;
}
export interface CloudRunV2ServiceConditions {
}
export declare function cloudRunV2ServiceConditionsToTerraform(struct?: CloudRunV2ServiceConditions): any;
export declare class CloudRunV2ServiceConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2ServiceConditions | undefined;
    set internalValue(value: CloudRunV2ServiceConditions | undefined);
    get executionReason(): string;
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get revisionReason(): string;
    get severity(): string;
    get state(): string;
    get type(): string;
}
export declare class CloudRunV2ServiceConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2ServiceConditionsOutputReference;
}
export interface CloudRunV2ServiceTerminalCondition {
}
export declare function cloudRunV2ServiceTerminalConditionToTerraform(struct?: CloudRunV2ServiceTerminalCondition): any;
export declare class CloudRunV2ServiceTerminalConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2ServiceTerminalCondition | undefined;
    set internalValue(value: CloudRunV2ServiceTerminalCondition | undefined);
    get executionReason(): string;
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get revisionReason(): string;
    get severity(): string;
    get state(): string;
    get type(): string;
}
export declare class CloudRunV2ServiceTerminalConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2ServiceTerminalConditionOutputReference;
}
export interface CloudRunV2ServiceTrafficStatuses {
}
export declare function cloudRunV2ServiceTrafficStatusesToTerraform(struct?: CloudRunV2ServiceTrafficStatuses): any;
export declare class CloudRunV2ServiceTrafficStatusesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2ServiceTrafficStatuses | undefined;
    set internalValue(value: CloudRunV2ServiceTrafficStatuses | undefined);
    get percent(): number;
    get revision(): string;
    get tag(): string;
    get type(): string;
    get uri(): string;
}
export declare class CloudRunV2ServiceTrafficStatusesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2ServiceTrafficStatusesOutputReference;
}
export interface CloudRunV2ServiceBinaryAuthorization {
    /**
    * If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#breakglass_justification CloudRunV2Service#breakglass_justification}
    */
    readonly breakglassJustification?: string;
    /**
    * If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#use_default CloudRunV2Service#use_default}
    */
    readonly useDefault?: boolean | cdktf.IResolvable;
}
export declare function cloudRunV2ServiceBinaryAuthorizationToTerraform(struct?: CloudRunV2ServiceBinaryAuthorizationOutputReference | CloudRunV2ServiceBinaryAuthorization): any;
export declare class CloudRunV2ServiceBinaryAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceBinaryAuthorization | undefined;
    set internalValue(value: CloudRunV2ServiceBinaryAuthorization | undefined);
    private _breakglassJustification?;
    get breakglassJustification(): string;
    set breakglassJustification(value: string);
    resetBreakglassJustification(): void;
    get breakglassJustificationInput(): string | undefined;
    private _useDefault?;
    get useDefault(): boolean | cdktf.IResolvable;
    set useDefault(value: boolean | cdktf.IResolvable);
    resetUseDefault(): void;
    get useDefaultInput(): boolean | cdktf.IResolvable | undefined;
}
export interface CloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef {
    /**
    * The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#secret CloudRunV2Service#secret}
    */
    readonly secret: string;
    /**
    * The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#version CloudRunV2Service#version}
    */
    readonly version?: string;
}
export declare function cloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefToTerraform(struct?: CloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefOutputReference | CloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef): any;
export declare class CloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef | undefined);
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface CloudRunV2ServiceTemplateContainersEnvValueSource {
    /**
    * secret_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#secret_key_ref CloudRunV2Service#secret_key_ref}
    */
    readonly secretKeyRef?: CloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef;
}
export declare function cloudRunV2ServiceTemplateContainersEnvValueSourceToTerraform(struct?: CloudRunV2ServiceTemplateContainersEnvValueSourceOutputReference | CloudRunV2ServiceTemplateContainersEnvValueSource): any;
export declare class CloudRunV2ServiceTemplateContainersEnvValueSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateContainersEnvValueSource | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersEnvValueSource | undefined);
    private _secretKeyRef;
    get secretKeyRef(): CloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefOutputReference;
    putSecretKeyRef(value: CloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef): void;
    resetSecretKeyRef(): void;
    get secretKeyRefInput(): CloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef | undefined;
}
export interface CloudRunV2ServiceTemplateContainersEnv {
    /**
    * Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#name CloudRunV2Service#name}
    */
    readonly name: string;
    /**
    * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#value CloudRunV2Service#value}
    */
    readonly value?: string;
    /**
    * value_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#value_source CloudRunV2Service#value_source}
    */
    readonly valueSource?: CloudRunV2ServiceTemplateContainersEnvValueSource;
}
export declare function cloudRunV2ServiceTemplateContainersEnvToTerraform(struct?: CloudRunV2ServiceTemplateContainersEnv | cdktf.IResolvable): any;
export declare class CloudRunV2ServiceTemplateContainersEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2ServiceTemplateContainersEnv | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _valueSource;
    get valueSource(): CloudRunV2ServiceTemplateContainersEnvValueSourceOutputReference;
    putValueSource(value: CloudRunV2ServiceTemplateContainersEnvValueSource): void;
    resetValueSource(): void;
    get valueSourceInput(): CloudRunV2ServiceTemplateContainersEnvValueSource | undefined;
}
export declare class CloudRunV2ServiceTemplateContainersEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2ServiceTemplateContainersEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2ServiceTemplateContainersEnvOutputReference;
}
export interface CloudRunV2ServiceTemplateContainersLivenessProbeGrpc {
    /**
    * Port number to access on the container. Number must be in the range 1 to 65535. If not specified, defaults to the same value as container.ports[0].containerPort.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#port CloudRunV2Service#port}
    */
    readonly port?: number;
    /**
    * The name of the service to place in the gRPC HealthCheckRequest
  (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
  If this is not specified, the default behavior is defined by gRPC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#service CloudRunV2Service#service}
    */
    readonly service?: string;
}
export declare function cloudRunV2ServiceTemplateContainersLivenessProbeGrpcToTerraform(struct?: CloudRunV2ServiceTemplateContainersLivenessProbeGrpcOutputReference | CloudRunV2ServiceTemplateContainersLivenessProbeGrpc): any;
export declare class CloudRunV2ServiceTemplateContainersLivenessProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateContainersLivenessProbeGrpc | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersLivenessProbeGrpc | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export interface CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#name CloudRunV2Service#name}
    */
    readonly name: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#value CloudRunV2Service#value}
    */
    readonly value?: string;
}
export declare function cloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersToTerraform(struct?: CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable): any;
export declare class CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersOutputReference;
}
export interface CloudRunV2ServiceTemplateContainersLivenessProbeHttpGet {
    /**
    * Path to access on the HTTP server. Defaults to '/'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#path CloudRunV2Service#path}
    */
    readonly path?: string;
    /**
    * http_headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#http_headers CloudRunV2Service#http_headers}
    */
    readonly httpHeaders?: CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
}
export declare function cloudRunV2ServiceTemplateContainersLivenessProbeHttpGetToTerraform(struct?: CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetOutputReference | CloudRunV2ServiceTemplateContainersLivenessProbeHttpGet): any;
export declare class CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateContainersLivenessProbeHttpGet | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersLivenessProbeHttpGet | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _httpHeaders;
    get httpHeaders(): CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersList;
    putHttpHeaders(value: CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders[] | cdktf.IResolvable): void;
    resetHttpHeaders(): void;
    get httpHeadersInput(): cdktf.IResolvable | CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders[] | undefined;
}
export interface CloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket {
    /**
    * Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#port CloudRunV2Service#port}
    */
    readonly port?: number;
}
export declare function cloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketToTerraform(struct?: CloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketOutputReference | CloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket): any;
export declare class CloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
}
export interface CloudRunV2ServiceTemplateContainersLivenessProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#failure_threshold CloudRunV2Service#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#initial_delay_seconds CloudRunV2Service#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#period_seconds CloudRunV2Service#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#timeout_seconds CloudRunV2Service#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#grpc CloudRunV2Service#grpc}
    */
    readonly grpc?: CloudRunV2ServiceTemplateContainersLivenessProbeGrpc;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#http_get CloudRunV2Service#http_get}
    */
    readonly httpGet?: CloudRunV2ServiceTemplateContainersLivenessProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#tcp_socket CloudRunV2Service#tcp_socket}
    */
    readonly tcpSocket?: CloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket;
}
export declare function cloudRunV2ServiceTemplateContainersLivenessProbeToTerraform(struct?: CloudRunV2ServiceTemplateContainersLivenessProbeOutputReference | CloudRunV2ServiceTemplateContainersLivenessProbe): any;
export declare class CloudRunV2ServiceTemplateContainersLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateContainersLivenessProbe | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersLivenessProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _grpc;
    get grpc(): CloudRunV2ServiceTemplateContainersLivenessProbeGrpcOutputReference;
    putGrpc(value: CloudRunV2ServiceTemplateContainersLivenessProbeGrpc): void;
    resetGrpc(): void;
    get grpcInput(): CloudRunV2ServiceTemplateContainersLivenessProbeGrpc | undefined;
    private _httpGet;
    get httpGet(): CloudRunV2ServiceTemplateContainersLivenessProbeHttpGetOutputReference;
    putHttpGet(value: CloudRunV2ServiceTemplateContainersLivenessProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): CloudRunV2ServiceTemplateContainersLivenessProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): CloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketOutputReference;
    putTcpSocket(value: CloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): CloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket | undefined;
}
export interface CloudRunV2ServiceTemplateContainersPorts {
    /**
    * Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#container_port CloudRunV2Service#container_port}
    */
    readonly containerPort?: number;
    /**
    * If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#name CloudRunV2Service#name}
    */
    readonly name?: string;
}
export declare function cloudRunV2ServiceTemplateContainersPortsToTerraform(struct?: CloudRunV2ServiceTemplateContainersPorts | cdktf.IResolvable): any;
export declare class CloudRunV2ServiceTemplateContainersPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2ServiceTemplateContainersPorts | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersPorts | cdktf.IResolvable | undefined);
    private _containerPort?;
    get containerPort(): number;
    set containerPort(value: number);
    resetContainerPort(): void;
    get containerPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class CloudRunV2ServiceTemplateContainersPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2ServiceTemplateContainersPorts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2ServiceTemplateContainersPortsOutputReference;
}
export interface CloudRunV2ServiceTemplateContainersResources {
    /**
    * Determines whether CPU should be throttled or not outside of requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#cpu_idle CloudRunV2Service#cpu_idle}
    */
    readonly cpuIdle?: boolean | cdktf.IResolvable;
    /**
    * Only memory and CPU are supported. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#limits CloudRunV2Service#limits}
    */
    readonly limits?: {
        [key: string]: string;
    };
}
export declare function cloudRunV2ServiceTemplateContainersResourcesToTerraform(struct?: CloudRunV2ServiceTemplateContainersResourcesOutputReference | CloudRunV2ServiceTemplateContainersResources): any;
export declare class CloudRunV2ServiceTemplateContainersResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateContainersResources | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersResources | undefined);
    private _cpuIdle?;
    get cpuIdle(): boolean | cdktf.IResolvable;
    set cpuIdle(value: boolean | cdktf.IResolvable);
    resetCpuIdle(): void;
    get cpuIdleInput(): boolean | cdktf.IResolvable | undefined;
    private _limits?;
    get limits(): {
        [key: string]: string;
    };
    set limits(value: {
        [key: string]: string;
    });
    resetLimits(): void;
    get limitsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface CloudRunV2ServiceTemplateContainersStartupProbeGrpc {
    /**
    * Port number to access on the container. Number must be in the range 1 to 65535. If not specified, defaults to the same value as container.ports[0].containerPort.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#port CloudRunV2Service#port}
    */
    readonly port?: number;
    /**
    * The name of the service to place in the gRPC HealthCheckRequest
  (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
  If this is not specified, the default behavior is defined by gRPC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#service CloudRunV2Service#service}
    */
    readonly service?: string;
}
export declare function cloudRunV2ServiceTemplateContainersStartupProbeGrpcToTerraform(struct?: CloudRunV2ServiceTemplateContainersStartupProbeGrpcOutputReference | CloudRunV2ServiceTemplateContainersStartupProbeGrpc): any;
export declare class CloudRunV2ServiceTemplateContainersStartupProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateContainersStartupProbeGrpc | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersStartupProbeGrpc | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
}
export interface CloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders {
    /**
    * The header field name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#name CloudRunV2Service#name}
    */
    readonly name: string;
    /**
    * The header field value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#value CloudRunV2Service#value}
    */
    readonly value?: string;
}
export declare function cloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersToTerraform(struct?: CloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable): any;
export declare class CloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class CloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersOutputReference;
}
export interface CloudRunV2ServiceTemplateContainersStartupProbeHttpGet {
    /**
    * Path to access on the HTTP server. Defaults to '/'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#path CloudRunV2Service#path}
    */
    readonly path?: string;
    /**
    * http_headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#http_headers CloudRunV2Service#http_headers}
    */
    readonly httpHeaders?: CloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders[] | cdktf.IResolvable;
}
export declare function cloudRunV2ServiceTemplateContainersStartupProbeHttpGetToTerraform(struct?: CloudRunV2ServiceTemplateContainersStartupProbeHttpGetOutputReference | CloudRunV2ServiceTemplateContainersStartupProbeHttpGet): any;
export declare class CloudRunV2ServiceTemplateContainersStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateContainersStartupProbeHttpGet | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersStartupProbeHttpGet | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _httpHeaders;
    get httpHeaders(): CloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersList;
    putHttpHeaders(value: CloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders[] | cdktf.IResolvable): void;
    resetHttpHeaders(): void;
    get httpHeadersInput(): cdktf.IResolvable | CloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders[] | undefined;
}
export interface CloudRunV2ServiceTemplateContainersStartupProbeTcpSocket {
    /**
    * Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#port CloudRunV2Service#port}
    */
    readonly port?: number;
}
export declare function cloudRunV2ServiceTemplateContainersStartupProbeTcpSocketToTerraform(struct?: CloudRunV2ServiceTemplateContainersStartupProbeTcpSocketOutputReference | CloudRunV2ServiceTemplateContainersStartupProbeTcpSocket): any;
export declare class CloudRunV2ServiceTemplateContainersStartupProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateContainersStartupProbeTcpSocket | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersStartupProbeTcpSocket | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
}
export interface CloudRunV2ServiceTemplateContainersStartupProbe {
    /**
    * Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#failure_threshold CloudRunV2Service#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#initial_delay_seconds CloudRunV2Service#initial_delay_seconds}
    */
    readonly initialDelaySeconds?: number;
    /**
    * How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#period_seconds CloudRunV2Service#period_seconds}
    */
    readonly periodSeconds?: number;
    /**
    * Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#timeout_seconds CloudRunV2Service#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * grpc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#grpc CloudRunV2Service#grpc}
    */
    readonly grpc?: CloudRunV2ServiceTemplateContainersStartupProbeGrpc;
    /**
    * http_get block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#http_get CloudRunV2Service#http_get}
    */
    readonly httpGet?: CloudRunV2ServiceTemplateContainersStartupProbeHttpGet;
    /**
    * tcp_socket block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#tcp_socket CloudRunV2Service#tcp_socket}
    */
    readonly tcpSocket?: CloudRunV2ServiceTemplateContainersStartupProbeTcpSocket;
}
export declare function cloudRunV2ServiceTemplateContainersStartupProbeToTerraform(struct?: CloudRunV2ServiceTemplateContainersStartupProbeOutputReference | CloudRunV2ServiceTemplateContainersStartupProbe): any;
export declare class CloudRunV2ServiceTemplateContainersStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateContainersStartupProbe | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersStartupProbe | undefined);
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _initialDelaySeconds?;
    get initialDelaySeconds(): number;
    set initialDelaySeconds(value: number);
    resetInitialDelaySeconds(): void;
    get initialDelaySecondsInput(): number | undefined;
    private _periodSeconds?;
    get periodSeconds(): number;
    set periodSeconds(value: number);
    resetPeriodSeconds(): void;
    get periodSecondsInput(): number | undefined;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _grpc;
    get grpc(): CloudRunV2ServiceTemplateContainersStartupProbeGrpcOutputReference;
    putGrpc(value: CloudRunV2ServiceTemplateContainersStartupProbeGrpc): void;
    resetGrpc(): void;
    get grpcInput(): CloudRunV2ServiceTemplateContainersStartupProbeGrpc | undefined;
    private _httpGet;
    get httpGet(): CloudRunV2ServiceTemplateContainersStartupProbeHttpGetOutputReference;
    putHttpGet(value: CloudRunV2ServiceTemplateContainersStartupProbeHttpGet): void;
    resetHttpGet(): void;
    get httpGetInput(): CloudRunV2ServiceTemplateContainersStartupProbeHttpGet | undefined;
    private _tcpSocket;
    get tcpSocket(): CloudRunV2ServiceTemplateContainersStartupProbeTcpSocketOutputReference;
    putTcpSocket(value: CloudRunV2ServiceTemplateContainersStartupProbeTcpSocket): void;
    resetTcpSocket(): void;
    get tcpSocketInput(): CloudRunV2ServiceTemplateContainersStartupProbeTcpSocket | undefined;
}
export interface CloudRunV2ServiceTemplateContainersVolumeMounts {
    /**
    * Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#mount_path CloudRunV2Service#mount_path}
    */
    readonly mountPath: string;
    /**
    * This must match the Name of a Volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#name CloudRunV2Service#name}
    */
    readonly name: string;
}
export declare function cloudRunV2ServiceTemplateContainersVolumeMountsToTerraform(struct?: CloudRunV2ServiceTemplateContainersVolumeMounts | cdktf.IResolvable): any;
export declare class CloudRunV2ServiceTemplateContainersVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2ServiceTemplateContainersVolumeMounts | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainersVolumeMounts | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class CloudRunV2ServiceTemplateContainersVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2ServiceTemplateContainersVolumeMounts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2ServiceTemplateContainersVolumeMountsOutputReference;
}
export interface CloudRunV2ServiceTemplateContainers {
    /**
    * Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#args CloudRunV2Service#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#command CloudRunV2Service#command}
    */
    readonly command?: string[];
    /**
    * URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#image CloudRunV2Service#image}
    */
    readonly image: string;
    /**
    * Name of the container specified as a DNS_LABEL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#name CloudRunV2Service#name}
    */
    readonly name?: string;
    /**
    * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#working_dir CloudRunV2Service#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#env CloudRunV2Service#env}
    */
    readonly env?: CloudRunV2ServiceTemplateContainersEnv[] | cdktf.IResolvable;
    /**
    * liveness_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#liveness_probe CloudRunV2Service#liveness_probe}
    */
    readonly livenessProbe?: CloudRunV2ServiceTemplateContainersLivenessProbe;
    /**
    * ports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#ports CloudRunV2Service#ports}
    */
    readonly ports?: CloudRunV2ServiceTemplateContainersPorts[] | cdktf.IResolvable;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#resources CloudRunV2Service#resources}
    */
    readonly resources?: CloudRunV2ServiceTemplateContainersResources;
    /**
    * startup_probe block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#startup_probe CloudRunV2Service#startup_probe}
    */
    readonly startupProbe?: CloudRunV2ServiceTemplateContainersStartupProbe;
    /**
    * volume_mounts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#volume_mounts CloudRunV2Service#volume_mounts}
    */
    readonly volumeMounts?: CloudRunV2ServiceTemplateContainersVolumeMounts[] | cdktf.IResolvable;
}
export declare function cloudRunV2ServiceTemplateContainersToTerraform(struct?: CloudRunV2ServiceTemplateContainers | cdktf.IResolvable): any;
export declare class CloudRunV2ServiceTemplateContainersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2ServiceTemplateContainers | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateContainers | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _env;
    get env(): CloudRunV2ServiceTemplateContainersEnvList;
    putEnv(value: CloudRunV2ServiceTemplateContainersEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | CloudRunV2ServiceTemplateContainersEnv[] | undefined;
    private _livenessProbe;
    get livenessProbe(): CloudRunV2ServiceTemplateContainersLivenessProbeOutputReference;
    putLivenessProbe(value: CloudRunV2ServiceTemplateContainersLivenessProbe): void;
    resetLivenessProbe(): void;
    get livenessProbeInput(): CloudRunV2ServiceTemplateContainersLivenessProbe | undefined;
    private _ports;
    get ports(): CloudRunV2ServiceTemplateContainersPortsList;
    putPorts(value: CloudRunV2ServiceTemplateContainersPorts[] | cdktf.IResolvable): void;
    resetPorts(): void;
    get portsInput(): cdktf.IResolvable | CloudRunV2ServiceTemplateContainersPorts[] | undefined;
    private _resources;
    get resources(): CloudRunV2ServiceTemplateContainersResourcesOutputReference;
    putResources(value: CloudRunV2ServiceTemplateContainersResources): void;
    resetResources(): void;
    get resourcesInput(): CloudRunV2ServiceTemplateContainersResources | undefined;
    private _startupProbe;
    get startupProbe(): CloudRunV2ServiceTemplateContainersStartupProbeOutputReference;
    putStartupProbe(value: CloudRunV2ServiceTemplateContainersStartupProbe): void;
    resetStartupProbe(): void;
    get startupProbeInput(): CloudRunV2ServiceTemplateContainersStartupProbe | undefined;
    private _volumeMounts;
    get volumeMounts(): CloudRunV2ServiceTemplateContainersVolumeMountsList;
    putVolumeMounts(value: CloudRunV2ServiceTemplateContainersVolumeMounts[] | cdktf.IResolvable): void;
    resetVolumeMounts(): void;
    get volumeMountsInput(): cdktf.IResolvable | CloudRunV2ServiceTemplateContainersVolumeMounts[] | undefined;
}
export declare class CloudRunV2ServiceTemplateContainersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2ServiceTemplateContainers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2ServiceTemplateContainersOutputReference;
}
export interface CloudRunV2ServiceTemplateScaling {
    /**
    * Maximum number of serving instances that this resource should have.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#max_instance_count CloudRunV2Service#max_instance_count}
    */
    readonly maxInstanceCount?: number;
    /**
    * Minimum number of serving instances that this resource should have.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#min_instance_count CloudRunV2Service#min_instance_count}
    */
    readonly minInstanceCount?: number;
}
export declare function cloudRunV2ServiceTemplateScalingToTerraform(struct?: CloudRunV2ServiceTemplateScalingOutputReference | CloudRunV2ServiceTemplateScaling): any;
export declare class CloudRunV2ServiceTemplateScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateScaling | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateScaling | undefined);
    private _maxInstanceCount?;
    get maxInstanceCount(): number;
    set maxInstanceCount(value: number);
    resetMaxInstanceCount(): void;
    get maxInstanceCountInput(): number | undefined;
    private _minInstanceCount?;
    get minInstanceCount(): number;
    set minInstanceCount(value: number);
    resetMinInstanceCount(): void;
    get minInstanceCountInput(): number | undefined;
}
export interface CloudRunV2ServiceTemplateVolumesCloudSqlInstance {
    /**
    * The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#instances CloudRunV2Service#instances}
    */
    readonly instances?: string[];
}
export declare function cloudRunV2ServiceTemplateVolumesCloudSqlInstanceToTerraform(struct?: CloudRunV2ServiceTemplateVolumesCloudSqlInstanceOutputReference | CloudRunV2ServiceTemplateVolumesCloudSqlInstance): any;
export declare class CloudRunV2ServiceTemplateVolumesCloudSqlInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateVolumesCloudSqlInstance | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateVolumesCloudSqlInstance | undefined);
    private _instances?;
    get instances(): string[];
    set instances(value: string[]);
    resetInstances(): void;
    get instancesInput(): string[] | undefined;
}
export interface CloudRunV2ServiceTemplateVolumesSecretItems {
    /**
    * Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#mode CloudRunV2Service#mode}
    */
    readonly mode: number;
    /**
    * The relative path of the secret in the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#path CloudRunV2Service#path}
    */
    readonly path: string;
    /**
    * The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#version CloudRunV2Service#version}
    */
    readonly version?: string;
}
export declare function cloudRunV2ServiceTemplateVolumesSecretItemsToTerraform(struct?: CloudRunV2ServiceTemplateVolumesSecretItems | cdktf.IResolvable): any;
export declare class CloudRunV2ServiceTemplateVolumesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2ServiceTemplateVolumesSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateVolumesSecretItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): number;
    set mode(value: number);
    get modeInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export declare class CloudRunV2ServiceTemplateVolumesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2ServiceTemplateVolumesSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2ServiceTemplateVolumesSecretItemsOutputReference;
}
export interface CloudRunV2ServiceTemplateVolumesSecret {
    /**
    * Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#default_mode CloudRunV2Service#default_mode}
    */
    readonly defaultMode?: number;
    /**
    * The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#secret CloudRunV2Service#secret}
    */
    readonly secret: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#items CloudRunV2Service#items}
    */
    readonly items?: CloudRunV2ServiceTemplateVolumesSecretItems[] | cdktf.IResolvable;
}
export declare function cloudRunV2ServiceTemplateVolumesSecretToTerraform(struct?: CloudRunV2ServiceTemplateVolumesSecretOutputReference | CloudRunV2ServiceTemplateVolumesSecret): any;
export declare class CloudRunV2ServiceTemplateVolumesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateVolumesSecret | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateVolumesSecret | undefined);
    private _defaultMode?;
    get defaultMode(): number;
    set defaultMode(value: number);
    resetDefaultMode(): void;
    get defaultModeInput(): number | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _items;
    get items(): CloudRunV2ServiceTemplateVolumesSecretItemsList;
    putItems(value: CloudRunV2ServiceTemplateVolumesSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | CloudRunV2ServiceTemplateVolumesSecretItems[] | undefined;
}
export interface CloudRunV2ServiceTemplateVolumes {
    /**
    * Volume's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#name CloudRunV2Service#name}
    */
    readonly name: string;
    /**
    * cloud_sql_instance block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#cloud_sql_instance CloudRunV2Service#cloud_sql_instance}
    */
    readonly cloudSqlInstance?: CloudRunV2ServiceTemplateVolumesCloudSqlInstance;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#secret CloudRunV2Service#secret}
    */
    readonly secret?: CloudRunV2ServiceTemplateVolumesSecret;
}
export declare function cloudRunV2ServiceTemplateVolumesToTerraform(struct?: CloudRunV2ServiceTemplateVolumes | cdktf.IResolvable): any;
export declare class CloudRunV2ServiceTemplateVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2ServiceTemplateVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateVolumes | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _cloudSqlInstance;
    get cloudSqlInstance(): CloudRunV2ServiceTemplateVolumesCloudSqlInstanceOutputReference;
    putCloudSqlInstance(value: CloudRunV2ServiceTemplateVolumesCloudSqlInstance): void;
    resetCloudSqlInstance(): void;
    get cloudSqlInstanceInput(): CloudRunV2ServiceTemplateVolumesCloudSqlInstance | undefined;
    private _secret;
    get secret(): CloudRunV2ServiceTemplateVolumesSecretOutputReference;
    putSecret(value: CloudRunV2ServiceTemplateVolumesSecret): void;
    resetSecret(): void;
    get secretInput(): CloudRunV2ServiceTemplateVolumesSecret | undefined;
}
export declare class CloudRunV2ServiceTemplateVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2ServiceTemplateVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2ServiceTemplateVolumesOutputReference;
}
export interface CloudRunV2ServiceTemplateVpcAccess {
    /**
    * VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#connector CloudRunV2Service#connector}
    */
    readonly connector?: string;
    /**
    * Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#egress CloudRunV2Service#egress}
    */
    readonly egress?: string;
}
export declare function cloudRunV2ServiceTemplateVpcAccessToTerraform(struct?: CloudRunV2ServiceTemplateVpcAccessOutputReference | CloudRunV2ServiceTemplateVpcAccess): any;
export declare class CloudRunV2ServiceTemplateVpcAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplateVpcAccess | undefined;
    set internalValue(value: CloudRunV2ServiceTemplateVpcAccess | undefined);
    private _connector?;
    get connector(): string;
    set connector(value: string);
    resetConnector(): void;
    get connectorInput(): string | undefined;
    private _egress?;
    get egress(): string;
    set egress(value: string);
    resetEgress(): void;
    get egressInput(): string | undefined;
}
export interface CloudRunV2ServiceTemplate {
    /**
    * KRM-style annotations for the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#annotations CloudRunV2Service#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#encryption_key CloudRunV2Service#encryption_key}
    */
    readonly encryptionKey?: string;
    /**
    * The sandbox environment to host this Revision. Possible values: ["EXECUTION_ENVIRONMENT_GEN1", "EXECUTION_ENVIRONMENT_GEN2"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#execution_environment CloudRunV2Service#execution_environment}
    */
    readonly executionEnvironment?: string;
    /**
    * KRM-style labels for the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#labels CloudRunV2Service#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Sets the maximum number of requests that each serving instance can receive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#max_instance_request_concurrency CloudRunV2Service#max_instance_request_concurrency}
    */
    readonly maxInstanceRequestConcurrency?: number;
    /**
    * The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#revision CloudRunV2Service#revision}
    */
    readonly revision?: string;
    /**
    * Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#service_account CloudRunV2Service#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Max allowed time for an instance to respond to a request.
  
  A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#timeout CloudRunV2Service#timeout}
    */
    readonly timeout?: string;
    /**
    * containers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#containers CloudRunV2Service#containers}
    */
    readonly containers?: CloudRunV2ServiceTemplateContainers[] | cdktf.IResolvable;
    /**
    * scaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#scaling CloudRunV2Service#scaling}
    */
    readonly scaling?: CloudRunV2ServiceTemplateScaling;
    /**
    * volumes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#volumes CloudRunV2Service#volumes}
    */
    readonly volumes?: CloudRunV2ServiceTemplateVolumes[] | cdktf.IResolvable;
    /**
    * vpc_access block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#vpc_access CloudRunV2Service#vpc_access}
    */
    readonly vpcAccess?: CloudRunV2ServiceTemplateVpcAccess;
}
export declare function cloudRunV2ServiceTemplateToTerraform(struct?: CloudRunV2ServiceTemplateOutputReference | CloudRunV2ServiceTemplate): any;
export declare class CloudRunV2ServiceTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTemplate | undefined;
    set internalValue(value: CloudRunV2ServiceTemplate | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _encryptionKey?;
    get encryptionKey(): string;
    set encryptionKey(value: string);
    resetEncryptionKey(): void;
    get encryptionKeyInput(): string | undefined;
    private _executionEnvironment?;
    get executionEnvironment(): string;
    set executionEnvironment(value: string);
    resetExecutionEnvironment(): void;
    get executionEnvironmentInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _maxInstanceRequestConcurrency?;
    get maxInstanceRequestConcurrency(): number;
    set maxInstanceRequestConcurrency(value: number);
    resetMaxInstanceRequestConcurrency(): void;
    get maxInstanceRequestConcurrencyInput(): number | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    resetRevision(): void;
    get revisionInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _containers;
    get containers(): CloudRunV2ServiceTemplateContainersList;
    putContainers(value: CloudRunV2ServiceTemplateContainers[] | cdktf.IResolvable): void;
    resetContainers(): void;
    get containersInput(): cdktf.IResolvable | CloudRunV2ServiceTemplateContainers[] | undefined;
    private _scaling;
    get scaling(): CloudRunV2ServiceTemplateScalingOutputReference;
    putScaling(value: CloudRunV2ServiceTemplateScaling): void;
    resetScaling(): void;
    get scalingInput(): CloudRunV2ServiceTemplateScaling | undefined;
    private _volumes;
    get volumes(): CloudRunV2ServiceTemplateVolumesList;
    putVolumes(value: CloudRunV2ServiceTemplateVolumes[] | cdktf.IResolvable): void;
    resetVolumes(): void;
    get volumesInput(): cdktf.IResolvable | CloudRunV2ServiceTemplateVolumes[] | undefined;
    private _vpcAccess;
    get vpcAccess(): CloudRunV2ServiceTemplateVpcAccessOutputReference;
    putVpcAccess(value: CloudRunV2ServiceTemplateVpcAccess): void;
    resetVpcAccess(): void;
    get vpcAccessInput(): CloudRunV2ServiceTemplateVpcAccess | undefined;
}
export interface CloudRunV2ServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#create CloudRunV2Service#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#delete CloudRunV2Service#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#update CloudRunV2Service#update}
    */
    readonly update?: string;
}
export declare function cloudRunV2ServiceTimeoutsToTerraform(struct?: CloudRunV2ServiceTimeoutsOutputReference | CloudRunV2ServiceTimeouts | cdktf.IResolvable): any;
export declare class CloudRunV2ServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2ServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface CloudRunV2ServiceTraffic {
    /**
    * Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#percent CloudRunV2Service#percent}
    */
    readonly percent?: number;
    /**
    * Revision to which to send this portion of traffic, if traffic allocation is by revision.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#revision CloudRunV2Service#revision}
    */
    readonly revision?: string;
    /**
    * Indicates a string to be part of the URI to exclusively reference this target.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#tag CloudRunV2Service#tag}
    */
    readonly tag?: string;
    /**
    * The allocation type for this traffic target. Possible values: ["TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST", "TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service#type CloudRunV2Service#type}
    */
    readonly type?: string;
}
export declare function cloudRunV2ServiceTrafficToTerraform(struct?: CloudRunV2ServiceTraffic | cdktf.IResolvable): any;
export declare class CloudRunV2ServiceTrafficOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunV2ServiceTraffic | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunV2ServiceTraffic | cdktf.IResolvable | undefined);
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    resetRevision(): void;
    get revisionInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class CloudRunV2ServiceTrafficList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunV2ServiceTraffic[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunV2ServiceTrafficOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service google_cloud_run_v2_service}
*/
export declare class CloudRunV2Service extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_run_v2_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service google_cloud_run_v2_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudRunV2ServiceConfig
    */
    constructor(scope: Construct, id: string, config: CloudRunV2ServiceConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _client?;
    get client(): string;
    set client(value: string);
    resetClient(): void;
    get clientInput(): string | undefined;
    private _clientVersion?;
    get clientVersion(): string;
    set clientVersion(value: string);
    resetClientVersion(): void;
    get clientVersionInput(): string | undefined;
    private _conditions;
    get conditions(): CloudRunV2ServiceConditionsList;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    get generation(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ingress?;
    get ingress(): string;
    set ingress(value: string);
    resetIngress(): void;
    get ingressInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get latestCreatedRevision(): string;
    get latestReadyRevision(): string;
    private _launchStage?;
    get launchStage(): string;
    set launchStage(value: string);
    resetLaunchStage(): void;
    get launchStageInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get observedGeneration(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    private _terminalCondition;
    get terminalCondition(): CloudRunV2ServiceTerminalConditionList;
    private _trafficStatuses;
    get trafficStatuses(): CloudRunV2ServiceTrafficStatusesList;
    get uid(): string;
    get uri(): string;
    private _binaryAuthorization;
    get binaryAuthorization(): CloudRunV2ServiceBinaryAuthorizationOutputReference;
    putBinaryAuthorization(value: CloudRunV2ServiceBinaryAuthorization): void;
    resetBinaryAuthorization(): void;
    get binaryAuthorizationInput(): CloudRunV2ServiceBinaryAuthorization | undefined;
    private _template;
    get template(): CloudRunV2ServiceTemplateOutputReference;
    putTemplate(value: CloudRunV2ServiceTemplate): void;
    get templateInput(): CloudRunV2ServiceTemplate | undefined;
    private _timeouts;
    get timeouts(): CloudRunV2ServiceTimeoutsOutputReference;
    putTimeouts(value: CloudRunV2ServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CloudRunV2ServiceTimeouts | undefined;
    private _traffic;
    get traffic(): CloudRunV2ServiceTrafficList;
    putTraffic(value: CloudRunV2ServiceTraffic[] | cdktf.IResolvable): void;
    resetTraffic(): void;
    get trafficInput(): cdktf.IResolvable | CloudRunV2ServiceTraffic[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
