import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ClouddeployDeliveryPipelineConfig extends cdktf.TerraformMetaArguments {
    /**
    * User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#annotations ClouddeployDeliveryPipeline#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Description of the `DeliveryPipeline`. Max length is 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#description ClouddeployDeliveryPipeline#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#id ClouddeployDeliveryPipeline#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#labels ClouddeployDeliveryPipeline#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#location ClouddeployDeliveryPipeline#location}
    */
    readonly location: string;
    /**
    * Name of the `DeliveryPipeline`. Format is [a-z][a-z0-9\-]{0,62}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#name ClouddeployDeliveryPipeline#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#project ClouddeployDeliveryPipeline#project}
    */
    readonly project?: string;
    /**
    * When suspended, no new releases or rollouts can be created, but in-progress ones will complete.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#suspended ClouddeployDeliveryPipeline#suspended}
    */
    readonly suspended?: boolean | cdktf.IResolvable;
    /**
    * serial_pipeline block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#serial_pipeline ClouddeployDeliveryPipeline#serial_pipeline}
    */
    readonly serialPipeline?: ClouddeployDeliveryPipelineSerialPipeline;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#timeouts ClouddeployDeliveryPipeline#timeouts}
    */
    readonly timeouts?: ClouddeployDeliveryPipelineTimeouts;
}
export interface ClouddeployDeliveryPipelineConditionPipelineReadyCondition {
}
export declare function clouddeployDeliveryPipelineConditionPipelineReadyConditionToTerraform(struct?: ClouddeployDeliveryPipelineConditionPipelineReadyCondition): any;
export declare class ClouddeployDeliveryPipelineConditionPipelineReadyConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClouddeployDeliveryPipelineConditionPipelineReadyCondition | undefined;
    set internalValue(value: ClouddeployDeliveryPipelineConditionPipelineReadyCondition | undefined);
    get status(): cdktf.IResolvable;
    get updateTime(): string;
}
export declare class ClouddeployDeliveryPipelineConditionPipelineReadyConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClouddeployDeliveryPipelineConditionPipelineReadyConditionOutputReference;
}
export interface ClouddeployDeliveryPipelineConditionTargetsPresentCondition {
}
export declare function clouddeployDeliveryPipelineConditionTargetsPresentConditionToTerraform(struct?: ClouddeployDeliveryPipelineConditionTargetsPresentCondition): any;
export declare class ClouddeployDeliveryPipelineConditionTargetsPresentConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClouddeployDeliveryPipelineConditionTargetsPresentCondition | undefined;
    set internalValue(value: ClouddeployDeliveryPipelineConditionTargetsPresentCondition | undefined);
    get missingTargets(): string[];
    get status(): cdktf.IResolvable;
    get updateTime(): string;
}
export declare class ClouddeployDeliveryPipelineConditionTargetsPresentConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClouddeployDeliveryPipelineConditionTargetsPresentConditionOutputReference;
}
export interface ClouddeployDeliveryPipelineCondition {
}
export declare function clouddeployDeliveryPipelineConditionToTerraform(struct?: ClouddeployDeliveryPipelineCondition): any;
export declare class ClouddeployDeliveryPipelineConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClouddeployDeliveryPipelineCondition | undefined;
    set internalValue(value: ClouddeployDeliveryPipelineCondition | undefined);
    private _pipelineReadyCondition;
    get pipelineReadyCondition(): ClouddeployDeliveryPipelineConditionPipelineReadyConditionList;
    private _targetsPresentCondition;
    get targetsPresentCondition(): ClouddeployDeliveryPipelineConditionTargetsPresentConditionList;
}
export declare class ClouddeployDeliveryPipelineConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClouddeployDeliveryPipelineConditionOutputReference;
}
export interface ClouddeployDeliveryPipelineSerialPipelineStages {
    /**
    * Skaffold profiles to use when rendering the manifest for this stage's `Target`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#profiles ClouddeployDeliveryPipeline#profiles}
    */
    readonly profiles?: string[];
    /**
    * The target_id to which this stage points. This field refers exclusively to the last segment of a target name. For example, this field would just be `my-target` (rather than `projects/project/locations/location/targets/my-target`). The location of the `Target` is inferred to be the same as the location of the `DeliveryPipeline` that contains this `Stage`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#target_id ClouddeployDeliveryPipeline#target_id}
    */
    readonly targetId?: string;
}
export declare function clouddeployDeliveryPipelineSerialPipelineStagesToTerraform(struct?: ClouddeployDeliveryPipelineSerialPipelineStages | cdktf.IResolvable): any;
export declare class ClouddeployDeliveryPipelineSerialPipelineStagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClouddeployDeliveryPipelineSerialPipelineStages | cdktf.IResolvable | undefined;
    set internalValue(value: ClouddeployDeliveryPipelineSerialPipelineStages | cdktf.IResolvable | undefined);
    private _profiles?;
    get profiles(): string[];
    set profiles(value: string[]);
    resetProfiles(): void;
    get profilesInput(): string[] | undefined;
    private _targetId?;
    get targetId(): string;
    set targetId(value: string);
    resetTargetId(): void;
    get targetIdInput(): string | undefined;
}
export declare class ClouddeployDeliveryPipelineSerialPipelineStagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ClouddeployDeliveryPipelineSerialPipelineStages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClouddeployDeliveryPipelineSerialPipelineStagesOutputReference;
}
export interface ClouddeployDeliveryPipelineSerialPipeline {
    /**
    * stages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#stages ClouddeployDeliveryPipeline#stages}
    */
    readonly stages?: ClouddeployDeliveryPipelineSerialPipelineStages[] | cdktf.IResolvable;
}
export declare function clouddeployDeliveryPipelineSerialPipelineToTerraform(struct?: ClouddeployDeliveryPipelineSerialPipelineOutputReference | ClouddeployDeliveryPipelineSerialPipeline): any;
export declare class ClouddeployDeliveryPipelineSerialPipelineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClouddeployDeliveryPipelineSerialPipeline | undefined;
    set internalValue(value: ClouddeployDeliveryPipelineSerialPipeline | undefined);
    private _stages;
    get stages(): ClouddeployDeliveryPipelineSerialPipelineStagesList;
    putStages(value: ClouddeployDeliveryPipelineSerialPipelineStages[] | cdktf.IResolvable): void;
    resetStages(): void;
    get stagesInput(): cdktf.IResolvable | ClouddeployDeliveryPipelineSerialPipelineStages[] | undefined;
}
export interface ClouddeployDeliveryPipelineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#create ClouddeployDeliveryPipeline#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#delete ClouddeployDeliveryPipeline#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline#update ClouddeployDeliveryPipeline#update}
    */
    readonly update?: string;
}
export declare function clouddeployDeliveryPipelineTimeoutsToTerraform(struct?: ClouddeployDeliveryPipelineTimeoutsOutputReference | ClouddeployDeliveryPipelineTimeouts | cdktf.IResolvable): any;
export declare class ClouddeployDeliveryPipelineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClouddeployDeliveryPipelineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ClouddeployDeliveryPipelineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline google_clouddeploy_delivery_pipeline}
*/
export declare class ClouddeployDeliveryPipeline extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_clouddeploy_delivery_pipeline";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/clouddeploy_delivery_pipeline google_clouddeploy_delivery_pipeline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ClouddeployDeliveryPipelineConfig
    */
    constructor(scope: Construct, id: string, config: ClouddeployDeliveryPipelineConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _condition;
    get condition(): ClouddeployDeliveryPipelineConditionList;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _suspended?;
    get suspended(): boolean | cdktf.IResolvable;
    set suspended(value: boolean | cdktf.IResolvable);
    resetSuspended(): void;
    get suspendedInput(): boolean | cdktf.IResolvable | undefined;
    get uid(): string;
    get updateTime(): string;
    private _serialPipeline;
    get serialPipeline(): ClouddeployDeliveryPipelineSerialPipelineOutputReference;
    putSerialPipeline(value: ClouddeployDeliveryPipelineSerialPipeline): void;
    resetSerialPipeline(): void;
    get serialPipelineInput(): ClouddeployDeliveryPipelineSerialPipeline | undefined;
    private _timeouts;
    get timeouts(): ClouddeployDeliveryPipelineTimeoutsOutputReference;
    putTimeouts(value: ClouddeployDeliveryPipelineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ClouddeployDeliveryPipelineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
